/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.Context;
import android.database.Cursor;
import com.akamai.android.sdk.db.AnaProviderContract;
import java.util.HashMap;
import java.util.HashSet;

class AkaFeedManager {
    private final HashMap<String, String> mIdToUrlMap = new HashMap(100);
    private final HashSet<String> mCachedAndReadySet = new HashSet(100);
    private final HashMap<String, String> mUrlToIdMap = new HashMap(100);
    private volatile boolean mInitialized;

    AkaFeedManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context) {
        Object object;
        Cursor cursor = context.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, new String[]{"_id", "url", "resourceready"}, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    object = cursor.getString(0);
                    String string = cursor.getString(1);
                    int n2 = cursor.getInt(2);
                    AkaFeedManager akaFeedManager = this;
                    synchronized (akaFeedManager) {
                        this.mIdToUrlMap.put((String)object, string);
                        this.mUrlToIdMap.put(string, (String)object);
                        if (n2 == 1) {
                            this.mCachedAndReadySet.add(string);
                        }
                    }
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        object = this;
        synchronized (object) {
            this.mInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String string, String string2) {
        AkaFeedManager akaFeedManager = this;
        synchronized (akaFeedManager) {
            this.mIdToUrlMap.put(string, string2);
            this.mUrlToIdMap.put(string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeedWithID(String string) {
        AkaFeedManager akaFeedManager = this;
        synchronized (akaFeedManager) {
            String string2 = this.mIdToUrlMap.get(string);
            if (string2 != null) {
                this.mIdToUrlMap.remove(string);
                this.mUrlToIdMap.remove(string2);
                this.mCachedAndReadySet.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceReady(String string, boolean bl2) {
        AkaFeedManager akaFeedManager = this;
        synchronized (akaFeedManager) {
            String string2 = this.mIdToUrlMap.get(string);
            if (string2 != null) {
                if (bl2) {
                    this.mCachedAndReadySet.add(string2);
                } else {
                    this.mCachedAndReadySet.remove(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isURLCachedAndReady(String string) {
        AkaFeedManager akaFeedManager = this;
        synchronized (akaFeedManager) {
            return !this.mInitialized || this.mCachedAndReadySet.contains(string);
        }
    }

    public synchronized String getFeedID(String string) {
        return this.mUrlToIdMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        AkaFeedManager akaFeedManager = this;
        synchronized (akaFeedManager) {
            this.mIdToUrlMap.clear();
            this.mCachedAndReadySet.clear();
            this.mUrlToIdMap.clear();
        }
    }
}

