/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.akamai.android.annotations.AkamaiInternal;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaNetworkQualityHandler;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaWebAnalyticsHandler;
import com.akamai.android.sdk.internal.AnaBitRateCalculator;
import com.akamai.android.sdk.internal.AnaFeedController;
import com.akamai.android.sdk.internal.AnaNetworkQualityStatus;
import com.akamai.android.sdk.internal.AnaWebDebugRecord;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.AkaHttpHelper;
import com.akamai.android.sdk.net.AkaHttpStatsCollector;
import com.akamai.android.sdk.net.AkaNetUtils;
import com.akamai.android.sdk.net.AkaResponseHeaderParser;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;

@AkamaiInternal
@Keep
public class AkaHttpUtils
extends AkaHttpHelper {
    private static final String TAG = "AkaHttpUtils";
    private static final String COOKIE_HEADER = "Cookie";
    private static final String IMAGE_MANAGER_QUERY_STRING = "imformat=chrome";
    private static final HashSet<String> IM_SUPPORTED_EXT_SET = new HashSet(6);
    private static final int DEFAULT_STAT_UPLOAD = 100;
    private static int mActiveStatCounter;
    private static final Hashtable<Integer, Long> mRmemMap;

    @AkamaiInternal
    @Keep
    static boolean isJPGRequest(URI uRI) {
        String string = uRI.getPath();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            int n2 = string.length();
            int n3 = string.lastIndexOf(46) + 1;
            if (n3 > string.lastIndexOf(47)) {
                String string2 = "";
                try {
                    string2 = string.substring(n3, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg");
            }
        }
        return false;
    }

    @AkamaiInternal
    @Keep
    public static int getMaxAge(AnaFeedItem anaFeedItem, SharedPreferences sharedPreferences) {
        return AkaHttpUtils.getHttpMaxAge(anaFeedItem);
    }

    @AkamaiInternal
    @Keep
    private static int getHttpMaxAge(AnaFeedItem anaFeedItem) {
        return Math.max(0, anaFeedItem != null ? anaFeedItem.getMaxAge() : 0);
    }

    @AkamaiInternal
    @Keep
    public static String getUrl(String string) {
        int n2;
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        boolean bl2 = vocAccelerator.getSecurePreferenceBoolean("ignore_query", false);
        if (bl2 && (n2 = string.indexOf(63)) > 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    @AkamaiInternal
    @Keep
    static void updateResponseHeaders(Map<String, String> map, Map<String, String> map2, final Context context, final AnaFeedItem anaFeedItem) {
        AkaResponseHeaderParser akaResponseHeaderParser = new AkaResponseHeaderParser(map);
        Map<String, String> map3 = akaResponseHeaderParser.getBareHeaders();
        for (String string : map3.keySet()) {
            map2.put(string, map3.get(string));
        }
        final long l2 = akaResponseHeaderParser.getExpiry() / 1000L;
        final String string = AkaHttpUtils.convertToStringHeaders(map2);
        anaFeedItem.setRespHeaders(string);
        VocAccelerator.getInstance().submitTask(new Runnable(){

            @Override
            public void run() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("responseheaders", string);
                contentValues.put("maxage", Long.valueOf(l2));
                contentValues.put("refreshtimestamp", Long.valueOf(System.currentTimeMillis()));
                context.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + anaFeedItem.getId())), contentValues, null, null);
            }
        });
    }

    @AkamaiInternal
    @Keep
    public static Map<String, String> parseHeadersFromString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";;")) {
                String[] stringArray2 = string2.split("==");
                if (stringArray2.length != 2) continue;
                hashMap.put(stringArray2[0].toLowerCase(), stringArray2[1]);
            }
        }
        return hashMap;
    }

    @AkamaiInternal
    @Keep
    public static String convertToStringHeaders(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";;");
                }
                stringBuilder.append(AkaHttpUtils.trimSemiColon(entry.getKey()));
                stringBuilder.append("==");
                stringBuilder.append(AkaHttpUtils.trimSemiColon(entry.getValue()));
            }
        }
        return stringBuilder.toString();
    }

    private static String trimSemiColon(String string) {
        if ((string = string.trim()).startsWith(";")) {
            string = string.substring(1);
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @AkamaiInternal
    @Keep
    static boolean containsRevalidationHeaders(String string) {
        return string.contains("last-modified") || string.contains("etag");
    }

    @AkamaiInternal
    @Keep
    public static String getQuotedString(String string) {
        if (!string.startsWith("\"")) {
            string = "\"" + string;
        }
        if (!string.endsWith("\"")) {
            string = string + "\"";
        }
        return string;
    }

    @AkamaiInternal
    @Keep
    public static String getConnectionType() {
        try {
            ConnectivityManager connectivityManager = VocAccelerator.getInstance().getConnectivityManager();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                if (networkInfo.getType() == 1) {
                    return "wifi";
                }
                if (networkInfo.getType() == 0) {
                    String string = networkInfo.getSubtypeName();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        return "cellular/" + networkInfo.getSubtypeName();
                    }
                    return "cellular";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @AkamaiInternal
    @Keep
    public static long getHeaderSize(Map<String, String> map) {
        long l2 = 0L;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            l2 += (long)(entry.getKey().getBytes().length + entry.getValue().getBytes().length);
        }
        return l2;
    }

    @AkamaiInternal
    @Keep
    static int getSignalStrength() {
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        boolean bl2 = vocAccelerator.getSecurePreferenceBoolean("get_sigstrength", false);
        if (bl2) {
            return vocAccelerator.getSignalStrength();
        }
        return -1;
    }

    @AkamaiInternal
    @Keep
    static int getBatteryLevel(Context context) {
        int n2 = -1;
        if (context != null) {
            n2 = AnaUtils.getBatteryLevel(context);
        }
        return n2;
    }

    @AkamaiInternal
    @Keep
    static boolean isCharging(Context context) {
        boolean bl2 = false;
        if (context != null) {
            bl2 = AnaUtils.isBatteryCharging(context);
        }
        return bl2;
    }

    @AkamaiInternal
    @Keep
    static String getLocation() {
        Location location;
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        boolean bl2 = vocAccelerator.getSecurePreferenceBoolean("get_location", false);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2 && (location = AnaUtils.getLocation(vocAccelerator.getAppContext())) != null) {
            stringBuilder.append(location.getLatitude());
            stringBuilder.append(",");
            stringBuilder.append(location.getLongitude());
        }
        return stringBuilder.toString();
    }

    @AkamaiInternal
    @Keep
    public static String getFileExtensionFromUrl(String string) {
        String string2 = "";
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                int n2;
                int n3;
                String string3;
                int n4;
                int n5 = string.lastIndexOf(35);
                if (n5 > 0) {
                    string = string.substring(0, n5);
                }
                if ((n4 = string.lastIndexOf(63)) > 0) {
                    string = string.substring(0, n4);
                }
                String string4 = string3 = 0 <= (n3 = string.lastIndexOf(47)) ? string.substring(n3 + 1) : string;
                if (!string3.isEmpty() && 0 <= (n2 = string3.lastIndexOf(46))) {
                    string2 = string3.substring(n2 + 1);
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaHttpUtils failed to get file ext for url: " + string), (Throwable)exception);
        }
        return string2;
    }

    private static boolean isIMsupportedExtension(String string) {
        String string2 = AkaHttpUtils.getFileExtensionFromUrl(string);
        return string2 != null && IM_SUPPORTED_EXT_SET.contains(string2);
    }

    @AkamaiInternal
    @Keep
    public static void addCookies(URLConnection uRLConnection, URL uRL, boolean bl2) {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler != null && uRLConnection != null && (!uRLConnection.getURL().toExternalForm().equals(uRL.toExternalForm()) || bl2)) {
            try {
                List<String> list;
                Map<String, List<String>> map = cookieHandler.get(uRLConnection.getURL().toURI(), uRLConnection.getRequestProperties());
                if ((map == null || map.isEmpty() || bl2) && (map = cookieHandler.get(uRL.toURI(), uRLConnection.getRequestProperties())) != null && !map.isEmpty() && (list = map.get(COOKIE_HEADER)) != null && !list.isEmpty()) {
                    uRLConnection.setRequestProperty(COOKIE_HEADER, TextUtils.join((CharSequence)";", list));
                }
            }
            catch (Exception exception) {
                Logger.d((String)"AkaHttpUtils: addCookies exception", (Object[])new Object[0]);
            }
        }
    }

    @AkamaiInternal
    @Keep
    public static void setCookies(URLConnection uRLConnection, URL uRL, boolean bl2) {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler != null && uRLConnection != null && (!uRLConnection.getURL().equals(uRL) || bl2)) {
            try {
                URI uRI = uRL.toURI();
                cookieHandler.put(uRI, uRLConnection.getHeaderFields());
            }
            catch (Exception exception) {
                Logger.d((String)"AkaHttpUtils: setCookies exception", (Object[])new Object[0]);
            }
        }
    }

    @AkamaiInternal
    @Keep
    public static Map<String, String> convertToWebViewHeaders(Map<String, List<String>> map, boolean bl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> list;
                String string = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)string) || (list = entry.getValue()) == null || list.size() <= 0) continue;
                if (bl2 && (string.equalsIgnoreCase("set-cookie") || string.equalsIgnoreCase("set-cookie2"))) {
                    AkaHttpUtils.addCookieAsJson(hashMap, string, list);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string2 = list.get(i2);
                    stringBuilder.append(string2);
                    if (string2.endsWith(";") || i2 == list.size() - 1) continue;
                    stringBuilder.append("; ");
                }
                hashMap.put(string, stringBuilder.toString());
            }
        }
        return hashMap;
    }

    private static void addCookieAsJson(Map<String, String> map, String string, List<String> list) {
        if (list != null && list.size() > 0) {
            JSONArray jSONArray = new JSONArray();
            for (String string2 : list) {
                jSONArray.put((Object)string2);
            }
            map.put(string, jSONArray.toString());
        }
    }

    @AkamaiInternal
    @Keep
    static long getRmemMax() {
        block6: {
            try {
                VocAccelerator vocAccelerator = VocAccelerator.getInstance();
                ConnectivityManager connectivityManager = vocAccelerator.getConnectivityManager();
                Context context = vocAccelerator.getAppContext();
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo == null || !networkInfo.isConnected()) break block6;
                int n2 = networkInfo.getSubtype();
                Long l2 = mRmemMap.get(n2);
                if (l2 == null) {
                    l2 = 0L;
                    String string = AnaUtils.getTcpBuffSizes(connectivityManager, context, networkInfo);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        try {
                            String[] stringArray = string.split(",");
                            l2 = Long.parseLong(stringArray[2]);
                            mRmemMap.put(n2, l2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return l2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    @AkamaiInternal
    @Keep
    public static String getAMCHeaderString(boolean bl2) {
        boolean bl3;
        int n2;
        long l2;
        String string;
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        Context context = vocAccelerator.getAppContext();
        AnaNetworkQualityStatus anaNetworkQualityStatus = AkaNetworkQualityHandler.getNetworkQuality(context);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = AkaHttpUtils.getNetworkInfoForFTcpHeader();
        if (!string2.isEmpty()) {
            stringBuilder.append(string2);
        }
        if (anaNetworkQualityStatus.networkQuality != -1) {
            stringBuilder.append("v=");
            stringBuilder.append("tpv1");
            stringBuilder.append(";");
            stringBuilder.append("tpresult=");
            stringBuilder.append(anaNetworkQualityStatus.networkQuality);
            stringBuilder.append(";");
            if (anaNetworkQualityStatus.rtt > 0L) {
                stringBuilder.append("rtt=");
                stringBuilder.append(anaNetworkQualityStatus.rtt);
                stringBuilder.append(";");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string = context.getApplicationContext().getPackageName()))) {
            stringBuilder.append("appdata=");
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        boolean bl4 = vocAccelerator.getSecurePreferenceBoolean("use_aic", false);
        if (bl2 || !bl4) {
            stringBuilder.append("prepositioned=true");
            stringBuilder.append(";");
        }
        stringBuilder.append("websdk=");
        stringBuilder.append(AnaUtils.getBuildVersion());
        stringBuilder.append(";");
        if (!TextUtils.isEmpty((CharSequence)vocAccelerator.getStaticParams())) {
            stringBuilder.append(vocAccelerator.getStaticParams());
            stringBuilder.append(";");
        }
        if ((l2 = AkaHttpUtils.getRmemMax()) > 0L) {
            stringBuilder.append("rwnd=");
            stringBuilder.append(l2);
            stringBuilder.append(";");
        }
        if ((n2 = vocAccelerator.getSignalStrength()) > 0) {
            stringBuilder.append("cqi=");
            stringBuilder.append(n2);
            stringBuilder.append(";");
        }
        boolean bl5 = vocAccelerator.getSecurePreferenceBoolean("transport_opt", false);
        boolean bl6 = bl3 = vocAccelerator.getSecurePreferenceBoolean("use_quic", false) && vocAccelerator.getCronetEngine() != null;
        if (bl5) {
            stringBuilder.append("optimization=transport");
            if (bl3) {
                stringBuilder.append(",quic");
            }
            stringBuilder.append(";");
        } else if (bl3) {
            stringBuilder.append("optimization=quic;");
        }
        stringBuilder.append("p=a");
        String string3 = vocAccelerator.checkHeaderValue(stringBuilder).toString();
        AnaUtils.getSDKSharedPreferences(context).edit().putString("last_conn_header_string", string3).apply();
        return string3;
    }

    @AkamaiInternal
    @Keep
    public static void insertHttpStats(AkaHttpStatsCollector akaHttpStatsCollector) {
        Map<String, Object> map;
        Context context = VocAccelerator.getInstance().getAppContext();
        if (context != null && (map = akaHttpStatsCollector.getStats()) != null && map.size() > 0) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("feedid", (String)map.get("s_uniqueId"));
            contentValues.put("url", (String)map.get("s_url"));
            contentValues.put("downloadtype", (String)map.get("s_type"));
            contentValues.put("timestamp", (Long)map.get("l_timeStamp"));
            contentValues.put("duration", (Long)map.get("l_duration"));
            contentValues.put("ttfb", (Long)map.get("l_ttfb"));
            contentValues.put("batterylevel", (Integer)map.get("i_batteryLevel"));
            contentValues.put("ischarging", Boolean.toString((Boolean)map.get("b_isCharging")));
            contentValues.put("connectiontype", (String)map.get("s_connectionType"));
            contentValues.put("location", (String)map.get("s_location"));
            contentValues.put("signalstrength", (Integer)map.get("i_signalStrength"));
            contentValues.put("respcode", (Integer)map.get("i_responseCode"));
            contentValues.put("requestheadersize", (Long)map.get("l_requestHeaderSize"));
            contentValues.put("responseheadersize", (Long)map.get("l_responseHeaderSize"));
            contentValues.put("contentlength", (Long)map.get("l_contentLength"));
            contentValues.put("mimetype", (String)map.get("s_mimeType"));
            contentValues.put("mpmethod", (Integer)map.get("i_mpMethod"));
            contentValues.put("mptype", (Integer)map.get("i_mpType"));
            contentValues.put("mpwinner", (Integer)map.get("i_mpWinner"));
            contentValues.put("serverprofile", (String)map.get("s_serverProfile"));
            contentValues.put("amcid", (String)map.get("s_amcId"));
            contentValues.put("quicEnabled", (Integer)map.get("s_quic_enabled"));
            contentValues.put("requestType", (String)map.get("s_requestType"));
            contentValues.put("v4Tries", (Integer)map.get("s_ATries"));
            contentValues.put("v6Tries", (Integer)map.get("s_AAAATries"));
            contentValues.put("contentLengthHeader", (String)map.get("s_contentLengthHeader"));
            contentValues.put("maxRwnd", (Long)map.get("l_maxRwnd"));
            contentValues.put("brotliEnabled", (Integer)map.get("s_brotliEnabled"));
            contentValues.put("brotliUsed", (Integer)map.get("s_brotliUsed"));
            contentValues.put("cacheable", (Integer)map.get("s_cacheable"));
            AnaNetworkQualityStatus anaNetworkQualityStatus = AkaNetworkQualityHandler.getNetworkQuality(context);
            int n2 = anaNetworkQualityStatus != null ? anaNetworkQualityStatus.networkQuality : -1;
            contentValues.put("tpResult", Integer.valueOf(n2));
            contentValues.put("sessionId", VocAccelerator.getInstance().getSessionId());
            contentValues.put("exceptionMessage", (String)map.get("s_exception_message"));
            contentValues.put("precached", (String)map.get("s_pre_cached"));
            contentValues.put("redirected", (String)map.get("s_redirected"));
            context.getContentResolver().insert(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, contentValues);
            AkaHttpUtils.triggerAnalyticsIfNeeded(context);
        }
    }

    @AkamaiInternal
    @Keep
    public static void updateHttpStats(AkaHttpStatsCollector akaHttpStatsCollector) {
        Map<String, Object> map;
        Context context = VocAccelerator.getInstance().getAppContext();
        if (context != null && (map = akaHttpStatsCollector.getStats()) != null && map.size() > 0) {
            akaHttpStatsCollector.insert("i_batteryLevel", AkaHttpUtils.getBatteryLevel(context));
            akaHttpStatsCollector.insert("b_isCharging", AkaHttpUtils.isCharging(context));
            akaHttpStatsCollector.insert("s_connectionType", AkaHttpUtils.getConnectionType());
            akaHttpStatsCollector.insert("s_location", AkaHttpUtils.getLocation());
            akaHttpStatsCollector.insert("i_signalStrength", AkaHttpUtils.getSignalStrength());
            akaHttpStatsCollector.insert("l_maxRwnd", AkaHttpUtils.getRmemMax());
            akaHttpStatsCollector.insert("s_quic_enabled", 0);
            akaHttpStatsCollector.insert("i_mpType", 0);
            akaHttpStatsCollector.insert("i_mpWinner", -1);
            akaHttpStatsCollector.insert("i_mpMethod", -1);
            akaHttpStatsCollector.insert("s_ATries", 0);
            akaHttpStatsCollector.insert("s_AAAATries", 0);
            akaHttpStatsCollector.insert("s_brotliEnabled", 0);
            akaHttpStatsCollector.insert("s_brotliUsed", 0);
            akaHttpStatsCollector.insert("s_uniqueId", "");
            akaHttpStatsCollector.insert("s_pre_cached", "false");
            long l2 = (Long)map.get("s_sent_request");
            long l3 = (Long)map.get("s_rcvd_response");
            long l4 = l3 - l2;
            long l5 = (Long)map.get("l_contentLength");
            long l6 = (Long)map.get("l_duration");
            long l7 = l5 * 8L;
            if (l7 > 0L && l6 > 0L && l4 > 0L) {
                AnaBitRateCalculator anaBitRateCalculator = AnaBitRateCalculator.getInstance();
                anaBitRateCalculator.addBitRate(l7, l6, l4);
            }
            if (!AkaSessionHandler.isEnabled()) {
                return;
            }
            boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("log_analytics", false);
            if (bl2) {
                AkaHttpUtils.insertHttpStats(akaHttpStatsCollector);
                SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(context).edit();
                editor.putString("last_server_profile", (String)map.get("s_serverProfile"));
                editor.putString("last_amc_id", (String)map.get("s_amcId"));
                editor.putString("last_url_connected", (String)map.get("s_url"));
                editor.apply();
                long l8 = (Long)map.get("l_timeStamp");
                long l9 = (Long)map.get("l_ttfb");
                long l10 = (Long)map.get("s_read_start_time");
                long l11 = (Long)map.get("s_connect_time");
                String string = (String)map.get("s_url");
                if (l9 > 60000L) {
                    AnaWebDebugRecord.setHighTtfbRecord(string, l8, l11, l10, l9 < 300000L, context);
                }
            }
        }
    }

    @AkamaiInternal
    @Keep
    public static void submitTask(Runnable runnable) {
        VocAccelerator.getInstance().getHandler().submit(runnable);
    }

    @AkamaiInternal
    @Keep
    public static String getARHeaderString() {
        return VocAccelerator.sPackageName;
    }

    @AkamaiInternal
    @Keep
    public static boolean isResponseCacheable(Map<String, List<String>> map) {
        HashMap<String, String> hashMap = new HashMap();
        try {
            hashMap = AkaHttpUtils.convertToWebViewHeaders(map, false);
            AkaResponseHeaderParser akaResponseHeaderParser = new AkaResponseHeaderParser(hashMap);
            return akaResponseHeaderParser.canDownload();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getAMCHeaderName() {
        return "Akamai-Mobile-Connectivity";
    }

    public static String getARHeaderName() {
        return "Akamai-Referrer";
    }

    public static String getAMCIDHeaderName() {
        return "AMC-ID";
    }

    private static void triggerAnalyticsIfNeeded(final Context context) {
        if (++mActiveStatCounter >= AnaUtils.getSDKSharedPreferences(context).getInt("upload_threshold", 100)) {
            mActiveStatCounter = 0;
            VocAccelerator.getInstance().submitTask(new Runnable(){

                @Override
                public void run() {
                    AkaWebAnalyticsHandler.sendWebAnalytics(context);
                }
            });
        }
    }

    private static String getNetworkInfoForFTcpHeader() {
        NetworkInfo networkInfo;
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        AkaNetUtils akaNetUtils = vocAccelerator.getNetUtils();
        ConnectivityManager connectivityManager = vocAccelerator.getConnectivityManager();
        StringBuilder stringBuilder = new StringBuilder();
        String string = akaNetUtils.getNetworkType();
        String string2 = "";
        if (string.equals("cell")) {
            string2 = akaNetUtils.getCellSubType();
        }
        if ((string.isEmpty() || string.equals("cell") && string2.isEmpty()) && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                string = "wifi";
            } else if (networkInfo.getType() == 0) {
                string = "cell";
                string2 = AnaUtils.getNetworkGen(networkInfo.getSubtype());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("type=");
            stringBuilder.append(string);
            if (string.equals("cell") && !string2.isEmpty()) {
                stringBuilder.append("/");
                stringBuilder.append(string2);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
        return "";
    }

    @AkamaiInternal
    @Keep
    public static String getAkaUrl(URL uRL, String string) {
        if (uRL != null && string.equals("GET") && AkaHttpUtils.shouldAddIMQueryParam(uRL.toString())) {
            try {
                URI uRI = uRL.toURI();
                String string2 = uRI.getQuery();
                string2 = TextUtils.isEmpty((CharSequence)string2) ? IMAGE_MANAGER_QUERY_STRING : string2 + "&imformat=chrome";
                URI uRI2 = new URI(uRI.getScheme(), uRI.getAuthority(), uRI.getPath(), string2, null);
                String string3 = uRI2.toString();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    Logger.dd((String)("IM query added " + string3), (Object[])new Object[0]);
                    return string3;
                }
            }
            catch (Exception exception) {
                return uRL.toString();
            }
        }
        return uRL.toString();
    }

    private static boolean shouldAddIMQueryParam(String string) {
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        if (!vocAccelerator.getSecurePreferenceBoolean("use_IM", false)) {
            return false;
        }
        return AkaHttpUtils.isIMsupportedExtension(string);
    }

    @AkamaiInternal
    @Keep
    public static boolean isContentCached(String string) {
        VocAccelerator vocAccelerator = VocAccelerator.getInstance();
        if (!vocAccelerator.isURLCachedAndReady(string)) {
            return false;
        }
        AnaFeedItem anaFeedItem = AnaFeedController.getWebFeedItemByUrl(vocAccelerator.getAppContext(), string);
        return anaFeedItem != null && anaFeedItem.isResourceReady();
    }

    @AkamaiInternal
    @Keep
    public static void setControlPathHeaders(HttpsURLConnection httpsURLConnection) {
        String string = AkaHttpUtils.getAMCHeaderString(false);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            httpsURLConnection.setRequestProperty("Akamai-Mobile-Connectivity", string);
        }
        httpsURLConnection.setRequestProperty("x-akamai-log", "false");
        httpsURLConnection.setRequestProperty("x-user-type", "sdk");
    }

    public static String getHostName(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        return uRI.getHost();
    }

    static {
        mRmemMap = new Hashtable();
        IM_SUPPORTED_EXT_SET.add("jpg");
        IM_SUPPORTED_EXT_SET.add("jpeg");
        IM_SUPPORTED_EXT_SET.add("png");
        IM_SUPPORTED_EXT_SET.add("gif");
        IM_SUPPORTED_EXT_SET.add("tiff");
        IM_SUPPORTED_EXT_SET.add("bmp");
    }

    @AkamaiInternal
    @Keep
    static class CacheControlRequestParser {
        private boolean mNoCache;
        private int mMaxStale = Integer.MIN_VALUE;
        private int mMaxAge = Integer.MIN_VALUE;
        private boolean mNoStore;

        CacheControlRequestParser(String string) {
            AkaResponseHeaderParser.HeaderParser.CacheControlHandler cacheControlHandler = new AkaResponseHeaderParser.HeaderParser.CacheControlHandler(){

                @Override
                public void handle(String string, String string2) {
                    if ("no-cache".equalsIgnoreCase(string)) {
                        CacheControlRequestParser.this.mNoCache = true;
                    } else if ("max-stale".equalsIgnoreCase(string)) {
                        CacheControlRequestParser.this.mMaxStale = AkaResponseHeaderParser.HeaderParser.parseSeconds(string2);
                    } else if ("max-age".equalsIgnoreCase(string)) {
                        CacheControlRequestParser.this.mMaxAge = AkaResponseHeaderParser.HeaderParser.parseSeconds(string2);
                    } else if ("no-store".equalsIgnoreCase(string)) {
                        CacheControlRequestParser.this.mNoStore = true;
                    }
                }
            };
            if (!TextUtils.isEmpty((CharSequence)string)) {
                AkaResponseHeaderParser.HeaderParser.parseCacheControl(string, cacheControlHandler);
            }
        }

        public boolean isNoCache() {
            return this.mNoCache;
        }

        public boolean isNoStore() {
            return this.mNoStore;
        }

        public int getMaxAge() {
            return this.mMaxAge;
        }

        public int getMaxStale() {
            return this.mMaxStale;
        }
    }
}

