/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.util.Base64;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

class SecureWriter {
    private final Context mContext;

    SecureWriter(Context context) {
        this.mContext = context;
    }

    private Cipher getEncryptCipher(Context context) {
        try {
            Class<?> clazz = Class.forName("com.akamai.android.sdk.net.AkaCryptoHandler");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Context.class);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(context);
            Method method = clazz.getDeclaredMethod("getCipher", Integer.TYPE);
            method.setAccessible(true);
            return (Cipher)method.invoke(obj, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    String encrypt(byte[] byArray) throws Exception {
        Cipher cipher = this.getEncryptCipher(this.mContext);
        byte[] byArray2 = new byte[]{};
        if (cipher != null) {
            byArray2 = cipher.doFinal(byArray);
        }
        return Base64.encodeToString((byte[])byArray2, (int)2);
    }

    InputStream getEncryptedInputStream(InputStream inputStream) throws Exception {
        Cipher cipher = this.getEncryptCipher(this.mContext);
        if (cipher == null) {
            throw new Exception("No cipher to encrypt...Skip");
        }
        return new CipherInputStream(inputStream, cipher);
    }

    byte[] encryptContent(byte[] byArray) throws Exception {
        Cipher cipher = this.getEncryptCipher(this.mContext);
        if (cipher != null) {
            return cipher.doFinal(byArray);
        }
        return new byte[0];
    }
}

