/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Debug;
import android.preference.PreferenceManager;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.akamai.android.annotations.PublicApi;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.model.AkaEvictionStrategy;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.VocUtils;
import com.akamai.android.utils.AkaCommonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.List;

@PublicApi
public class AnaUtils
extends AkaCommonUtils {
    private static final String LOG_TAG = "AnaUtils";
    private static final int SECOND = 1;
    private static final int MINUTE_IN_SEC = 60;
    private static final int HOUR_IN_SEC = 3600;
    private static final int DAY_IN_SEC = 86400;

    private AnaUtils() {
    }

    private static String getTodPolicy(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("tod_policy", "");
        if (string == null || string.isEmpty()) {
            return "";
        }
        return string;
    }

    public static long getIndividualFileLimit(Context context) {
        long l2 = 0L;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("file_limit", "100");
        l2 = string.equals("Unlimited") ? Long.MAX_VALUE : Long.valueOf(string) * 0x100000L;
        return l2;
    }

    public static boolean isCongestionControlEnabled() {
        return VocAccelerator.getInstance().getSecurePreferenceBoolean("congestion_control", false);
    }

    public static String getCongestionControlServer(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return "FILL_IT";
    }

    public static boolean isCongestionControlEnabledWifi(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getBoolean("congestion_control_wifi", false) || AnaUtils.isCongestionControlEnabled();
    }

    public static boolean isFirstLaunch(@NonNull Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getBoolean("first_launch", true);
    }

    public static int getCongestionControlPort(Context context) {
        int n2;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("congestion_server_port", "50000");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.parseInt("50000");
        }
        return n2;
    }

    public static int getCongestionControlHighThreshold(Context context) {
        int n2;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("congestion_control_high_threshold", "80");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.parseInt("80");
        }
        return n2;
    }

    public static int getCongestionControlLowThreshold(Context context) {
        int n2;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("congestion_control_low_threshold", "40");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.parseInt("40");
        }
        return n2;
    }

    public static long getCongestionControlRetryInterval(Context context) {
        long l2;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("congestion_control_retry_interval", "2000");
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = Long.parseLong("2000");
        }
        return l2;
    }

    public static boolean isWifiConnected(Context context) {
        boolean bl2 = false;
        try {
            ConnectivityManager connectivityManager = VocAccelerator.getInstance().getConnectivityManager();
            NetworkInfo networkInfo = AnaUtils.getNetworkInfo(connectivityManager, 1);
            NetworkInfo networkInfo2 = AnaUtils.getNetworkInfo(connectivityManager, 9);
            if (networkInfo != null && networkInfo.isConnected() && !AnaUtils.isActiveNetworkMetered(connectivityManager) && AnaUtils.isDefaultNetwork(connectivityManager, networkInfo) || networkInfo2 != null && networkInfo2.isConnected() && AnaUtils.isDefaultNetwork(connectivityManager, networkInfo2)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("Unable to get wifi info " + exception));
        }
        return bl2;
    }

    @SuppressLint(value={"MissingPermission"})
    public static int getSignalStrength(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (Build.VERSION.SDK_INT > 17) {
                List list = null;
                if (telephonyManager != null) {
                    list = telephonyManager.getAllCellInfo();
                }
                if (list != null && list.size() > 0) {
                    for (CellInfo cellInfo : list) {
                        if (!cellInfo.isRegistered()) continue;
                        if (cellInfo instanceof CellInfoGsm) {
                            CellInfoGsm cellInfoGsm = (CellInfoGsm)cellInfo;
                            return cellInfoGsm.getCellSignalStrength().getAsuLevel();
                        }
                        if (cellInfo instanceof CellInfoLte) {
                            CellInfoLte cellInfoLte = (CellInfoLte)cellInfo;
                            return cellInfoLte.getCellSignalStrength().getAsuLevel();
                        }
                        if (cellInfo instanceof CellInfoCdma) {
                            CellInfoCdma cellInfoCdma = (CellInfoCdma)cellInfo;
                            return cellInfoCdma.getCellSignalStrength().getAsuLevel();
                        }
                        if (!(cellInfo instanceof CellInfoWcdma)) continue;
                        CellInfoWcdma cellInfoWcdma = (CellInfoWcdma)cellInfo;
                        return cellInfoWcdma.getCellSignalStrength().getAsuLevel();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static NetworkInfo getNetworkInfo(ConnectivityManager connectivityManager, int n2) {
        block5: {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    Network[] networkArray = connectivityManager.getAllNetworks();
                    if (networkArray != null) {
                        for (Network network : networkArray) {
                            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
                            if (networkInfo == null || networkInfo.getType() != n2) continue;
                            return networkInfo;
                        }
                    }
                    break block5;
                }
                return connectivityManager.getNetworkInfo(n2);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("Unable to get network info " + exception));
            }
        }
        return null;
    }

    private static boolean isDefaultNetwork(ConnectivityManager connectivityManager, NetworkInfo networkInfo) {
        NetworkInfo networkInfo2 = connectivityManager.getActiveNetworkInfo();
        return networkInfo2 != null && networkInfo != null && networkInfo2.getType() == networkInfo.getType();
    }

    private static boolean isActiveNetworkMetered(ConnectivityManager connectivityManager) {
        if (Build.VERSION.SDK_INT >= 16) {
            return connectivityManager.isActiveNetworkMetered();
        }
        return false;
    }

    public static boolean isCellularConnected(Context context) {
        boolean bl2 = false;
        try {
            ConnectivityManager connectivityManager = VocAccelerator.getInstance().getConnectivityManager();
            NetworkInfo networkInfo = AnaUtils.getNetworkInfo(connectivityManager, 0);
            NetworkInfo networkInfo2 = AnaUtils.getNetworkInfo(connectivityManager, 1);
            if (networkInfo != null && networkInfo.isConnected() && AnaUtils.isDefaultNetwork(connectivityManager, networkInfo) || networkInfo2 != null && networkInfo2.isConnected() && AnaUtils.isActiveNetworkMetered(connectivityManager) && AnaUtils.isDefaultNetwork(connectivityManager, networkInfo2)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("Unable to get cell info " + exception));
        }
        return bl2;
    }

    public static String getNetworkTypeName(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = VocAccelerator.getInstance().getConnectivityManager();
        if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                return "WIFI";
            }
            if (networkInfo.getType() == 0) {
                return AnaUtils.getRatTypeForCell(networkInfo.getSubtype());
            }
        }
        return "";
    }

    public static boolean is3GAndAbove(Context context, int n2) {
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        boolean bl2 = false;
        if (n2 == 0 && (networkInfo = AnaUtils.getNetworkInfo(connectivityManager = VocAccelerator.getInstance().getConnectivityManager(), 0)) != null && networkInfo.isConnected()) {
            n2 = networkInfo.getSubtype();
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                bl2 = false;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean isBatteryCharging(Context context) {
        try {
            Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (intent == null) {
                return false;
            }
            return intent.getIntExtra("status", -1) == 2 || intent.getIntExtra("status", -1) == 5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getBatteryLevel(Context context) {
        try {
            Intent intent = context.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            int n2 = 0;
            if (intent == null) {
                return n2;
            }
            int n3 = intent.getIntExtra("level", 0);
            int n4 = intent.getIntExtra("scale", 0);
            n2 = n3 == 0 || n4 == 0 ? 0 : n3 * 100 / n4;
            return n2;
        }
        catch (Exception exception) {
            return 100;
        }
    }

    public static Location getLocation(Context context) {
        Location location = null;
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            List list = locationManager.getAllProviders();
            float f2 = Float.MAX_VALUE;
            long l2 = 0L;
            for (String string : list) {
                Location location2 = locationManager.getLastKnownLocation(string);
                if (location2 == null) continue;
                float f3 = location2.getAccuracy();
                long l3 = location2.getTime();
                if (l3 <= l2 || !(f3 < f2)) continue;
                location = location2;
                f2 = f3;
                l2 = l3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return location;
    }

    public static String getBuildVersion() {
        return "21.30.6";
    }

    public static String getHostAppVersion(Context context) {
        String string = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.versionName;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaUtils: Cannot find package info");
        }
        return string;
    }

    @PublicApi
    @Keep
    @SuppressLint(value={"HardwareIds"})
    public static void logCurrentState(Context context) {
        String string = VocUtils.getMediaPath(context);
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        boolean bl2 = sharedPreferences.getBoolean("use_new_quota_values", false);
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Version " + AnaUtils.getBuildVersion()));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: TOD " + AnaUtils.getTodPolicy(context)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Battery Level " + AnaUtils.getBatteryLevel(context)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Total Memory  " + AnaDiskUtils.totalMemory(string) / 1048576.0f + " MB"));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Used Memory  " + AnaDiskUtils.usedMemory(string) / 1048576.0f + " MB"));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Free Memory  " + AnaDiskUtils.freeMemory(string) / 1048576.0f + " MB"));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Device Type " + Build.MODEL));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: OS Version " + Build.VERSION.RELEASE));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Wifi Status " + AnaUtils.isWifiConnected(context)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Aborted notification " + sharedPreferences.getBoolean("abortedNotification", false)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Pending sync " + sharedPreferences.getBoolean("pending_sync", false)));
        if (!bl2) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota limit  " + sharedPreferences.getLong("daily_download_quota", -1L)));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota type  " + sharedPreferences.getString("daily_quota_type", "")));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota usage  " + sharedPreferences.getLong("daily_quota_usage", 0L)));
        } else {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota limit WiFi " + sharedPreferences.getLong("daily_wifi_quota", -1L)));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota usage WiFi " + sharedPreferences.getLong("daily_quota_usage_wifi", 0L)));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota limit Cellular " + sharedPreferences.getLong("daily_cellular_quota", -1L)));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota usage Cellular " + sharedPreferences.getLong("daily_quota_usage_cellular", 0L)));
        }
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Daily quota timestamp " + sharedPreferences.getLong("daily_quota_ts", 0L)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Network preference  " + sharedPreferences.getString("network_preference", "0")));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Prefetch storage limit  " + sharedPreferences.getString("prefetch_storage_limit", "0") + " MB"));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: last cache fill  " + sharedPreferences.getLong("last_cache_fill", 0L)));
        Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: Current server ssl certificate " + sharedPreferences.getString("sslCertificate", "")));
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int n2 = android.os.Process.myPid();
        int[] nArray = new int[]{n2};
        Debug.MemoryInfo[] memoryInfoArray = new Debug.MemoryInfo[]{};
        if (activityManager != null) {
            memoryInfoArray = activityManager.getProcessMemoryInfo(nArray);
        }
        if (memoryInfoArray != null && memoryInfoArray.length > 0) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AnaUtils: Misc " + memoryInfoArray[0].getTotalPss() + " , " + memoryInfoArray[0].getTotalPrivateDirty() + " , " + memoryInfoArray[0].getTotalSharedDirty()));
        }
    }

    public static boolean isPrefetchAllowed(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getBoolean("prefetch_enabled", true);
    }

    public static long getLTECongHighThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_lte_high_threshold", 0x300000L);
    }

    public static long getLTECongLowThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_lte_low_threshold", 524288L);
    }

    public static long get3GCongHighThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_3g_high_threshold", 0x100000L);
    }

    public static long get3GCongLowThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_3g_low_threshold", 524288L);
    }

    public static long getHSPACongHighThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_hspa_high_threshold", 0x100000L);
    }

    public static long getHSPACongLowThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_hspa_low_threshold", 524288L);
    }

    public static long getEDGECongHighThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_edge_high_threshold", 524288L);
    }

    public static long getEDGECongLowThreshold(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getLong("cong_edge_low_threshold", 262144L);
    }

    public static String getNetworkGen(int n2) {
        String string;
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                string = "2G";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 14: {
                string = "3G";
                break;
            }
            case 12: {
                string = "3.5G";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                string = "4G";
                break;
            }
            default: {
                string = "4G";
            }
        }
        return string;
    }

    private static String getRatTypeForCell(int n2) {
        String string;
        switch (n2) {
            case 11: {
                string = "IDEN";
                break;
            }
            case 4: {
                string = "CDMA";
                break;
            }
            case 7: {
                string = "1xRTT";
                break;
            }
            case 2: {
                string = "EDGE";
                break;
            }
            case 1: {
                string = "GPRS";
                break;
            }
            case 5: {
                string = "EVDO_0";
                break;
            }
            case 6: {
                string = "EVDO_A";
                break;
            }
            case 3: {
                string = "UMTS";
                break;
            }
            case 10: {
                string = "HSPA";
                break;
            }
            case 14: {
                string = "EHRPD";
                break;
            }
            case 12: {
                string = "EVDO_B";
                break;
            }
            case 15: {
                string = "HSPAP";
                break;
            }
            case 9: {
                string = "HSUPA";
                break;
            }
            case 13: {
                string = "LTE";
                break;
            }
            case 16: {
                string = "GSM";
                break;
            }
            case 8: {
                string = "HSDPA";
                break;
            }
            case 18: {
                string = "IWLAN";
                break;
            }
            default: {
                string = "";
            }
        }
        return "MOBILE:" + string;
    }

    public static String getNetworkQualityMethod(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getString("network_quality_method", "https");
    }

    public static String getNetworkQualityUri(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getString("network_quality_uri", "ion.ludin.org/akamai-mobile/v1/network-quality-test");
    }

    public static int getNetworkQualityPingCount(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_ping_count", 5);
    }

    public static int getNetworkQualityPingFrequency(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_ping_frequency", 2);
    }

    public static int getNetworkQualityDuration(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_duration", 30);
    }

    public static int getNetworkQualityFrequency(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_frequency", 5);
    }

    public static int get2GTestTimeout(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_2g_timeout", 1200);
    }

    public static int get3GTestTimeout(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_3g_timeout", 800);
    }

    public static int get3_5GTestTimeout(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_3_5g_timeout", 800);
    }

    public static int get4GTestTimeout(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getInt("network_quality_4g_timeout", 600);
    }

    public static String getCarrier(Context context) {
        String string = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaUtils: Unable to get carrier info: " + exception));
        }
        return string;
    }

    public static SharedPreferences getSDKSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (sharedPreferences.getBoolean("prefsCopyFailedOnUpgrade", false)) {
            return sharedPreferences;
        }
        return context.getSharedPreferences("com.akamai.android.sdk.PCDPreferences", 0);
    }

    public static AkaEvictionStrategy getEvictionStrategy(Context context) {
        String string = AnaUtils.getSDKSharedPreferences(context).getString("eviction_strategy", AkaEvictionStrategy.Least_Frequently_Used.getShortName());
        return AkaEvictionStrategy.get(string);
    }

    public static void loadDefaultPrefs(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        Logger.dd((String)"AkaSdkLogger-map", (String)"AnaUtils: loading default prefs");
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (!sharedPreferences.contains("server_ip_address")) {
            editor.putString("network_preference", "2");
            editor.putString("prefetch_storage_limit", "3000");
            editor.putString("file_limit", "100");
            editor.putString("sdk_version", AnaUtils.getBuildVersion());
            if (!sharedPreferences.contains("encryption_enabled")) {
                editor.putBoolean("encryption_enabled", true);
            }
            editor.apply();
        }
    }

    public static String getTcpBuffSizes(ConnectivityManager connectivityManager, Context context, NetworkInfo networkInfo) {
        if (networkInfo == null || !networkInfo.isConnected()) {
            return "";
        }
        if (Build.VERSION.SDK_INT >= 21) {
            for (Network network : connectivityManager.getAllNetworks()) {
                NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(network);
                if (networkInfo2 == null || networkInfo2.getType() != networkInfo.getType() || !networkInfo2.isConnected()) continue;
                LinkProperties linkProperties = connectivityManager.getLinkProperties(network);
                String string = "";
                try {
                    Method method = linkProperties.getClass().getMethod("getTcpBufferSizes", null);
                    string = (String)method.invoke((Object)linkProperties, (Object[])null);
                }
                catch (Exception exception) {
                    Logger.d((String)"AkaSdkLogger-map", (String)("AnaUtils: getTcpBuffSizes(): " + exception));
                }
                return string;
            }
        } else if (Build.VERSION.SDK_INT >= 15) {
            String string = "";
            if (AnaUtils.isWifiConnected(context)) {
                string = "net.tcp.buffersize.wifi";
            } else if (AnaUtils.isCellularConnected(context)) {
                string = AnaUtils.getTcpBufferProperty(networkInfo.getSubtype());
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                try {
                    return AnaUtils.getProperty(string);
                }
                catch (Exception exception) {
                    Logger.d((String)"AkaSdkLogger-map", (String)("AnaUtils: getTcpBufferSize(): " + exception));
                }
            }
        }
        return "";
    }

    public static String getTcpBufferProperty(int n2) {
        String string = "";
        switch (n2) {
            case 2: {
                string = "net.tcp.buffersize.edge";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                string = "net.tcp.buffersize.evdo";
                break;
            }
            case 1: {
                string = "net.tcp.buffersize.gprs";
                break;
            }
            case 8: {
                string = "net.tcp.buffersize.hsdpa";
                break;
            }
            case 10: {
                string = "net.tcp.buffersize.hspa";
                break;
            }
            case 15: {
                string = "net.tcp.buffersize.hspap";
                break;
            }
            case 9: {
                string = "net.tcp.buffersize.hsupa";
                break;
            }
            case 3: {
                string = "net.tcp.buffersize.umts";
                break;
            }
            case 13: {
                string = "net.tcp.buffersize.umts";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String string) {
        Process process = null;
        String string2 = "";
        try {
            process = Runtime.getRuntime().exec("/system/bin/getprop " + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = "";
            try {
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append("\n");
                }
            }
            catch (IOException iOException) {
                Logger.d((String)"AkaSdkLogger-map", (String)("AnaUtils: getProperty " + iOException));
            }
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtils: getProperty(): " + stringBuilder));
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AnaUtils: getProperty " + exception));
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    public static boolean isEmulator() {
        boolean bl2 = false;
        try {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsPRODUCT:" + Build.PRODUCT));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsMANUFACTURER :" + Build.MANUFACTURER));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsBRAND :" + Build.BRAND));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsDEVICE :" + Build.DEVICE));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsMODEL :" + Build.MODEL));
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaUtilsFINGERPRINT :" + Build.FINGERPRINT));
            if (Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.MANUFACTURER.equals("unknown") || Build.DEVICE.startsWith("generic") || Build.DEVICE.equals("vbox86p") || Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("vbox86p") || Build.PRODUCT.equals("sdk_google_phone_x86") || Build.BRAND.contains("generic")) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public static long getCurrentUTCTimeInSeconds() {
        return AnaUtils.getCurrentUTCTimeInMillis() / 1000L;
    }
}

