/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.db;

import android.content.Context;
import android.net.Uri;
import java.util.List;
import java.util.Set;

public final class AnaProviderContract {
    private static boolean sIsInitialized = false;
    static String AUTHORITY = "";
    private static Uri AUTHORITY_URI = Uri.parse((String)("content://" + AUTHORITY));
    static final String FEEDITEMS = "feeditems";
    static final String FEEDITEMCOUNT = "feeditemcount";
    static final String HTTPSTATS = "httpstats";
    static final String SESSIONSTATS = "sessionstats";
    static final String USEREVENTS = "userevents";
    static final String EVENTLOGS = "eventlogs";
    static final String SEGMENTS = "segments";
    static final String DELETED_FEEDS = "deletedfeeds";
    static final String FEEDSTATS = "feedstats";
    public static Uri CONTENT_URI_FEEDS = Uri.parse((String)("content://" + AUTHORITY + "/" + "feeditems"));
    public static Uri CONTENT_URI_SEGMENT_SUBSCRIPTION = Uri.parse((String)("content://" + AUTHORITY + "/" + "segments"));
    public static Uri CONTENT_URI_FEED_DELETED = Uri.parse((String)("content://" + AUTHORITY + "/deleted/"));
    public static Uri CONTENT_URI_FEEDS_FILTER = Uri.parse((String)("content://" + AUTHORITY + "/" + "feeditems" + "/filter/"));
    public static Uri CONTENT_URI_FEEDS_COUNT = Uri.parse((String)("content://" + AUTHORITY + "/" + "feeditemcount"));
    public static Uri HTTP_CONSUMPTION_STATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "httpstats"));
    public static Uri ACTIVITY_SESSION_STATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "sessionstats"));
    public static Uri USER_EVENTS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "userevents"));
    public static Uri EVENT_LOG_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "eventlogs"));
    public static Uri FEEDSTATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "feedstats"));
    public static Uri DELETED_FEEDS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + "deletedfeeds"));
    public static final String FEEDITEM_SORTORDER_FOR_LFU = "viewcount ASC, ";
    public static final String FEEDITEM_SORTORDER_FOR_LRU = "accessts ASC, ";
    public static final String FEEDITEM_DOWNLOAD_ORDER_PRIORITY_TIMESTAMP = "priority ASC, timestamp DESC";
    public static final String[] WEBFEEDITEM_COLUMNS = new String[]{"_id", "url", "resourceready", "refreshtimestamp", "maxage", "responseheaders", "videofile", "feedtype", "viewcount", "accessts", "syncPending", "segment", "size", "mustRevalidate", "dlUrl", "networkSelection"};

    private AnaProviderContract() {
    }

    public static String getIdSelectionClause(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        if (n2 > 0) {
            stringBuilder.append("_id");
            stringBuilder.append(" IN (");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("'");
                stringBuilder.append(list.get(i2));
                stringBuilder.append("'");
                if (i2 == n2 - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String getIdSelectionClause(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = set.size();
        if (n2 > 0) {
            stringBuilder.append("_id");
            stringBuilder.append(" IN (");
            int n3 = 0;
            for (String string : set) {
                stringBuilder.append("'");
                stringBuilder.append(string);
                stringBuilder.append("'");
                if (n3 != n2 - 1) {
                    stringBuilder.append(",");
                }
                ++n3;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String getProviderSelectionClause(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("provider");
            stringBuilder.append("=");
            stringBuilder.append("'");
            stringBuilder.append(list.get(i2));
            stringBuilder.append("'");
            if (i2 == n2 - 1) continue;
            stringBuilder.append(" OR ");
        }
        return stringBuilder.toString();
    }

    public static synchronized void initialize(Context context) {
        if (context == null || sIsInitialized) {
            return;
        }
        AUTHORITY = context.getPackageName() + ".AnaContentProvider";
        AUTHORITY_URI = Uri.parse((String)("content://" + AUTHORITY));
        CONTENT_URI_FEEDS = Uri.parse((String)("content://" + AUTHORITY + "/" + FEEDITEMS));
        CONTENT_URI_FEED_DELETED = Uri.parse((String)("content://" + AUTHORITY + "/deleted/"));
        CONTENT_URI_FEEDS_FILTER = Uri.parse((String)("content://" + AUTHORITY + "/" + FEEDITEMS + "/filter/"));
        CONTENT_URI_FEEDS_COUNT = Uri.parse((String)("content://" + AUTHORITY + "/" + FEEDITEMCOUNT));
        HTTP_CONSUMPTION_STATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + HTTPSTATS));
        ACTIVITY_SESSION_STATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + SESSIONSTATS));
        USER_EVENTS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + USEREVENTS));
        EVENT_LOG_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + EVENTLOGS));
        CONTENT_URI_SEGMENT_SUBSCRIPTION = Uri.parse((String)("content://" + AUTHORITY + "/" + SEGMENTS));
        DELETED_FEEDS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + DELETED_FEEDS));
        FEEDSTATS_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + FEEDSTATS));
        sIsInitialized = true;
    }

    public static String getAuthority() {
        return AUTHORITY;
    }

    public static final class DeletedFeeds {
        public static final String ID = "_id";
        public static final String TIMESTAMP = "timestamp";
    }

    public static final class SegmentSubscription {
        public static final String LONGNAME = "sgmntlname";
        public static final String SHORTNAME = "sgmntsname";
        public static final String HTTP_TS = "httpts";
        public static final String SERVER_TS = "timestamp";
        public static final String SUBSCRIBED = "subscribed";
        public static final String DOWNLOAD_MANIFEST_TS = "downloadManifestTS";
        public static final String FG_SEGMENT = "fgSegment";
    }

    public static final class EventLog {
        public static final String ID = "_id";
        public static final String NAME = "name";
        public static final String TIMESTAMP = "timestamp";
        public static final String SESSIONID = "sessionId";
    }

    public static final class UserEvents {
        public static final String ID = "_id";
        public static final String NAME = "name";
        public static final String START_TIME = "starttime";
        public static final String STOP_TIME = "stoptime";
        public static final String CONNECTION_TYPE = "connectiontype";
        public static final String SESSIONID = "sessionId";
    }

    public static final class SessionStats {
        public static final String ID = "_id";
        public static final String TIMESTAMP = "timestamp";
        public static final String DURATION = "duration";
        public static final String NAME = "name";
    }

    public static final class HttpStats {
        public static final String ID = "_id";
        public static final String FEED_ID = "feedid";
        public static final String URL = "url";
        public static final String DOWNLOAD_TYPE = "downloadtype";
        public static final String TIMESTAMP = "timestamp";
        public static final String DURATION = "duration";
        public static final String TTFB = "ttfb";
        public static final String BATTERY_LEVEL = "batterylevel";
        public static final String CHARGING = "ischarging";
        public static final String CONNECTION_TYPE = "connectiontype";
        public static final String LOCATION = "location";
        public static final String SIGNAL_STRENGTH = "signalstrength";
        public static final String RESPONSE_CODE = "respcode";
        public static final String REQUEST_HEADER_SIZE = "requestheadersize";
        public static final String RESPONSE_HEADER_SIZE = "responseheadersize";
        public static final String CONTENT_LENGTH = "contentlength";
        public static final String MIME_TYPE = "mimetype";
        public static final String MULTIPATH_TYPE = "mptype";
        public static final String MULTIPATH_WINNER = "mpwinner";
        public static final String MULTIPATH_METHOD = "mpmethod";
        public static final String SERVER_PROFILE = "serverprofile";
        public static final String AMC_ID = "amcid";
        public static final String QUIC_ENABLED = "quicEnabled";
        public static final String REQUEST_TYPE = "requestType";
        public static final String IPV4_TRIES = "v4Tries";
        public static final String IPV6_TRIES = "v6Tries";
        public static final String CONTENT_LENGTH_HEADER = "contentLengthHeader";
        public static final String MAX_RWND_HEADER = "maxRwnd";
        public static final String BROTLI_ENABLED = "brotliEnabled";
        public static final String BROTLI_USED = "brotliUsed";
        public static final String CACHEABLE = "cacheable";
        public static final String TPRESULT = "tpResult";
        public static final String SESSIONID = "sessionId";
        public static final String EXCEPTION_MESSAGE = "exceptionMessage";
        public static final String PRECACHED = "precached";
        public static final String REDIRECTED = "redirected";
    }

    public static final class FeedItem {
        public static final String ID = "_id";
        public static final String PROVIDER = "provider";
        public static final String URL = "url";
        public static final String DL_URL = "dlUrl";
        public static final String FILE_NAME = "videofile";
        public static final String FILE_MIMETYPE = "feedtype";
        public static final String SIZE = "size";
        public static final String TIMESTAMP = "timestamp";
        public static final String CREATION_TIMESTAMP = "creationtimestamp";
        public static final String REFRESH_TIMESTAMP = "refreshtimestamp";
        public static final String MAX_AGE = "maxage";
        public static final String FEED_MUSTREVALIDATE = "mustRevalidate";
        public static final String RESOURCEREADY = "resourceready";
        public static final String ACCESS_COUNT = "viewcount";
        public static final String LAST_ACCESS_TS = "accessts";
        public static final String CACHE_TYPE = "syncPending";
        public static final String FEED_SEGMENT = "segment";
        public static final String RESP_HEADERS = "responseheaders";
        public static final String DOWNLOAD_PRIORITY = "priority";
        public static final String NETWORK_SELECTION = "networkSelection";
        public static final String DELETE_STATUS = "status";
    }
}

