/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.cronet.IAkaCronetEngine;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AnaBitRateCalculator;
import com.akamai.android.sdk.internal.AnaFeedController;
import com.akamai.android.sdk.internal.AnaWebDebugRecord;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.AkaCryptoHandler;
import com.akamai.android.sdk.net.AkaDefErrorStream;
import com.akamai.android.sdk.net.AkaDefHttpURLConn;
import com.akamai.android.sdk.net.AkaDefOutputStream;
import com.akamai.android.sdk.net.AkaHttpStatsCollector;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.AkaInputStream;
import com.akamai.android.sdk.net.AkaMultiPathHandler;
import com.akamai.android.sdk.net.AkaResponseHeaderParser;
import com.akamai.android.sdk.net.AkaUrlStat;
import com.akamai.android.sdk.net.AkaUrlStatCollector;
import com.akamai.android.sdk.net.DnsHandler;
import com.akamai.android.sdk.net.MultiPathRequest;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.ErrorUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;

public class AkaURLConnection
extends AkaDefHttpURLConn {
    private static final String TAG = "AkaURLConnection";
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String ACCEPT_ENCODING_HEADER_VALUE = "gzip, br";
    private static final String X_ANDROID_RESPONSE_HEADER = "X-Android-Response-Source";
    private static final String X_ANDROID_RESPONSE_HEADER_VALUE_CACHE = "CACHE";
    private static final String X_ANDROID_RESPONSE_HEADER_VALUE_COND_CACHE = "CONDITIONAL_CACHE";
    VocAccelerator mAccelerator;
    private int mType;
    static final int TYPE_CACHED = 0;
    private static final int TYPE_HTTP = 1;
    private static final int TYPE_HTTPS = 2;
    private static final int TYPE_CACHED_EXPIRED = 3;
    private AnaFeedItem mFeedItem;
    private Map<String, String> mResponseHeaders;
    Map<String, String> mRequestHeaders;
    private String mPathToContent;
    private long mTTFB = 0L;
    String mRequestMethod = "GET";
    int mReadTimeout = -1;
    int mConnectTimeout = -1;
    int mFixedContentLength = -1;
    int mChunkLength = -1;
    private static final int DEFAULT_CHUNK_LENGTH = 1024;
    private long mRequestTime = System.currentTimeMillis();
    private boolean mNoCache_request;
    private boolean mIsMultiPath;
    private boolean mIsQUIC;
    private boolean mWasSecondaryAbortedByGhost;
    HashSet<String> mIPTested;
    private int mMultiPathMethod = -1;
    private volatile boolean mIsWinnerSelected;
    private volatile int mErrorCount = 0;
    private IOException mConnectException;
    private MultiPathRequest mMainRequest;
    byte[] mPostData;
    String mUrl_toString;
    String mOriginalUrl_toString;
    boolean mIsSecureRequest;
    HostnameVerifier mHostnameVerifier;
    SSLSocketFactory mSSLSocketFactory;
    private boolean mIsCacheFill;
    private boolean mIsJpgRequest;
    Proxy mProxy;
    private boolean mUniversalCacheEnabled;
    private boolean mSetInstanceFollowRedirects = true;
    private boolean mSinglePathUsingMPWinner = false;
    private boolean mIsCookieUpdated = false;
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private boolean mIsBrotliEnabled = false;
    private boolean mIsBrotliUsed = false;
    private int mWinningIpType = -1;
    private long mConnectTime = 0L;
    private boolean mUseCaches = true;
    private static final String[] PERMITTED_USER_METHODS = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE"};
    static final ExecutorService sThreadPool = Executors.newCachedThreadPool();
    static boolean sIsDNSLibraryPresent = false;
    private AkaInputStream mInputStream;
    public static int NETWORK_REQUESTS;
    public static int CACHED_REQUESTS;
    public static long NETWORK_DOWNLOAD_SZ;
    public static long CACHED_DOWNLOAD_SZ;
    public static long NETWORK_LOAD_TIME;
    public static long CACHED_LOAD_TIME;
    private static final Object sLock;
    private static volatile boolean ENABLE_DEBUG_STATS;

    AkaURLConnection(URL uRL) {
        super(uRL);
        this.mAccelerator = VocAccelerator.getInstance();
        if (this.mAccelerator.getAppContext() == null) {
            throw new IllegalStateException("SDK not initialized. Refer integration guide to see if there is any missing setup.");
        }
        this.init();
    }

    private void init() {
        this.mRequestHeaders = new HashMap<String, String>();
        this.mUrl_toString = this.url.toString();
        this.mOriginalUrl_toString = this.url.toString();
        this.mIsSecureRequest = this.url.getProtocol().equalsIgnoreCase("https");
        this.mRequestHeaders.put("Akamai-Referrer", VocAccelerator.sPackageName);
        this.mUniversalCacheEnabled = this.mAccelerator.getSecurePreferenceBoolean("universal_cache", false);
        if (this.mAccelerator.isURLCachedAndReady(this.mUrl_toString)) {
            this.mFeedItem = AnaFeedController.getWebFeedItemByUrl(this.mAccelerator.getAppContext(), this.mUrl_toString);
        }
        if (this.mFeedItem == null || !this.mFeedItem.isResourceReady()) {
            this.mType = !this.mIsSecureRequest ? 1 : 2;
        } else {
            long l2 = this.mFeedItem.getRefreshTimeStamp() + TimeUnit.SECONDS.toMillis(AkaHttpUtils.getMaxAge(this.mFeedItem, this.mAccelerator.getSharedPreferences()));
            if (this.mRequestTime <= l2) {
                this.mType = 0;
                this.debugLog(TAG, "type: cached");
            } else {
                this.mType = 3;
                this.debugLog(TAG, "type: cached expired");
            }
        }
    }

    private void debugLog(Object ... objectArray) {
        if (this.mLogStats && !this.mIsCacheFill) {
            Logger.dd((String)"AkaSdkLogger-map", (Object[])objectArray);
        }
    }

    protected void setProxy(Proxy proxy) {
        this.mProxy = proxy;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mHostnameVerifier = hostnameVerifier;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.mSSLSocketFactory = sSLSocketFactory;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    int getType() {
        return this.mType;
    }

    protected URLConnection getConnection() {
        return this.mUrlConnection;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            if (this.mConnectException != null) {
                throw this.mConnectException;
            }
            if (this.mLogStats) {
                this.mAccelerator.submitTask(new Runnable(){

                    @Override
                    public void run() {
                        AkaUrlStat akaUrlStat = new AkaUrlStat();
                        URL uRL = AkaURLConnection.this.mOriginalUrl != null ? AkaURLConnection.this.mOriginalUrl : AkaURLConnection.this.url;
                        akaUrlStat.mUrl = uRL;
                        akaUrlStat.mStartTime = AkaURLConnection.this.mStartTime;
                        AkaUrlStatCollector.getInstance().urlReqStart((Object)AkaURLConnection.this.mUrlConnection, akaUrlStat);
                    }
                });
            }
            try {
                switch (this.mType) {
                    case 0: {
                        boolean bl2 = false;
                        try {
                            String string = VocUtils.getContentPath(this.mAccelerator.getAppContext(), this.mFeedItem);
                            File file = new File(string);
                            if (file.exists() && file.length() > 0L && this.mUseCaches) {
                                long l2 = this.mFeedItem.getSize() > 0L ? this.mFeedItem.getSize() : file.length();
                                this.mConnectTime = this.mStartTime = AnaUtils.getCurrentUTCTimeInMillis();
                                bl2 = true;
                                this.mPathToContent = string;
                                this.mResponseHeaders = AkaHttpUtils.parseHeadersFromString(this.mFeedItem.getRespHeaders());
                                this.mResponseHeaders.put(CONTENT_LENGTH_HEADER.toLowerCase(), Long.toString(l2));
                                this.mResponseHeaders.put("Content-Type".toLowerCase(), this.mFeedItem.getMimeType());
                                this.mAccelerator.updateFeedStats(this.mFeedItem, this.mStartTime, true);
                            }
                        }
                        catch (Exception exception) {
                            Logger.e((String)"AkaSdkLogger-map", (String)"AkaURLConnection: File not found: Invalid cache entry");
                        }
                        if (bl2) break;
                        this.mType = !this.mIsSecureRequest ? 1 : 2;
                        this.connect();
                        return;
                    }
                    case 1: 
                    case 2: {
                        this.sendRequest(false);
                        break;
                    }
                    case 3: {
                        String string;
                        boolean bl3 = false;
                        if (!TextUtils.isEmpty((CharSequence)this.mFeedItem.getRespHeaders())) {
                            bl3 = AkaHttpUtils.containsRevalidationHeaders(this.mFeedItem.getRespHeaders());
                        }
                        if (!bl3) {
                            this.debugLog(TAG, "cache expired: no revalidation headers");
                            this.mType = !this.mIsSecureRequest ? 1 : 2;
                            this.connect();
                            return;
                        }
                        Map<String, String> map = AkaHttpUtils.parseHeadersFromString(this.mFeedItem.getRespHeaders());
                        String string2 = map.get("last-modified");
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            this.mRequestHeaders.put("If-Modified-Since", string2);
                        }
                        if (!TextUtils.isEmpty((CharSequence)(string = map.get("etag")))) {
                            this.mRequestHeaders.put("If-None-Match", AkaHttpUtils.getQuotedString(string));
                        }
                        this.sendRequest(true);
                        int n2 = ((HttpURLConnection)this.mUrlConnection).getResponseCode();
                        if (n2 == 304) {
                            this.debugLog(TAG, "Content not modified, serve from cache");
                            AkaHttpUtils.updateResponseHeaders(AkaHttpUtils.convertToWebViewHeaders(this.mUrlConnection.getHeaderFields(), true), map, this.mAccelerator.getAppContext(), this.mFeedItem);
                            this.mType = 0;
                            ((HttpURLConnection)this.mUrlConnection).disconnect();
                            this.connect();
                            return;
                        }
                        this.debugLog(TAG, "Content modified");
                        this.mType = !this.mIsSecureRequest ? 1 : 2;
                    }
                }
                this.connected = true;
            }
            catch (IOException iOException) {
                this.updateException(iOException);
                throw iOException;
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaURLConnection: connect() failed with : " + exception));
            }
        }
    }

    public void setInstanceFollowRedirects(boolean bl2) {
        this.mSetInstanceFollowRedirects = bl2;
    }

    public void setUseCaches(boolean bl2) {
        this.mUseCaches = bl2;
    }

    public boolean getUseCaches() {
        return this.mUseCaches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(boolean bl2) throws IOException {
        block23: {
            String string;
            String string2;
            this.mIsMultiPath = false;
            if (!this.mRequestHeaders.containsKey("Akamai-Mobile-Connectivity") && !TextUtils.isEmpty((CharSequence)(string2 = AkaHttpUtils.getAMCHeaderString(this.mIsCacheFill)))) {
                this.mRequestHeaders.put("Akamai-Mobile-Connectivity", string2);
            }
            if (Logger.getCurrentLogLevel() == Logger.LEVEL.DEBUG) {
                try {
                    if (AkaHttpUtils.isJPGRequest(this.getURL().toURI())) {
                        this.mIsJpgRequest = true;
                        this.mRequestHeaders.put("Pragma", "Pragma: akamai-x-flush-log, akamai-x-cache-on, akamai-x-get-cache-key,akamai-x-check-cacheable, akamai-x-serial-no, akamai-x-get-extracted-values,akamai-x-get-true-cache-key, akamai-x-get-request-id, akamai- x-cache-remote-on, x-akamai-logging-mode: verbose");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mPostData = this.mOutputStream == null ? null : this.mOutputStream.getPostData();
            boolean bl3 = this.mRequestMethod.equals("POST") && this.mPostData != null;
            boolean bl4 = this.mRequestMethod.equals("GET");
            boolean bl5 = bl4 || bl3;
            boolean bl6 = this.mHostnameVerifier != null || this.mSSLSocketFactory != null;
            boolean bl7 = sIsDNSLibraryPresent && !bl6 && !bl2 && !this.mIsCacheFill && bl4 && this.mAccelerator.getSecurePreferenceBoolean("use_multipath", false) && this.mAccelerator.getMultiPathHandler().match(this.mUrl_toString) && !this.mAccelerator.getMultiPathHandler().isRaceInProgress(this.url.getHost());
            Logger.dd((String)"AkaSdkLogger-map", (String)("Request headers for Url: " + this.mUrl_toString + this.mRequestHeaders.entrySet().toString()));
            AkaMultiPathHandler.WinnerIP winnerIP = this.mAccelerator.getMultiPathHandler().getWinningIp(this.url.getHost());
            String string3 = "";
            if (winnerIP != null) {
                string3 = winnerIP.ip;
                this.mWinningIpType = winnerIP.ipType;
            }
            if (!bl7) {
                try {
                    this.mIsQUIC = !bl6 && !this.mIsCacheFill && !bl2 && bl5 && !this.mIsCacheFill && this.mAccelerator.getSecurePreferenceBoolean("use_quic", false);
                    this.mSinglePathUsingMPWinner = !TextUtils.isEmpty((CharSequence)string3);
                    this.debugLog(TAG, "Single path using previous multipath winner: " + this.mSinglePathUsingMPWinner);
                    this.createUrlConnection(string3);
                    this.setDelegateRequestMethod();
                    this.setDelegateRequestHeaders();
                    AkaHttpUtils.addCookies(this.mUrlConnection, super.getURL(), this.mIsQUIC);
                    this.setPostData();
                    this.mStartTime = AnaUtils.getCurrentUTCTimeInMillis();
                }
                catch (IOException iOException) {
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        this.mAccelerator.getMultiPathHandler().removeWinningIp(this.url.getHost());
                        this.sendRequest(bl2);
                    }
                    break block23;
                }
            }
            this.mIsMultiPath = true;
            this.debugLog(TAG, "MultiPath: true");
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.debugLog(TAG, "Multipath using previous winner", string3, "for request", this.mUrl_toString);
                try {
                    this.createUrlConnection(string3);
                    this.setDelegateRequestMethod();
                    this.setDelegateRequestHeaders();
                    AkaHttpUtils.addCookies(this.mUrlConnection, super.getURL(), false);
                    this.setPostData();
                    this.mStartTime = AnaUtils.getCurrentUTCTimeInMillis();
                    this.mMultiPathMethod = 2;
                    return;
                }
                catch (IOException iOException) {
                    this.mAccelerator.getMultiPathHandler().removeWinningIp(this.url.getHost());
                }
            }
            if (TextUtils.isEmpty((CharSequence)(string = this.mAccelerator.getSharedPreferences().getString("dns", "208.67.222.222")))) {
                this.sendRequest(true);
                return;
            }
            this.mIPTested = new HashSet(4);
            this.mMultiPathMethod = this.mAccelerator.getMultiPathHandler().selectMethod();
            this.mStartTime = AnaUtils.getCurrentUTCTimeInMillis();
            this.mAccelerator.getMultiPathHandler().markRaceInProgress(this.url.getHost());
            sThreadPool.submit(new MultiPathRequest(this, 1, "", 1));
            sThreadPool.submit(new MultiPathRequest(this, 2, string, 2));
            AkaURLConnection akaURLConnection = this;
            synchronized (akaURLConnection) {
                while (!this.mIsWinnerSelected) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.mAccelerator.getMultiPathHandler().clearRaceInProgress(this.url.getHost());
            this.mUrlConnection = this.mMainRequest.getConnection();
            if (this.mErrorCount == 2) {
                if (this.mWasSecondaryAbortedByGhost) {
                    this.mWasSecondaryAbortedByGhost = false;
                    this.sendRequest(true);
                    return;
                }
                if (this.mConnectException != null) {
                    throw this.mConnectException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnect(MultiPathRequest multiPathRequest) {
        if (!multiPathRequest.isError()) {
            AkaURLConnection akaURLConnection = this;
            synchronized (akaURLConnection) {
                if (!this.mIsWinnerSelected) {
                    this.mIsWinnerSelected = true;
                    multiPathRequest.setWinner(true);
                    this.mConnectException = null;
                    this.mMainRequest = multiPathRequest;
                    this.updateConnectTime();
                    ((Object)((Object)this)).notifyAll();
                }
            }
            if (!multiPathRequest.isWinner()) {
                int n2 = this.mAccelerator.getSharedPreferences().getInt("maxContentLen", 131072);
                if (this.mMultiPathMethod == 1 && multiPathRequest.getContentLength() <= n2) {
                    multiPathRequest.executeDownload(n2);
                } else {
                    multiPathRequest.closeInputStream();
                }
                this.logStats(multiPathRequest, AnaUtils.getCurrentUTCTimeInMillis());
                multiPathRequest.disconnect();
            } else {
                this.mAccelerator.getMultiPathHandler().addWinner(this.url.getHost(), multiPathRequest.getEndServerIp(), multiPathRequest.getRequestType());
            }
            return;
        }
        boolean bl2 = false;
        long l2 = AnaUtils.getCurrentUTCTimeInMillis();
        if (multiPathRequest.getRequestType() == 2 && multiPathRequest.isAbortedByGhost()) {
            this.mWasSecondaryAbortedByGhost = true;
        }
        AkaURLConnection akaURLConnection = this;
        synchronized (akaURLConnection) {
            ++this.mErrorCount;
            if (this.mConnectException == null && multiPathRequest.getException() != null && !this.mIsWinnerSelected) {
                this.mConnectException = multiPathRequest.getException();
            }
            if (this.mErrorCount == 2) {
                bl2 = true;
                if (this.mWasSecondaryAbortedByGhost) {
                    bl2 = false;
                }
                this.mIsWinnerSelected = true;
                this.mMainRequest = multiPathRequest;
                ((Object)((Object)this)).notifyAll();
            }
        }
        if (!bl2) {
            this.logStats(multiPathRequest, l2);
            multiPathRequest.disconnect();
        }
    }

    private void logStats(final MultiPathRequest multiPathRequest, final long l2) {
        final int n2 = multiPathRequest.getBytesRead();
        final URLConnection uRLConnection = multiPathRequest.getConnection();
        final long l3 = multiPathRequest.getTTFB();
        this.mAccelerator.submitTask(new Runnable(){

            @Override
            public void run() {
                AkaURLConnection.this.logStats(n2, l3, l2, uRLConnection, multiPathRequest, l2);
            }
        });
    }

    private void createUrlConnection(String string) throws IOException {
        if (!string.equals("")) {
            String string2 = this.mUrl_toString;
            String string3 = this.url.getHost();
            if (!this.mIsSecureRequest) {
                if (string.contains(":")) {
                    string = "[" + string + "]";
                }
                string2 = this.mUrl_toString.replaceFirst(string3, string);
            }
            URLConnection uRLConnection = this.mUrlConnection = this.mProxy == null ? AkaHttpUtils.getURLWithDefaultHandlers((String)string2, (boolean)this.mIsSecureRequest).openConnection() : AkaHttpUtils.getURLWithDefaultHandlers((String)string2, (boolean)this.mIsSecureRequest).openConnection(this.mProxy);
            if (!this.mIsSecureRequest) {
                this.mUrlConnection.setRequestProperty("Host", string3);
            } else {
                MultiPathRequest.CustomSSLSocketFactory customSSLSocketFactory = new MultiPathRequest.CustomSSLSocketFactory(string, string3);
                ((HttpsURLConnection)this.mUrlConnection).setSSLSocketFactory(customSSLSocketFactory);
            }
            ((HttpURLConnection)this.mUrlConnection).setInstanceFollowRedirects(false);
        } else {
            String string4 = AkaHttpUtils.getAkaUrl(this.url, this.mRequestMethod);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                this.mUrl_toString = string4;
            }
            IAkaCronetEngine iAkaCronetEngine = this.mAccelerator.getCronetEngine();
            if (this.mIsQUIC && iAkaCronetEngine != null) {
                this.mUrlConnection = iAkaCronetEngine.getUrlConnection(this.mAccelerator.getAppContext(), new URL(this.mUrl_toString));
                this.debugLog(TAG, "Request served using Cronet library", this.mUrl_toString);
            } else {
                this.mIsQUIC = false;
                URLConnection uRLConnection = this.mUrlConnection = this.mProxy == null ? AkaHttpUtils.getURLWithDefaultHandlers((String)this.mUrl_toString, (boolean)this.mIsSecureRequest).openConnection() : AkaHttpUtils.getURLWithDefaultHandlers((String)this.mUrl_toString, (boolean)this.mIsSecureRequest).openConnection(this.mProxy);
                if (this.mUrlConnection instanceof HttpsURLConnection) {
                    if (this.mHostnameVerifier != null) {
                        ((HttpsURLConnection)this.mUrlConnection).setHostnameVerifier(this.mHostnameVerifier);
                    }
                    if (this.mSSLSocketFactory != null) {
                        ((HttpsURLConnection)this.mUrlConnection).setSSLSocketFactory(this.mSSLSocketFactory);
                    }
                }
            }
        }
        if (this.mConnectTimeout != -1) {
            this.mUrlConnection.setConnectTimeout(this.mConnectTimeout);
        }
        if (this.mReadTimeout != -1) {
            this.mUrlConnection.setReadTimeout(this.mReadTimeout);
        }
        this.mUrlConnection.setDoInput(this.doInput);
        this.mUrlConnection.setDoOutput(this.doOutput);
        if (this.mFixedContentLength >= 0) {
            ((HttpURLConnection)this.mUrlConnection).setFixedLengthStreamingMode(this.mFixedContentLength);
        } else if (this.mChunkLength > 0) {
            ((HttpURLConnection)this.mUrlConnection).setChunkedStreamingMode(this.mChunkLength);
        }
        ((HttpURLConnection)this.mUrlConnection).setInstanceFollowRedirects(this.mSetInstanceFollowRedirects);
        this.mUrlConnection.setUseCaches(this.mUseCaches);
    }

    private void setDelegateRequestMethod() throws ProtocolException {
        if (!TextUtils.isEmpty((CharSequence)this.mRequestMethod)) {
            ((HttpURLConnection)this.mUrlConnection).setRequestMethod(this.mRequestMethod);
        }
    }

    private void setDelegateRequestHeaders() {
        boolean bl2 = this.mIsBrotliEnabled = this.mAccelerator.getBrotliDecoder() != null && this.mType != 0 && this.mAccelerator.getSecurePreferenceBoolean("use_brotli", false);
        if (this.mRequestHeaders != null && this.mRequestHeaders.size() > 0) {
            for (Map.Entry<String, String> entry : this.mRequestHeaders.entrySet()) {
                this.mUrlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                if (!this.mIsBrotliEnabled || !entry.getKey().equalsIgnoreCase(ACCEPT_ENCODING_HEADER)) continue;
                this.mIsBrotliEnabled = false;
            }
        }
        if (this.mIsBrotliEnabled) {
            this.mUrlConnection.setRequestProperty(ACCEPT_ENCODING_HEADER, ACCEPT_ENCODING_HEADER_VALUE);
            this.debugLog(TAG, "Enabling brotli");
        }
    }

    private void setPostData() throws IOException {
        if (this.mRequestMethod.equals("POST") && this.mPostData != null) {
            OutputStream outputStream = this.mUrlConnection.getOutputStream();
            outputStream.write(this.mPostData);
            outputStream.flush();
            outputStream.close();
        }
    }

    public int getResponseCode() throws IOException {
        try {
            this.connect();
            if (this.mType == 0) {
                return 200;
            }
            if (this.mUrlConnection != null) {
                int n2 = ((HttpURLConnection)this.mUrlConnection).getResponseCode();
                this.updateConnectTime();
                if (!this.mIsCookieUpdated) {
                    AkaHttpUtils.setCookies(this.mUrlConnection, super.getURL(), this.mIsQUIC);
                    this.mIsCookieUpdated = true;
                }
                return n2;
            }
        }
        catch (IOException iOException) {
            this.updateException(iOException);
            throw iOException;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException {
        this.connect();
        try {
            if (this.mInputStream == null) {
                InputStream inputStream;
                if (this.mType == 0) {
                    inputStream = new FileInputStream(this.mPathToContent);
                    SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mAccelerator.getAppContext());
                    Boolean bl2 = sharedPreferences.getBoolean("encryption_enabled", true);
                    if (this.mIsSecureRequest && bl2.booleanValue()) {
                        AkaCryptoHandler akaCryptoHandler = new AkaCryptoHandler(this.mAccelerator.getAppContext());
                        Cipher cipher = akaCryptoHandler.getCipher(2);
                        if (cipher == null) {
                            Logger.d((String)"AkaSdkLogger-map", (String)"AkaURLConnection: Can't decrypt, switch");
                            this.connected = false;
                            this.mType = 2;
                            return this.getInputStream();
                        }
                        inputStream = new CipherInputStream(inputStream, cipher);
                    }
                } else {
                    inputStream = this.mUrlConnection.getInputStream();
                    this.updateConnectTime();
                }
                this.mInputStream = this.mIsBrotliEnabled ? new AkaInputStream(new BufferedInputStream(this.getBrotliEnabledStream(inputStream)), this) : new AkaInputStream(new BufferedInputStream(inputStream), this);
            }
            if (!this.mIsCookieUpdated) {
                AkaHttpUtils.setCookies(this.mUrlConnection, super.getURL(), this.mIsQUIC);
                this.mIsCookieUpdated = true;
            }
            return this.mInputStream;
        }
        catch (IOException iOException) {
            this.updateException(iOException);
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.updateException(illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return null;
        }
    }

    protected void onUserReadStart(long l2) {
        this.mTTFB = l2;
    }

    protected void onReadComplete(final long l2) {
        final long l3 = AnaUtils.getCurrentUTCTimeInMillis();
        this.mAccelerator.submitTask(new Runnable(){

            @Override
            public void run() {
                AkaURLConnection.this.logStats(l2, AkaURLConnection.this.mTTFB, l3, AkaURLConnection.this.mUrlConnection, AkaURLConnection.this.mMainRequest, AkaURLConnection.this.mConnectTime);
            }
        });
    }

    private Map<String, String> getResponseHeadersForLogging(URLConnection uRLConnection) {
        Map<String, String> map = new HashMap<String, String>();
        if (uRLConnection == null) {
            return map;
        }
        try {
            map = AkaHttpUtils.convertToWebViewHeaders(uRLConnection.getHeaderFields(), false);
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return map;
    }

    private String getContentTypeForLogging(URLConnection uRLConnection) {
        String string = "";
        try {
            if (this.mType == 0) {
                string = this.getContentType();
            } else if (uRLConnection != null) {
                string = uRLConnection.getContentType();
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return string;
    }

    private synchronized void logStats(long l2, long l3, long l4, URLConnection uRLConnection, MultiPathRequest multiPathRequest, long l5) {
        Object object;
        if (!this.mLogStats && multiPathRequest == null) {
            return;
        }
        long l6 = l4 > this.mStartTime && this.mStartTime > 0L ? l4 - this.mStartTime : 0L;
        long l7 = l3 > this.mStartTime && this.mStartTime > 0L ? l3 - this.mStartTime : 0L;
        try {
            long l8 = Long.parseLong(uRLConnection.getHeaderField("X-Android-Sent-Millis"));
            long l9 = Long.parseLong(uRLConnection.getHeaderField("X-Android-Received-Millis"));
            long l10 = l9 - l8;
            long l11 = l2 * 8L;
            if (l11 > 0L && l6 > 0L && l10 > 0L) {
                object = AnaBitRateCalculator.getInstance();
                ((AnaBitRateCalculator)object).addBitRate(l11, l6, l10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 0;
        boolean bl2 = false;
        if (this.mIsQUIC) {
            bl2 = this.updateQuicMaxAgeifEnabled(uRLConnection);
        }
        Context context = this.mAccelerator.getAppContext();
        boolean bl3 = this.mAccelerator.getSecurePreferenceBoolean("log_analytics", false);
        String string = AkaHttpUtils.getUrl(this.mUrl_toString);
        AkaHttpStatsCollector akaHttpStatsCollector = new AkaHttpStatsCollector(string);
        super.logStats(l4, l2);
        if (bl3 || !AkaSessionHandler.isEnabled()) {
            Object object2;
            String string2;
            if (this.mType == 0) {
                string2 = this.mFeedItem.isUniversalCacheItem() ? "CACHE_FETCH_ADHOC" : "CACHE_FETCH";
                n2 = 200;
            } else {
                string2 = this.isOSCached(uRLConnection) ? "CACHE_FETCH_OS" : "CACHE_MISS";
                try {
                    n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.mIsCacheFill) {
                string2 = "CACHE_FILL";
            }
            akaHttpStatsCollector.insert("s_quic_enabled", bl2 ? 1 : 0);
            akaHttpStatsCollector.insert("s_uniqueId", this.mFeedItem == null || this.mFeedItem.isUniversalCacheItem() ? "" : this.mFeedItem.getId());
            akaHttpStatsCollector.insert("i_responseCode", n2 < 0 ? 0 : n2);
            akaHttpStatsCollector.insert("l_requestHeaderSize", this.getRequestSize());
            akaHttpStatsCollector.insert("l_responseHeaderSize", AkaHttpUtils.getHeaderSize(this.mType == 0 ? this.getResponseHeaders(false) : this.getResponseHeadersForLogging(uRLConnection)));
            akaHttpStatsCollector.insert("l_contentLength", l2);
            akaHttpStatsCollector.insert("l_timeStamp", this.mStartTime);
            akaHttpStatsCollector.insert("l_duration", l6);
            akaHttpStatsCollector.insert("l_ttfb", l7);
            akaHttpStatsCollector.insert("s_type", string2);
            akaHttpStatsCollector.insert("i_batteryLevel", AkaHttpUtils.getBatteryLevel(context));
            akaHttpStatsCollector.insert("b_isCharging", AkaHttpUtils.isCharging(context));
            akaHttpStatsCollector.insert("s_connectionType", AkaHttpUtils.getConnectionType());
            akaHttpStatsCollector.insert("s_location", AkaHttpUtils.getLocation());
            akaHttpStatsCollector.insert("i_signalStrength", AkaHttpUtils.getSignalStrength());
            String string3 = this.getContentTypeForLogging(uRLConnection);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                string3 = "";
            }
            akaHttpStatsCollector.insert("s_mimeType", string3);
            object = "";
            String string4 = "";
            String string5 = "";
            if (this.mType != 0) {
                object = this.getHeaderField(uRLConnection, "Akamai-Mobile-Connectivity");
                string4 = this.getHeaderField(uRLConnection, "AMC-ID");
                string5 = this.getHeaderField(uRLConnection, CONTENT_LENGTH_HEADER);
            }
            akaHttpStatsCollector.insert("s_serverProfile", object);
            akaHttpStatsCollector.insert("s_amcId", string4);
            akaHttpStatsCollector.insert("s_contentLengthHeader", string5);
            akaHttpStatsCollector.insert("l_maxRwnd", AkaHttpUtils.getRmemMax());
            SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(this.mAccelerator.getAppContext()).edit();
            editor.putString("last_server_profile", (String)object);
            editor.putString("last_amc_id", string4);
            editor.putString("last_url_connected", string);
            editor.apply();
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            if (this.mIsMultiPath) {
                n5 = this.mMultiPathMethod;
                if (n5 == 2) {
                    n3 = this.mWinningIpType;
                    n4 = 1;
                } else if (multiPathRequest != null) {
                    n3 = multiPathRequest.getRequestType();
                    int n8 = n4 = multiPathRequest.isWinner() ? 1 : 0;
                    if (multiPathRequest.isAbortedByGhost()) {
                        n5 = 3;
                    } else if (TextUtils.isEmpty((CharSequence)multiPathRequest.getEndServerIp())) {
                        n5 = 4;
                    }
                    n6 = multiPathRequest.getAAAATries();
                    n7 = multiPathRequest.getATries();
                }
            } else {
                n3 = this.mSinglePathUsingMPWinner ? 3 : 0;
            }
            int n9 = -1;
            if (this.mType == 1 || this.mType == 2) {
                object2 = new AkaResponseHeaderParser(this.getResponseHeadersForLogging(uRLConnection));
                n9 = ((AkaResponseHeaderParser)object2).canDownload() && l2 < 3000000L ? 1 : 0;
            }
            akaHttpStatsCollector.insert("s_cacheable", n9);
            akaHttpStatsCollector.insert("i_mpType", n3);
            akaHttpStatsCollector.insert("i_mpWinner", n4);
            akaHttpStatsCollector.insert("i_mpMethod", n5);
            akaHttpStatsCollector.insert("s_ATries", n7);
            akaHttpStatsCollector.insert("s_AAAATries", n6);
            akaHttpStatsCollector.insert("s_brotliEnabled", this.mIsBrotliEnabled ? 1 : 0);
            akaHttpStatsCollector.insert("s_brotliUsed", this.mIsBrotliUsed ? 1 : 0);
            akaHttpStatsCollector.insert("s_requestType", this.mRequestMethod);
            akaHttpStatsCollector.insert("s_exception_message", this.mException == null ? "" : ErrorUtils.getError(this.mException));
            object2 = this.mFeedItem != null && AkaSessionHandler.isFgSegment(this.mFeedItem.getSegment()) ? "true" : "false";
            akaHttpStatsCollector.insert("s_pre_cached", object2);
            String string6 = "false";
            try {
                string6 = !uRLConnection.getURL().toString().equals(this.mUrl_toString) ? "true" : "false";
            }
            catch (Exception exception) {
                // empty catch block
            }
            akaHttpStatsCollector.insert("s_redirected", string6);
            AkaHttpUtils.insertHttpStats(akaHttpStatsCollector);
            if (l7 > 60000L) {
                AnaWebDebugRecord.setHighTtfbRecord(this.mUrl_toString, this.mStartTime, l5, l3, l7 < 300000L, this.mAccelerator.getAppContext());
            }
            if (multiPathRequest == null || multiPathRequest.isWinner()) {
                this.debugLog(l2, l4);
            }
        }
        if (!this.mIsCacheFill) {
            if (this.mIsJpgRequest && uRLConnection != null) {
                String string7 = this.getHeaderField(uRLConnection, "X-Image-Server-Product");
                Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{TAG, "AIC", !TextUtils.isEmpty((CharSequence)string7) && string7.equalsIgnoreCase("aic")});
            }
            if (multiPathRequest != null) {
                Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{TAG, "Stats", akaHttpStatsCollector, "MultiPath related info", multiPathRequest});
            } else {
                Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{TAG, "Stats", akaHttpStatsCollector});
            }
        }
        this.handleBadPaddingException(context);
    }

    private void handleBadPaddingException(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("media_path", "");
        if (this.mException != null && this.mException instanceof IOException && (this.mException.getMessage().equals("Error while finalizing cipher") || this.mException.getMessage().contains("javax.crypto.BadPaddingException"))) {
            AkaCacheHandler.clearCache(this.mAccelerator.getAppContext(), true);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            Logger.d((String)"AkaSdkLogger-map", (String)"AkaURLConnectionHandling BadPaddingException. Clearing cache and turn off encryption flag");
            editor.putBoolean("encryption_enabled", false);
            editor.commit();
        }
    }

    private String getHeaderField(URLConnection uRLConnection, String string) {
        String string2 = "";
        try {
            string2 = uRLConnection.getHeaderField(string);
            if (string2 == null) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            AkaLogger.in((String)"AkaSdkLogger-map", (Object[])new Object[]{TAG, exception});
        }
        return string2;
    }

    private long getRequestSize() {
        long l2 = 0L;
        for (Map.Entry<String, String> entry : this.mRequestHeaders.entrySet()) {
            l2 += (long)(entry.getKey().getBytes().length + entry.getValue().getBytes().length);
        }
        long l3 = this.mOutputStream == null ? 0L : this.mOutputStream.getBytesWritten();
        return l2 + l3;
    }

    public void disconnect() {
        this.closeStreams();
        this.releaseConnection();
    }

    private void closeStreams() {
        if (this.mInputStream != null) {
            try {
                this.mInputStream.close();
            }
            catch (Exception exception) {}
        } else {
            this.onReadComplete(0L);
        }
    }

    private void releaseConnection() {
        if (this.mUrlConnection != null) {
            try {
                ((HttpURLConnection)this.mUrlConnection).disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getContentEncoding() {
        return this.getHeaderField(CONTENT_ENCODING_HEADER);
    }

    public String getHeaderField(String string) {
        try {
            this.connect();
            String string2 = null;
            if (this.mType == 0) {
                string = string.toLowerCase();
                string2 = this.mResponseHeaders.get(string);
                if (string.equals("set-cookie") || string.equals("set-cookie2")) {
                    try {
                        JSONArray jSONArray = new JSONArray(string2);
                        string2 = jSONArray.getString(0);
                    }
                    catch (Exception exception) {}
                }
            } else {
                string2 = this.mUrlConnection.getHeaderField(string);
                this.updateConnectTime();
            }
            if (string != null && string.equalsIgnoreCase(CONTENT_ENCODING_HEADER) && this.mIsBrotliEnabled) {
                return null;
            }
            return string2;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return null;
        }
    }

    public Map<String, List<String>> getHeaderFields() {
        Map<String, List<String>> map;
        try {
            this.connect();
            map = this.mType == 0 ? this.convertToUrlConnectionHeaders(this.mResponseHeaders, false) : this.mUrlConnection.getHeaderFields();
            if (map != null && !map.isEmpty() && this.mIsBrotliEnabled) {
                HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                for (String string : map.keySet()) {
                    if (string != null && string.equalsIgnoreCase(CONTENT_ENCODING_HEADER)) continue;
                    hashMap.put(string, map.get(string));
                }
                map = Collections.unmodifiableMap(hashMap);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return Collections.emptyMap();
        }
        return map;
    }

    public Map<String, String> getResponseHeaders(boolean bl2) {
        if (this.connected && this.mType == 0 && bl2) {
            return this.mResponseHeaders;
        }
        return AkaHttpUtils.convertToWebViewHeaders(this.getHeaderFields(), bl2);
    }

    private boolean updateQuicMaxAgeifEnabled(URLConnection uRLConnection) {
        try {
            if (uRLConnection == null) {
                return false;
            }
            String string = uRLConnection.getHeaderField("alt-svc");
            String string2 = uRLConnection.getHeaderField("quic-version");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return false;
            }
            boolean bl2 = true;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                String[] stringArray;
                boolean bl3 = false;
                long l2 = 0L;
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaURLConnection alt-svc received " + string + " quic version " + string2));
                for (String string3 : stringArray = string.split(";")) {
                    if (string3.contains("quic")) {
                        bl3 = true;
                        continue;
                    }
                    if (!string3.contains("ma")) continue;
                    l2 = Long.parseLong(string3.split("=")[1]);
                }
                if (bl3 && l2 > 0L) {
                    this.mAccelerator.updateQuicMaxAge(this.url.getHost(), System.currentTimeMillis() + l2 * 1000L);
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return false;
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        if (string != null && string2 != null) {
            if (string.equalsIgnoreCase("x-user-type")) {
                this.mIsCacheFill = true;
                if (this.mType == 0 || this.mType == 3) {
                    this.mType = !this.mIsSecureRequest ? 1 : 2;
                }
                return;
            }
            if (string.equalsIgnoreCase("x-akamai-log")) {
                boolean bl2 = true;
                try {
                    bl2 = Boolean.parseBoolean(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mLogStats = bl2;
                return;
            }
            this.mRequestHeaders.put(string, string2);
            if (string.equalsIgnoreCase("pragma")) {
                if (string2.toLowerCase().contains("no-cache")) {
                    this.mNoCache_request = true;
                    if (this.mType == 0) {
                        this.debugLog(TAG, "Revalidate cached content");
                        this.mType = 3;
                    }
                }
            } else if (string.equalsIgnoreCase("cache-control")) {
                boolean bl3;
                AkaHttpUtils.CacheControlRequestParser cacheControlRequestParser = new AkaHttpUtils.CacheControlRequestParser(string2);
                if (cacheControlRequestParser.isNoStore()) {
                    this.mUniversalCacheEnabled = false;
                    this.mNoCache_request = true;
                }
                boolean bl4 = bl3 = cacheControlRequestParser.isNoCache() || this.mNoCache_request;
                if (bl3) {
                    this.mNoCache_request = true;
                    if (this.mType == 0) {
                        this.debugLog(TAG, "Revalidate cached content");
                        this.mType = 3;
                    }
                } else if (this.mType == 0 || this.mType == 3) {
                    int n2;
                    int n3 = n2 = this.mFeedItem.mustRevalidate() ? 0 : cacheControlRequestParser.getMaxStale();
                    if (n2 == Integer.MIN_VALUE) {
                        n2 = 0;
                    } else if (n2 == -1) {
                        if (this.mType == 3) {
                            this.debugLog(TAG, "Serve stale content");
                        }
                        this.mType = 0;
                        return;
                    }
                    int n4 = cacheControlRequestParser.getMaxAge();
                    int n5 = AkaHttpUtils.getMaxAge(this.mFeedItem, this.mAccelerator.getSharedPreferences());
                    int n6 = (n4 < 0 ? n5 : Math.min(n4, n5)) + n2;
                    long l2 = this.mFeedItem.getRefreshTimeStamp() + TimeUnit.SECONDS.toMillis(n6);
                    if (this.mRequestTime > l2) {
                        if (this.mType == 0) {
                            this.debugLog(TAG, "Revalidate cached content");
                        }
                        this.mType = 3;
                    } else {
                        if (this.mType == 3) {
                            this.debugLog(TAG, "Serve stale content");
                        }
                        this.mType = 0;
                    }
                }
            }
        }
    }

    public void addRequestProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        if (string2 != null) {
            if (this.mRequestHeaders.containsKey(string)) {
                this.setRequestProperty(string, this.mRequestHeaders.get(string) + ";" + string2);
            } else {
                this.setRequestProperty(string, string2);
            }
        }
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        for (String string2 : PERMITTED_USER_METHODS) {
            if (!string2.equals(string)) continue;
            this.mRequestMethod = string;
            if (!(this.mType != 0 && this.mType != 3 || string.equals("GET"))) {
                this.debugLog(TAG, "non-GET request: Serve from network");
                this.mType = !this.mIsSecureRequest ? 1 : 2;
            }
            return;
        }
        throw new ProtocolException("Unknown method '" + string + "'; must be one of " + Arrays.toString(PERMITTED_USER_METHODS));
    }

    public String getRequestMethod() {
        return this.mRequestMethod;
    }

    public boolean usingProxy() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        if (this.mType == 0) {
            return false;
        }
        try {
            if (this.mUrlConnection != null) {
                return ((HttpURLConnection)this.mUrlConnection).usingProxy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isResponseFromCache() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        return this.mType == 0;
    }

    public boolean isUsingMultiPath() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        return this.mIsMultiPath;
    }

    public void setReadTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeoutMillis < 0");
        }
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.mReadTimeout = n2;
    }

    public void setConnectTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeoutMillis < 0");
        }
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.mConnectTimeout = n2;
    }

    public void setFixedLengthStreamingMode(int n2) {
        if (this.connected || this.mOutputStream != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.mChunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.mFixedContentLength = n2;
    }

    public void setChunkedStreamingMode(int n2) {
        if (this.connected || this.mOutputStream != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.mFixedContentLength >= 0) {
            throw new IllegalStateException("Already in fixed-length mode");
        }
        this.mChunkLength = n2 <= 0 ? 1024 : n2;
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            boolean bl2;
            boolean bl3 = bl2 = this.mRequestMethod.equals("POST") && this.mChunkLength == -1 && !this.connected;
            if (!bl2) {
                this.connect();
            }
            if (this.mOutputStream == null) {
                if (this.mType == 0) {
                    return null;
                }
                OutputStream outputStream = bl2 ? new ByteArrayOutputStream() : this.mUrlConnection.getOutputStream();
                this.mOutputStream = new AkaDefOutputStream(outputStream, bl2);
            }
            return this.mOutputStream;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                this.updateException(exception);
                throw (IOException)exception;
            }
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return null;
        }
    }

    public String getResponseMessage() throws IOException {
        try {
            this.connect();
            if (this.mType == 0) {
                return "OK";
            }
            if (this.mUrlConnection != null) {
                return ((HttpURLConnection)this.mUrlConnection).getResponseMessage();
            }
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                this.updateException(exception);
                throw (IOException)exception;
            }
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return null;
    }

    public InputStream getErrorStream() {
        if (this.mType == 0) {
            return null;
        }
        try {
            this.connect();
            return this.mUrlConnection != null && ((HttpURLConnection)this.mUrlConnection).getErrorStream() != null ? new AkaDefErrorStream(((HttpURLConnection)this.mUrlConnection).getErrorStream(), (AkaDefHttpURLConn)this) : null;
        }
        catch (IOException iOException) {
            this.updateException(iOException);
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return null;
    }

    public String getRequestProperty(String string) {
        if (string == null || this.mRequestHeaders == null || !this.mRequestHeaders.containsKey(string)) {
            return null;
        }
        return this.mRequestHeaders.get(string);
    }

    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.convertToUrlConnectionHeaders(this.mRequestHeaders, true);
    }

    public URL getURL() {
        if (this.mUrlConnection != null) {
            return this.mUrlConnection.getURL();
        }
        return super.getURL();
    }

    public boolean getInstanceFollowRedirects() {
        return this.mSetInstanceFollowRedirects;
    }

    public String getHeaderFieldKey(int n2) {
        try {
            this.connect();
            if (this.mType == 0) {
                return null;
            }
            return this.mUrlConnection.getHeaderFieldKey(n2);
        }
        catch (IOException iOException) {
            this.updateException(iOException);
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaURLConnection: connect() failed with : " + exception));
            return null;
        }
        return null;
    }

    public String getHeaderField(int n2) {
        try {
            this.connect();
            if (this.mType == 0) {
                return null;
            }
            return this.mUrlConnection.getHeaderField(n2);
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
            return null;
        }
    }

    boolean shouldAddToUniversalCache() {
        boolean bl2;
        boolean bl3 = bl2 = this.mIsCacheFill || !this.mUniversalCacheEnabled || this.mType == 0 || !this.mRequestMethod.equals("GET");
        if (!bl2) {
            int n2 = 0;
            try {
                n2 = this.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n2 == 200;
        }
        return false;
    }

    private Map<String, List<String>> convertToUrlConnectionHeaders(Map<String, String> map, boolean bl2) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            List<String> list = new ArrayList<String>();
            if ((string.equalsIgnoreCase("set-cookie") || string.equalsIgnoreCase("set-cookie2")) && !bl2) {
                list = this.getCookiesFromJson(string2);
            } else {
                list.add(string2);
            }
            hashMap.put(entry.getKey(), list);
        }
        return hashMap;
    }

    private List<String> getCookiesFromJson(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            JSONArray jSONArray = new JSONArray(string);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                arrayList.add(jSONArray.getString(i2));
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)TAG, (Throwable)exception);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugLog(long l2, long l3) {
        if (!ENABLE_DEBUG_STATS) {
            return;
        }
        if (this.mIsCacheFill) {
            return;
        }
        long l4 = l3 > this.mStartTime && this.mStartTime > 0L ? l3 - this.mStartTime : 0L;
        Object object = sLock;
        synchronized (object) {
            if (this.mType == 0) {
                ++CACHED_REQUESTS;
                CACHED_DOWNLOAD_SZ += l2;
                CACHED_LOAD_TIME += l4;
            } else {
                ++NETWORK_REQUESTS;
                NETWORK_DOWNLOAD_SZ += l2;
                NETWORK_LOAD_TIME += l4;
            }
        }
    }

    public static void disableDebugLog() {
        ENABLE_DEBUG_STATS = false;
    }

    public static void resetDebugLog() {
        ENABLE_DEBUG_STATS = true;
        NETWORK_REQUESTS = 0;
        CACHED_REQUESTS = 0;
        NETWORK_DOWNLOAD_SZ = 0L;
        CACHED_DOWNLOAD_SZ = 0L;
        NETWORK_LOAD_TIME = 0L;
        CACHED_LOAD_TIME = 0L;
    }

    private InputStream getBrotliEnabledStream(InputStream inputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        if (this.mUrlConnection != null && this.mUrlConnection.getContentEncoding() != null) {
            String string = this.mUrlConnection.getContentEncoding();
            List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                switch (string2 = iterator.next()) {
                    case "br": {
                        inputStream2 = this.mAccelerator.getBrotliDecoder().getDecodedStream(inputStream);
                        this.mIsBrotliUsed = true;
                        break;
                    }
                    case "gzip": {
                        inputStream2 = new GZIPInputStream(inputStream2);
                    }
                }
            }
        }
        return inputStream2;
    }

    protected void updateException(Exception exception) {
        this.mException = exception;
        this.onReadComplete(0L);
    }

    private void updateConnectTime() {
        if (this.mConnectTime == 0L) {
            this.mConnectTime = AnaUtils.getCurrentUTCTimeInMillis();
        }
    }

    private boolean isOSCached(URLConnection uRLConnection) {
        String string;
        if (uRLConnection != null && !TextUtils.isEmpty((CharSequence)(string = uRLConnection.getHeaderField(X_ANDROID_RESPONSE_HEADER)))) {
            String[] stringArray = string.split(" ", 2);
            if (X_ANDROID_RESPONSE_HEADER_VALUE_CACHE.equals(stringArray[0])) {
                return true;
            }
            if (stringArray.length == 1) {
                return false;
            }
            try {
                return X_ANDROID_RESPONSE_HEADER_VALUE_COND_CACHE.equals(stringArray[0]) && Integer.parseInt(stringArray[1]) == 304;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    static {
        sIsDNSLibraryPresent = DnsHandler.sDNSWrapperImpl != null;
        NETWORK_REQUESTS = 0;
        CACHED_REQUESTS = 0;
        NETWORK_DOWNLOAD_SZ = 0L;
        CACHED_DOWNLOAD_SZ = 0L;
        NETWORK_LOAD_TIME = 0L;
        CACHED_LOAD_TIME = 0L;
        sLock = new Object();
        ENABLE_DEBUG_STATS = false;
    }
}

