/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.akamai.android.sdk.internal.SecureWriter;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.Random;

class SecurePreferenceWriteHandler {
    private final SharedPreferences mSharedPreferences;
    private final SecureWriter mWriter;

    SecurePreferenceWriteHandler(Context context) {
        Context context2 = context;
        this.mSharedPreferences = AnaUtils.getSDKSharedPreferences(context2);
        this.mWriter = new SecureWriter(context);
    }

    void putString(String string, String string2) throws Exception {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        string2 = this.saltedValue(string2);
        editor.putString(this.mWriter.encrypt(string.getBytes()), this.mWriter.encrypt(string2.getBytes()));
        if ("production".equals("mock")) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    void putBoolean(String string, boolean bl2) throws Exception {
        VocAccelerator.getInstance().putSecurePreferenceBooleanToCache(string, bl2);
        this.putString(string, Boolean.toString(bl2));
    }

    void remove(String string) {
        try {
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.remove(this.mWriter.encrypt(string.getBytes()));
            if ("production".equals("mock")) {
                editor.commit();
            } else {
                editor.apply();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String saltedValue(String string) {
        Random random = new Random();
        int n2 = random.nextInt(Integer.MAX_VALUE) + 1;
        return random.nextInt(n2) + "&" + string + "&" + random.nextInt(n2);
    }
}

