/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.akamai.android.sdk.Logger;

class AkaStatusHelper {
    AkaStatusHelper() {
    }

    public static Intent createCacheSyncStartIntent(Context context) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("com.akamai.android.sdk.ACTION_VOC_STATUS");
        intent.putExtra("com.akamai.android.sdk.ACTION_VOC_STATUS.SYNC_START", true);
        AkaStatusHelper.setComponentNameifNeeded(context, intent);
        return intent;
    }

    public static Intent createCacheSyncDoneIntent(Context context) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("com.akamai.android.sdk.ACTION_VOC_STATUS");
        intent.putExtra("com.akamai.android.sdk.ACTION_VOC_STATUS.SYNC_DONE", true);
        AkaStatusHelper.setComponentNameifNeeded(context, intent);
        return intent;
    }

    public static Intent createNewContentIntent(Context context, int n2) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("com.akamai.android.sdk.ACTION_VOC_STATUS");
        intent.putExtra("com.akamai.android.sdk.ACTION_VOC_STATUS.NEW_FEEDS", n2);
        AkaStatusHelper.setComponentNameifNeeded(context, intent);
        return intent;
    }

    public static Intent createManifestDownloadedIntent(Context context) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("com.akamai.android.sdk.ACTION_VOC_STATUS");
        intent.putExtra("com.akamai.android.sdk.ACTION_VOC_MANIFEST_DOWNLOAD", true);
        AkaStatusHelper.setComponentNameifNeeded(context, intent);
        return intent;
    }

    public static Intent createCongestionStatusIntent(Context context, int n2) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("com.akamai.android.sdk.ACTION_VOC_STATUS");
        intent.putExtra("com.akamai.android.sdk.ACTION_VOC_CONG_STATUS", n2);
        AkaStatusHelper.setComponentNameifNeeded(context, intent);
        return intent;
    }

    private static void setComponentNameifNeeded(Context context, Intent intent) {
        block8: {
            try {
                Object object;
                if (Build.VERSION.SDK_INT < 26) break block8;
                PackageManager packageManager = context.getPackageManager();
                try {
                    object = packageManager.getApplicationInfo(context.getPackageName(), 0);
                    if (object != null && ((ApplicationInfo)object).targetSdkVersion < 26) {
                        return;
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Logger.dd((String)"AkaSdkLogger-map", (String)"Package not found ", (Throwable)nameNotFoundException);
                }
                object = packageManager.queryBroadcastReceivers(intent, 0);
                if (object != null && !object.isEmpty()) {
                    if (object.size() > 1) {
                        Logger.dd((String)"AkaSdkLogger-map", (String)"Multiple VocStatusReceivers, Expecting only one Receiver of the type");
                    }
                    ResolveInfo resolveInfo = (ResolveInfo)object.get(0);
                    ActivityInfo activityInfo = resolveInfo.activityInfo;
                    if (activityInfo != null) {
                        ComponentName componentName = new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name);
                        intent.setComponent(componentName);
                    }
                }
            }
            catch (Exception exception) {
                Logger.d((String)"AkaSdkLogger-map", (String)"Error extracting component name ", (Throwable)exception);
            }
        }
    }
}

