/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Keep;
import com.akamai.android.annotations.PublicApi;
import com.akamai.android.sdk.model.AkaEvictionStrategy;
import com.akamai.android.sdk.util.AnaUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

@PublicApi
@Keep
public class MapConfigBuilder {
    protected final Context mContext;

    public MapConfigBuilder(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @PublicApi
    @Keep
    public MapConfigBuilder setWhitelist(Set<String> set) {
        return this.storeFilterList(1, set);
    }

    @PublicApi
    @Keep
    public MapConfigBuilder setBlacklist(Set<String> set) {
        return this.storeFilterList(2, set);
    }

    @PublicApi
    @Keep
    public MapConfigBuilder sdkCacheLimit(int n2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("prefetch_storage_limit", Float.toString(n2));
        editor.apply();
        return this;
    }

    @PublicApi
    @Keep
    public MapConfigBuilder evictionStrategy(AkaEvictionStrategy akaEvictionStrategy) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        switch (akaEvictionStrategy) {
            case Least_Frequently_Used: {
                editor.putString("eviction_strategy", AkaEvictionStrategy.Least_Frequently_Used.getShortName());
                break;
            }
            case Least_Recently_Used: {
                editor.putString("eviction_strategy", AkaEvictionStrategy.Least_Recently_Used.getShortName());
            }
        }
        editor.apply();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private MapConfigBuilder storeFilterList(int n2, Set<String> set) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (set == null) {
            n2 = 0;
        } else {
            for (String string : set) {
                void object2;
                URL uRL = null;
                if (!string.startsWith("http") && !string.startsWith("https")) {
                    StringBuilder stringBuilder = new StringBuilder(string);
                    stringBuilder.insert(0, "http://");
                    String string2 = stringBuilder.toString();
                }
                try {
                    uRL = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null || uRL.getHost() == null) {
                    hashSet.add(object2);
                    continue;
                }
                hashSet.add(uRL.getHost());
            }
        }
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt("hostname_filter_mode", n2);
        editor.putStringSet("hostname_filter_list", hashSet);
        editor.apply();
        return this;
    }
}

