/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.text.TextUtils;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.AkaResolver;
import com.akamai.android.sdk.net.AkaURLConnection;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

class MultiPathRequest
implements Runnable {
    public static final int TYPE_SINGLE_PATH = 0;
    public static final int TYPE_PRIMARY = 1;
    public static final int TYPE_SECONDARY = 2;
    public static final int TYPE_SINGLE_PATH_USING_MULTIPATH_WINNER = 3;
    public static final int DNS_LOCAL = 1;
    public static final int DNS_SECONDARY = 2;
    private final AkaURLConnection mParent;
    final int mDNSType;
    private final int mRequestType;
    final String mDNS;
    private URLConnection mURLConnection;
    private String mServerToConnect;
    private boolean mAmITheWinner;
    private IOException mException;
    private boolean mIsError = false;
    private int mBytesRead = 0;
    private long mTTFB = 0L;
    private boolean mIsAbortedByGhost;
    private int mAAAATries;
    private int mATries;

    MultiPathRequest(AkaURLConnection akaURLConnection, int n, String string, int n2) {
        this.mParent = akaURLConnection;
        this.mDNSType = n;
        this.mDNS = string;
        this.mRequestType = n2;
    }

    public String toString() {
        return "type: " + this.getDebugName() + ", server: " + this.mServerToConnect + ", winner: " + this.mAmITheWinner + ", abortByGhost: " + this.mIsAbortedByGhost + ", error: " + this.mIsError + ", exception: " + this.getErrorString();
    }

    private String getErrorString() {
        if (this.mException != null) {
            return this.mException.toString();
        }
        if (TextUtils.isEmpty((CharSequence)this.mServerToConnect)) {
            return "No distinct IP";
        }
        return "";
    }

    private String getDebugName() {
        return this.mRequestType == 1 ? "PRIMARY" : "SECONDARY";
    }

    void setWinner(boolean bl) {
        this.mAmITheWinner = bl;
    }

    boolean isAbortedByGhost() {
        return this.mIsAbortedByGhost;
    }

    boolean isWinner() {
        return this.mAmITheWinner;
    }

    int getRequestType() {
        return this.mRequestType;
    }

    IOException getException() {
        return this.mException;
    }

    URLConnection getConnection() {
        return this.mURLConnection;
    }

    boolean isError() {
        return this.mIsError;
    }

    String getEndServerIp() {
        return this.mServerToConnect;
    }

    int getBytesRead() {
        return this.mBytesRead;
    }

    long getTTFB() {
        return this.mTTFB;
    }

    void disconnect() {
        if (this.mURLConnection != null) {
            try {
                ((HttpURLConnection)this.mURLConnection).disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void closeInputStream() {
        if (this.mURLConnection != null) {
            try {
                InputStream inputStream = this.mURLConnection.getInputStream();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String string = this.mParent.getURL().getHost();
            boolean bl = false;
            AkaResolver akaResolver = new AkaResolver(this, string);
            akaResolver.run();
            for (int i = 0; i < 2; ++i) {
                List<String> list;
                if (i == 0) {
                    list = akaResolver.getPrimaryResults();
                    bl = akaResolver.isPrimaryAAAA();
                } else {
                    list = akaResolver.getSecondaryResults();
                    bl = akaResolver.isSecondaryAAAA();
                    if (list.isEmpty()) {
                        this.mIsError = true;
                        return;
                    }
                }
                String string2 = "";
                for (String string3 : list) {
                    String string4;
                    AkaURLConnection akaURLConnection = this.mParent;
                    synchronized (akaURLConnection) {
                        if (!this.mParent.mIPTested.contains(string3)) {
                            this.mParent.mIPTested.add(string3);
                            string2 = string3;
                            if (bl) {
                                ++this.mAAAATries;
                            } else {
                                ++this.mATries;
                            }
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        if (i != 1) continue;
                        this.mIsError = true;
                        return;
                    }
                    this.mServerToConnect = string2;
                    this.prepareRequest(this.mParent.mIsSecureRequest, this.mServerToConnect, string);
                    int n = ((HttpURLConnection)this.mURLConnection).getResponseCode();
                    this.mException = null;
                    this.mIsError = false;
                    if (this.mRequestType == 2 && n == 204 && (string4 = this.mURLConnection.getHeaderField("Akamai-Multi-Path")) != null && string4.toLowerCase().contains("abort")) {
                        this.mIsAbortedByGhost = true;
                        this.mIsError = true;
                    }
                    return;
                }
            }
        }
        catch (IOException iOException) {
            this.mException = iOException;
            this.mIsError = true;
        }
        finally {
            this.mParent.onConnect(this);
        }
    }

    int getContentLength() {
        int n = 0;
        try {
            n = this.mURLConnection.getContentLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeDownload(int n) {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            bufferedInputStream = new BufferedInputStream(this.mURLConnection.getInputStream());
            byte[] byArray = new byte[2048];
            int n3 = 0;
            boolean bl = true;
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                if (bl) {
                    this.mTTFB = AnaUtils.getCurrentUTCTimeInMillis();
                    bl = false;
                }
                this.mBytesRead = n3 += n2;
                if (n3 <= n) continue;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void prepareRequest(boolean bl, String string, String string2) throws IOException {
        Object object;
        String string3 = this.mParent.mUrl_toString;
        if (!bl) {
            if (string.contains(":")) {
                string = "[" + string + "]";
            }
            string3 = this.mParent.mUrl_toString.replaceFirst(string2, string);
        }
        URLConnection uRLConnection = this.mURLConnection = this.mParent.mProxy == null ? AkaHttpUtils.getURLWithDefaultHandlers((String)string3, (boolean)bl).openConnection() : AkaHttpUtils.getURLWithDefaultHandlers((String)string3, (boolean)bl).openConnection(this.mParent.mProxy);
        if (!bl) {
            this.mURLConnection.setRequestProperty("Host", string2);
        } else {
            object = new CustomSSLSocketFactory(string, string2);
            ((HttpsURLConnection)this.mURLConnection).setSSLSocketFactory((SSLSocketFactory)object);
        }
        this.mURLConnection.setRequestProperty("Akamai-Multi-Path", Integer.toString(this.mRequestType));
        if (this.mParent.mConnectTimeout != -1) {
            this.mURLConnection.setConnectTimeout(this.mParent.mConnectTimeout);
        }
        if (this.mParent.mReadTimeout != -1) {
            this.mURLConnection.setReadTimeout(this.mParent.mReadTimeout);
        }
        this.mURLConnection.setDoInput(this.mParent.getDoInput());
        this.mURLConnection.setDoOutput(this.mParent.getDoOutput());
        if (this.mParent.mFixedContentLength >= 0) {
            ((HttpURLConnection)this.mURLConnection).setFixedLengthStreamingMode(this.mParent.mFixedContentLength);
        } else if (this.mParent.mChunkLength > 0) {
            ((HttpURLConnection)this.mURLConnection).setChunkedStreamingMode(this.mParent.mChunkLength);
        }
        ((HttpURLConnection)this.mURLConnection).setRequestMethod(this.mParent.mRequestMethod);
        if (this.mParent.mRequestHeaders != null && this.mParent.mRequestHeaders.size() > 0) {
            for (Map.Entry entry : this.mParent.mRequestHeaders.entrySet()) {
                this.mURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        ((HttpURLConnection)this.mURLConnection).setInstanceFollowRedirects(false);
        if (this.mParent.mRequestMethod.equals("POST") && this.mParent.mPostData != null) {
            object = this.mURLConnection.getOutputStream();
            ((OutputStream)object).write(this.mParent.mPostData);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
        }
        AkaHttpUtils.addCookies(this.mURLConnection, this.mParent.getURL(), false);
    }

    public int getAAAATries() {
        return this.mAAAATries;
    }

    public int getATries() {
        return this.mATries;
    }

    static class CustomSSLSocketFactory
    extends SSLSocketFactory {
        private static final SSLSocketFactory sDelegateSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        private final String mEndServerIp;
        private final String mRequestHost;

        CustomSSLSocketFactory(String string, String string2) {
            this.mEndServerIp = string;
            this.mRequestHost = string2;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return sDelegateSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return sDelegateSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            if (bl) {
                socket.close();
            }
            return this.createSocket(string, n);
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            if (!string.equals(this.mRequestHost)) {
                return sDelegateSocketFactory.createSocket(string, n);
            }
            return sDelegateSocketFactory.createSocket(this.mEndServerIp, n);
        }

        @Override
        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
            return this.createSocket(string, n);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.createSocket(inetAddress.getHostName(), n);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.createSocket(inetAddress.getHostName(), n);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CustomSSLSocketFactory) {
                CustomSSLSocketFactory customSSLSocketFactory = (CustomSSLSocketFactory)object;
                return this.mEndServerIp.equals(customSSLSocketFactory.mEndServerIp) && this.mRequestHost.equals(customSSLSocketFactory.mRequestHost);
            }
            return false;
        }
    }
}

