/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class AkaResponseHeaderParser {
    private final Map<String, String> mResponseHeaders;
    private Date servedDate;
    private Date lastModified;
    private Date expires;
    private boolean noCache;
    private boolean noStore;
    private int maxAgeSeconds = -1;
    private boolean isPublic;
    private boolean mustRevalidate;
    private String etag;
    private long mCalculatedExpiryInMs = -1L;
    private final Map<String, String> mBareHeaders;
    private static final long MIN_EXPIRY_FOR_SHORT_LIVED_CONTENT_IN_MS = TimeUnit.MINUTES.toMillis(10L);

    public AkaResponseHeaderParser(Map<String, String> map) {
        this.mResponseHeaders = map;
        this.mBareHeaders = new HashMap<String, String>();
        this.parse();
    }

    private void parse() {
        if (this.mResponseHeaders == null) {
            return;
        }
        HeaderParser.CacheControlHandler cacheControlHandler = new HeaderParser.CacheControlHandler(){

            @Override
            public void handle(String string, String string2) {
                if ("no-cache".equalsIgnoreCase(string)) {
                    AkaResponseHeaderParser.this.noCache = true;
                } else if ("no-store".equalsIgnoreCase(string)) {
                    AkaResponseHeaderParser.this.noStore = true;
                } else if ("max-age".equalsIgnoreCase(string)) {
                    AkaResponseHeaderParser.this.maxAgeSeconds = HeaderParser.parseSeconds(string2);
                } else if ("public".equalsIgnoreCase(string)) {
                    AkaResponseHeaderParser.this.isPublic = true;
                } else if ("must-revalidate".equalsIgnoreCase(string)) {
                    AkaResponseHeaderParser.this.mustRevalidate = true;
                }
            }
        };
        for (Map.Entry<String, String> entry : this.mResponseHeaders.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("Cache-Control".equalsIgnoreCase(string)) {
                HeaderParser.parseCacheControl(string2, cacheControlHandler);
                continue;
            }
            if ("Date".equalsIgnoreCase(string)) {
                this.servedDate = HttpDate.parse(string2);
                continue;
            }
            if ("Expires".equalsIgnoreCase(string)) {
                this.expires = HttpDate.parse(string2);
                continue;
            }
            if ("Last-Modified".equalsIgnoreCase(string)) {
                this.lastModified = HttpDate.parse(string2);
                this.mBareHeaders.put("last-modified", string2);
                continue;
            }
            if ("ETag".equalsIgnoreCase(string)) {
                this.etag = string2;
                this.mBareHeaders.put("etag", string2);
                continue;
            }
            if ("Pragma".equalsIgnoreCase(string)) {
                if (!"no-cache".equalsIgnoreCase(string2)) continue;
                this.noCache = true;
                continue;
            }
            if (string.toLowerCase().startsWith("access")) {
                this.mBareHeaders.put(string.toLowerCase(), string2);
                continue;
            }
            if ("timing-allow-origin".equalsIgnoreCase(string)) {
                this.mBareHeaders.put(string.toLowerCase(), string2);
                continue;
            }
            if (string.toLowerCase().startsWith("x-")) {
                if (string.toLowerCase().startsWith("x-android-")) continue;
                this.mBareHeaders.put(string.toLowerCase(), string2);
                continue;
            }
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                this.mBareHeaders.put("set-cookie", string2);
                continue;
            }
            if ("Set-Cookie2".equalsIgnoreCase(string)) {
                this.mBareHeaders.put("set-cookie2", string2);
                continue;
            }
            if (!"Vary".equalsIgnoreCase(string) || "Accept-Encoding".equalsIgnoreCase(string2)) continue;
            this.noStore = true;
        }
    }

    public Map<String, String> getBareHeaders() {
        return this.mBareHeaders;
    }

    public long getExpiry() {
        if (this.mCalculatedExpiryInMs == -1L) {
            long l = 0L;
            if (this.maxAgeSeconds >= 0) {
                l = TimeUnit.SECONDS.toMillis(this.maxAgeSeconds);
            } else if (this.servedDate != null) {
                if (this.expires != null) {
                    l = this.expires.getTime() - this.servedDate.getTime();
                }
                if (l <= 0L) {
                    l = 0L;
                    if (this.lastModified != null && this.servedDate.after(this.lastModified)) {
                        l = (this.servedDate.getTime() - this.lastModified.getTime()) / 10L;
                    }
                }
            }
            this.mCalculatedExpiryInMs = l;
        }
        return this.mCalculatedExpiryInMs;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean canDownload() {
        return !this.noStore && (this.etag != null || this.lastModified != null || this.getExpiry() > MIN_EXPIRY_FOR_SHORT_LIVED_CONTENT_IN_MS);
    }

    public String getContentType() {
        return this.mResponseHeaders.get("Content-Type");
    }

    private static final class HttpDate {
        private static final ThreadLocal<DateFormat> STANDARD_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat;
            }
        };
        private static final String[] BROWSER_COMPATIBLE_DATE_FORMATS = new String[]{"EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z", "EEE MMM d yyyy HH:mm:ss z"};

        static Date parse(String string) {
            try {
                return STANDARD_DATE_FORMAT.get().parse(string);
            }
            catch (ParseException parseException) {
                for (String string2 : BROWSER_COMPATIBLE_DATE_FORMATS) {
                    try {
                        return new SimpleDateFormat(string2, Locale.US).parse(string);
                    }
                    catch (ParseException parseException2) {
                    }
                }
                return null;
            }
        }

        public static String format(Date date) {
            return STANDARD_DATE_FORMAT.get().format(date);
        }

        private HttpDate() {
        }
    }

    public static final class HeaderParser {
        public static void parseCacheControl(String string, CacheControlHandler cacheControlHandler) {
            int n = 0;
            while (n < string.length()) {
                String string2;
                int n2;
                int n3 = n;
                n = HeaderParser.skipUntil(string, n, "=,");
                String string3 = string.substring(n3, n).trim();
                if (n == string.length() || string.charAt(n) == ',') {
                    ++n;
                    cacheControlHandler.handle(string3, null);
                    continue;
                }
                ++n;
                if ((n = HeaderParser.skipWhitespace(string, n)) < string.length() && string.charAt(n) == '\"') {
                    n2 = ++n;
                    n = HeaderParser.skipUntil(string, n, "\"");
                    string2 = string.substring(n2, n);
                    ++n;
                } else {
                    n2 = n;
                    n = HeaderParser.skipUntil(string, n, ",");
                    string2 = string.substring(n2, n).trim();
                }
                cacheControlHandler.handle(string3, string2);
            }
        }

        static int skipUntil(String string, int n, String string2) {
            while (n < string.length() && string2.indexOf(string.charAt(n)) == -1) {
                ++n;
            }
            return n;
        }

        static int skipWhitespace(String string, int n) {
            char c;
            while (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\t')) {
                ++n;
            }
            return n;
        }

        public static int parseSeconds(String string) {
            try {
                long l = Long.parseLong(string);
                if (l > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (l < 0L) {
                    return 0;
                }
                return (int)l;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        private HeaderParser() {
        }

        public static interface CacheControlHandler {
            public void handle(String var1, String var2);
        }
    }
}

