/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import androidx.annotation.NonNull;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AnaDownloadManager;
import com.akamai.android.sdk.net.AkaFeedManager;
import com.akamai.android.sdk.net.AkaResponseHeaderParser;
import com.akamai.android.sdk.net.AkaURLConnection;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.IOException;
import java.io.InputStream;

class AkaInputStream
extends InputStream {
    private final InputStream mInputStream;
    private boolean mReadComplete;
    private boolean mReadStart;
    private long mBytesRead = 0L;
    private final AkaURLConnection mParent;
    public static final long FOREGROUND_CACHE_BUFFER_LIMIT = 3000000L;
    private boolean mIsEndOfStream;
    private boolean mIsStreamClosed;
    private static final String LOG_TAG = "AkaInpStream";

    public AkaInputStream(InputStream inputStream, AkaURLConnection akaURLConnection) {
        this.mInputStream = inputStream;
        if (this.mInputStream.markSupported() && akaURLConnection.shouldAddToUniversalCache()) {
            this.mInputStream.mark(3000001);
        }
        this.mParent = akaURLConnection;
    }

    @Override
    public int read() throws IOException {
        try {
            int n = this.mInputStream.read();
            if (n == -1) {
                this.mIsEndOfStream = true;
                this.onReadComplete();
            } else {
                ++this.mBytesRead;
                this.onReadStart();
            }
            return n;
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.mInputStream.available();
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        this.onReadComplete();
        if (this.mIsStreamClosed) {
            return;
        }
        this.mIsStreamClosed = true;
        if (!this.mParent.shouldAddToUniversalCache()) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching, shouldAddToUniversalCache: false, url: " + this.mParent.mUrl_toString));
            this.mInputStream.close();
            return;
        }
        boolean bl = false;
        if (this.isWithinCacheableBounds(this.mBytesRead)) {
            bl = true;
        } else {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching, outside bounds, skip: " + this.mBytesRead));
        }
        if (bl && this.mIsEndOfStream) {
            try {
                this.mInputStream.reset();
                AnaDownloadManager.getInstance(this.mParent.mAccelerator.getAppContext()).getUniversalCacheHandler().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (!AkaSessionHandler.isEnabled()) {
                                Logger.dd((String)"AkaSdkLogger-map", (String)"AkaInpStream: Universal caching, SDK is not active, skip");
                                return;
                            }
                            AkaFeedManager akaFeedManager = ((AkaInputStream)AkaInputStream.this).mParent.mAccelerator.getFeedManager();
                            String string = akaFeedManager.getFeedID(((AkaInputStream)AkaInputStream.this).mParent.mUrl_toString);
                            AkaResponseHeaderParser akaResponseHeaderParser = new AkaResponseHeaderParser(AkaInputStream.this.mParent.getResponseHeaders(true));
                            if (akaResponseHeaderParser.canDownload()) {
                                AkaInputStream.this.downloadContent(akaResponseHeaderParser);
                            } else {
                                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching: Content not downloadable, url: " + ((AkaInputStream)AkaInputStream.this).mParent.mUrl_toString));
                            }
                        }
                        catch (Exception exception) {
                            Logger.e((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching: ex: " + exception));
                        }
                        finally {
                            AkaInputStream.this.closeStreamSilently();
                        }
                    }
                });
            }
            catch (Exception exception) {
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching: inpstrm reset ex: " + exception));
                this.closeStreamSilently();
            }
        } else {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: InpStrm isMarked: " + bl + ", isEOF: " + this.mIsEndOfStream));
            this.mInputStream.close();
        }
    }

    @Override
    public void mark(int n) {
        this.mInputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.mInputStream.markSupported();
    }

    @Override
    public int read(@NonNull byte[] byArray) throws IOException {
        try {
            return this.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    @Override
    public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = this.mInputStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.mIsEndOfStream = true;
                this.onReadComplete();
            } else {
                this.mBytesRead += (long)n3;
                this.onReadStart();
            }
            return n3;
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.mInputStream.reset();
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    @Override
    public long skip(long l) throws IOException {
        try {
            return this.mInputStream.skip(l);
        }
        catch (IOException iOException) {
            this.mParent.updateException(iOException);
            throw iOException;
        }
    }

    private void onReadComplete() {
        if (!this.mReadComplete) {
            this.mReadComplete = true;
            if (this.mParent != null) {
                this.mParent.onReadComplete(this.mBytesRead);
            }
        }
    }

    private void closeStreamSilently() {
        if (this.mInputStream != null) {
            try {
                this.mInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onReadStart() {
        if (!this.mReadStart) {
            this.mReadStart = true;
            if (this.mParent != null) {
                this.mParent.onUserReadStart(AnaUtils.getCurrentUTCTimeInMillis());
            }
        }
    }

    private void downloadContent(AkaResponseHeaderParser akaResponseHeaderParser) throws IOException {
        Logger.dd((String)"AkaSdkLogger-map", (String)("AkaInpStream: Universal caching: saving url: " + this.mParent.mOriginalUrl_toString));
        AnaDownloadManager anaDownloadManager = AnaDownloadManager.getInstance(this.mParent.mAccelerator.getAppContext());
        anaDownloadManager.downloadFromInputStream(this.mParent.mOriginalUrl_toString, this.mInputStream, akaResponseHeaderParser, this.mBytesRead);
    }

    private boolean isWithinCacheableBounds(long l) {
        return l > 0L && l < 3000000L && this.mInputStream.markSupported();
    }
}

