/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class AnaDownloadPolicyManager {
    private final Context mContext;
    public static final int GLOBAL_CONFIG = 0;
    public static final int WIFI_ONLY = 1;
    public static final int WIFI_AND_CELLULAR = 2;
    public static final int CELLULAR_ONLY = 6;
    private static final int CACHE_AT_THRESHOLD_PERCENTAGE = 80;
    public static final int POLICY_OK = 0;
    public static final int POLICY_NO_WIFI = 2;
    public static final int POLICY_CACHE_FULL = 4;
    public static final int POLICY_NO_NETWORK = 5;
    private static final int POLICY_DOWNLOAD_NOT_PERMITTED = 7;
    private static final int POLICY_DAY_LIMIT_REACHED = 8;
    private static final int POLICY_DAY_RESIDUAL_LIMIT_REACHED = 10;
    private static final String DAILY_CELL_QUOTA_TYPE = "APPLY_TO_CELLULAR_ONLY";
    private static final String DAILY_CELL_WIFI_QUOTA_TYPE = "APPLY_TO_CELLULAR_AND_WIFI";
    public static final int PREFETCH_LIMIT_DEFAULT = 3;
    private static final String LOG_TAG = "AnaDownloadPolicyManager";

    public AnaDownloadPolicyManager(Context context) {
        this.mContext = context;
    }

    static String valueOf(int n) {
        switch (n) {
            case 0: {
                return "OK";
            }
            case 2: {
                return "No WiFi";
            }
            case 4: {
                return "Cache Full";
            }
            case 5: {
                return "No Network";
            }
            case 7: {
                return "Download not permitted";
            }
            case 8: {
                return "Day limit reached";
            }
            case 10: {
                return "Day residual limit reached";
            }
        }
        return "UNKNOWN";
    }

    public int isDownloadPermitted(AnaFeedItem anaFeedItem) {
        int n = 0;
        switch (anaFeedItem.getNetworkSelection()) {
            case 1: {
                if (AnaUtils.isWifiConnected(this.mContext)) break;
                n = 2;
                break;
            }
            case 2: {
                if (AnaUtils.isCellularConnected(this.mContext) || AnaUtils.isWifiConnected(this.mContext)) {
                    n = 0;
                    break;
                }
                n = 5;
                break;
            }
            default: {
                n = this.isDownloadPermitted();
            }
        }
        return n;
    }

    public int isDownloadPermitted() {
        int n = 0;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        int n2 = Integer.parseInt(sharedPreferences.getString("network_preference", "0"));
        if (this.isNetworkAvailable()) {
            switch (n2) {
                case 1: {
                    if (AnaUtils.isWifiConnected(this.mContext)) break;
                    n = 2;
                    break;
                }
                case 6: {
                    if (!AnaUtils.isWifiConnected(this.mContext) && AnaUtils.isCellularConnected(this.mContext)) {
                        n = 0;
                        break;
                    }
                    n = 5;
                    break;
                }
                case 2: {
                    n = AnaUtils.isCellularConnected(this.mContext) || AnaUtils.isWifiConnected(this.mContext) ? 0 : 5;
                }
            }
        } else {
            n = 5;
        }
        return n;
    }

    int isDownloadPermittedForSize(long l, AnaFeedItem anaFeedItem, String string) {
        int n = 0;
        n = !AnaDiskUtils.isCacheStorageAvailable(l, string, this.mContext) ? 4 : this.isDayLimitAvailable(l, anaFeedItem);
        return n;
    }

    public boolean isCacheAtThreshold() {
        return this.getCacheUsagePercentage() >= 80.0f;
    }

    private float getCacheUsagePercentage() {
        String string = VocUtils.getMediaPath(this.mContext);
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        float f = AnaDiskUtils.usedMemory(string, true);
        float f2 = Float.parseFloat(sharedPreferences.getString("prefetch_storage_limit", Integer.toString(3)));
        return f / (f2 *= 1048576.0f) * 100.0f;
    }

    boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = VocAccelerator.getInstance().getConnectivityManager();
        if (connectivityManager != null) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        return false;
    }

    void updateDayUsage(long l) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        this.verifyDayUsageTimestamp();
        long l2 = Calendar.getInstance(TimeZone.getTimeZone("utc")).getTimeInMillis();
        if (l > 0L) {
            boolean bl = sharedPreferences.getBoolean("use_new_quota_values", false);
            if (!bl) {
                String string = sharedPreferences.getString("daily_quota_type", "");
                if (string.length() > 0) {
                    long l3 = sharedPreferences.getLong("daily_quota_usage", 0L);
                    if (string.equals(DAILY_CELL_QUOTA_TYPE)) {
                        if (!AnaUtils.isWifiConnected(this.mContext) && AnaUtils.isCellularConnected(this.mContext)) {
                            editor.putLong("daily_quota_usage", l3 + l);
                            editor.putLong("daily_quota_ts", l2);
                            editor.apply();
                        }
                    } else if (string.equals(DAILY_CELL_WIFI_QUOTA_TYPE)) {
                        editor.putLong("daily_quota_usage", l3 + l);
                        editor.putLong("daily_quota_ts", l2);
                        editor.apply();
                    }
                }
            } else {
                if (AnaUtils.isWifiConnected(this.mContext)) {
                    long l4 = sharedPreferences.getLong("daily_quota_usage_wifi", 0L);
                    editor.putLong("daily_quota_usage_wifi", l4 + l);
                    editor.putLong("daily_quota_ts", l2);
                } else if (AnaUtils.isCellularConnected(this.mContext)) {
                    long l5 = sharedPreferences.getLong("daily_quota_usage_cellular", 0L);
                    editor.putLong("daily_quota_usage_cellular", l5 + l);
                    editor.putLong("daily_quota_ts", l2);
                }
                editor.apply();
            }
        }
    }

    private int isDayLimitAvailable(long l, AnaFeedItem anaFeedItem) {
        int n = 0;
        int n2 = 8;
        boolean bl = true;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        boolean bl2 = sharedPreferences.getBoolean("use_new_quota_values", false);
        String string = "";
        long l2 = -1L;
        long l3 = 0L;
        int n3 = sharedPreferences.getInt("daily_manifest_count", 0);
        if (!bl2) {
            string = sharedPreferences.getString("daily_quota_type", "");
            l2 = sharedPreferences.getLong("daily_download_quota", -1L);
            l3 = sharedPreferences.getLong("daily_quota_usage", 0L);
        } else if (AnaUtils.isWifiConnected(this.mContext)) {
            l2 = sharedPreferences.getLong("daily_wifi_quota", -1L);
            l3 = sharedPreferences.getLong("daily_quota_usage_wifi", 0L);
            string = "wifi";
        } else if (AnaUtils.isCellularConnected(this.mContext)) {
            l2 = sharedPreferences.getLong("daily_cellular_quota", -1L);
            l3 = sharedPreferences.getLong("daily_quota_usage_cellular", 0L);
            string = "cellular";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        int n4 = calendar.get(11);
        if (l2 > -1L) {
            if (n3 > 3) {
                if (n4 <= 8) {
                    l2 /= 3L;
                    n2 = 10;
                } else if (n4 <= 16) {
                    l2 = l2 * 2L / 3L;
                    n2 = 10;
                }
            }
            if (!bl2) {
                if (string.length() > 0) {
                    if (string.equals(DAILY_CELL_WIFI_QUOTA_TYPE)) {
                        bl = l3 + l < l2;
                    } else if (string.equals(DAILY_CELL_QUOTA_TYPE) && !AnaUtils.isWifiConnected(this.mContext) && AnaUtils.isCellularConnected(this.mContext)) {
                        bl = l3 + l < l2;
                    }
                }
            } else {
                boolean bl3 = bl = l3 + l < l2;
            }
        }
        if (!bl) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AnaDownloadPolicyManager: Daily quota false usage " + l3 + " quota " + l2 + " type " + string + " hr " + n4));
            n = n2;
        }
        return n;
    }

    void verifyDayUsageTimestamp() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        long l = sharedPreferences.getLong("daily_quota_ts", 0L);
        if (l > 0L) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("utc"));
            int n = calendar.get(5);
            calendar.setTimeInMillis(l);
            if (n != calendar.get(5)) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                boolean bl = sharedPreferences.getBoolean("use_new_quota_values", false);
                if (!bl) {
                    editor.putLong("daily_quota_usage", 0L);
                } else {
                    editor.putLong("daily_quota_usage_wifi", 0L);
                    editor.putLong("daily_quota_usage_cellular", 0L);
                }
                editor.apply();
            }
        }
    }

    void dailyUsagePrefs() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        boolean bl = sharedPreferences.getBoolean("use_new_quota_values", false);
        if (!bl) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaDownloadPolicyManager: Sync parms " + sharedPreferences.getString("daily_quota_type", "") + " " + sharedPreferences.getLong("daily_quota_usage", 0L) + " lastup " + sharedPreferences.getLong("daily_quota_ts", 0L) + " count " + sharedPreferences.getInt("daily_manifest_count", 0)));
        } else {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaDownloadPolicyManager: Sync parms daily quota usage: wifi " + sharedPreferences.getLong("daily_quota_usage_wifi", 0L) + ", cellular " + sharedPreferences.getLong("daily_quota_usage_cellular", 0L) + " lastup " + sharedPreferences.getLong("daily_quota_ts", 0L) + " count " + sharedPreferences.getInt("daily_manifest_count", 0)));
        }
    }
}

