/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AbstractContentDownloader;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AnaDownloadManager;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.AnaResourceDownloadRunnable;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

class AkaWebContentDownloader
extends AbstractContentDownloader {
    private static final String LOG_TAG = "AkaWebContentDownloader";

    AkaWebContentDownloader(Context context) {
        super(context);
    }

    @Override
    protected void downloadWebContent() {
        boolean bl = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", true);
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
        if (AnaUtils.isPrefetchAllowed(this.mContext) && (bl || bl2)) {
            Object object;
            this.mDownloadPolicyManager.verifyDayUsageTimestamp();
            this.mDownloadPolicyManager.dailyUsagePrefs();
            LinkedHashMap<String, AnaFeedItem> linkedHashMap = new LinkedHashMap<String, AnaFeedItem>();
            long l = 0L;
            int n = 0;
            boolean bl3 = VocAccelerator.getInstance().isAppInForeground();
            Queue<AnaFeedItem> queue = this.fetchItemsFromDb(bl, bl2);
            while (!queue.isEmpty()) {
                long l2;
                object = queue.remove();
                if (linkedHashMap.containsKey(((AnaFeedItem)object).getId()) || !bl3 && !TextUtils.isEmpty((CharSequence)((AnaFeedItem)object).getSegment()) && AkaSessionHandler.isFgSegment(((AnaFeedItem)object).getSegment()) || (n = AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, l + (l2 = ((AnaFeedItem)object).getSize()), (AnaFeedItem)object)) != 0) continue;
                l += l2;
                linkedHashMap.put(((AnaFeedItem)object).getId(), (AnaFeedItem)object);
            }
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebContentDownloader: WebContent: Queued for download, no of items" + linkedHashMap.size() + ", policy  " + n));
            object = AnaDownloadManager.getInstance(this.mContext);
            ExecutorService executorService = ((AnaDownloadManager)object).downloadGenericFeeds(linkedHashMap);
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaWebContentDownloader: " + interruptedException.getLocalizedMessage()));
            }
            ((AnaDownloadManager)object).clearFeeds();
            Logger.d((String)"AkaSdkLogger-map", (String)"AkaWebContentDownloader: WebContent: Done");
        } else {
            Logger.d((String)"AkaSdkLogger-map", (String)"AkaWebContentDownloader: WebContent: prefetch not allowed");
        }
    }

    @NonNull
    @VisibleForTesting
    protected Queue<AnaFeedItem> fetchItemsFromDb(boolean bl, boolean bl2) {
        Cursor cursor = this.mContext.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, "syncPending=?", new String[]{String.valueOf(0)}, "priority ASC, timestamp DESC");
        LinkedList<AnaFeedItem> linkedList = new LinkedList<AnaFeedItem>();
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                    boolean bl3 = AkaSessionHandler.isFgSegment(anaFeedItem.getSegment());
                    if (!bl2 && bl3 || !bl && !bl3) continue;
                    linkedList.add(anaFeedItem);
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        return linkedList;
    }

    public static Set<String> pruneCacheIfNeeded(Context context, AnaDownloadPolicyManager anaDownloadPolicyManager) {
        return AkaWebContentDownloader.pruneFeedIds(context, new HashSet<String>(), anaDownloadPolicyManager);
    }
}

