/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AbstractFeedContentParser;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaManifestData;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class AkaSegmentManifestParser
extends AbstractFeedContentParser {
    private static final String LOG_TAG = "AkaSegmentManifestParser";
    private final Context mContext;

    AkaSegmentManifestParser(Context context) {
        super(context);
        this.mContext = context;
    }

    public static void deleteUrlsAssociatedWithSegment(String string, Context context) {
        List<String> list = AkaSegmentManifestParser.getNonUcUrlsFromDb(string, context);
        if (!list.isEmpty()) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("Delete Segment Items:" + list));
            VocAccelerator.getInstance().submitTask(new PurgeRunnable(list, context));
        }
    }

    @Override
    void parseManifestAndInsertToDb() {
        List<AkaSegmentManifestDownloader.SegmentInfo> list = AkaSegmentManifestDownloader.getExistingSubscribedSegments(this.mContext);
        HashMap<String, ContentValues> hashMap = new HashMap<String, ContentValues>();
        String string = VocUtils.getDataPath(this.mContext);
        if (list != null) {
            for (AkaSegmentManifestDownloader.SegmentInfo segmentInfo : list) {
                String string2 = string + segmentInfo.mLongName + ".json";
                Map<String, ContentValues> map = this.readJsonData(string2, segmentInfo.mLongName);
                if (hashMap.isEmpty()) {
                    hashMap.putAll(map);
                    continue;
                }
                for (Map.Entry<String, ContentValues> entry : map.entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        this.mergePrioritiesForDuplicatedUrls(hashMap);
        this.insertParsedContentToDB(hashMap);
    }

    private void mergePrioritiesForDuplicatedUrls(@NonNull Map<String, ContentValues> map) {
        if (this.duplicatedUrlsWithPriority.isEmpty()) {
            return;
        }
        for (String string : this.duplicatedUrlsWithPriority.keySet()) {
            ContentValues contentValues = map.get(string);
            if (!this.duplicatedUrlsWithPriority.containsKey(string)) continue;
            Integer n = (Integer)this.duplicatedUrlsWithPriority.get(string);
            Integer n2 = contentValues.getAsInteger("priority");
            if (n >= n2) continue;
            contentValues.put("priority", n);
        }
    }

    @Override
    protected void addFeedDataFromJson(Map.Entry<String, String> entry, AkaManifestData akaManifestData, Map<String, ContentValues> map, String string) {
        String string2 = "";
        try {
            string2 = entry.getKey();
            String string3 = entry.getValue();
            UUID uUID = UUID.nameUUIDFromBytes(string2.getBytes());
            String string4 = uUID.toString() + System.currentTimeMillis();
            ContentValues contentValues = new ContentValues();
            int n = akaManifestData.getPriority();
            if (string2 == null) {
                return;
            }
            if (!this.urls.contains(string2)) {
                long l;
                this.urls.add(string2);
                String string5 = akaManifestData.getSegmentType();
                long l2 = AnaUtils.getCurrentUTCTimeInMillis();
                String string6 = "file_" + string4;
                long l3 = l = 0L;
                if (l3 > this.mFileLimit) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Size > FileLimit...Skip: " + this.mFileLimit));
                    return;
                }
                String string7 = this.getDlUrl(akaManifestData, string2);
                contentValues.put("_id", string4);
                contentValues.put("url", string2);
                contentValues.put("size", Long.valueOf(l));
                contentValues.put("provider", string5);
                contentValues.put("feedtype", "sdk/fg");
                contentValues.put("timestamp", Long.valueOf(l2));
                contentValues.put("videofile", string6);
                contentValues.put("viewcount", Integer.valueOf(0));
                contentValues.put("resourceready", Integer.valueOf(0));
                contentValues.put("priority", Integer.valueOf(n));
                contentValues.put("networkSelection", Integer.valueOf(akaManifestData.getNetworkSelection()));
                contentValues.put("segment", string);
                contentValues.put("creationtimestamp", string3);
                contentValues.put("dlUrl", string7);
                map.put(string2, contentValues);
            } else if (this.duplicatedUrlsWithPriority.containsKey(string2)) {
                if (n < (Integer)this.duplicatedUrlsWithPriority.get(string2)) {
                    this.duplicatedUrlsWithPriority.put(string2, n);
                }
            } else {
                this.duplicatedUrlsWithPriority.put(string2, n);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Exception Parsing url: " + string2));
            exception.printStackTrace();
        }
    }

    private String getDlUrl(AkaManifestData akaManifestData, String string) throws URISyntaxException {
        Map<String, String> map;
        String string2 = "";
        String string3 = AkaHttpUtils.getHostName(string);
        if (!TextUtils.isEmpty((CharSequence)string3) && (map = akaManifestData.getDlHostnameMappings()).containsKey(string3)) {
            string2 = string.replaceFirst(string3, map.get(string3));
        }
        return string2;
    }

    private void insertParsedContentToDB(@Nullable Map<String, ContentValues> map) {
        if (map == null) {
            return;
        }
        Map<String, AbstractFeedContentParser.FeedInfo> map2 = this.getFeedInfoFromDb(null, this.mContext);
        boolean bl = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", true);
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
        if (bl || bl2) {
            try {
                String string;
                ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
                ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
                for (String object : map.keySet()) {
                    ContentValues contentValues = map.get(object);
                    string = contentValues.getAsString("segment");
                    boolean feedInfo = AkaSessionHandler.isFgSegment(string);
                    if (!bl && !feedInfo || !bl2 && feedInfo) continue;
                    String string2 = contentValues.getAsString("url");
                    if (!map2.containsKey(string2)) {
                        contentValues.put("syncPending", Integer.valueOf(0));
                        arrayList.add(contentValues);
                        continue;
                    }
                    arrayList2.add(contentValues);
                }
                if (!arrayList.isEmpty()) {
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)("New Segment Items inserted:" + arrayList));
                    this.mContext.getContentResolver().bulkInsert(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), arrayList.toArray(new ContentValues[arrayList.size()]));
                }
                if (!arrayList2.isEmpty()) {
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)("Segment Items are updated:" + arrayList2));
                    ArrayList arrayList3 = new ArrayList();
                    for (ContentValues contentValues : arrayList2) {
                        string = contentValues.getAsString("url");
                        AbstractFeedContentParser.FeedInfo feedInfo = map2.get(string);
                        map2.remove(string);
                        int n = (Integer)contentValues.get("priority");
                        int n2 = feedInfo.mPriority;
                        String string2 = (String)contentValues.get("dlUrl");
                        String string3 = feedInfo.mDlUrl;
                        int n3 = (Integer)contentValues.get("networkSelection");
                        int n4 = feedInfo.mNetworkSelection;
                        if (n == n2 && string2.equals(string3) && n3 == n4) continue;
                        ContentValues contentValues2 = new ContentValues();
                        contentValues2.put("priority", Integer.valueOf(n));
                        contentValues2.put("dlUrl", string2);
                        contentValues2.put("networkSelection", Integer.valueOf(n3));
                        arrayList3.add(ContentProviderOperation.newUpdate((Uri)AnaProviderContract.CONTENT_URI_FEEDS).withValues(contentValues2).withSelection("url=?", new String[]{contentValues.getAsString("url")}).withYieldAllowed(true).build());
                    }
                    this.mContext.getContentResolver().applyBatch(AnaProviderContract.getAuthority(), arrayList3);
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Error inserting/updating feeds: " + exception));
                exception.printStackTrace();
            }
        }
        if (!map2.isEmpty()) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("Delete Segment Items:" + map2));
            VocAccelerator.getInstance().submitTask(new PurgeRunnable(new ArrayList<String>(map2.keySet()), this.mContext));
        }
    }

    static class PurgeRunnable
    implements Runnable {
        final List<String> mUrls;
        final Context mContext;

        PurgeRunnable(List<String> list, Context context) {
            this.mUrls = list;
            this.mContext = context;
        }

        @Override
        public void run() {
            AkaCacheHandler.deleteSegmentContentByUrl(this.mContext, this.mUrls);
        }
    }
}

