/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import com.akamai.android.sdk.Logger;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

class AkaSSLWrapper {
    private static final String TAG = "AkaSSLWrapper";
    private static final String CERTKEY = "Akama1V0C";
    private static SSLSocketFactory sPinnedSSLSocketFactory = null;

    AkaSSLWrapper() {
    }

    public static synchronized SSLSocketFactory getPinnedSSLSocketFactory(Context context) {
        try {
            if (sPinnedSSLSocketFactory == null && !"production".equals("production")) {
                int n = context.getResources().getIdentifier("server", "raw", context.getPackageName());
                if (n == 0) {
                    Logger.e((String)"AkaSdkLogger-map", (String)"AkaSSLWrapper Unable to locate bks files");
                } else {
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    InputStream inputStream = context.getResources().openRawResource(n);
                    keyStore.load(inputStream, CERTKEY.toCharArray());
                    inputStream.close();
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                    sPinnedSSLSocketFactory = sSLContext.getSocketFactory();
                }
            }
            return sPinnedSSLSocketFactory;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

