/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Build;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import androidx.collection.LruCache;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.R;
import com.akamai.android.sdk.internal.AkaStatusHelper;
import com.akamai.android.sdk.internal.AnaBitRateCalculator;
import com.akamai.android.sdk.internal.AnaNetworkQualityStatus;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AkaNetworkQualityHandler {
    private final Context mContext;
    private final String LOGTAG = "CngDtctr";
    private final String CONGESTION_FLAG = "CongestionFlag";
    private static final int RESULT_RETRY = 3;
    private static final long TIME_DELTA_IN_MS = 60000L;
    private static final String PARAM_ECHO = "echo";
    private static final String sEchoPayload = AkaNetworkQualityHandler.randomString(40);
    @SuppressLint(value={"StaticFieldLeak"})
    private static AkaNetworkQualityHandler sInstance;
    private final Hashtable<String, AnaNetworkQualityStatus> mCongestionTable = new Hashtable();
    private final LruCache<String, LinkedList<Long>> mCongestionMap = new LruCache(10);
    private String mCurrentCellKey = "";
    private int mCurrentNetworkType = -1;
    private int mCurrentCellSubType = 0;
    private final Hashtable<String, Long[]> mTcpBufferTable = new Hashtable();
    private volatile boolean mCongRunning = false;
    private boolean mHostNameVerified = true;
    private final ConnectivityManager mConnectivityManager;
    private HostnameVerifier mHostnameVerifier;
    private static final long DEFAULT_RWIN_10_30MBPS = 511104L;
    private static final long DEFAULT_RWIN_2_15MBPS = 255552L;
    private static final long DEFAULT_RWIN_1_5MBPS = 127776L;
    private static final long DEFAULT_RWIN_2MPBS = 63888L;

    private AkaNetworkQualityHandler(Context context) {
        this.mContext = context.getApplicationContext();
        this.mCongestionTable.put("CongestionFlag", new AnaNetworkQualityStatus());
        this.mConnectivityManager = VocAccelerator.getInstance().getConnectivityManager();
    }

    public static synchronized AkaNetworkQualityHandler getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new AkaNetworkQualityHandler(context);
        }
        return sInstance;
    }

    public static AnaNetworkQualityStatus getNetworkQuality(Context context) {
        return AkaNetworkQualityHandler.getInstance(context).getStatus();
    }

    public static void startNQDetection(Context context) {
        AkaNetworkQualityHandler.getInstance(context).startDetection();
    }

    public synchronized void startDetection() {
        if (!AnaUtils.isCongestionControlEnabled()) {
            return;
        }
        if (!this.mCongRunning) {
            this.mCongRunning = true;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AkaNetworkQualityHandler.this.hasCongestion(1, true);
                        int n = AnaUtils.getNetworkQualityPingCount(AkaNetworkQualityHandler.this.mContext);
                        int n2 = AnaUtils.getNetworkQualityFrequency(AkaNetworkQualityHandler.this.mContext);
                        while (AnaUtils.isCongestionControlEnabled() && VocAccelerator.getInstance().isAppInForeground()) {
                            AkaNetworkQualityHandler.this.hasCongestion(n, true);
                            Thread.sleep(n2 * 1000);
                        }
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: startDetection", (Throwable)exception);
                    }
                    finally {
                        AkaNetworkQualityHandler.this.setCongestionRunning(false);
                    }
                }
            });
            thread.start();
        }
    }

    private synchronized boolean isCongestionRunning() {
        return this.mCongRunning;
    }

    private synchronized void setCongestionRunning(boolean bl) {
        this.mCongRunning = bl;
    }

    public void reset() {
        this.mCongestionTable.put("CongestionFlag", new AnaNetworkQualityStatus());
    }

    private AnaNetworkQualityStatus getStatus() {
        AnaNetworkQualityStatus anaNetworkQualityStatus = this.mCongestionTable.get("CongestionFlag");
        long l = System.currentTimeMillis() - anaNetworkQualityStatus.timeStamp;
        if (l > 60000L) {
            anaNetworkQualityStatus.networkQuality = -1;
            VocAccelerator.getInstance().submitTask(new Runnable(){

                @Override
                public void run() {
                    AkaNetworkQualityHandler.this.startDetection();
                }
            });
        }
        return anaNetworkQualityStatus;
    }

    private int canDownload() {
        return this.mCongestionTable.get((Object)"CongestionFlag").networkQuality;
    }

    private int getReadTimeOutForNetwork(int n) {
        int n2 = 600;
        String string = AnaUtils.getNetworkGen(n);
        if (n == 0) {
            n2 = AnaUtils.get4GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("2g")) {
            n2 = AnaUtils.get2GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            n2 = AnaUtils.get3GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            n2 = AnaUtils.get3_5GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            n2 = AnaUtils.get4GTestTimeout(this.mContext);
        }
        return n2;
    }

    public void detectCongestion() {
        try {
            if (!this.isCongestionRunning()) {
                this.hasCongestion(5, false);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: detectCongestion", (Throwable)exception);
        }
    }

    public String getResponseStr() {
        long l = -1L;
        long l2 = -1L;
        return l2 + "ms," + l + " ms, cong:" + this.canDownload();
    }

    private boolean isCongestionCheckEnabled() {
        return AnaUtils.isCongestionControlEnabled();
    }

    private void hasCongestion(int n, boolean bl) {
        int n2 = -1;
        int n3 = AnaUtils.getNetworkQualityPingFrequency(this.mContext) * 1000;
        String string = AnaUtils.getNetworkQualityMethod(this.mContext);
        CongResponse congResponse = new CongResponse();
        String string2 = "";
        int n4 = -1;
        long l = -1L;
        AnaBitRateCalculator anaBitRateCalculator = AnaBitRateCalculator.getInstance();
        AnaNetworkQualityStatus anaNetworkQualityStatus = new AnaNetworkQualityStatus();
        if (AnaUtils.isWifiConnected(this.mContext)) {
            n4 = 1;
        } else if (AnaUtils.isCellularConnected(this.mContext)) {
            n4 = 0;
        }
        anaNetworkQualityStatus.networkType = n4;
        int n5 = this.getCurrentNetworkSubType();
        if (this.mCurrentNetworkType != n4 || this.mCurrentCellSubType != n5) {
            anaBitRateCalculator.clear();
        }
        this.mCurrentCellSubType = n5;
        this.mCurrentNetworkType = n4;
        boolean bl2 = false;
        if (!this.isCongestionCheckEnabled()) {
            anaNetworkQualityStatus.networkQuality = -1;
            this.mCongestionTable.put("CongestionFlag", anaNetworkQualityStatus);
        } else if (!AnaUtils.isCongestionControlEnabledWifi(this.mContext) && AnaUtils.isWifiConnected(this.mContext)) {
            anaNetworkQualityStatus.networkQuality = -1;
        } else {
            long l2 = this.getHighThreshold(this.mCurrentCellSubType) / 1000L;
            long l3 = this.getLowThreshold(this.mCurrentCellSubType) / 1000L;
            string2 = AnaUtils.getNetworkGen(this.mCurrentCellSubType);
            double d = 0.0;
            Trendline trendline = null;
            long l4 = anaBitRateCalculator.getAverageBitRate();
            l = anaBitRateCalculator.getAverageRTT();
            if (l4 <= 0L || l <= 0L) {
                int n6;
                bl2 = true;
                int n7 = 3;
                long l5 = 0L;
                int n8 = 5;
                ArrayList<Long> arrayList = new ArrayList<Long>(n8);
                ArrayList<Long> arrayList2 = new ArrayList<Long>(n8);
                int n9 = 0;
                int n10 = 0;
                int n11 = 1;
                for (n6 = 0; n6 < n; ++n6) {
                    try {
                        String string3 = this.prepareRequest();
                        congResponse = string.equalsIgnoreCase("tcp") ? this.invokeTcpRequest(string3) : this.invokeHttpRequest();
                        n7 = congResponse.congLevel;
                        l5 = congResponse.bitRate;
                        if (congResponse.responseTime > 0L) {
                            n10 = (int)((long)n10 + congResponse.responseTime);
                            n9 = n10 / n11;
                            ++n11;
                        }
                        if (l5 == 0L) {
                            this.updateNetworkQuality(anaNetworkQualityStatus, 2, -1, AnaUtils.getNetworkGen(this.mCurrentCellSubType), bl);
                            n2 = 2;
                            continue;
                        }
                        if (l5 <= 0L || n6 <= 0 && n != 1) continue;
                        arrayList.add(l5);
                        arrayList2.add(System.currentTimeMillis() / 1000L);
                        if (this.mCongestionMap.get((Object)this.mCurrentCellKey) != null) {
                            LinkedList linkedList = (LinkedList)this.mCongestionMap.get((Object)this.mCurrentCellKey);
                            if (linkedList.size() == 30) {
                                linkedList.removeFirst();
                            }
                            linkedList.addLast(l5);
                        }
                        if (n7 != 3) {
                            n2 = n7;
                            break;
                        }
                        if (n6 + 1 >= n) continue;
                        Thread.sleep(n3);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: hasCongestion(): ", (Throwable)exception);
                    }
                }
                if (n7 == 3 && n6 >= n && arrayList.size() > 0) {
                    trendline = new Trendline(arrayList, arrayList2);
                    long l6 = 0L;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) != null && (l6 = this.calculateAverage((LinkedList)this.mCongestionMap.get((Object)this.mCurrentCellKey))) > 0L) {
                        d = (double)(trendline.avg - l6) / (double)l6 * 100.0;
                    }
                    l4 = trendline.avg;
                }
                l = n9;
            }
            if (l4 > 0L) {
                if (l4 >= l2) {
                    n2 = 0;
                } else if (l4 <= l3) {
                    n2 = 2;
                } else {
                    n2 = 1;
                    if (bl2) {
                        long l7 = (l2 - l4) * 100L / (l2 - l3);
                        Random random = new Random();
                        int n12 = random.nextInt(100);
                        if (l7 >= 80L && n12 <= 40 || l7 >= 60L && n12 <= 20 || l7 >= 40L && n12 <= 5 || l7 <= 20L && n12 == 0) {
                            n2 = 2;
                        }
                        if (n2 == 1) {
                            if (this.mCongestionTable.get((Object)"CongestionFlag").networkQuality == 2 && d < 0.0) {
                                n2 = 2;
                            } else if (d < -30.0 && trendline.slope < -50.0) {
                                n2 = 2;
                            } else if (d < -60.0 && trendline.slope < 0.0) {
                                n2 = 2;
                            }
                        }
                    }
                }
            }
        }
        this.updateNetworkQuality(anaNetworkQualityStatus, n2, (int)l, string2, bl);
    }

    private void updateNetworkQuality(AnaNetworkQualityStatus anaNetworkQualityStatus, int n, int n2, String string, boolean bl) {
        AnaNetworkQualityStatus anaNetworkQualityStatus2 = this.mCongestionTable.get("CongestionFlag");
        if (n != anaNetworkQualityStatus2.networkQuality && bl) {
            this.mContext.sendBroadcast(AkaStatusHelper.createCongestionStatusIntent(this.mContext, n));
        }
        anaNetworkQualityStatus.networkQuality = n;
        anaNetworkQualityStatus.rtt = n2;
        anaNetworkQualityStatus.networkSubType = this.mCurrentCellSubType;
        anaNetworkQualityStatus.networkGen = string;
        anaNetworkQualityStatus.timeStamp = System.currentTimeMillis();
        this.mCongestionTable.put("CongestionFlag", anaNetworkQualityStatus);
        Logger.dd((String)"AkaSdkLogger-map", (String)("NetworkQualityStatus: " + anaNetworkQualityStatus.toString()));
    }

    private long calculateAverage(LinkedList<Long> linkedList) {
        long l = 0L;
        if (linkedList.size() > 0) {
            long l2 = 0L;
            for (Long l3 : linkedList) {
                l2 += l3.longValue();
            }
            l = l2 / (long)linkedList.size();
        }
        return l;
    }

    private int processResponse(String string) throws NumberFormatException {
        long l = Calendar.getInstance(TimeZone.getTimeZone("utc")).getTimeInMillis();
        int n = 3;
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                if (string2.startsWith("Cellload")) {
                    int n2 = Integer.parseInt(string2.split("=")[1]);
                    if (n2 <= 0) continue;
                    int n3 = AnaUtils.getCongestionControlHighThreshold(this.mContext);
                    int n4 = AnaUtils.getCongestionControlLowThreshold(this.mContext);
                    if (n2 >= n3) {
                        n = 2;
                        continue;
                    }
                    if (n2 <= n4) {
                        n = 0;
                        continue;
                    }
                    if (n2 <= n4 || n2 >= n3) continue;
                    n = 1;
                    continue;
                }
                if (!string2.startsWith("ServerTS")) continue;
                l = Long.parseLong(string2.split("=")[1]);
            }
        }
        return n;
    }

    @SuppressLint(value={"MissingPermission"})
    private String prepareRequest() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            CellLocation cellLocation = null;
            if (telephonyManager != null) {
                cellLocation = telephonyManager.getCellLocation();
            }
            String string = this.getLocalIpAddress();
            if (cellLocation != null) {
                if (cellLocation instanceof GsmCellLocation) {
                    int n;
                    int n2 = ((GsmCellLocation)cellLocation).getCid();
                    if (n2 > -1) {
                        stringBuilder.append(",Cellid=").append(n2);
                    }
                    if ((n = ((GsmCellLocation)cellLocation).getLac()) > -1) {
                        stringBuilder.append(",Lac=").append(n);
                    }
                    this.mCurrentCellSubType = this.getCurrentNetworkSubType();
                    this.mCurrentCellKey = n2 + "-" + this.mCurrentCellSubType;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) == null) {
                        this.mCongestionMap.put((Object)this.mCurrentCellKey, new LinkedList());
                    }
                } else if (cellLocation instanceof CdmaCellLocation) {
                    int n = ((CdmaCellLocation)cellLocation).getBaseStationId();
                    int n3 = ((CdmaCellLocation)cellLocation).getBaseStationLatitude();
                    int n4 = ((CdmaCellLocation)cellLocation).getBaseStationLongitude();
                    if (n > -1) {
                        stringBuilder.append(",BaseId=").append(n);
                    }
                    if (n3 > -1) {
                        stringBuilder.append(",BaseLat=").append(n3);
                    }
                    if (n4 > -1) {
                        stringBuilder.append(",BaseLong=").append(n4);
                    }
                    this.mCurrentCellSubType = this.getCurrentNetworkSubType();
                    this.mCurrentCellKey = n4 + "-" + this.mCurrentCellSubType;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) == null) {
                        this.mCongestionMap.put((Object)this.mCurrentCellKey, new LinkedList());
                    }
                }
            }
            if (string.length() > 0) {
                stringBuilder.append(",Ip=").append(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private int getCurrentNetworkSubType() {
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.getSubtype();
        }
        return 0;
    }

    private String getLocalIpAddress() {
        String string = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    string = inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("CngDtctr: " + socketException.toString()));
        }
        return string;
    }

    private CongResponse invokeTcpRequest(String string) {
        int n = this.getCurrentNetworkSubType();
        long l = 0L;
        String string2 = AnaUtils.getCongestionControlServer(this.mContext);
        int n2 = AnaUtils.getCongestionControlPort(this.mContext);
        long l2 = AnaUtils.getCongestionControlRetryInterval(this.mContext);
        int n3 = this.getCurrentNetworkSubType();
        int n4 = this.getReadTimeOutForNetwork(n3);
        long l3 = -1L;
        int n5 = 0;
        String string3 = "";
        long l4 = 0L;
        ConnectionHandler connectionHandler = ConnectionHandler.getInstance();
        long l5 = System.currentTimeMillis();
        int n6 = 0;
        try {
            connectionHandler.sendRequest(string2, n2, string, n4);
            string3 = connectionHandler.readResponse();
            l4 = System.currentTimeMillis();
            n6 = this.processResponse(string3);
            l = l4 - l5;
            if (l <= 0L) {
                l = 1L;
            }
            n5 = string3.getBytes().length * 8;
            l3 = this.downloadSpeed("tcp", n5 * 2, l, n);
        }
        catch (IOException iOException) {
            Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: invokeTcpRequest(): ", (Throwable)iOException);
            if (iOException instanceof SocketTimeoutException) {
                l3 = 0L;
            }
            connectionHandler.forceNewSocketCreation();
        }
        CongResponse congResponse = new CongResponse(n6, l3, l);
        return congResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CongResponse invokeHttpRequest() {
        Object object;
        int n = this.getCurrentNetworkSubType();
        String string = AnaUtils.getNetworkGen(this.getCurrentNetworkSubType());
        long l = -1L;
        int n2 = this.getReadTimeOutForNetwork(n);
        long l2 = -1L;
        String string2 = "https://";
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            object = AnaUtils.getNetworkQualityMethod(this.mContext);
            if (!this.mHostNameVerified || ((String)object).equals("http")) {
                string2 = "http://";
            }
            Uri.Builder builder = new Uri.Builder().encodedPath(string2 + AnaUtils.getNetworkQualityUri(this.mContext));
            builder.appendQueryParameter(PARAM_ECHO, sEchoPayload);
            String string3 = builder.toString();
            URL uRL = new URL(string3);
            long l3 = TrafficStats.getUidRxBytes((int)this.mContext.getApplicationInfo().uid);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string4 = AkaHttpUtils.getAMCHeaderString(false);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                httpURLConnection.setRequestProperty("Akamai-Mobile-Connectivity", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)VocAccelerator.sPackageName)) {
                httpURLConnection.setRequestProperty("Akamai-Referrer", VocAccelerator.sPackageName);
            }
            httpURLConnection.setRequestProperty("x-akamai-log", "false");
            httpURLConnection.setRequestProperty("x-user-type", "sdk");
            if (httpURLConnection instanceof HttpsURLConnection) {
                if (!TextUtils.isEmpty((CharSequence)this.mCurrentCellKey)) {
                    String string5 = AnaUtils.getCarrier(this.mContext);
                    httpURLConnection.setRequestProperty("Akamai-Cell-Info", TextUtils.isEmpty((CharSequence)string5) ? this.mCurrentCellKey : string5 + "/" + this.mCurrentCellKey);
                }
                if (this.mHostnameVerifier == null) {
                    this.mHostnameVerifier = new HostnameVerifier(){

                        @Override
                        public boolean verify(String string, SSLSession sSLSession) {
                            AkaNetworkQualityHandler.this.mHostNameVerified = HttpsURLConnection.getDefaultHostnameVerifier().verify(string, sSLSession) || HttpsURLConnection.getDefaultHostnameVerifier().verify("a248.e.akamai.net", sSLSession);
                            return AkaNetworkQualityHandler.this.mHostNameVerified;
                        }
                    };
                }
                if ("production".equals("mock")) {
                    httpURLConnection = this.pinCertsForMocking((HttpsURLConnection)httpURLConnection);
                } else {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.mHostnameVerifier);
                }
            }
            httpURLConnection.setReadTimeout(n2);
            httpURLConnection.setUseCaches(false);
            int n3 = httpURLConnection.getResponseCode();
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            if (n3 == 200 || n3 == 204) {
                int n4;
                inputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                byte[] byArray = new byte[8192];
                int n5 = 0;
                while ((n4 = inputStream.read(byArray)) != -1) {
                    n5 += n4;
                }
                long l4 = System.nanoTime();
                long l5 = Long.parseLong(httpURLConnection.getHeaderField("X-Android-Sent-Millis"));
                long l6 = Long.parseLong(httpURLConnection.getHeaderField("X-Android-Received-Millis"));
                long l7 = TrafficStats.getUidRxBytes((int)this.mContext.getApplicationInfo().uid);
                l = this.downloadSpeed("htp", n5, l6 - l5, n);
                l2 = l6 - l5;
                editor.remove("last_ping_fail_ec");
                editor.remove("last_ping_fail_ts");
                editor.apply();
            } else {
                editor.putInt("last_ping_fail_ec", n3);
                editor.putLong("last_ping_fail_ts", System.currentTimeMillis());
                editor.apply();
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketTimeoutException) {
                l = 0L;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        object = new CongResponse(3, l, l2);
        return object;
    }

    private long downloadSpeed(String string, long l, long l2, int n) {
        long l3 = this.getDefaultTcpBufferSize(this.getCurrentNetworkSubType());
        Long[] longArray = this.getTcpBufferSize();
        if (longArray.length > 0 && longArray[0] < l3) {
            l3 = longArray[0];
        }
        long l4 = l3 / l2;
        return l4;
    }

    private String displayString(long l) {
        long l2 = 1024L;
        long l3 = l2 * 1024L;
        long l4 = l3 * 1024L;
        if (l < l2) {
            return l + " bit-sec";
        }
        if (l > l2 && l < l3) {
            return l / l2 + " Kbit-sec";
        }
        if (l > l3 && l < l4) {
            return l / l3 + " Mbit-sec";
        }
        if (l > l4) {
            return l / l4 + " Gbit-sec";
        }
        return "???";
    }

    private static String randomString(int n) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(random.nextInt(9));
        }
        return stringBuilder.toString();
    }

    private long getHighThreshold(int n) {
        long l = 0x100000L;
        String string = AnaUtils.getNetworkGen(n);
        if (string.toLowerCase().contains("2g")) {
            l = AnaUtils.getEDGECongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            l = AnaUtils.get3GCongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            l = AnaUtils.getHSPACongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            l = AnaUtils.getLTECongHighThreshold(this.mContext);
        }
        return l;
    }

    private long getLowThreshold(int n) {
        long l = 524288L;
        String string = AnaUtils.getNetworkGen(n);
        if (string.toLowerCase().contains("2g")) {
            l = AnaUtils.getEDGECongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            l = AnaUtils.get3GCongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            l = AnaUtils.getHSPACongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            l = AnaUtils.getLTECongLowThreshold(this.mContext);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long[] getTcpBufferSize() {
        Long[] longArray;
        String string;
        block11: {
            int n;
            Network[] networkArray;
            NetworkInfo networkInfo;
            block13: {
                int n2;
                block12: {
                    n2 = this.getCurrentNetworkSubType();
                    string = Integer.toString(n2);
                    if (this.mTcpBufferTable.containsKey(string)) {
                        return this.mTcpBufferTable.get(string);
                    }
                    long l = this.getDefaultTcpBufferSize(n2);
                    longArray = new Long[]{l, l, l};
                    if (Build.VERSION.SDK_INT < 21) break block12;
                    networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
                    if (networkInfo == null || !networkInfo.isConnected()) break block11;
                    networkArray = this.mConnectivityManager.getAllNetworks();
                    n = networkArray.length;
                    break block13;
                }
                if (Build.VERSION.SDK_INT < 15) break block11;
                String string2 = "";
                if (AnaUtils.isWifiConnected(this.mContext)) {
                    string2 = "net.tcp.buffersize.wifi";
                } else if (AnaUtils.isCellularConnected(this.mContext)) {
                    string2 = AnaUtils.getTcpBufferProperty(n2);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    try {
                        String[] stringArray;
                        String string3 = AnaUtils.getProperty(string2);
                        if (!TextUtils.isEmpty((CharSequence)string3) && (stringArray = string3.split(",")).length > 0) {
                            longArray[0] = Long.parseLong(stringArray[0]) * 8L;
                            longArray[1] = Long.parseLong(stringArray[1]) * 8L;
                            longArray[2] = Long.parseLong(stringArray[2]) * 8L;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        Logger.d((String)"AkaSdkLogger-map", (String)("CngDtctr: getTcpBufferSize(): " + exception));
                    }
                }
                break block11;
            }
            for (int i = 0; i < n; ++i) {
                Network network = networkArray[i];
                NetworkInfo networkInfo2 = this.mConnectivityManager.getNetworkInfo(network);
                if (networkInfo2 == null || networkInfo2.getType() != networkInfo.getType() || !networkInfo2.isConnected()) continue;
                LinkProperties linkProperties = this.mConnectivityManager.getLinkProperties(network);
                try {
                    String[] stringArray;
                    Method method = linkProperties.getClass().getMethod("getTcpBufferSizes", null);
                    String string4 = (String)method.invoke((Object)linkProperties, (Object[])null);
                    if (TextUtils.isEmpty((CharSequence)string4) || (stringArray = string4.split(",")).length <= 0) break;
                    longArray[0] = Long.parseLong(stringArray[0]) * 8L;
                    longArray[1] = Long.parseLong(stringArray[1]) * 8L;
                    longArray[2] = Long.parseLong(stringArray[2]) * 8L;
                }
                catch (Exception exception) {
                    Logger.d((String)"AkaSdkLogger-map", (String)("CngDtctr: getTcpBufferSize(): " + exception));
                }
                break;
            }
        }
        this.mTcpBufferTable.put(string, longArray);
        return longArray;
    }

    private long getDefaultTcpBufferSize(int n) {
        long l = 63888L;
        if (n != 0) {
            String string = AnaUtils.getNetworkGen(this.getCurrentNetworkSubType());
            if (string.equalsIgnoreCase("4g")) {
                l = 511104L;
            }
            if (string.equalsIgnoreCase("3.5g")) {
                l = 255552L;
            }
            if (string.equalsIgnoreCase("3g")) {
                l = 127776L;
            }
            if (string.equalsIgnoreCase("2g")) {
                l = 63888L;
            }
        } else if (AnaUtils.isWifiConnected(this.mContext)) {
            l = 511104L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection pinCertsForMocking(HttpsURLConnection httpsURLConnection) throws CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        Certificate certificate;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (InputStream inputStream = this.mContext.getResources().openRawResource(R.raw.map);){
            certificate = certificateFactory.generateCertificate(inputStream);
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("ca=" + ((X509Certificate)certificate).getSubjectDN()));
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509CertificateArray = new X509Certificate[]{};
                x509CertificateArray[0] = (X509Certificate)certificate;
                return x509CertificateArray;
            }
        }}, null);
        httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        httpsURLConnection.setHostnameVerifier(new NullHostNameVerifier());
        return httpsURLConnection;
    }

    class NullHostNameVerifier
    implements HostnameVerifier {
        NullHostNameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            if (string.equals("127.0.0.1")) {
                AkaLogger.in((String)"AkaSdkLogger-map", (String)("NullHostNameVerifier Approving certificate for " + string));
                return true;
            }
            return false;
        }
    }

    private static final class CongResponse {
        int congLevel = -1;
        long bitRate = -1L;
        long responseTime = -1L;

        CongResponse() {
        }

        CongResponse(int n, long l, long l2) {
            this.congLevel = n;
            this.bitRate = l;
            this.responseTime = l2;
        }
    }

    private class Trendline {
        private final ArrayList<Long> xAxisValues;
        private final ArrayList<Long> yAxisValues;
        private int count;
        private long xAxisValuesSum;
        private long xxSum;
        private long xySum;
        private long yAxisValuesSum;
        long avg;
        double slope;
        double intercept;
        double start;
        double stop;

        Trendline(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
            this.yAxisValues = arrayList;
            this.xAxisValues = arrayList2;
            this.Initialize();
        }

        private void Initialize() {
            this.count = this.yAxisValues.size();
            long l = 0L;
            for (Long l2 : this.yAxisValues) {
                l += l2.longValue();
            }
            this.avg = l / (long)this.count;
            this.yAxisValuesSum = l;
            l = 0L;
            for (Long l2 : this.xAxisValues) {
                l += l2.longValue();
            }
            this.xAxisValuesSum = l;
            this.xxSum = 0L;
            this.xySum = 0L;
            for (int i = 0; i < this.count; ++i) {
                this.xySum += this.xAxisValues.get(i) * this.yAxisValues.get(i);
                this.xxSum += this.xAxisValues.get(i) * this.xAxisValues.get(i);
            }
            this.slope = this.CalculateSlope();
            this.intercept = this.CalculateIntercept();
            this.start = this.CalculateStart();
            this.stop = this.CalculateEnd();
        }

        private double CalculateSlope() {
            try {
                double d = (long)this.count * this.xySum - this.xAxisValuesSum * this.yAxisValuesSum;
                double d2 = (long)this.count * this.xxSum - this.xAxisValuesSum * this.xAxisValuesSum;
                if (d > 0.0 && d2 > 0.0) {
                    this.slope = d / d2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.slope;
        }

        private double CalculateIntercept() {
            return ((double)this.yAxisValuesSum - this.slope * (double)this.xAxisValuesSum) / (double)this.count;
        }

        private double CalculateStart() {
            return this.slope * (double)this.xAxisValues.get(0).longValue() + this.intercept;
        }

        private double CalculateEnd() {
            return this.slope * (double)this.xAxisValues.get(this.count - 1).longValue() + this.intercept;
        }
    }

    private static class ConnectionHandler {
        private Socket mSocket = null;
        private DataOutputStream mOutputToServer = null;
        private BufferedReader mInputFromServer = null;
        private static ConnectionHandler sInstance = null;
        private final String LOGTAG = "ConnectionHandler";

        private ConnectionHandler() {
        }

        static synchronized ConnectionHandler getInstance() {
            if (sInstance == null) {
                sInstance = new ConnectionHandler();
            }
            return sInstance;
        }

        boolean sendRequest(String string, int n, String string2, int n2) throws IOException {
            if (!this.openConnection(string, n, n2)) {
                return false;
            }
            this.mOutputToServer.writeBytes(string2 + '\n');
            return true;
        }

        String readResponse() throws IOException {
            return this.mInputFromServer.readLine();
        }

        synchronized void forceNewSocketCreation() {
            if (this.mSocket != null) {
                try {
                    this.mInputFromServer.close();
                    this.mOutputToServer.close();
                    this.mSocket.close();
                }
                catch (IOException iOException) {
                    Logger.e((String)"AkaSdkLogger-map", (String)"ConnectionHandler: forceNewSocketCreation(): ", (Throwable)iOException);
                }
            }
            this.mInputFromServer = null;
            this.mOutputToServer = null;
            this.mSocket = null;
        }

        synchronized boolean openConnection(String string, int n, int n2) {
            try {
                if (this.requiresNewConnection()) {
                    this.mSocket = new Socket(string, n);
                    this.mSocket.setSoTimeout(n2);
                    this.mOutputToServer = new DataOutputStream(this.mSocket.getOutputStream());
                    this.mInputFromServer = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
                }
            }
            catch (IOException iOException) {
                Logger.e((String)"AkaSdkLogger-map", (String)"ConnectionHandler: openConnection(): ", (Throwable)iOException);
                return false;
            }
            return true;
        }

        private boolean requiresNewConnection() throws IOException {
            boolean bl = false;
            if (this.mSocket == null) {
                bl = true;
            } else if (!this.mSocket.isConnected()) {
                this.mInputFromServer.close();
                this.mOutputToServer.close();
                this.mSocket.close();
                bl = true;
            }
            return bl;
        }

        public void setTimeOut(int n) throws IOException {
            if (this.mSocket != null) {
                this.mSocket.setSoTimeout(n);
            }
        }
    }
}

