/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaJsonObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AkaManifestData {
    private static final String SEGMENT_ID = "segment_id";
    private static final String LICENSE_KEY = "license_key";
    private static final String SEGMENT_TYPE = "segment_type";
    private static final String URLS = "urls";
    private static final String URL = "url";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPS = "timestamps";
    private static final String MODIFIED = "modified";
    private static final String CREATED = "created";
    private static final String PRIORITY = "priority";
    private static final String DL_HOST_MAPPING = "download_host_mapping";
    private static final String ORIG_HOSTNAME = "url_hostname";
    private static final String DL_HOSTNAME = "download_hostname";
    private static final String NETWORK_SELECTION = "network_selection";
    private String mSegmentId = null;
    private String mLicenseKey = null;
    private String mSegmentType = null;
    private Map<String, String> mUrls = new HashMap<String, String>();
    private Map<String, String> mDlHostnameMapping = new HashMap<String, String>();
    private String mModified;
    private String mCreated;
    private int mNetworkSelection = 0;
    private int mPriority = Integer.MAX_VALUE;

    AkaManifestData(String string) {
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                AkaJsonObject akaJsonObject = new AkaJsonObject(new JSONObject(string));
                this.mSegmentId = akaJsonObject.getString(SEGMENT_ID, "");
                this.mLicenseKey = akaJsonObject.getString(LICENSE_KEY, "");
                this.mSegmentType = akaJsonObject.getString(SEGMENT_TYPE, "");
                this.mNetworkSelection = this.createNetworkSelection(akaJsonObject.getString(NETWORK_SELECTION, null));
                String string2 = akaJsonObject.getString(PRIORITY, String.valueOf(this.mPriority));
                this.mPriority = Integer.parseInt(string2);
                JSONArray jSONArray = akaJsonObject.getJsonArray(DL_HOST_MAPPING, new JSONArray());
                this.mDlHostnameMapping = this.getConvertedDlMappings(jSONArray);
                JSONArray jSONArray2 = akaJsonObject.getJsonArray(URLS, null);
                this.mUrls = this.getUrls(jSONArray2);
                JSONObject jSONObject = akaJsonObject.getJsonObject(TIMESTAMPS, null);
                this.addTimestamp(jSONObject);
            }
        }
        catch (NumberFormatException | JSONException throwable) {
            Logger.d((String)"AkaSdkLogger-map", (String)"AkaManifestData: exception ", (Throwable)throwable);
        }
    }

    private Map<String, String> getUrls(JSONArray jSONArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                AkaJsonObject akaJsonObject = new AkaJsonObject(jSONArray.getJSONObject(i));
                String string = akaJsonObject.getString(URL, "");
                String string2 = akaJsonObject.getString(TIMESTAMP, "");
                if (string == null || string.isEmpty() || string2 == null) continue;
                hashMap.put(string, string2);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                Logger.e((String)"AkaSdkLogger-map", (String)"AkaManifestData - getUrls: exception ", (Throwable)jSONException);
            }
        }
        return hashMap;
    }

    private Map<String, String> getConvertedDlMappings(JSONArray jSONArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                AkaJsonObject akaJsonObject = new AkaJsonObject(jSONArray.getJSONObject(i));
                String string = akaJsonObject.getString(ORIG_HOSTNAME, "");
                String string2 = akaJsonObject.getString(DL_HOSTNAME, "");
                if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) continue;
                hashMap.put(string, string2);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                Logger.e((String)"AkaSdkLogger-map", (String)"AkaManifestData - getConvertedDlMappings: exception ", (Throwable)jSONException);
            }
        }
        return hashMap;
    }

    private void addTimestamp(JSONObject jSONObject) {
        AkaJsonObject akaJsonObject = new AkaJsonObject(jSONObject);
        try {
            this.mModified = akaJsonObject.getString(MODIFIED, "");
            this.mCreated = akaJsonObject.getString(CREATED, "");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaManifestData - addTimestamp: exception ", (Throwable)jSONException);
        }
    }

    private int createNetworkSelection(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        switch (string) {
            case "WIFI_ONLY": {
                return 1;
            }
            case "WIFI_AND_CELLULAR": {
                return 2;
            }
        }
        return 0;
    }

    @Nullable
    public String getSegmentId() {
        return this.mSegmentId;
    }

    @Nullable
    public String getLicenseKey() {
        return this.mLicenseKey;
    }

    @Nullable
    public String getSegmentType() {
        return this.mSegmentType;
    }

    @NonNull
    public Map<String, String> getUrls() {
        return this.mUrls;
    }

    @Nullable
    public String getModified() {
        return this.mModified;
    }

    @Nullable
    public String getCreated() {
        return this.mCreated;
    }

    public int getPriority() {
        return this.mPriority;
    }

    @NonNull
    public Map<String, String> getDlHostnameMappings() {
        return this.mDlHostnameMapping;
    }

    public int getNetworkSelection() {
        return this.mNetworkSelection;
    }
}

