/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaConfigHandler;
import com.akamai.android.sdk.internal.AnaFeedController;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.File;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class AkaCacheHandler {
    private static final String LOG_TAG = "AkaCacheHandler";
    public static final Object REGISTER_UPDATE_LOCK = new Object();
    private static final String LAST_PURGE_TIME = "lastPurgeTime";
    private static final String PURGEBYURL_TIMESTAMP = "timestamp";
    private static final String PURGEBYURL_URL = "url";
    private static final String PURGEBYURL_TYPE = "type";
    private static final String PURGEBYURL_TYPE_DELETE = "DELETE";

    public static void removeData(Context context) {
        AkaCacheHandler.clearCache(context, false);
    }

    public static void invalidateUCContent(final Context context, final long l) {
        final SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        long l2 = sharedPreferences.getLong(LAST_PURGE_TIME, 0L);
        if (l > l2) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("maxage", Integer.valueOf(0));
                    String string = "refreshtimestamp<=? and syncPending=?";
                    context.getContentResolver().update(AnaProviderContract.CONTENT_URI_FEEDS, contentValues, string, new String[]{String.valueOf(l * 1000L), String.valueOf(1)});
                    sharedPreferences.edit().putLong(AkaCacheHandler.LAST_PURGE_TIME, l).apply();
                }
            }).start();
        }
    }

    public static void purgeCachedContentByUrl(Context context, JSONArray jSONArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (context == null || jSONArray == null) {
            Logger.e((String)"AkaSdkLogger-map", (String)"purgeCachedContentByUrl: invalid parameters");
            return;
        }
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                if (jSONObject != null && jSONObject.has(PURGEBYURL_URL) && jSONObject.has(PURGEBYURL_TIMESTAMP) && jSONObject.has(PURGEBYURL_TYPE)) {
                    long l;
                    long l2;
                    String string = jSONObject.getString(PURGEBYURL_URL);
                    AnaFeedItem anaFeedItem = AnaFeedController.getAnaFeedItemByUrl(context, string);
                    if (anaFeedItem == null || (l2 = jSONObject.getLong(PURGEBYURL_TIMESTAMP)) <= (l = anaFeedItem.getRefreshTimeStamp() / 1000L)) continue;
                    String string2 = jSONObject.getString(PURGEBYURL_TYPE);
                    boolean bl = string2.equalsIgnoreCase(PURGEBYURL_TYPE_DELETE);
                    if (bl) {
                        AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaCacheHandler UC deleting url -" + string));
                        AkaCacheHandler.deleteCachedContentByUrl(context, anaFeedItem, hashSet);
                        continue;
                    }
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaCacheHandler UC invalidating url -" + string));
                    AkaCacheHandler.invalidateCachedContentByUrl(context, string);
                    continue;
                }
                Logger.e((String)"AkaSdkLogger-map", (String)"purgeCachedContentByUrl json content missing items");
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"purgeCachedContentByUrl exception parsing the item");
            exception.printStackTrace();
        }
        if (!hashSet.isEmpty()) {
            VocAccelerator.getInstance().onDelete(hashSet);
        }
    }

    public static void deleteSegmentContentByUrl(Context context, List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (context == null || list == null) {
            Logger.e((String)"AkaSdkLogger-map", (String)"deleteSegmentContentByUrl: invalid parameters");
            return;
        }
        try {
            for (String string : list) {
                AnaFeedItem anaFeedItem = AnaFeedController.getAnaFeedItemByUrl(context, string);
                if (anaFeedItem == null) continue;
                AkaCacheHandler.deleteCachedContentByUrl(context, anaFeedItem, hashSet);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"purgeCachedContentByUrl exception parsing the item");
            exception.printStackTrace();
        }
        if (!hashSet.isEmpty()) {
            VocAccelerator.getInstance().onDelete(hashSet);
        }
    }

    static void purgeUniversalCache(String string, ArrayList<String> arrayList, Context context) {
        if (string.equals("globalPurge")) {
            AkaCacheHandler.clearCache(context, false);
            AnaDiskUtils.forceRecalculateMemorySize(context);
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.apply();
        } else if (arrayList != null && arrayList.size() > 0) {
            String string2 = "";
            if (string.equals("providerPurge")) {
                string2 = AnaProviderContract.getProviderSelectionClause(arrayList);
            } else if (string.equals("identifierPurge")) {
                string2 = AnaProviderContract.getIdSelectionClause(arrayList);
            }
            if (!string2.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                Cursor cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, string2, null, null);
                if (cursor != null) {
                    if (cursor.moveToFirst()) {
                        while (!cursor.isAfterLast()) {
                            AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                            Set<String> set = AkaCacheHandler.removeCacheEntry(anaFeedItem, 3, context);
                            for (String string3 : set) {
                                hashSet.add(string3);
                            }
                            cursor.moveToNext();
                        }
                    }
                    cursor.close();
                }
                if (hashSet.size() > 0) {
                    Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, hashSet.size() + " UC items deleted"});
                    string2 = AnaProviderContract.getIdSelectionClause(hashSet);
                    if (!string2.isEmpty()) {
                        VocAccelerator.getInstance().onDelete(hashSet);
                        context.getContentResolver().delete(AnaProviderContract.CONTENT_URI_FEEDS, string2, null);
                    }
                    AnaDiskUtils.forceRecalculateMemorySize(context);
                }
            }
        }
    }

    public static void clearCache(Context context, Boolean bl) {
        File[] fileArray;
        File file;
        File[] fileArray2;
        File file2;
        String string;
        File[] fileArray3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            object4 = (CookieManager)CookieManager.getDefault();
            object3 = ((CookieManager)object4).getCookieStore();
            object3.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        context = context.getApplicationContext();
        object4 = VocUtils.getMediaPath(context);
        object3 = VocUtils.getDataPath(context);
        File file3 = new File((String)object4);
        if (file3.exists() && (object2 = file3.listFiles()) != null) {
            object = object2;
            int n = ((File[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object5 = object[i];
                ((File)object5).delete();
            }
        }
        if (((File)(object = new File((String)(object2 = AnaDiskUtils.getInternalStoragePath(context, bl))))).exists() && (fileArray3 = ((File)object).listFiles()) != null) {
            for (File file4 : fileArray3) {
                file4.delete();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string = AnaDiskUtils.getRemovableStoragePath(context, true))) && (file2 = new File(string)).exists() && (fileArray2 = file2.listFiles()) != null) {
            File[] fileArray4 = fileArray2;
            int n = fileArray4.length;
            for (int i = 0; i < n; ++i) {
                File file5 = fileArray4[i];
                file5.delete();
            }
        }
        if ((file = new File((String)object3)).exists() && (fileArray = file.listFiles()) != null) {
            for (File file5 : fileArray) {
                if (file5.getName().endsWith(".json")) {
                    file5.delete();
                }
                if (!file5.getName().endsWith(".json.old")) continue;
                file5.delete();
            }
        }
        context.getContentResolver().delete(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, null);
        ContentValues contentValues = new ContentValues();
        contentValues.put("httpts", "");
        contentValues.put("downloadManifestTS", Long.valueOf(0L));
        context.getContentResolver().update(AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION, contentValues, null, null);
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        AkaConfigHandler.delPrefForclearCache(editor);
        editor.apply();
        AnaDiskUtils.forceRecalculateMemorySize(context);
    }

    static Set<String> removeCacheEntry(AnaFeedItem anaFeedItem, Context context) {
        return AkaCacheHandler.removeCacheEntry(anaFeedItem, 1, context);
    }

    private static Set<String> removeCacheEntry(AnaFeedItem anaFeedItem, int n, Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<AnaFeedItem> linkedList = new LinkedList<AnaFeedItem>();
        linkedList.add(anaFeedItem);
        while (!linkedList.isEmpty()) {
            AnaFeedItem anaFeedItem2 = (AnaFeedItem)linkedList.remove();
            try {
                AnaFeedController.deleteFeedInFileSystem(context, anaFeedItem2);
                if (hashSet.contains(anaFeedItem2.getId())) continue;
                hashSet.add(anaFeedItem2.getId());
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaCacheHandler: Cannot delete feed id: " + anaFeedItem2.getId() + ", reason: " + exception));
            }
        }
        return hashSet;
    }

    private static void deleteCachedContentByUrl(Context context, AnaFeedItem anaFeedItem, Set<String> set) {
        String string;
        if (anaFeedItem.isResourceReady()) {
            string = AnaDiskUtils.getInternalStoragePath(context);
            try {
                File file = new File(string + anaFeedItem.getFileName());
                if (file.exists()) {
                    boolean bl = file.delete();
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)("deleteCachedContentByUrl: file " + file.getName() + " deleted " + (bl ? "successfully." : "failed.")));
                } else {
                    Logger.e((String)"AkaSdkLogger-map", (String)("deleteCachedContentByUrl: no such file " + file.getName()));
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"deleteCachedContentByUrl exception deleting cached file");
            }
        }
        string = "url=?";
        context.getContentResolver().delete(AnaProviderContract.CONTENT_URI_FEEDS, "url=?", new String[]{anaFeedItem.getUrl()});
        set.add(anaFeedItem.getId());
        AnaDiskUtils.forceRecalculateMemorySize(context);
    }

    private static void invalidateCachedContentByUrl(Context context, String string) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("maxage", Integer.valueOf(0));
        String string2 = "url=? and syncPending=?";
        context.getContentResolver().update(AnaProviderContract.CONTENT_URI_FEEDS, contentValues, "url=? and syncPending=?", new String[]{string, "1"});
    }
}

