/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.net.Uri;
import android.text.TextUtils;
import com.akamai.android.sdk.AkaMap;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaDatabaseSchema;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.File;
import java.util.Calendar;
import java.util.TimeZone;

class AnaDatabaseAccess {
    private SQLiteDatabase database;
    private final AnaDatabaseSchema databaseHelper;
    private static final int SQLITE_ERROR = -1;
    private static final String LOG_TAG = "AnaDatabaseAccess";
    private final Context mContext;
    private final String[] feedItemColumns = new String[]{"_id", "provider", "url", "videofile", "feedtype", "size", "timestamp", "resourceready", "viewcount", "priority", "creationtimestamp", "status", "responseheaders", "refreshtimestamp", "maxage", "syncPending", "accessts", "segment", "mustRevalidate", "dlUrl", "networkSelection"};
    private final String[] httpStatsColumns = new String[]{"_id", "feedid", "url", "downloadtype", "timestamp", "duration", "ttfb", "batterylevel", "ischarging", "connectiontype", "location", "signalstrength", "respcode", "requestheadersize", "responseheadersize", "contentlength", "mimetype", "mptype", "mpmethod", "mpwinner", "serverprofile", "amcid", "quicEnabled", "requestType", "v4Tries", "v6Tries", "contentLengthHeader", "maxRwnd", "brotliEnabled", "brotliUsed", "cacheable", "tpResult", "sessionId", "exceptionMessage", "precached", "redirected"};
    private final String[] sessionStatsColumns = new String[]{"_id", "timestamp", "duration", "name"};
    private final String[] userEventColumns = new String[]{"_id", "name", "starttime", "stoptime", "connectiontype", "sessionId"};
    private final String[] eventLogColumns = new String[]{"_id", "name", "timestamp", "sessionId"};
    private final String[] segmentSubscriptionColumns = new String[]{"sgmntlname", "sgmntsname", "httpts", "timestamp", "subscribed", "downloadManifestTS", "fgSegment"};
    private final String[] deletedFeedsColumns = new String[]{"_id", "timestamp"};

    AnaDatabaseAccess(Context context) {
        this.mContext = context;
        this.databaseHelper = new AnaDatabaseSchema(context, (DatabaseErrorHandler)new DefaultDatabaseErrorHandler());
    }

    public synchronized void open() throws SQLException {
        try {
            this.database = this.databaseHelper.getWritableDatabase();
            this.database.execSQL("PRAGMA foreign_keys=ON");
            this.database.execSQL("VACUUM");
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseAccess: open: ", (Throwable)sQLException);
            AnaUtils.getSDKSharedPreferences(this.mContext).edit().putLong("last_db_corruption_ts", Calendar.getInstance(TimeZone.getTimeZone("utc")).getTimeInMillis()).apply();
            if (this.database == null) {
                String string = this.mContext.getDatabasePath("feed.db").getPath();
                this.deleteFile(string);
                this.deleteFile(string + "-journal");
                this.deleteFile(string + "-shm");
                this.deleteFile(string + "-wal");
                try {
                    this.database = this.databaseHelper.getWritableDatabase();
                    this.database.execSQL("PRAGMA foreign_keys=ON");
                    this.database.execSQL("VACUUM");
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseAccess: open: exception within exception handling: ", (Throwable)exception);
                }
                AkaMap.getInstance().clearMapCache();
            }
            this.database.close();
            this.database = null;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseAccess: open: Non SQL exception: ", (Throwable)exception);
        }
    }

    private void deleteFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        file.delete();
    }

    private void close() {
        this.databaseHelper.close();
    }

    public Uri addFeedItem(ContentValues contentValues) {
        Uri uri = null;
        try {
            this.database.insertOrThrow("feeditem", null, contentValues);
            uri = Uri.parse((String)("feeditems/" + contentValues.getAsString("_id")));
            VocAccelerator.getInstance().onInsert(contentValues.getAsString("_id"), contentValues.getAsString("url"));
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return uri;
    }

    public int updateFeed(String string, ContentValues contentValues, String string2, String[] stringArray) {
        int n = 0;
        try {
            n = string2 != null && !string2.isEmpty() ? this.database.update("feeditem", contentValues, "_id='" + string + "' and " + string2, stringArray) : this.database.update("feeditem", contentValues, "_id='" + string + "'", null);
            if (n == 1 && contentValues.containsKey("resourceready")) {
                VocAccelerator.getInstance().onUpdate(string, contentValues.getAsBoolean("resourceready"));
            }
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return n;
    }

    public int updateFeeds(ContentValues contentValues, String string, String[] stringArray) {
        int n = 0;
        try {
            n = this.database.update("feeditem", contentValues, string, stringArray);
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return n;
    }

    public int updateFeedStats(ContentValues contentValues, String string, String[] stringArray) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.database.update("feeditem", contentValues, string, stringArray);
        }
        return this.database.update("feeditem", contentValues, null, null);
    }

    public void delete(AnaFeedItem anaFeedItem) {
        String string = anaFeedItem.getId();
        this.database.delete("feeditem", "_id = " + string, null);
    }

    public void deleteFeedItem(String string) {
        this.database.delete("feeditem", "_id = " + this.quotifyString(string), null);
    }

    public int deleteFeeds(String string, String[] stringArray) {
        int n;
        if (string == null || string.isEmpty()) {
            n = this.database.delete("feeditem", null, null);
            VocAccelerator.getInstance().onClearCache();
        } else {
            n = this.database.delete("feeditem", string, stringArray);
        }
        return n;
    }

    public int deleteSegment(String string, String[] stringArray) {
        int n = string == null || string.isEmpty() ? this.database.delete("segment", null, null) : this.database.delete("segment", string, stringArray);
        return n;
    }

    public int deleteDeletedFeeds(String string, String[] stringArray) {
        if (string == null || string.isEmpty()) {
            return this.database.delete("deletedfeeds", null, null);
        }
        return this.database.delete("deletedfeeds", string, stringArray);
    }

    public Cursor getFeedItems(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = this.feedItemColumns;
        }
        Cursor cursor = string2 != null && !string2.isEmpty() ? this.database.query("feeditem", stringArray, string, stringArray2, null, null, string2, null) : this.database.query("feeditem", stringArray, string, stringArray2, null, null, "timestamp DESC", null);
        return cursor;
    }

    public Cursor getFilteredCount(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count (*) from ");
        stringBuffer.append("feeditem");
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string);
        Cursor cursor = this.database.rawQuery(stringBuffer.toString(), stringArray2);
        return cursor;
    }

    public Cursor getFeedItem(String string) {
        Cursor cursor = this.database.query("feeditem", this.feedItemColumns, "_id = '" + string + "'", null, null, null, "_id DESC", null);
        return cursor;
    }

    public Cursor getHttpConsumptionStats(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals("count (*)")) {
            return this.getCountOfHttpConsumptionStats(string, stringArray2);
        }
        Cursor cursor = this.database.query("httpstats", this.httpStatsColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    private Cursor getCountOfHttpConsumptionStats(String string, String[] stringArray) {
        String string2 = "SELECT count (*) from httpstats WHERE " + string;
        return this.database.rawQuery(string2, stringArray);
    }

    public Cursor getSessionStats(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("sessionstats", this.sessionStatsColumns, string, stringArray2, null, null, "timestamp ASC", null);
        return cursor;
    }

    public Cursor getUserEvents(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("userevents", this.userEventColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public Cursor getEventLogs(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("eventlog", this.eventLogColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public Cursor getSegment(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return this.database.query("segment", this.segmentSubscriptionColumns, string, stringArray2, null, null, null, null);
    }

    public Cursor getDeletedFeeds(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray == null) {
            stringArray = this.deletedFeedsColumns;
        }
        if (string2 == null) {
            string2 = "timestamp ASC";
        }
        Cursor cursor = this.database.query("deletedfeeds", stringArray, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public boolean addHttpConsumptionStats(ContentValues contentValues) {
        boolean bl = false;
        try {
            if (this.database.insertOrThrow("httpstats", null, contentValues) != -1L) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl;
    }

    public boolean addSessionStats(ContentValues contentValues) {
        boolean bl = false;
        try {
            if (this.database.insertOrThrow("sessionstats", null, contentValues) != -1L) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl;
    }

    public boolean addUserEvent(ContentValues contentValues) {
        boolean bl = false;
        try {
            if (this.database.insertOrThrow("userevents", null, contentValues) != -1L) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl;
    }

    public boolean addEventLog(ContentValues contentValues) {
        boolean bl = false;
        try {
            if (this.database.insertOrThrow("eventlog", null, contentValues) != -1L) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl;
    }

    public void addOrUpdateSegment(ContentValues contentValues) {
        try {
            String string = "INSERT OR REPLACE INTO segment VALUES ( " + this.quotifyString(contentValues.getAsString("sgmntlname")) + "," + this.quotifyString(contentValues.getAsString("sgmntsname")) + "," + contentValues.get("timestamp") + "," + this.quotifyString(contentValues.getAsString("httpts")) + "," + contentValues.get("subscribed") + "," + contentValues.get("downloadManifestTS") + "," + contentValues.get("fgSegment") + ")";
            this.database.execSQL(string);
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: addOrUpdateSegment: " + (Object)((Object)sQLException)));
        }
    }

    public boolean addDeletedFeeds(ContentValues contentValues) {
        try {
            if (this.database.insertOrThrow("deletedfeeds", null, contentValues) != -1L) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: addDeletedFeeds" + (Object)((Object)sQLException)));
        }
        return false;
    }

    public void deleteHttpConsumptionStats(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("httpstats", string, stringArray);
    }

    public void deleteSessionStats(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("sessionstats", string, stringArray);
    }

    public void deleteUserEvents(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("userevents", string, stringArray);
    }

    public void deleteEventLogs(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("eventlog", string, stringArray);
    }

    public int updateSegment(ContentValues contentValues, String string, String[] stringArray) {
        return this.database.update("segment", contentValues, string, stringArray);
    }

    private String quotifyString(String string) {
        return string != null ? "'" + string + "'" : "''";
    }

    private void handleDiskIOError() {
        Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseAccess: handleDiskIOError closing db");
        try {
            this.close();
            this.open();
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseAccess: handleDiskIOError ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(int n, ContentValues[] contentValuesArray) {
        int n2 = 0;
        switch (n) {
            case 10: 
            case 20: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addFeedItem(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 200: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addHttpConsumptionStats(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 210: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addSessionStats(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 220: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addUserEvent(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 230: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addEventLog(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 250: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addOrUpdateSegment(contentValues);
                        ++n2;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
        }
        return n2;
    }

    boolean isDatabaseAccessible() {
        return this.database != null && this.database.isOpen();
    }
}

