/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.akamai.android.annotations.PublicApi;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.CommonUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

@Keep
@PublicApi
public class MapSdkInfo
extends Logger {
    private static final ExecutorService sLogThread = Executors.newSingleThreadExecutor();
    private static final String LOG_TAG = "MapSdkInfo";

    @Keep
    @PublicApi
    public static String getSegments() {
        Set<String> set = MapSdkInfo.getSegments(VocAccelerator.getInstance().getAppContext());
        String string = "";
        if (!set.isEmpty()) {
            string = TextUtils.join((CharSequence)",", set);
        }
        return string;
    }

    @Keep
    @PublicApi
    @NonNull
    public static Set<String> getSegments(Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        Cursor cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), new String[]{"sgmntlname"}, "subscribed=? AND fgSegment=?", new String[]{"1", "0"}, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String string = cursor.getString(0);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        string = string.trim();
                    }
                    hashSet.add(string);
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        return hashSet;
    }

    @Keep
    @PublicApi
    public static boolean isEnabled() {
        boolean bl = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_web_acceleration", false);
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("kill_switch", false);
        return bl && !bl2;
    }

    @Keep
    @PublicApi
    public static void logCurrentConfiguration(Context context) throws Exception {
        MapSdkInfo.checkIfDebug();
        final Context context2 = context.getApplicationContext();
        sLogThread.submit(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                VocAccelerator vocAccelerator = VocAccelerator.getInstance();
                SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context2);
                CommonUtils.append(stringBuilder, "***Logging Current Configuration***", ":");
                CommonUtils.append(stringBuilder, "SDK Version", AnaUtils.getBuildVersion(), true);
                CommonUtils.append(stringBuilder, "App Version", VocAccelerator.sPackageName, true);
                CommonUtils.append(stringBuilder, "SDK license key", sharedPreferences.getString("publicKey", ""), true);
                CommonUtils.append(stringBuilder, "Server Config Ts", sharedPreferences.getLong("config_ts", 0L), true);
                CommonUtils.append(stringBuilder, "Last Fcm Ts", sharedPreferences.getLong("fcm_recv_ts", 0L), true);
                CommonUtils.append(stringBuilder, "Last Cache Fill", sharedPreferences.getLong("last_cache_fill", 0L), true);
                CommonUtils.append(stringBuilder, "Last Analytics Upload Ts", sharedPreferences.getLong("lastanalyticsupload_ts", 0L), true);
                CommonUtils.append(stringBuilder, "WebAcceleration", vocAccelerator.getSecurePreferenceBoolean("enable_web_acceleration", false), true);
                CommonUtils.append(stringBuilder, "Master A/B ", vocAccelerator.getSecurePreferenceBoolean("use_master_ab", false), true);
                CommonUtils.append(stringBuilder, "MultiPath", vocAccelerator.getSecurePreferenceBoolean("use_multipath", false), true);
                CommonUtils.append(stringBuilder, "MultiPath: StickinessInterval (sec)", sharedPreferences.getInt("stickyTime", 0), true);
                CommonUtils.append(stringBuilder, "MultiPath: Patterns", vocAccelerator.getMultiPathHandler().getCompiledPatternList(), true);
                CommonUtils.append(stringBuilder, "Preposition", vocAccelerator.getSecurePreferenceBoolean("preposition", false), true);
                CommonUtils.append(stringBuilder, "Precache", vocAccelerator.getSecurePreferenceBoolean("enable_fgsegments", false), true);
                CommonUtils.append(stringBuilder, "Precache Segments", vocAccelerator.getSecurePreferenceBoolean("enable_fgsegments", false), true);
                CommonUtils.append(stringBuilder, "Universal Cache", vocAccelerator.getSecurePreferenceBoolean("universal_cache", false), true);
                CommonUtils.append(stringBuilder, "TransportOpt", vocAccelerator.getSecurePreferenceBoolean("transport_opt", false), true);
                CommonUtils.append(stringBuilder, "Image Manager support enabled ", vocAccelerator.getSecurePreferenceBoolean("use_IM", false));
                CommonUtils.append(stringBuilder, "AIC support enabled ", vocAccelerator.getSecurePreferenceBoolean("use_aic", false));
                CommonUtils.append(stringBuilder, "Quic", vocAccelerator.getSecurePreferenceBoolean("use_quic", false), true);
                CommonUtils.append(stringBuilder, "Quic library added ", vocAccelerator.getCronetEngine() != null);
                CommonUtils.append(stringBuilder, "Brotli", vocAccelerator.getSecurePreferenceBoolean("use_brotli", false), true);
                CommonUtils.append(stringBuilder, "Brotli library added ", vocAccelerator.getBrotliDecoder() != null);
                CommonUtils.append(stringBuilder, "NetworkQuality", AnaUtils.isCongestionControlEnabled(), true);
                CommonUtils.append(stringBuilder, "NetworkQuality: Method", AnaUtils.getNetworkQualityMethod(context2), true);
                CommonUtils.append(stringBuilder, "NetworkQuality: URI", AnaUtils.getNetworkQualityUri(context2), true);
                JSONArray jSONArray = new JSONArray();
                try {
                    jSONArray.put((Object)new JSONObject().put("type", (Object)"2G").put("low", AnaUtils.getEDGECongLowThreshold(context2)).put("high", AnaUtils.getEDGECongHighThreshold(context2)).put("timeout", AnaUtils.get2GTestTimeout(context2)));
                    jSONArray.put((Object)new JSONObject().put("type", (Object)"3G").put("low", AnaUtils.get3GCongLowThreshold(context2)).put("high", AnaUtils.get3GCongHighThreshold(context2)).put("timeout", AnaUtils.get3GTestTimeout(context2)));
                    jSONArray.put((Object)new JSONObject().put("type", (Object)"3.5G").put("low", AnaUtils.getHSPACongLowThreshold(context2)).put("high", AnaUtils.getHSPACongHighThreshold(context2)).put("timeout", AnaUtils.get3_5GTestTimeout(context2)));
                    jSONArray.put((Object)new JSONObject().put("type", (Object)"4G").put("low", AnaUtils.getLTECongLowThreshold(context2)).put("high", AnaUtils.getLTECongHighThreshold(context2)).put("timeout", AnaUtils.get4GTestTimeout(context2)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jSONArray.length() > 0) {
                    CommonUtils.append(stringBuilder, "NetworkQuality: Thresholds", jSONArray, true);
                }
                CommonUtils.append(stringBuilder, "Analytics", vocAccelerator.getSecurePreferenceBoolean("log_analytics", false), true);
                CommonUtils.append(stringBuilder, "Analytics: IgnoreQueryString", vocAccelerator.getSecurePreferenceBoolean("ignore_query", false), true);
                CommonUtils.append(stringBuilder, "Analytics: Location", vocAccelerator.getSecurePreferenceBoolean("get_location", false), true);
                CommonUtils.append(stringBuilder, "Analytics: Carrier", vocAccelerator.getSecurePreferenceBoolean("get_carrier", false), true);
                CommonUtils.append(stringBuilder, "Analytics: SessionLength", vocAccelerator.getSecurePreferenceBoolean("store_session", false), true);
                Logger.dd((String)MapSdkInfo.LOG_TAG, (String)stringBuilder.toString());
            }
        });
    }

    @Keep
    @PublicApi
    public static void logExistingContent(Context context) throws Exception {
        MapSdkInfo.checkIfDebug();
        final Context context2 = context.getApplicationContext();
        sLogThread.submit(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                CommonUtils.append(stringBuilder, "***Logging Existing Content***", ":");
                Set<String> set = MapSdkInfo.getSegments(context2);
                CommonUtils.append(stringBuilder, "Subscribed Segments", set, true);
                CommonUtils.append(stringBuilder, "Id, Url, Type, Downloaded", "", true);
                Logger.dd((String)MapSdkInfo.LOG_TAG, (String)stringBuilder.toString());
                stringBuilder.setLength(0);
                Cursor cursor = context2.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, new String[]{"_id", "url", "feedtype", "resourceready", "syncPending", "segment", "dlUrl"}, null, null, null);
                if (cursor != null) {
                    if (cursor.moveToFirst()) {
                        while (!cursor.isAfterLast()) {
                            String string;
                            String string2 = cursor.getString(0);
                            String string3 = cursor.getString(1);
                            String string4 = cursor.getString(2);
                            boolean bl = cursor.getInt(3) == 1;
                            boolean bl2 = cursor.getInt(4) == 1;
                            String string5 = "Universal Cache";
                            if (!bl2) {
                                string = cursor.getString(5);
                                string5 = AkaSessionHandler.isFgSegment(string) ? "Precache" : "Preposition";
                                string5 = string5 + " " + string;
                            }
                            string = cursor.getString(6);
                            String string6 = string2 + ", " + string3 + ", " + string4 + ", resourceReady-" + bl + " ," + string5 + ", dlurl-" + string;
                            Logger.dd((String)MapSdkInfo.LOG_TAG, (String)(string6 + "\n"));
                            cursor.moveToNext();
                        }
                    } else {
                        Log.d((String)MapSdkInfo.LOG_TAG, (String)"No Content on the device");
                    }
                    cursor.close();
                }
            }
        });
    }
}

