/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk;

import android.content.Context;
import androidx.annotation.Keep;
import com.akamai.android.annotations.PublicApi;
import com.akamai.android.sdk.util.VocUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

@PublicApi
@Keep
class MapProperties
extends Properties {
    private static final MapProperties sInstance = new MapProperties();
    private static final String propertiesFile = "sdk.properties";
    static final String KEY_LOG_CONFIG = "logConfig";
    static final String KEY_LOG_CONTENT = "logContent";
    static final String KEY_SET_LEVEL_DEBUG = "setLogLevelDebug";
    static final String KEY_SIGN_OUT = "signOut";
    static final String KEY_CLEAR_CACHE = "clearCache";
    static final String KEY_PERFORM_CACHE_FILL = "performCacheFill";

    private MapProperties() {
    }

    @PublicApi
    @Keep
    public static MapProperties getInstance() {
        return sInstance;
    }

    @PublicApi
    @Keep
    public boolean loadProperties(Context context) {
        try {
            String string = VocUtils.getDataPath(context) + propertiesFile;
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            this.load(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            ((InputStream)fileInputStream).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @PublicApi
    @Keep
    public boolean getProperty(String string, boolean bl) {
        boolean bl2 = bl;
        try {
            bl2 = Boolean.parseBoolean(this.getProperty(string, String.valueOf(bl)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }
}

