/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.akamai.android.sdk.net.AkaCryptoHandler;
import com.akamai.android.sdk.util.AnaUtils;
import javax.crypto.Cipher;

final class SecurePreferenceReadHandler {
    private final SharedPreferences mSharedPreferences;
    private final AkaCryptoHandler mCryptoHandler;

    SecurePreferenceReadHandler(Context context) {
        this.mSharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        this.mCryptoHandler = new AkaCryptoHandler(context.getApplicationContext());
    }

    String getString(String string, String string2) throws Exception {
        String string3 = this.mSharedPreferences.getString(this.encrypt(string.getBytes()), string2);
        if (!string3.equals(string2)) {
            string3 = this.decrypt(string3);
            string3 = this.stripSalt(string3);
        }
        return string3;
    }

    boolean getBoolean(String string, boolean bl2) throws Exception {
        return Boolean.parseBoolean(this.getString(string, Boolean.toString(bl2)));
    }

    boolean containsKey(String string) throws Exception {
        return this.mSharedPreferences.contains(this.encrypt(string.getBytes()));
    }

    private String stripSalt(String string) {
        return string.split("&")[1];
    }

    private String decrypt(String string) throws Exception {
        byte[] byArray = Base64.decode((byte[])string.getBytes(), (int)2);
        Cipher cipher = this.mCryptoHandler.getCipher(2);
        byArray = cipher.doFinal(byArray);
        return new String(byArray);
    }

    private String encrypt(byte[] byArray) throws Exception {
        Cipher cipher = this.mCryptoHandler.getCipher(1);
        byte[] byArray2 = cipher.doFinal(byArray);
        return Base64.encodeToString((byte[])byArray2, (int)2);
    }
}

