/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaFirebaseHandler;
import com.akamai.android.sdk.internal.AkaInterceptorHandler;
import com.akamai.android.sdk.internal.AkaJsonObject;
import com.akamai.android.sdk.internal.AkaNetworkQualityHandler;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSegmentManifestParser;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaWebAnalyticsHandler;
import com.akamai.android.sdk.internal.AnaNotificationData;
import com.akamai.android.sdk.internal.AppBatteryTestConnection;
import com.akamai.android.sdk.internal.SecurePreferenceWriteHandler;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.CommonUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AkaConfigHandler {
    public static final long SIXTY_DAYS_IN_SECONDS = 5184000L;
    private static final String LOG_TAG = "AkaConfigHandler";
    private static final String HTTP_IF_MODIFIED_HEADER = "If-Modified-Since";
    private static final int HTTP_SUCCESS = 200;
    private static final int HTTP_NOT_MODIFIED = 304;
    private final Context mContext;
    private StringBuilder mConfigData;
    private boolean mWebAccelerationEnabled;
    private final SecurePreferenceWriteHandler mPreferenceWriteHandler;
    private final SharedPreferences.Editor mEditor;
    private boolean mIsAbMasterInAGroup;
    private boolean mIsAbTestingEnabled;
    private boolean mIsAbMasterEnabled;
    private boolean isSdkActiveChanged = false;
    private boolean isSdkHashChanged = false;
    private String mExistingLicenseHash;

    public AkaConfigHandler(@NonNull Context context) {
        this.mContext = context;
        this.mPreferenceWriteHandler = new SecurePreferenceWriteHandler(this.mContext);
        this.mEditor = AnaUtils.getSDKSharedPreferences(this.mContext).edit();
        this.mConfigData = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(JSONObject jSONObject) {
        try {
            this.updateConfiguration(jSONObject);
        }
        finally {
            if (this.isSdkActiveChanged) {
                VocAccelerator.getInstance().registerActivityLifecyleListener();
                VocAccelerator.getInstance().initializeFeedManager();
                VocAccelerator.getInstance().setupInterceptor();
                boolean bl2 = false;
                boolean bl3 = false;
                bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("store_session", false);
                bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("log_analytics", false);
                if (!bl2) {
                    this.mContext.getContentResolver().delete(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, null, null);
                }
                if (!bl3) {
                    this.mContext.getContentResolver().delete(AnaProviderContract.USER_EVENTS_URI, null, null);
                    this.mContext.getContentResolver().delete(AnaProviderContract.EVENT_LOG_URI, null, null);
                    this.mContext.getContentResolver().delete(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, null, null);
                }
            }
            if (this.isSdkHashChanged || this.isSdkActiveChanged) {
                AkaFirebaseHandler.subscribeToFCMTopic(this.mExistingLicenseHash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getConfig() throws JSONException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        HttpsURLConnection httpsURLConnection = null;
        try {
            URL uRL = new URL(AkaSessionHandler.getConfigUrl(this.mContext));
            httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            if (httpsURLConnection != null) {
                int n2;
                httpsURLConnection.setDoInput(true);
                httpsURLConnection.setRequestMethod("GET");
                if ("production".equals("dev")) {
                    httpsURLConnection = new AppBatteryTestConnection().updateHttpsURLConnection(this.mContext, httpsURLConnection, "map-configuration.default.abattery.appbattery.nss1.tn.akamai.com");
                } else if ("production".equals("mock")) {
                    httpsURLConnection = new AppBatteryTestConnection().updateHttpsURLConnection(this.mContext, httpsURLConnection, "127.0.0.1");
                }
                String string = AnaUtils.getSDKSharedPreferences(this.mContext).getString("config_ims_ts", "");
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    httpsURLConnection.setRequestProperty(HTTP_IF_MODIFIED_HEADER, string);
                }
                AkaHttpUtils.setControlPathHeaders(httpsURLConnection);
                inputStream = httpsURLConnection.getInputStream();
                if (inputStream == null) {
                    inputStream = httpsURLConnection.getErrorStream();
                }
                if ((n2 = httpsURLConnection.getResponseCode()) == 200) {
                    String string2;
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)"Got new config");
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    inputStreamReader = new InputStreamReader(bufferedInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2);
                    }
                    this.updateImsTimeStamp(httpsURLConnection);
                } else if (n2 == 304) {
                    Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, " config not modified"});
                } else {
                    Logger.e((String)"AkaSdkLogger-map", (String)(LOG_TAG + stringBuilder.toString()));
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaConfigHandler: getConfig with exception:" + exception));
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpsURLConnection != null) {
                httpsURLConnection.disconnect();
            }
        }
        return stringBuilder.toString().isEmpty() ? null : new JSONObject(stringBuilder.toString());
    }

    private void updateImsTimeStamp(HttpsURLConnection httpsURLConnection) {
        SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(this.mContext).edit();
        String string = httpsURLConnection.getHeaderField("Last-Modified");
        editor.putString("config_ims_ts", string);
        editor.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguration(JSONObject jSONObject) {
        Logger.dd((String)"AkaSdkLogger-map", (String)("AkaConfigHandler: Capabilities: " + jSONObject));
        AkaJsonObject akaJsonObject = new AkaJsonObject(jSONObject);
        this.mConfigData = new StringBuilder();
        try {
            boolean bl2;
            long l2 = AnaUtils.getSDKSharedPreferences(this.mContext).getLong("config_ts", 0L);
            JSONObject jSONObject2 = akaJsonObject.getJsonObject("timestamps", null);
            if (jSONObject2 != null) {
                long l3 = new AkaJsonObject(jSONObject2).getLong("modified", 0L);
                if (l3 == l2) {
                    return;
                }
                this.mEditor.putLong("config_ts", l3);
            }
            boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("kill_switch", false);
            if (this.updateMapKill(bl3 = akaJsonObject.getBoolean("map_kill", bl3))) {
                return;
            }
            String string = this.mContext.getPackageName();
            String string2 = akaJsonObject.getString("appId", "");
            boolean bl4 = true;
            if (!(TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string) || (bl4 = string2.equals(string)))) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaConfigHandler appId -" + string + " is different from configured one - " + string2));
            }
            this.mWebAccelerationEnabled = akaJsonObject.getBoolean("map_enabled", bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_web_acceleration", false)) && !bl3 && bl4;
            this.mPreferenceWriteHandler.putBoolean("enable_web_acceleration", this.mWebAccelerationEnabled);
            CommonUtils.append(this.mConfigData, "enableAcc", this.mWebAccelerationEnabled);
            this.isSdkActiveChanged = this.mWebAccelerationEnabled != bl2;
            if (this.updateDisable(!this.mWebAccelerationEnabled)) {
                return;
            }
            this.mExistingLicenseHash = VocAccelerator.getInstance().getSecurePreferenceString("license_hash", "");
            String string3 = akaJsonObject.getString("license_hash", this.mExistingLicenseHash);
            this.isSdkHashChanged = !string3.equals(this.mExistingLicenseHash);
            this.mPreferenceWriteHandler.putString("license_hash", string3);
            if (jSONObject.has("sdk_features") && !jSONObject.isNull("sdk_features")) {
                this.addSdkFeatures(jSONObject.getJSONObject("sdk_features"));
            }
            this.mEditor.putLong("idleDetectionTime", akaJsonObject.getLong("idleDetectionTime", 5184000L) * 1000L);
            this.mEditor.apply();
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaConfigHandler: Exception getting  configuration ", (Throwable)exception);
        }
        finally {
            AkaWebAnalyticsHandler.deleteOldStats(false, this.mContext);
            VocAccelerator.getInstance().clearCapabilities();
            this.mEditor.apply();
            AkaNetworkQualityHandler.getInstance(this.mContext).startDetection();
            VocAccelerator.getInstance().getMultiPathHandler().initPatterns();
            VocAccelerator.getInstance().addOrRemoveSigStrengthListener(true);
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaConfigHandler: updateConfig: " + this.mConfigData));
        }
    }

    private boolean updateMapKill(boolean bl2) throws Exception {
        if (bl2) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaConfigHandler SDK Killed");
            this.mPreferenceWriteHandler.putBoolean("kill_switch", bl2);
            this.mPreferenceWriteHandler.putBoolean("enable_web_acceleration", bl2);
            AkaFirebaseHandler.subscribeToFCMTopic(this.mExistingLicenseHash);
            AkaSessionHandler.signOut(this.mContext, null);
            return true;
        }
        return false;
    }

    private boolean updateDisable(boolean bl2) throws Exception {
        if (bl2) {
            this.mPreferenceWriteHandler.putBoolean("enable_web_acceleration", bl2);
            AkaFirebaseHandler.subscribeToFCMTopic(this.mExistingLicenseHash);
            AkaInterceptorHandler.removeData(this.mContext);
            AkaSegmentManifestDownloader.removeData(this.mContext);
            AkaBackgroundService.getInstance(this.mContext).clearCache();
            return true;
        }
        return false;
    }

    private void addSdkFeatures(JSONObject jSONObject) throws Exception {
        boolean bl2 = this.mIsAbMasterInAGroup = VocAccelerator.getInstance().getSecurePreferenceBoolean("use_master_ab", false);
        this.mIsAbTestingEnabled = true;
        this.mIsAbMasterEnabled = false;
        if (jSONObject != null) {
            JSONObject jSONObject2;
            if (jSONObject.has("ab_features") && (jSONObject2 = jSONObject.getJSONObject("ab_features")) != null) {
                if (jSONObject2.has("enabled")) {
                    this.mIsAbTestingEnabled = jSONObject2.getBoolean("enabled");
                    if (this.mIsAbTestingEnabled && jSONObject2.has("master_ab_enabled")) {
                        if (this.mIsAbTestingEnabled) {
                            this.mIsAbMasterEnabled = jSONObject2.getBoolean("master_ab_enabled");
                            this.mPreferenceWriteHandler.putBoolean("use_master_ab_server_flag", this.mIsAbTestingEnabled && this.mIsAbMasterEnabled);
                            if (this.mIsAbMasterEnabled && jSONObject2.has("master_ab_percent")) {
                                double d2 = jSONObject2.getDouble("master_ab_percent");
                                this.mIsAbMasterInAGroup = Math.random() * 100.0 < d2;
                            } else {
                                this.mIsAbMasterInAGroup = false;
                            }
                        } else {
                            this.mIsAbMasterInAGroup = true;
                        }
                        this.mPreferenceWriteHandler.putBoolean("use_master_ab", this.mIsAbMasterInAGroup);
                        CommonUtils.append(this.mConfigData, "mIsAbMasterInAGroup", this.mIsAbMasterInAGroup);
                    }
                }
                if (bl2 != this.mIsAbMasterInAGroup) {
                    Logger.d((String)"AkaSdkLogger-map", (String)("The SDK A/B group has been changed to" + (this.mIsAbMasterInAGroup ? " A " : " B ") + "group."));
                }
                this.addAbFeatures(jSONObject2);
            }
            this.addAnalyticsConfig(jSONObject);
        }
    }

    private void addAbFeatures(JSONObject jSONObject) throws Exception {
        Logger.d((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, jSONObject});
        if (jSONObject != null) {
            JSONObject jSONObject2;
            if (jSONObject.has("cache") && (jSONObject2 = jSONObject.getJSONObject("cache")) != null) {
                this.addCacheFeatures(jSONObject2);
            }
            this.addCongestionInfo(jSONObject);
            this.addMultipath(jSONObject);
            this.addFeature(jSONObject, "tcp_optimization", "transport_opt");
            this.addFeature(jSONObject, "quic", "use_quic");
            if (this.addFeature(jSONObject, "brotli", "use_brotli")) {
                VocAccelerator.getInstance().initCronetWithHints(true);
            }
            this.addFeature(jSONObject, "image_manager", "use_IM");
            this.addFeature(jSONObject, "aic", "use_aic");
        }
    }

    private void addAnalyticsConfig(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        if (jSONObject.has("analytics") && (jSONObject2 = jSONObject.getJSONObject("analytics")) != null) {
            boolean bl2;
            boolean bl3;
            VocAccelerator vocAccelerator = VocAccelerator.getInstance();
            if (jSONObject2.has("enabled")) {
                bl3 = jSONObject2.getBoolean("enabled");
                this.mPreferenceWriteHandler.putBoolean("log_analytics", bl3);
                CommonUtils.append(this.mConfigData, "logAnalytics", bl3);
            } else {
                bl3 = vocAccelerator.getSecurePreferenceBoolean("log_analytics", false);
            }
            if (jSONObject2.has("ignore_query_string")) {
                bl2 = jSONObject2.getBoolean("ignore_query_string");
                CommonUtils.append(this.mConfigData, "ignoreQueryString", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("ignore_query", false);
            }
            this.mPreferenceWriteHandler.putBoolean("ignore_query", bl2 && bl3);
            if (jSONObject2.has("capture_location")) {
                bl2 = jSONObject2.getBoolean("capture_location");
                CommonUtils.append(this.mConfigData, "CaptureLocation", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("get_location", false);
            }
            this.mPreferenceWriteHandler.putBoolean("get_location", bl2 && bl3);
            if (jSONObject2.has("capture_carrier_name")) {
                bl2 = jSONObject2.getBoolean("capture_carrier_name");
                CommonUtils.append(this.mConfigData, "CaptureCarrier", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("get_carrier", false);
            }
            this.mPreferenceWriteHandler.putBoolean("get_carrier", bl2 && bl3);
            if (jSONObject2.has("capture_session_length")) {
                bl2 = jSONObject2.getBoolean("capture_session_length");
                CommonUtils.append(this.mConfigData, "CaptureSessionLength", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("store_session", false);
            }
            this.mPreferenceWriteHandler.putBoolean("store_session", bl2 && bl3);
            if (jSONObject2.has("upload_when_out_of_policy")) {
                bl2 = jSONObject2.getBoolean("upload_when_out_of_policy");
                CommonUtils.append(this.mConfigData, "uploadOutOfPolicy", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("upload_analytics_oop", false);
            }
            this.mPreferenceWriteHandler.putBoolean("upload_analytics_oop", bl2 && bl3);
            if (jSONObject2.has("debug_percent")) {
                bl2 = this.isEnableGroupByPercent(jSONObject2.getDouble("debug_percent"));
                CommonUtils.append(this.mConfigData, "debugPercent", bl2);
            } else {
                bl2 = vocAccelerator.getSecurePreferenceBoolean("debug_logs", false);
            }
            this.mPreferenceWriteHandler.putBoolean("debug_logs", bl2 && bl3);
            if (jSONObject2.has("upload_threshold")) {
                this.mEditor.putInt("upload_threshold", jSONObject2.getInt("upload_threshold"));
            }
            if (jSONObject2.has("capture_signal_strength")) {
                this.mEditor.putBoolean("get_sigstrength", jSONObject2.getBoolean("capture_signal_strength"));
            }
            if (jSONObject2.has("upload_url")) {
                this.mEditor.putString("upload_url", jSONObject2.getString("upload_url"));
            }
        }
    }

    private void addCongestionInfo(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        if (jSONObject.has("network_quality") && (jSONObject2 = jSONObject.getJSONObject("network_quality")) != null) {
            int n2;
            int n3;
            int n4;
            String string;
            String string2;
            if (jSONObject2.has("enabled")) {
                boolean bl2 = jSONObject2.getBoolean("enabled");
                if (bl2 && jSONObject2.has("ab_percent")) {
                    bl2 = this.isEnableGroup(jSONObject2.getDouble("ab_percent"));
                }
                this.mPreferenceWriteHandler.putBoolean("congestion_control", bl2);
                CommonUtils.append(this.mConfigData, "networkQualityDetection", bl2);
                if (!bl2) {
                    AkaNetworkQualityHandler akaNetworkQualityHandler = AkaNetworkQualityHandler.getInstance(this.mContext);
                    akaNetworkQualityHandler.reset();
                }
            }
            if (jSONObject2.has("method") && !TextUtils.isEmpty((CharSequence)(string2 = jSONObject2.getString("method")))) {
                this.mEditor.putString("network_quality_method", string2);
                CommonUtils.append(this.mConfigData, "congMethod", string2);
            }
            if (jSONObject2.has("url") && !TextUtils.isEmpty((CharSequence)(string = jSONObject2.getString("url")))) {
                if (string.startsWith("http://")) {
                    string = string.replaceFirst("http://", "");
                } else if (string.startsWith("https://")) {
                    string = string.replaceFirst("https://", "");
                }
                this.mEditor.putString("network_quality_uri", string);
                CommonUtils.append(this.mConfigData, "congUri", string);
            }
            if (jSONObject2.has("ping_count") && (n4 = jSONObject2.getInt("ping_count")) > 0) {
                this.mEditor.putInt("network_quality_ping_count", n4);
            }
            if (jSONObject2.has("ping_frequency") && (n3 = jSONObject2.getInt("ping_frequency")) > 0) {
                this.mEditor.putInt("network_quality_ping_frequency", n3);
            }
            if (jSONObject2.has("cycle_frequency") && (n2 = jSONObject2.getInt("cycle_frequency")) > 0) {
                this.mEditor.putInt("network_quality_frequency", n2);
            }
            if (jSONObject2.has("radios")) {
                JSONArray jSONArray = jSONObject2.getJSONArray("radios");
                this.storeCongestionThresholds(jSONArray);
                CommonUtils.append(this.mConfigData, "Congestion Threshold", jSONArray);
            }
        }
    }

    private void storeCongestionThresholds(JSONArray jSONArray) throws JSONException {
        if (jSONArray != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            block10: for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                String string = jSONObject.getString("type");
                n3 = jSONObject.getInt("high_threshold") * 1000;
                n2 = jSONObject.getInt("low_threshold") * 1000;
                if (jSONObject.has("response_timeout")) {
                    n4 = jSONObject.getInt("response_timeout");
                }
                if (n2 <= 0 || n3 <= 0) continue;
                if (string.equals("2G")) {
                    this.mEditor.putLong("cong_edge_low_threshold", (long)n2);
                    this.mEditor.putLong("cong_edge_high_threshold", (long)n3);
                    if (n4 > 0) {
                        this.mEditor.putInt("network_quality_2g_timeout", n4);
                    }
                }
                switch (string) {
                    case "3G": {
                        this.mEditor.putLong("cong_3g_low_threshold", (long)n2);
                        this.mEditor.putLong("cong_3g_high_threshold", (long)n3);
                        if (n4 <= 0) continue block10;
                        this.mEditor.putInt("network_quality_3g_timeout", n4);
                        continue block10;
                    }
                    case "3.5G": {
                        this.mEditor.putLong("cong_hspa_low_threshold", (long)n2);
                        this.mEditor.putLong("cong_hspa_high_threshold", (long)n3);
                        if (n4 <= 0) continue block10;
                        this.mEditor.putInt("network_quality_3_5g_timeout", n4);
                        continue block10;
                    }
                    case "4G": {
                        this.mEditor.putLong("cong_lte_low_threshold", (long)n2);
                        this.mEditor.putLong("cong_lte_high_threshold", (long)n3);
                        if (n4 <= 0) continue block10;
                        this.mEditor.putInt("network_quality_4g_timeout", n4);
                    }
                }
            }
        }
    }

    private boolean addFeature(JSONObject jSONObject, String string, String string2) {
        boolean bl2;
        boolean bl3 = bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean(string2, false);
        try {
            JSONObject jSONObject2;
            if (jSONObject.has(string) && !jSONObject.isNull(string) && (jSONObject2 = jSONObject.getJSONObject(string)) != null && jSONObject2.has("enabled") && (bl3 = jSONObject2.getBoolean("enabled")) && jSONObject2.has("ab_percent")) {
                bl3 = this.isEnableGroup(jSONObject2.getDouble("ab_percent"));
            }
            Logger.d((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, " Settings key is " + string2 + " and useFeature is: " + bl3});
            this.mPreferenceWriteHandler.putBoolean(string2, bl3);
            CommonUtils.append(this.mConfigData, string, bl3 && this.mWebAccelerationEnabled);
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("addFeature " + string + " resulted in an exception:" + exception.getMessage()));
        }
        return bl2 != bl3;
    }

    private void addMultipath(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("use_multipath", false);
        if (jSONObject.has("sr4c") && (jSONObject2 = jSONObject.getJSONObject("sr4c")) != null) {
            int n2;
            int n3;
            String string;
            if (jSONObject2.has("enabled")) {
                bl2 = jSONObject2.getBoolean("enabled");
                CommonUtils.append(this.mConfigData, "useMultipath", bl2);
                if (bl2 && jSONObject2.has("ab_percent")) {
                    bl2 = this.isEnableGroup(jSONObject2.getDouble("ab_percent"));
                }
            }
            if (jSONObject2.has("second_dns") && !TextUtils.isEmpty((CharSequence)(string = jSONObject2.getString("second_dns")))) {
                this.mEditor.putString("dns", string);
            }
            if (jSONObject2.has("max_content_length") && (n3 = jSONObject2.getInt("max_content_length")) > 0) {
                this.mEditor.putInt("maxContentLen", n3);
            }
            if (jSONObject2.has("stickiness_interval") && (n2 = jSONObject2.getInt("stickiness_interval")) >= 0) {
                this.mEditor.putInt("stickyTime", n2);
                CommonUtils.append(this.mConfigData, "stick_to_winner(sec)", n2);
            }
            if (jSONObject2.has("urls")) {
                string = jSONObject2.getJSONArray("urls");
                CommonUtils.append(this.mConfigData, "urlList", string);
                if (string != null && string.length() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        String string2 = string.getString(i2);
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        try {
                            String string3;
                            int n4;
                            int n5;
                            if (!string2.startsWith("http://") && !string2.startsWith("https://") || (n5 = string2.indexOf("//")) == -1 || (n4 = string2.indexOf("/", n5 + 2)) == -1 || TextUtils.isEmpty((CharSequence)(string3 = string2.substring(n5 + 2, n4)))) continue;
                            arrayList.add("^" + (String)string2);
                            continue;
                        }
                        catch (Exception exception) {
                            Logger.e((String)"AkaSdkLogger-map", (String)("AkaConfigHandler: Url list: " + (String)string2 + ", ex=" + exception));
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        JSONArray jSONArray = new JSONArray();
                        for (String string4 : arrayList) {
                            jSONArray.put((Object)string4);
                        }
                        this.mEditor.putString("url_list", jSONArray.toString());
                    }
                }
            }
        }
        this.mPreferenceWriteHandler.putBoolean("use_multipath", bl2 && this.mWebAccelerationEnabled);
    }

    private void addCacheFeatures(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray;
        Object object;
        JSONObject jSONObject2;
        Object object2;
        if (jSONObject.has("policy") && (object2 = jSONObject.getJSONObject("policy")) != null) {
            if (object2.has("wifi_download_limit") && object2.has("cellular_download_limit")) {
                this.mEditor.putLong("daily_wifi_quota", object2.getLong("wifi_download_limit"));
                this.mEditor.putLong("daily_cellular_quota", object2.getLong("cellular_download_limit"));
                CommonUtils.append(this.mConfigData, "dailyWifiQuota", object2.getLong("wifi_download_limit"));
                CommonUtils.append(this.mConfigData, "dailyCellQuota", object2.getLong("cellular_download_limit"));
                this.mEditor.putBoolean("use_new_quota_values", true);
            }
            if (object2.has("download_times")) {
                CommonUtils.append(this.mConfigData, "timeOfDayPolicy", this.storeTodPolicy(object2.getString("download_times")));
            }
            if (object2.has("network_selection")) {
                this.storeNetworkSelection(object2.getString("network_selection"));
            }
        }
        object2 = new AkaSegmentHandler();
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", false);
        if (jSONObject.has("preposition") && (jSONObject2 = jSONObject.getJSONObject("preposition")) != null && jSONObject2.has("enabled")) {
            bl2 = jSONObject2.getBoolean("enabled");
            if (bl2 && jSONObject2.has("ab_percent")) {
                bl2 = this.isEnableGroup(jSONObject2.getDouble("ab_percent"));
            }
            if (bl2) {
                ((AkaSegmentHandler)object2).addSegments(jSONObject2, false);
            } else {
                ((AkaSegmentHandler)object2).removeSegments(this.mContext, false);
            }
        }
        this.mPreferenceWriteHandler.putBoolean("preposition", bl2);
        CommonUtils.append(this.mConfigData, "prepositionCache", bl2);
        boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("universal_cache", false);
        if (jSONObject.has("universal") && (object = jSONObject.getJSONObject("universal")) != null) {
            if (object.has("enabled") && (bl3 = object.getBoolean("enabled")) && object.has("ab_percent")) {
                bl3 = this.isEnableGroup(object.getDouble("ab_percent"));
            }
            if (object.has("purge_timestamp")) {
                AkaCacheHandler.invalidateUCContent(this.mContext, object.getLong("purge_timestamp"));
            }
            if (object.has("purge_list") && !object.isNull("purge_list")) {
                jSONArray = object.getJSONArray("purge_list");
                VocAccelerator.getInstance().submitTask(new PurgeRunnable(jSONArray));
                CommonUtils.append(this.mConfigData, "Purge Url List", jSONArray);
            }
        }
        this.mPreferenceWriteHandler.putBoolean("universal_cache", bl3);
        if (!bl3) {
            Logger.d((String)"AkaSdkLogger-map", (String)"AkaConfigHandler: Universal cache disabled, purge UC items");
            object = new ArrayList(1);
            ((ArrayList)object).add("sdk");
            AkaCacheHandler.purgeUniversalCache("providerPurge", (ArrayList<String>)object, this.mContext);
        }
        CommonUtils.append(this.mConfigData, "universalCache", bl3);
        boolean bl4 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
        if (jSONObject.has("precache") && (jSONArray = jSONObject.getJSONObject("precache")) != null && jSONArray.has("enabled")) {
            bl4 = jSONArray.getBoolean("enabled");
            if (bl4 && jSONArray.has("ab_percent")) {
                bl4 = this.isEnableGroup(jSONArray.getDouble("ab_percent"));
            }
            if (bl4) {
                ((AkaSegmentHandler)object2).addSegments((JSONObject)jSONArray, true);
            } else {
                ((AkaSegmentHandler)object2).removeSegments(this.mContext, true);
            }
        }
        this.mPreferenceWriteHandler.putBoolean("enable_fgsegments", bl4);
        CommonUtils.append(this.mConfigData, "precaching", bl4);
    }

    private boolean isEnableGroup(double d2) {
        if (!this.mIsAbTestingEnabled) {
            return true;
        }
        if (this.mIsAbMasterEnabled) {
            return this.mIsAbMasterInAGroup;
        }
        return this.isEnableGroupByPercent(d2);
    }

    private boolean isEnableGroupByPercent(double d2) {
        return Math.random() * 100.0 < d2;
    }

    private void storeNetworkSelection(String string) {
        switch (string) {
            case "WIFI_AND_CELLULAR": {
                this.mEditor.putString("network_preference", String.valueOf(2));
                break;
            }
            case "WIFI_ONLY": {
                this.mEditor.putString("network_preference", String.valueOf(1));
                break;
            }
            case "CELLULAR_ONLY": {
                this.mEditor.putString("network_preference", String.valueOf(6));
                break;
            }
            default: {
                this.mEditor.putString("network_preference", String.valueOf(1));
            }
        }
        CommonUtils.append(this.mConfigData, "networkSelection", string);
    }

    private String storeTodPolicy(String string) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (string != null && !string.isEmpty()) {
            string = string.replace(" ", "");
            editor.putString("tod_policy", string);
        }
        editor.apply();
        return string;
    }

    private static void clearCapabilities(Context context) {
        SecurePreferenceWriteHandler securePreferenceWriteHandler = new SecurePreferenceWriteHandler(context);
        try {
            securePreferenceWriteHandler.remove("congestion_control");
            securePreferenceWriteHandler.remove("enable_web_acceleration");
            securePreferenceWriteHandler.remove("log_analytics");
            securePreferenceWriteHandler.remove("ignore_query");
            securePreferenceWriteHandler.remove("get_location");
            securePreferenceWriteHandler.remove("get_carrier");
            securePreferenceWriteHandler.remove("store_session");
            securePreferenceWriteHandler.remove("preposition");
            securePreferenceWriteHandler.remove("enable_fgsegments");
            securePreferenceWriteHandler.remove("universal_cache");
            securePreferenceWriteHandler.remove("use_multipath");
            securePreferenceWriteHandler.remove("transport_opt");
            securePreferenceWriteHandler.remove("use_quic");
            securePreferenceWriteHandler.remove("use_aic");
            securePreferenceWriteHandler.remove("debug_logs");
            securePreferenceWriteHandler.remove("use_brotli");
            securePreferenceWriteHandler.remove("use_IM");
            securePreferenceWriteHandler.remove("use_master_ab");
            securePreferenceWriteHandler.remove("network_quality_method");
            securePreferenceWriteHandler.remove("network_quality_uri");
            securePreferenceWriteHandler.remove("network_quality_ping_count");
            securePreferenceWriteHandler.remove("network_quality_ping_frequency");
            securePreferenceWriteHandler.remove("network_quality_duration");
            securePreferenceWriteHandler.remove("network_quality_frequency");
            securePreferenceWriteHandler.remove("dns");
            securePreferenceWriteHandler.remove("maxContentLen");
            securePreferenceWriteHandler.remove("stickyTime");
            securePreferenceWriteHandler.remove("url_list");
            securePreferenceWriteHandler.remove("upload_analytics_oop");
            securePreferenceWriteHandler.remove("upload_threshold");
            VocAccelerator.getInstance().clearCapabilities();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void removeData(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        AkaConfigHandler.clearCapabilities(context);
        editor.remove("daily_wifi_quota");
        editor.remove("daily_quota_usage_wifi");
        editor.remove("daily_cellular_quota");
        editor.remove("daily_quota_usage_cellular");
        editor.remove("com.akamai.anaina.FULL_SYNC");
        editor.remove("daily_quota_ts");
        AkaConfigHandler.delPrefForclearCache(editor);
        editor.apply();
    }

    public static void delPrefForclearCache(SharedPreferences.Editor editor) {
        editor.remove("config_ts");
    }

    public static boolean isConfigSyncAllowed(Context context, String string) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        long l2 = 0L;
        long l3 = sharedPreferences.getLong("config_ts", 0L);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)"Checking config timestamp in notification");
            AnaNotificationData anaNotificationData = new AnaNotificationData(string);
            l2 = anaNotificationData.getConfigTimeStamp();
            return l2 > 0L && l2 != l3;
        }
        return true;
    }

    private static void resetSegments(Context context, String string, String[] stringArray) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("httpts", "");
        contentValues.put("downloadManifestTS", Long.valueOf(0L));
        contentValues.put("timestamp", Long.valueOf(0L));
        context.getContentResolver().update(AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION, contentValues, string, stringArray);
    }

    class PurgeRunnable
    implements Runnable {
        final JSONArray mPurgeList;

        PurgeRunnable(JSONArray jSONArray) {
            this.mPurgeList = jSONArray;
        }

        @Override
        public void run() {
            AkaCacheHandler.purgeCachedContentByUrl(AkaConfigHandler.this.mContext, this.mPurgeList);
        }
    }

    private class AkaSegmentHandler {
        private AkaSegmentHandler() {
        }

        private void addSegments(JSONObject jSONObject, boolean bl2) {
            Object object;
            Object object2;
            Object object3;
            int n2 = bl2 ? 1 : 0;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Cursor cursor = AkaConfigHandler.this.mContext.getApplicationContext().getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), null, "fgSegment=" + n2, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        object3 = new AkaSegmentManifestDownloader.SegmentInfo(cursor);
                        hashMap.put(((AkaSegmentManifestDownloader.SegmentInfo)object3).mLongName, object3);
                        cursor.moveToNext();
                    }
                }
                cursor.close();
            }
            object3 = new ArrayList<String>();
            if (jSONObject != null && jSONObject.has("segments") && !jSONObject.isNull("segments")) {
                try {
                    boolean bl3 = bl2;
                    JSONArray jSONArray = jSONObject.getJSONArray("segments");
                    Set<String> object4 = AkaSessionHandler.getSegments(AkaConfigHandler.this.mContext);
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        object2 = jSONArray.getJSONObject(i2);
                        if (!object2.has("name") || TextUtils.isEmpty((CharSequence)(object = object2.getString("name")))) continue;
                        object = ((String)object).trim();
                        if (!bl2 && !object4.isEmpty()) {
                            bl3 = object4.contains(object);
                        }
                        long l2 = object2.getLong("timestamp");
                        object3.add(object);
                        ContentValues contentValues = new ContentValues();
                        if (hashMap.containsKey(object)) {
                            contentValues.put("fgSegment", Integer.valueOf(bl2 ? 1 : 0));
                            contentValues.put("timestamp", Long.valueOf(l2));
                            contentValues.put("subscribed", Integer.valueOf(bl3 ? 1 : 0));
                            contentValues.put("downloadManifestTS", Integer.valueOf(0));
                            AkaConfigHandler.this.mContext.getContentResolver().update(AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION, contentValues, "sgmntlname=?", new String[]{object});
                            hashMap.remove(object);
                            CommonUtils.append(AkaConfigHandler.this.mConfigData, "FGSegmentSubscribed", object);
                            continue;
                        }
                        contentValues.put("sgmntlname", (String)object);
                        contentValues.put("sgmntsname", (String)object);
                        contentValues.put("subscribed", Integer.valueOf(bl3 ? 1 : 0));
                        contentValues.put("downloadManifestTS", Integer.valueOf(0));
                        contentValues.put("timestamp", Long.valueOf(l2));
                        contentValues.put("fgSegment", Integer.valueOf(bl2 ? 1 : 0));
                        AkaConfigHandler.this.mContext.getApplicationContext().getContentResolver().insert(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), contentValues);
                        CommonUtils.append(AkaConfigHandler.this.mConfigData, "FGSegmentSubscribed", object);
                    }
                }
                catch (Exception exception) {
                    Logger.dd((String)"AkaSdkLogger-map", (String)("AkaConfigHandler: " + exception.toString()));
                }
            }
            if (bl2) {
                AkaSessionHandler.setFgSegments(object3);
            }
            if (!hashMap.isEmpty()) {
                String string = VocUtils.getDataPath(AkaConfigHandler.this.mContext);
                for (Map.Entry entry : hashMap.entrySet()) {
                    Logger.dd((String)"AkaSdkLogger-map", (String)("Deleting segment: " + (String)entry.getKey()));
                    AkaSegmentManifestParser.deleteUrlsAssociatedWithSegment((String)entry.getKey(), AkaConfigHandler.this.mContext);
                    String string2 = "sgmntlname=?  AND subscribed=?";
                    if (((AkaSegmentManifestDownloader.SegmentInfo)entry.getValue()).mIsSubscribed) {
                        AkaConfigHandler.resetSegments(AkaConfigHandler.this.mContext, string2, new String[]{(String)entry.getKey(), "1"});
                    } else {
                        AkaConfigHandler.this.mContext.getApplicationContext().getContentResolver().delete(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), string2, new String[]{(String)entry.getKey(), "0"});
                    }
                    try {
                        object2 = new File(string + ((AkaSegmentManifestDownloader.SegmentInfo)entry.getValue()).mLongName + ".json");
                        if (((File)object2).exists()) {
                            ((File)object2).delete();
                        }
                        if (!((File)(object = new File(string + ((AkaSegmentManifestDownloader.SegmentInfo)entry.getValue()).mLongName + ".json.old"))).exists()) continue;
                        ((File)object).delete();
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)("AkaConfigHandler addSegments: " + exception.toString()));
                    }
                }
            }
        }

        private void removeSegments(Context context, boolean bl2) {
            Object object;
            Logger.dd((String)"AkaSdkLogger-map", (String)("Unsubscribing all segments of " + (bl2 ? "precache" : "preposition")));
            int n2 = bl2 ? 1 : 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            Cursor cursor = context.getApplicationContext().getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), null, "fgSegment=?", new String[]{String.valueOf(n2)}, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        object = new AkaSegmentManifestDownloader.SegmentInfo(cursor);
                        arrayList.add(((AkaSegmentManifestDownloader.SegmentInfo)object).mLongName);
                        cursor.moveToNext();
                    }
                }
                cursor.close();
            }
            if (!arrayList.isEmpty()) {
                object = VocUtils.getDataPath(context);
                for (String string : arrayList) {
                    Logger.dd((String)"AkaSdkLogger-map", (String)("Deleting segment: " + string));
                    AkaSegmentManifestParser.deleteUrlsAssociatedWithSegment(string, context);
                    try {
                        File file;
                        File file2 = new File((String)object + string + ".json");
                        if (file2.exists()) {
                            file2.delete();
                        }
                        if (!(file = new File((String)object + string + ".json.old")).exists()) continue;
                        file.delete();
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)("AkaConfigHandler removeSegments: " + exception.toString()));
                    }
                }
                context.getApplicationContext().getContentResolver().delete(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), "fgSegment=? AND subscribed=?", new String[]{String.valueOf(n2), "0"});
                AkaConfigHandler.resetSegments(context, null, null);
            }
        }
    }
}

