/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;

public class AnaDiskUtils {
    public static final String LOG_TAG = AnaDiskUtils.class.getSimpleName();
    private static final int BUFFER_SIZE = 4096;
    private static float sUsedMemory = 0.0f;

    public static float totalMemory(String string) {
        float f2 = 0.0f;
        try {
            File file = new File(string);
            if (file.exists()) {
                StatFs statFs = new StatFs(string);
                f2 = (float)statFs.getBlockCount() * (float)statFs.getBlockSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f2;
    }

    public static float freeMemory(String string) {
        if (string == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        try {
            File file = new File(string);
            if (file.exists()) {
                StatFs statFs = new StatFs(string);
                f2 = (float)statFs.getAvailableBlocks() * (float)statFs.getBlockSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f2;
    }

    public static float usedMemory(String string) {
        return AnaDiskUtils.usedMemory(string, false);
    }

    public static float usedMemory(String string, boolean bl2) {
        if (sUsedMemory > 0.0f && !bl2) {
            return sUsedMemory;
        }
        float f2 = 0.0f;
        try {
            f2 = AnaDiskUtils.updateUsedMem(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f2;
    }

    private static float updateUsedMem(String string) {
        float f2 = 0.0f;
        try {
            File[] fileArray;
            File file = new File(string);
            if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    f2 += (float)fileArray[i2].length();
                }
                sUsedMemory = f2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f2;
    }

    public static synchronized void addToUsedMemory(float f2) {
        sUsedMemory += f2;
    }

    public static synchronized void forceRecalculateMemorySize(Context context) {
        try {
            sUsedMemory = 0.0f;
            String string = VocUtils.getMediaPath(context, null);
            AnaDiskUtils.updateUsedMem(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getRemovableStoragePath(Context context, boolean bl2) {
        File[] fileArray;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string = sharedPreferences.getString("sdcardAvailable", "");
        File file = Environment.getExternalStorageDirectory();
        String string2 = "/Android/data/" + context.getPackageName() + "/files";
        String string3 = file.getAbsolutePath() + string2;
        if (Build.VERSION.SDK_INT < 19) {
            HashSet<String> hashSet = AnaDiskUtils.getExternalMounts();
            hashSet.remove(file.getAbsolutePath());
            if (hashSet.isEmpty()) {
                return null;
            }
            String string4 = hashSet.iterator().next();
            String string5 = string4 + string2;
            String string6 = string5 = !string5.endsWith("/") ? string5 + "/" : string5;
            if (!string5.equals(string)) {
                sharedPreferences.edit().putString("sdcardAvailable", string5).apply();
            }
            return bl2 ? string4 : string5;
        }
        for (File file2 : fileArray = context.getExternalFilesDirs(null)) {
            String string7;
            if (file2 == null || file2.equals(new File(string3))) continue;
            String string8 = file2.getAbsolutePath();
            String string9 = string8 = !string8.endsWith("/") ? string8 + "/" : string8;
            if (!string8.equals(string)) {
                sharedPreferences.edit().putString("sdcardAvailable", string8).apply();
            }
            String string10 = string7 = bl2 ? file2.getAbsolutePath() : file2.getAbsolutePath().replace(string2, "");
            if (string7.endsWith("/")) continue;
            return string7 + "/";
        }
        return null;
    }

    public static String getInternalStoragePath(Context context) {
        return AnaDiskUtils.getInternalStoragePath(context, false);
    }

    public static String getInternalStoragePath(Context context, Boolean bl2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        Boolean bl3 = sharedPreferences.getBoolean("encryption_enabled", true);
        if (!bl3.booleanValue() && !bl2.booleanValue()) {
            String string = context.getFilesDir().getAbsolutePath();
            return string.endsWith("/") ? string : string + "/";
        }
        String string = context.getPackageName();
        return Environment.getExternalStorageDirectory() + "/Android/data/" + string + "/files/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<String> getExternalMounts() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        String string = "(?i).*vold.*(vfat|ntfs|exfat|fat32|ext3|ext4).*rw.*";
        String string2 = "";
        try {
            object = new ProcessBuilder(new String[0]).command("mount").redirectErrorStream(true).start();
            ((Process)object).waitFor();
            try (InputStream inputStream = ((Process)object).getInputStream();){
                byte[] byArray = new byte[4096];
                while (inputStream.read(byArray) != -1) {
                    string2 = string2 + new String(byArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (String string3 : object = string2.split("\n")) {
            String[] stringArray;
            if (string3.toLowerCase(Locale.US).contains("asec") || !string3.matches(string)) continue;
            for (String string4 : stringArray = string3.split(" ")) {
                if (!string4.startsWith("/") || string4.toLowerCase(Locale.US).contains("vold")) continue;
                hashSet.add(string4);
            }
        }
        return hashSet;
    }

    public static boolean isCacheStorageAvailable(long l2, String string, Context context) {
        boolean bl2 = true;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        String string2 = AnaDiskUtils.getInternalStoragePath(context);
        AnaDiskUtils.getRemovableStoragePath(context, true);
        float f2 = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            f2 = AnaDiskUtils.usedMemory(string2, true);
        }
        float f3 = AnaDiskUtils.freeMemory(string);
        sharedPreferences.edit().putString("internalPathFreeSpace", string + "," + String.valueOf(f3) + "," + String.valueOf(f2)).apply();
        float f4 = Float.parseFloat(sharedPreferences.getString("prefetch_storage_limit", Integer.toString(3)));
        f4 *= 1048576.0f;
        if (f3 < 1.0f) {
            bl2 = false;
        }
        if ((float)l2 > AnaDiskUtils.freeMemory(string) || (float)l2 + f2 > f4) {
            bl2 = false;
        }
        return bl2;
    }
}

