/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.MapScope;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.File;
import java.util.HashSet;

public class AnaFeedController {
    private static final String LOG_TAG = "AnaFeedController";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearHttpsWebContent(Context context) {
        String string = "scope='" + MapScope.WEBCONTENT.name() + "' and " + "url" + " like 'https%'";
        Cursor cursor = null;
        try {
            cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, string, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("resourceready", Boolean.valueOf(false));
                contentValues.put("responseheaders", "");
                while (!cursor.isAfterLast()) {
                    AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                    String string2 = VocUtils.getMediaPath(context, null);
                    File file = new File(string2 + anaFeedItem.getThumbFileName());
                    File file2 = new File(string2 + anaFeedItem.getVideoFileName());
                    if (file.exists()) {
                        file.delete();
                    }
                    if (file2.exists()) {
                        file2.delete();
                    }
                    context.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + anaFeedItem.getId())), contentValues, null, null);
                    cursor.moveToNext();
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaFeedController: clearHttpsContent: ", (Throwable)exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int deleteFeed(Context context, String string, int n2) {
        AnaFeedItem anaFeedItem = AnaFeedController.getAnaFeedItemByUrl(context, string);
        int n3 = 0;
        if (anaFeedItem != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(anaFeedItem.getId());
            VocAccelerator.getInstance().onDelete(hashSet);
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", Integer.valueOf(2));
            contentValues.put("paused", Integer.valueOf(0));
            contentValues.put("resourceready", Integer.valueOf(0));
            String string2 = anaFeedItem.getId();
            context.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + anaFeedItem.getId())), contentValues, null, null);
            AnaFeedController.deleteFeedInFileSystem(context, anaFeedItem);
            n3 = context.getContentResolver().delete(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + anaFeedItem.getId())), null, null);
            contentValues.clear();
            contentValues.put("_id", string2);
            contentValues.put("timestamp", Long.valueOf(System.currentTimeMillis()));
            context.getContentResolver().insert(Uri.parse((String)AnaProviderContract.DELETED_FEEDS_URI.toString()), contentValues);
        }
        return n3;
    }

    public static void deleteFeedInFileSystem(Context context, AnaFeedItem anaFeedItem) {
        if (anaFeedItem == null) {
            return;
        }
        String string = AnaDiskUtils.getInternalStoragePath(context);
        File file = new File(string + anaFeedItem.getThumbFileName());
        File file2 = new File(string + anaFeedItem.getVideoFileName());
        if (file.exists()) {
            file.delete();
        }
        if (file2.exists()) {
            file2.delete();
        }
    }

    private static void deleteDirectory(File file) {
        File[] fileArray;
        Logger.d((String)"AkaSdkLogger-map", (String)("AnaFeedControllerdeleteDirectory: file = " + file.getAbsolutePath()));
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                AnaFeedController.deleteDirectory(file2);
            }
        }
        file.delete();
    }

    public static AnaFeedItem getAnaFeedItemByUrl(Context context, String string) {
        AnaFeedItem anaFeedItem = null;
        Cursor cursor = context.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, null, "url=?", new String[]{string}, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                anaFeedItem = new AnaFeedItem(cursor);
            }
            cursor.close();
        }
        return anaFeedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnaFeedItem getWebFeedItemByUrl(Context context, String string) {
        Cursor cursor = context.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, AnaProviderContract.WEBFEEDITEM_COLUMNS, "url=? and resourceready=?", new String[]{string, "1"}, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    AnaFeedItem anaFeedItem = AnaFeedController.createWebFeedItemFromCursor(cursor);
                    return anaFeedItem;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    private static AnaFeedItem createWebFeedItemFromCursor(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        AnaFeedItem anaFeedItem = new AnaFeedItem();
        anaFeedItem.setId(cursor.getString(0));
        anaFeedItem.setUrl(cursor.getString(1));
        anaFeedItem.setResourceReady(cursor.getInt(2) == 1);
        anaFeedItem.setRefreshTimeStamp(cursor.getLong(3));
        anaFeedItem.setMaxAge(cursor.getInt(4));
        anaFeedItem.setParentId(cursor.getString(5));
        anaFeedItem.setChildId(cursor.getString(6));
        anaFeedItem.setRespHeaders(cursor.getString(7));
        anaFeedItem.setPolicyId(cursor.getString(8));
        anaFeedItem.setVideoFileName(cursor.getString(9));
        anaFeedItem.setType(cursor.getString(10));
        anaFeedItem.setScope(MapScope.valueOf(cursor.getString(11)));
        anaFeedItem.setViewCount(cursor.getInt(12));
        anaFeedItem.setAccessTs(cursor.getLong(13));
        anaFeedItem.setSyncPending(cursor.getInt(14) == 1);
        anaFeedItem.setSegment(cursor.getString(15));
        anaFeedItem.setSize(cursor.getLong(16));
        anaFeedItem.setMustRevalidate(cursor.getInt(17) == 1);
        return anaFeedItem;
    }

    static AnaFeedItem createWebFeedItem(Context context, String string, String string2, long l2) {
        ContentValues contentValues = new ContentValues();
        String string3 = string;
        int n2 = string.lastIndexOf("imformat=chrome");
        if (n2 > 0) {
            string3 = string.substring(0, n2 - 1);
        }
        contentValues.put("_id", string2);
        contentValues.put("url", string3);
        contentValues.put("size", Long.valueOf(l2));
        contentValues.put("provider", "sdk");
        contentValues.put("title", "");
        contentValues.put("summary", "");
        contentValues.put("thumbfile", "");
        contentValues.put("duration", "0");
        contentValues.put("feedtype", "sdk/fg");
        contentValues.put("scope", MapScope.WEBCONTENT.name());
        contentValues.put("timestamp", Long.valueOf(AnaUtils.getCurrentUTCTimeInMillis()));
        contentValues.put("videofile", "file_" + string2);
        long l3 = AnaUtils.getCurrentUTCTimeInMillis() + 2592000000L;
        contentValues.put("expirydate", Long.valueOf(l3));
        contentValues.put("viewbookmark", Integer.valueOf(0));
        contentValues.put("viewcount", Integer.valueOf(0));
        contentValues.put("resourceready", Integer.valueOf(0));
        contentValues.put("hidden", Integer.valueOf(1));
        contentValues.put("shareurl", "");
        contentValues.put("categories", "");
        contentValues.put("tags", "");
        contentValues.put("priority", "10");
        contentValues.put("creationtimestamp", Long.valueOf(AnaUtils.getCurrentUTCTimeInMillis()));
        contentValues.put("syncPending", Integer.valueOf(1));
        try {
            context.getApplicationContext().getContentResolver().insert(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), contentValues);
        }
        catch (Exception exception) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AnaFeedController: createWebFeedItem, ex: " + exception));
        }
        return AnaFeedController.getAnaFeedItemByUrl(context, string);
    }
}

