/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaWebContentDownloader;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.AnaFeedController;
import com.akamai.android.sdk.internal.AnaResourceDownloadRunnable;
import com.akamai.android.sdk.internal.MapScope;
import com.akamai.android.sdk.internal.SecureWriter;
import com.akamai.android.sdk.model.AnaContentSource;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.AkaResponseHeaderParser;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AnaDownloadManager {
    private final Context mContext;
    private final Map<String, AnaContentSource> mContentSourceMap = new HashMap<String, AnaContentSource>();
    @SuppressLint(value={"StaticFieldLeak"})
    private static AnaDownloadManager sDownloadManager;
    private final HashSet<String> mFeedVisit = new HashSet();
    private final AnaDownloadPolicyManager mDownloadPolicyManager;
    private final Map<String, AnaResourceDownloadRunnable> mDownloadRunnables = new HashMap<String, AnaResourceDownloadRunnable>();
    private final ExecutorService mUniversalCacheHandler = Executors.newSingleThreadExecutor();
    private final long MIN_REFRESH_INTERVAL_IN_MS = TimeUnit.MINUTES.toMillis(15L);
    private boolean mSignOut = false;
    private static final String LOG_TAG = "DwnldMgr";
    private static final int THREAD_POOL_SIZE_WIFI = 3;

    private AnaDownloadManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mDownloadPolicyManager = new AnaDownloadPolicyManager(this.mContext);
        this.initContentSourceMap();
    }

    public static synchronized AnaDownloadManager getInstance(Context context) {
        if (sDownloadManager == null) {
            sDownloadManager = new AnaDownloadManager(context);
        }
        return sDownloadManager;
    }

    @NonNull
    public ExecutorService downloadGenericFeeds(@NonNull LinkedHashMap<String, AnaFeedItem> linkedHashMap) {
        ExecutorService executorService = this.isNetworkTypeWifi() ? Executors.newFixedThreadPool(3) : Executors.newSingleThreadExecutor();
        for (AnaFeedItem anaFeedItem : linkedHashMap.values()) {
            AnaResourceDownloadRunnable anaResourceDownloadRunnable = new AnaResourceDownloadRunnable(anaFeedItem, this.mDownloadPolicyManager, this.mContext, false, false);
            if (!this.addRunnable(anaFeedItem.getId(), anaResourceDownloadRunnable)) continue;
            executorService.submit(anaResourceDownloadRunnable);
        }
        executorService.shutdown();
        return executorService;
    }

    private boolean isNetworkTypeWifi() {
        String string = VocAccelerator.getInstance().getNetUtils().getNetworkType();
        return !TextUtils.isEmpty((CharSequence)string) && string.equals("wifi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFromInputStream(String string, InputStream inputStream, AkaResponseHeaderParser akaResponseHeaderParser, long l2) throws IOException {
        AnaFeedItem anaFeedItem;
        int n2;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        if (sharedPreferences.getBoolean("enablePolicyForegroundCaching", false) && (n2 = this.mDownloadPolicyManager.isDownloadPermitted()) != 0) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Universal caching: policy failure, skip reason: " + AnaDownloadPolicyManager.valueOf(n2)));
            return;
        }
        long l3 = System.currentTimeMillis();
        FilterOutputStream filterOutputStream = null;
        boolean bl2 = TextUtils.isEmpty((CharSequence)string);
        AnaFeedItem anaFeedItem2 = anaFeedItem = !bl2 ? AnaFeedController.getAnaFeedItemByUrl(this.mContext, string) : null;
        if (anaFeedItem == null) {
            anaFeedItem = AnaFeedController.createWebFeedItem(this.mContext, string, String.valueOf(System.currentTimeMillis()), l2);
        }
        try {
            if (anaFeedItem != null) {
                boolean bl3;
                String string2;
                boolean bl4;
                boolean bl5;
                boolean bl6 = bl5 = anaFeedItem.getScope() == MapScope.WEBCONTENT;
                if (anaFeedItem.isResourceReady()) {
                    if (bl5) {
                        long l4;
                        long l5 = l3 - anaFeedItem.getRefreshTimeStamp();
                        if (l5 < this.MIN_REFRESH_INTERVAL_IN_MS && l3 < (l4 = anaFeedItem.getRefreshTimeStamp() + TimeUnit.SECONDS.toMillis(AkaHttpUtils.getMaxAge(anaFeedItem, AnaUtils.getSDKSharedPreferences(this.mContext))))) {
                            Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Foreground caching: skip web content download within min refresh interval for id: " + anaFeedItem.getId()));
                            return;
                        }
                    } else {
                        Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Foreground caching: NON web content: already downloaded, skip id: " + anaFeedItem.getId()));
                        return;
                    }
                }
                if (!(bl4 = AnaDiskUtils.isCacheStorageAvailable(l2, string2 = AnaDiskUtils.getInternalStoragePath(this.mContext), this.mContext)) && !(bl3 = this.makeSpace(l2))) {
                    Set<String> set = AkaWebContentDownloader.removeExpiredContent(this.mContext);
                    Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Removed " + set.size() + " expired contents"));
                    if (AnaDiskUtils.isCacheStorageAvailable(l2, string2, this.mContext)) {
                        Logger.dd((String)"AkaSdkLogger-map", (String)"DwnldMgr: Space is available for further downloads");
                    } else {
                        Logger.dd((String)"AkaSdkLogger-map", (String)"DwnldMgr: Universal caching (MAP): No space, skip");
                    }
                    return;
                }
                if (this.addRunnable(anaFeedItem.getId(), null)) {
                    File file = new File(string2 + anaFeedItem.getVideoFileName());
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] byArray = new byte[(int)l2];
                    if (bl5 && string.startsWith("https")) {
                        SecureWriter secureWriter = new SecureWriter(this.mContext);
                        byte[] byArray2 = secureWriter.encryptContent(byArray);
                        filterOutputStream.write(byArray2);
                    } else {
                        filterOutputStream.write(byArray);
                    }
                    ((BufferedOutputStream)filterOutputStream).flush();
                    long l6 = System.currentTimeMillis() - l3;
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("resourceready", Boolean.valueOf(true));
                    long l7 = file.length();
                    long l8 = anaFeedItem.getSize();
                    if (l8 == 0L && l7 > 0L) {
                        contentValues.put("size", Long.valueOf(l7));
                    }
                    if (bl5) {
                        String string3 = akaResponseHeaderParser.getContentType();
                        if (!TextUtils.isEmpty((CharSequence)string3) && !string3.equals(anaFeedItem.getType())) {
                            contentValues.put("feedtype", string3);
                        }
                        contentValues.put("responseheaders", AkaHttpUtils.convertToStringHeaders(akaResponseHeaderParser.getBareHeaders()));
                        contentValues.put("maxage", Long.valueOf(akaResponseHeaderParser.getExpiry() / 1000L));
                        contentValues.put("refreshtimestamp", Long.valueOf(System.currentTimeMillis()));
                        contentValues.put("mustRevalidate", Integer.valueOf(akaResponseHeaderParser.mustRevalidate() ? 1 : 0));
                    }
                    this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + anaFeedItem.getId())), contentValues, null, null);
                    AnaDiskUtils.addToUsedMemory(file.length());
                } else {
                    Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Universal caching: already in queue skip id: " + anaFeedItem.getId()));
                }
            } else {
                Logger.dd((String)"AkaSdkLogger-map", (String)("DwnldMgr: Universal caching: feeditem null!, url: " + string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (anaFeedItem != null) {
                this.mDownloadRunnables.remove(anaFeedItem.getId());
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeSpace(long l2) {
        String string = AnaUtils.getEvictionStrategy(this.mContext).getSortOrder();
        try (Cursor cursor = null;){
            cursor = this.mContext.getApplicationContext().getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, null, "syncPending=? and resourceready=?", new String[]{String.valueOf(1), "1"}, string);
            if (cursor != null && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                    Logger.dd((String)("DwnldMgr: Universal cache: deleting id: " + anaFeedItem.getId() + ", url: " + anaFeedItem.getUrl()), (Object[])new Object[0]);
                    AnaFeedController.deleteFeed(this.mContext, anaFeedItem.getUrl(), 1);
                    String string2 = VocUtils.getMediaPath(this.mContext, anaFeedItem);
                    if (AnaDiskUtils.isCacheStorageAvailable(l2, string2, this.mContext)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    cursor.moveToNext();
                }
            }
        }
        return false;
    }

    public ExecutorService getUniversalCacheHandler() {
        return this.mUniversalCacheHandler;
    }

    private synchronized boolean addRunnable(String string, AnaResourceDownloadRunnable anaResourceDownloadRunnable) {
        if (!this.mDownloadRunnables.containsKey(string)) {
            this.mDownloadRunnables.put(string, anaResourceDownloadRunnable);
            return true;
        }
        return false;
    }

    public synchronized AnaResourceDownloadRunnable getRunnable(String string) {
        return this.mDownloadRunnables.get(string);
    }

    public synchronized boolean addFeed(String string) {
        return this.mFeedVisit.add(string);
    }

    public synchronized boolean containsFeed(String string) {
        return this.mFeedVisit.contains(string);
    }

    public synchronized boolean removeFeed(String string, boolean bl2) {
        this.mDownloadRunnables.remove(string);
        return this.mFeedVisit.remove(string);
    }

    public synchronized void clearFeeds() {
        this.mFeedVisit.clear();
        this.mDownloadRunnables.clear();
    }

    private void initContentSourceMap() {
        this.mContentSourceMap.clear();
        Cursor cursor = this.mContext.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_SOURCES.toString()), null, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AnaContentSource anaContentSource = new AnaContentSource(cursor);
                this.mContentSourceMap.put(anaContentSource.getId(), anaContentSource);
                cursor.moveToNext();
            }
            cursor.close();
        }
    }

    public void setSignOut(boolean bl2) {
        this.mSignOut = bl2;
    }

    public boolean isSignOut() {
        return this.mSignOut;
    }
}

