/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaConfigHandler;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSegmentManifestParser;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaStatusHelper;
import com.akamai.android.sdk.internal.AkaWebAnalyticsHandler;
import com.akamai.android.sdk.internal.AkaWebContentDownloader;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.ICacheSyncController;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class AkaSyncController
extends Worker
implements ICacheSyncController {
    public static final String LOG_TAG = "AkaSyncController";
    static final String NOTIFICATION = "Notification";
    static final String ALLOW_CONFIG_SYNC = "allowConfigSync";
    private Context mContext;
    private final AkaWebContentDownloader mWebContentDownloader;
    private final AkaSegmentManifestDownloader mSegmentManifestDownloader;
    private final AnaDownloadPolicyManager mDownloadPolicyManager;

    public AkaSyncController(@NonNull Context context, @NonNull WorkerParameters workerParameters) {
        super(context, workerParameters);
        this.mContext = context;
        this.mWebContentDownloader = new AkaWebContentDownloader(context);
        this.mSegmentManifestDownloader = AkaSegmentManifestDownloader.getInstance();
        this.mDownloadPolicyManager = new AnaDownloadPolicyManager(context);
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        String string = this.getInputData().getString(NOTIFICATION);
        boolean bl2 = this.getInputData().getBoolean(ALLOW_CONFIG_SYNC, false);
        try {
            if (!this.mDownloadPolicyManager.isNetworkAvailable()) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AkaSyncController: No network available");
                return ListenableWorker.Result.failure();
            }
            if (AkaConfigHandler.isConfigSyncAllowed(this.mContext, string) || bl2) {
                Logger.d((String)"AkaSdkLogger-map", (String)"AkaSyncController: Performing Full sync");
                this.fullSync();
            } else {
                Logger.d((String)"AkaSdkLogger-map", (String)"AkaSyncController: Performing Cache sync");
                this.cacheSync();
            }
            return ListenableWorker.Result.success();
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)LOG_TAG, (Throwable)exception);
            return ListenableWorker.Result.failure();
        }
    }

    private void fullSync() {
        AkaWebAnalyticsHandler.sendWebAnalytics(this.mContext);
        this.getConfig();
        this.cacheSync();
    }

    private void cacheSync() {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaSyncController: sync: SDK is not active");
            return;
        }
        int n2 = this.mDownloadPolicyManager.isDownloadPermitted();
        if (n2 == 0) {
            this.mContext.sendBroadcast(AkaStatusHelper.createCacheSyncStartIntent(this.mContext));
            this.updateCacheTime(System.currentTimeMillis());
            boolean bl2 = this.downloadMetadata();
            if (bl2) {
                this.parseManifestAndInsertToDb();
            }
            this.downloadWebContent();
            this.mContext.sendBroadcast(AkaStatusHelper.createCacheSyncDoneIntent(this.mContext));
        } else {
            Logger.dd((String)"AkaSdkLogger-map", (String)("AkaSyncController: fullSync, policy failure: " + AnaDownloadPolicyManager.valueOf(n2)));
        }
    }

    @Override
    public boolean downloadMetadata() {
        return this.mSegmentManifestDownloader.downloadMetaData();
    }

    @Override
    public void downloadWebContent() {
        this.mWebContentDownloader.downloadWebContent();
    }

    @Override
    public void parseManifestAndInsertToDb() {
        AkaSegmentManifestParser akaSegmentManifestParser = new AkaSegmentManifestParser(this.mContext);
        akaSegmentManifestParser.parseManifestAndInsertToDb();
    }

    @Override
    public void getConfig() {
        try {
            AkaConfigHandler akaConfigHandler = new AkaConfigHandler(this.mContext);
            JSONObject jSONObject = akaConfigHandler.getConfig();
            if (jSONObject != null) {
                akaConfigHandler.updateConfig(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void updateCacheTime(long l2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_cache_fill", l2);
        editor.apply();
    }
}

