/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import com.akamai.android.sdk.AkaMap;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.MapSdkInfo;
import com.akamai.android.sdk.VocService;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaConfigHandler;
import com.akamai.android.sdk.internal.AkaFirebaseHandler;
import com.akamai.android.sdk.internal.AkaInterceptorHandler;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.SecurePreferenceWriteHandler;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class AkaSessionHandler
extends MapSdkInfo {
    private static final String PROD_MANIFEST_BASE = "https://manifest-map.akamai.com/manifest?id=";
    private static final String PROD_CONFIG_BASE = "https://configuration-map.akamai.com/config?id=";
    private static final String PROD_ANALYTICS_BASE = "https://fe-map-emea2.pvoc-anaina.com/Anaina/v0/analyticsUpload";
    public static final String DEV_MANIFEST_BASE = "https://198.18.135.8/manifest?id=";
    public static final String DEV_CONFIG_BASE = "https://198.18.135.8/config?id=";
    public static final String DEV_ANALYTICS_BASE = "https://198.18.130.34/Anaina/v0/analyticsUpload";
    public static final String MOCK_MANIFEST_BASE = "https://127.0.0.1:8443/manifest?id=";
    public static final String MOCK_CONFIG_BASE = "https://127.0.0.1:8443/config?id=";
    public static final String MOCK_ANALYTICS_BASE = "https://127.0.0.1:8443/Anaina/v0/analyticsUpload";
    private static AkaSessionHandler sInstance;
    private static final String LOG_TAG = "AkaSessionHandler";

    public static synchronized AkaSessionHandler getInstance() {
        if (sInstance == null) {
            sInstance = new AkaSessionHandler();
        }
        return sInstance;
    }

    private AkaSessionHandler() {
    }

    public static void setLicense(Context context, String string) {
        SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(context).edit();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string = string.trim();
        }
        editor.putString("publicKey", string);
        editor.apply();
    }

    public static void setUserSegments(Context context, Set<String> set) {
        AkaSessionHandler.setUserSegments(context, AkaSessionHandler.getJoinedString(set.toArray(new String[set.size()])), true);
    }

    public static void setUserSegments(Context context, String string, boolean bl2) {
        if (string == null) {
            string = "";
        }
        Set<String> set = AkaSessionHandler.getSegments(context);
        AkaSegmentManifestDownloader.updateUserSegments(context, set, string, bl2);
    }

    public static void setUserSegments(Context context, String[] stringArray) {
        AkaSessionHandler.setUserSegments(context, AkaSessionHandler.getJoinedString(stringArray), true);
    }

    public static void signOut(Context context, VocService.VocAysncResponseHandler vocAysncResponseHandler) {
        if (context != null) {
            AkaInterceptorHandler.removeData(context);
            AkaConfigHandler.removeData(context);
            AkaSegmentManifestDownloader.removeData(context);
            VocAccelerator.removeData(context);
            AkaCacheHandler.removeData(context);
            if (vocAysncResponseHandler != null) {
                vocAysncResponseHandler.send(0, new Bundle());
            }
        }
    }

    public static void updateLastFgTs(Context context, long l2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_fg_ts", l2);
        editor.apply();
    }

    public static void setFgSegments(List<String> list) {
        SharedPreferences.Editor editor = VocAccelerator.getInstance().getSharedPreferences().edit();
        editor.putString("fg_segments", AkaSessionHandler.getJoinedString(list.toArray(new String[list.size()])));
        editor.apply();
    }

    public static boolean isFgSegment(String string) {
        String string2 = AkaSessionHandler.getFgSegments();
        String[] stringArray = string2.split(",");
        List<String> list = Arrays.asList(stringArray);
        return list.contains(string);
    }

    public static String getConfigUrl(Context context) {
        String string = AkaSessionHandler.getLicense(context);
        if (string == null) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaSessionHandler API key not set");
            return "";
        }
        String string2 = "";
        if ("production".equals("production")) {
            string2 = PROD_CONFIG_BASE + string + "&appid=" + context.getPackageName();
        } else if ("production".equals("dev")) {
            string2 = DEV_CONFIG_BASE + string + "&appid=" + context.getPackageName();
        } else if ("production".equals("mock")) {
            string2 = MOCK_CONFIG_BASE + string + "&appid=" + context.getPackageName();
        }
        return string2;
    }

    public static String getManifestUrl(Context context, String string) {
        String string2 = AkaSessionHandler.getLicense(context);
        if (string2 == null) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaSessionHandler API key not set");
            return "";
        }
        String string3 = "";
        if ("production".equals("production")) {
            string3 = PROD_MANIFEST_BASE + string2 + "&segment=" + string + "&appid=" + context.getPackageName();
        } else if ("production".equals("dev")) {
            string3 = DEV_MANIFEST_BASE + string2 + "&segment=" + string + "&appid=" + context.getPackageName();
        } else if ("production".contentEquals("mock")) {
            string3 = MOCK_MANIFEST_BASE + string2 + "&segment=" + string;
        }
        return string3;
    }

    public static String getAnalyticsUploadUrl(Context context) {
        String string = DEV_ANALYTICS_BASE;
        if ("production".equals("production")) {
            return VocAccelerator.getInstance().getSharedPreferences().getString("upload_url", PROD_ANALYTICS_BASE);
        }
        if ("production".equals("mock")) {
            return MOCK_ANALYTICS_BASE;
        }
        return string;
    }

    private static String getJoinedString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length != 0) {
            stringBuilder.append(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuilder.append(",");
                stringBuilder.append(stringArray[i2]);
            }
        }
        return stringBuilder.toString();
    }

    public static String getLicense(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getString("publicKey", "");
    }

    public static String getFgSegments() {
        SharedPreferences sharedPreferences = VocAccelerator.getInstance().getSharedPreferences();
        return sharedPreferences.getString("fg_segments", "");
    }

    public static String getLicenseHash() {
        String string = VocAccelerator.getInstance().getSecurePreferenceString("license_hash", "");
        return string;
    }

    public static boolean isKilled() {
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("kill_switch", false);
        return bl2;
    }

    public static boolean isUpgradeFromNonUnifiedSdk(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.contains("server_ip_address");
    }

    public static void upgradeToUnifiedSdk(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaSessionHandler: Upgrading to Unified SDK");
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("com.akamai.anaina.FULL_SYNC");
        editor.remove("config_ts");
        editor.remove("lastsdkeventupload_ts");
        editor.remove("server_ip_address");
        editor.apply();
    }

    public void kill() {
        if ("production".equals("dev")) {
            AkaMap.getInstance().clearMapCache();
            try {
                SecurePreferenceWriteHandler securePreferenceWriteHandler = new SecurePreferenceWriteHandler(VocAccelerator.getInstance().getAppContext());
                securePreferenceWriteHandler.putBoolean("enable_web_acceleration", true);
                securePreferenceWriteHandler.putBoolean("kill_switch", true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            AkaFirebaseHandler.subscribeToFCMTopic(AkaSessionHandler.getLicenseHash());
        }
    }

    public void enableSdk(boolean bl2) {
        if ("production".equals("dev")) {
            try {
                SecurePreferenceWriteHandler securePreferenceWriteHandler = new SecurePreferenceWriteHandler(VocAccelerator.getInstance().getAppContext());
                securePreferenceWriteHandler.putBoolean("enable_web_acceleration", bl2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            AkaFirebaseHandler.subscribeToFCMTopic(AkaSessionHandler.getLicenseHash());
        }
    }
}

