/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AbstractFeedContentParser;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaManifestData;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.MapScope;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class AkaSegmentManifestParser
extends AbstractFeedContentParser {
    private static final String LOG_TAG = "AkaSegmentManifestParser";
    static final int EXPIRY_IN_DAYS = 30;
    private final Context mContext;

    AkaSegmentManifestParser(Context context) {
        super(context);
        this.mContext = context;
    }

    public static void deleteUrlsAssociatedWithSegment(String string, Context context) {
        List<String> list = AkaSegmentManifestParser.getNonUcUrlsFromDb(string, context);
        if (!list.isEmpty()) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("Delete Segment Items:" + list));
            VocAccelerator.getInstance().submitTask(new PurgeRunnable(list, context));
        }
    }

    @Override
    void parseManifestAndInsertToDb() {
        List<AkaSegmentManifestDownloader.SegmentInfo> list = AkaSegmentManifestDownloader.getExistingSubscribedSegments(this.mContext);
        HashMap<String, ContentValues> hashMap = new HashMap<String, ContentValues>();
        String string = VocUtils.getDataPath(this.mContext);
        if (list != null) {
            for (AkaSegmentManifestDownloader.SegmentInfo segmentInfo : list) {
                String string2 = string + segmentInfo.mLongName + ".json";
                Map<String, ContentValues> map = this.readJsonData(string2, segmentInfo.mLongName);
                if (hashMap.isEmpty()) {
                    hashMap.putAll(map);
                    continue;
                }
                for (Map.Entry<String, ContentValues> entry : map.entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        this.mergePrioritiesForDuplicatedUrls(hashMap);
        this.insertParsedContentToDB(hashMap);
    }

    private void mergePrioritiesForDuplicatedUrls(@NonNull Map<String, ContentValues> map) {
        if (this.duplicatedUrlsWithPriority.isEmpty()) {
            return;
        }
        for (String string : this.duplicatedUrlsWithPriority.keySet()) {
            ContentValues contentValues = map.get(string);
            if (!this.duplicatedUrlsWithPriority.containsKey(string)) continue;
            Integer n2 = (Integer)this.duplicatedUrlsWithPriority.get(string);
            Integer n3 = contentValues.getAsInteger("priority");
            if (n2 >= n3) continue;
            contentValues.put("priority", n2);
        }
    }

    @Override
    protected void addFeedDataFromJson(Map.Entry<String, String> entry, AkaManifestData akaManifestData, Map<String, ContentValues> map, String string) {
        String string2 = "";
        try {
            string2 = entry.getKey();
            String string3 = entry.getValue();
            UUID uUID = UUID.nameUUIDFromBytes(string2.getBytes());
            String string4 = uUID.toString() + System.currentTimeMillis();
            String string5 = akaManifestData.getSegmentType();
            ContentValues contentValues = new ContentValues();
            int n2 = akaManifestData.getPriority();
            if (string2 == null) {
                return;
            }
            if (!this.urls.contains(string2)) {
                long l2;
                this.urls.add(string2);
                String string6 = akaManifestData.getSegmentType();
                String string7 = MapScope.WEBCONTENT.name();
                int n3 = 30;
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String string13 = "";
                String string14 = "0";
                long l3 = AnaUtils.getCurrentUTCTimeInMillis();
                String string15 = "file_" + string4;
                long l4 = l2 = 0L;
                if (l4 > this.mFileLimit) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Size > FileLimit...Skip: " + this.mFileLimit));
                    return;
                }
                long l5 = AnaUtils.getCurrentUTCTimeInMillis() + (long)n3 * 86400000L;
                contentValues.put("_id", string4);
                contentValues.put("url", string2);
                contentValues.put("size", Long.valueOf(l2));
                contentValues.put("provider", string6);
                contentValues.put("title", string8);
                contentValues.put("summary", string9);
                contentValues.put("thumbfile", string10);
                contentValues.put("duration", string14);
                contentValues.put("feedtype", string5);
                contentValues.put("scope", string7);
                contentValues.put("timestamp", Long.valueOf(l3));
                contentValues.put("videofile", string15);
                contentValues.put("expirydate", Long.valueOf(l5));
                contentValues.put("viewbookmark", Integer.valueOf(0));
                contentValues.put("viewcount", Integer.valueOf(0));
                contentValues.put("resourceready", Integer.valueOf(0));
                contentValues.put("hidden", Integer.valueOf(1));
                contentValues.put("shareurl", string11);
                contentValues.put("categories", string12);
                contentValues.put("tags", string13);
                contentValues.put("priority", Integer.valueOf(n2));
                contentValues.put("segment", string);
                contentValues.put("creationtimestamp", string3);
                map.put(string2, contentValues);
            } else if (this.duplicatedUrlsWithPriority.containsKey(string2)) {
                if (n2 < (Integer)this.duplicatedUrlsWithPriority.get(string2)) {
                    this.duplicatedUrlsWithPriority.put(string2, n2);
                }
            } else {
                this.duplicatedUrlsWithPriority.put(string2, n2);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Exception Parsing url: " + string2));
            exception.printStackTrace();
        }
    }

    private void insertParsedContentToDB(@Nullable Map<String, ContentValues> map) {
        if (map == null) {
            return;
        }
        List<String> list = AkaSegmentManifestParser.getNonUcUrlsFromDb(null, this.mContext);
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", true);
        boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
        if (bl2 || bl3) {
            try {
                ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
                for (String string : map.keySet()) {
                    ContentValues contentValues = map.get(string);
                    String string2 = contentValues.getAsString("segment");
                    boolean bl4 = AkaSessionHandler.isFgSegment(string2);
                    if (!bl2 && !bl4 || !bl3 && bl4) continue;
                    String string3 = contentValues.getAsString("url");
                    if (!list.contains(string3)) {
                        contentValues.put("syncPending", Integer.valueOf(0));
                        arrayList.add(contentValues);
                        continue;
                    }
                    list.remove(string3);
                }
                if (!arrayList.isEmpty()) {
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)("New Segment Items inserted:" + arrayList));
                    this.mContext.getContentResolver().bulkInsert(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), arrayList.toArray(new ContentValues[arrayList.size()]));
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestParser: Error inserting/updating feeds: " + exception));
                exception.printStackTrace();
            }
        }
        if (!list.isEmpty()) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("Delete Segment Items:" + list));
            VocAccelerator.getInstance().submitTask(new PurgeRunnable(list, this.mContext));
        }
    }

    static class PurgeRunnable
    implements Runnable {
        final List<String> mUrls;
        final Context mContext;

        PurgeRunnable(List<String> list, Context context) {
            this.mUrls = list;
            this.mContext = context;
        }

        @Override
        public void run() {
            AkaCacheHandler.deleteSegmentContentByUrl(this.mContext, this.mUrls);
        }
    }
}

