/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaJsonObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AkaManifestData {
    private static final String SEGMENT_ID = "segment_id";
    private static final String LICENSE_KEY = "license_key";
    private static final String SEGMENT_HASH = "segment_hash";
    private static final String SEGMENT_TYPE = "segment_type";
    private static final String URLS = "urls";
    private static final String URL = "url";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPS = "timestamps";
    private static final String MODIFIED = "modified";
    private static final String CREATED = "created";
    private static final String PRIORITY = "priority";
    private String mSegmentId = null;
    private String mLicenseKey = null;
    private String mSegmentHash = null;
    private String mSegmentType = null;
    private final Map<String, String> mUrls = new HashMap<String, String>();
    private String mModified;
    private String mCreated;
    private int mPriority = Integer.MAX_VALUE;

    AkaManifestData(String string) {
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                AkaJsonObject akaJsonObject = new AkaJsonObject(new JSONObject(string));
                this.mSegmentId = akaJsonObject.getString(SEGMENT_ID, "");
                this.mLicenseKey = akaJsonObject.getString(LICENSE_KEY, "");
                this.mSegmentHash = akaJsonObject.getString(SEGMENT_HASH, "");
                this.mSegmentType = akaJsonObject.getString(SEGMENT_TYPE, "");
                String string2 = akaJsonObject.getString(PRIORITY, String.valueOf(this.mPriority));
                this.mPriority = Integer.parseInt(string2);
                JSONArray jSONArray = akaJsonObject.getJsonArray(URLS, null);
                this.addUrls(jSONArray);
                JSONObject jSONObject = akaJsonObject.getJsonObject(TIMESTAMPS, null);
                this.addTimestamp(jSONObject);
            }
        }
        catch (NumberFormatException | JSONException throwable) {
            Logger.d((String)"AkaSdkLogger-map", (String)"AnaNotificationData: exception ", (Throwable)throwable);
        }
    }

    private void addUrls(JSONArray jSONArray) {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                AkaJsonObject akaJsonObject = new AkaJsonObject(jSONArray.getJSONObject(i2));
                String string = akaJsonObject.getString(URL, "");
                String string2 = akaJsonObject.getString(TIMESTAMP, "");
                if (string == null || string.isEmpty() || string2 == null) continue;
                this.mUrls.put(string, string2);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaNotificationData - addUrls: exception ", (Throwable)jSONException);
            }
        }
    }

    private void addTimestamp(JSONObject jSONObject) {
        AkaJsonObject akaJsonObject = new AkaJsonObject(jSONObject);
        try {
            this.mModified = akaJsonObject.getString(MODIFIED, "");
            this.mCreated = akaJsonObject.getString(CREATED, "");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Logger.e((String)"AkaSdkLogger-map", (String)"AnaNotificationData - addTimestamp: exception ", (Throwable)jSONException);
        }
    }

    @Nullable
    public String getSegmentId() {
        return this.mSegmentId;
    }

    @Nullable
    public String getLicenseKey() {
        return this.mLicenseKey;
    }

    @Nullable
    public String getSegmentHash() {
        return this.mSegmentHash;
    }

    @Nullable
    public String getSegmentType() {
        return this.mSegmentType;
    }

    @NonNull
    public Map<String, String> getUrls() {
        return this.mUrls;
    }

    @Nullable
    public String getModified() {
        return this.mModified;
    }

    @Nullable
    public String getCreated() {
        return this.mCreated;
    }

    public int getPriority() {
        return this.mPriority;
    }
}

