/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AkaJsonObject {
    private final JSONObject mJsonObject;
    private static final String LOG_TAG = "AkaJsonObject";

    public AkaJsonObject(JSONObject jSONObject) {
        this.mJsonObject = jSONObject;
    }

    public String getString(String string, String string2) throws JSONException {
        if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
            return this.mJsonObject.getString(string);
        }
        return string2;
    }

    public int getInt(String string, int n2) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                return this.mJsonObject.getInt(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getInt() " + exception));
        }
        return n2;
    }

    public long getLong(String string, long l2) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                return this.mJsonObject.getLong(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getLong() " + exception.fillInStackTrace()));
        }
        return l2;
    }

    public double getDouble(String string, double d2) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                return this.mJsonObject.getDouble(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getDouble() " + exception));
        }
        return d2;
    }

    public boolean getBoolean(String string, boolean bl2) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                Object object = this.mJsonObject.get(string);
                if (object != null && object instanceof String) {
                    return Boolean.valueOf(object.toString().trim());
                }
                return this.mJsonObject.getBoolean(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getBoolean() " + exception));
        }
        return bl2;
    }

    public JSONArray getJsonArray(String string, JSONArray jSONArray) {
        try {
            Object object;
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string) && (object = this.mJsonObject.get(string)) != null && object instanceof JSONArray && ((JSONArray)object).length() > 0) {
                return (JSONArray)object;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getJsonArray() " + exception));
        }
        return jSONArray;
    }

    public Object getObject(String string, Object object) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                return this.mJsonObject.get(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getObject() " + exception));
        }
        return object;
    }

    public JSONObject getJsonObject(String string, JSONObject jSONObject) {
        try {
            if (this.mJsonObject.has(string) && !this.mJsonObject.isNull(string)) {
                return (JSONObject)this.mJsonObject.get(string);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception parsing json for getObject() " + exception));
        }
        return jSONObject;
    }
}

