/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaManifestData;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

abstract class AbstractFeedContentParser {
    public static final String TIMESTAMP = "timeStamp";
    private static final String LOG_TAG = "AbsFeedContentParser";
    final HashSet<String> urls;
    final Map<String, Integer> duplicatedUrlsWithPriority;
    private final Context mContext;
    final long mFileLimit;

    AbstractFeedContentParser(Context context) {
        this.mContext = context;
        this.urls = new HashSet();
        this.duplicatedUrlsWithPriority = new HashMap<String, Integer>();
        this.mFileLimit = AnaUtils.getIndividualFileLimit(this.mContext);
    }

    abstract void parseManifestAndInsertToDb();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ContentValues> readJsonData(String string, String string2) {
        HashMap<String, ContentValues> hashMap = new HashMap<String, ContentValues>();
        File file = new File(string);
        Reader reader = null;
        try {
            if (file.exists()) {
                int n2;
                Logger.dd((String)"AkaSdkLogger-map", (String)("AbsFeedContentParser: Manifest file name :" + file.getName()));
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n2 = reader.read()) != -1) {
                    char c2 = (char)n2;
                    if (c2 == '\n') continue;
                    stringBuilder.append(c2);
                }
                String string3 = stringBuilder.toString();
                AkaManifestData akaManifestData = new AkaManifestData(string3);
                if (akaManifestData.getUrls() != null) {
                    for (Map.Entry<String, String> entry : akaManifestData.getUrls().entrySet()) {
                        this.addFeedDataFromJson(entry, akaManifestData, hashMap, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AbsFeedContentParser: AbsFeedContentParser:" + exception.toString()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.duplicatedUrlsWithPriority.size() > 0) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AbsFeedContentParser: AnaFeedContentParser: dup size " + this.duplicatedUrlsWithPriority.size()));
            }
        }
        this.mContext.getContentResolver().notifyChange(AnaProviderContract.CONTENT_URI_FEEDS, null);
        AkaLogger.in((String)"AkaSdkLogger-map", (String)("New Manifest Data for segment " + string2 + " is:" + hashMap.entrySet()));
        return hashMap;
    }

    void addFeedDataFromJson(Map.Entry<String, String> entry, AkaManifestData akaManifestData, Map<String, ContentValues> map, String string) {
    }

    static List<String> getNonUcUrlsFromDb(String string, Context context) {
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string2 = "segment='" + string + "' AND ";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Cursor cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), new String[]{"url"}, string2 + "syncPending" + "=" + 0, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String string3 = cursor.getString(0);
                    arrayList.add(string3);
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        return arrayList;
    }
}

