/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.HashSet;
import java.util.Set;

abstract class AbstractContentDownloader {
    private static final String LOG_TAG = "AbstractContentDownloader";
    private static final int REGISTER_UPDATE_RESULT_SUCCESS = 0;
    private static final int REGISTER_UPDATE_RESULT_FAILURE = 1;
    private static final int REGISTER_UPDATE_RESULT_NOT_NEEDED = 2;
    final AnaDownloadPolicyManager mDownloadPolicyManager;
    final Context mContext;

    AbstractContentDownloader(Context context) {
        this.mContext = context;
        this.mDownloadPolicyManager = new AnaDownloadPolicyManager(context);
    }

    public static String valueOfRegisterUpdateResult(int n2) {
        switch (n2) {
            case 0: {
                return "success";
            }
            case 1: {
                return "failure";
            }
            case 2: {
                return "not needed";
            }
        }
        return "";
    }

    protected void downloadWebContent() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public static Set<String> pruneFeedIds(Context context, Set<String> set, AnaDownloadPolicyManager anaDownloadPolicyManager) {
        if (set == null) {
            set = new HashSet<String>();
        }
        if (anaDownloadPolicyManager.isCacheAtThreshold()) {
            set.addAll(AbstractContentDownloader.removeExpiredContent(context));
            set.addAll(AbstractContentDownloader.pruneLRUCache(context, anaDownloadPolicyManager));
        }
        if (set.size() > 0) {
            VocAccelerator.getInstance().onDelete(set);
            Logger.d((String)("AbstractContentDownloader: Prune cache size " + set.size()), (Object[])new Object[0]);
            context.getContentResolver().delete(AnaProviderContract.CONTENT_URI_FEEDS, AnaProviderContract.getIdSelectionClause(set), null);
            AnaDiskUtils.forceRecalculateMemorySize(context);
        }
        return set;
    }

    public static Set<String> removeExpiredContent(Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        Cursor cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                if (AnaUtils.getCurrentUTCTimeInMillis() > anaFeedItem.getExpiryDate()) {
                    Set<String> set = AkaCacheHandler.removeCacheEntry(anaFeedItem, context);
                    for (String string : set) {
                        hashSet.add(string);
                    }
                }
                cursor.moveToNext();
            }
            cursor.close();
            if (hashSet.size() > 0) {
                context.getContentResolver().delete(AnaProviderContract.CONTENT_URI_FEEDS, AnaProviderContract.getIdSelectionClause(hashSet), null);
            }
        }
        return hashSet;
    }

    private static Set<String> pruneLRUCache(Context context, AnaDownloadPolicyManager anaDownloadPolicyManager) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = AnaUtils.getEvictionStrategy(context).getSortOrder();
        Cursor cursor = context.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, "persisttoexpiration=0", null, string);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    AnaFeedItem anaFeedItem = new AnaFeedItem(cursor);
                    Set<String> set = AkaCacheHandler.removeCacheEntry(anaFeedItem, context);
                    for (String string2 : set) {
                        hashSet.add(string2);
                    }
                    cursor.moveToNext();
                    if (anaDownloadPolicyManager.isCacheAtThreshold()) continue;
                    break;
                }
            }
            cursor.close();
        }
        return hashSet;
    }
}

