/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.db;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.akamai.android.annotations.AkamaiInternal;
import com.akamai.android.sdk.db.AnaDatabaseAccess;
import com.akamai.android.sdk.db.AnaProviderContract;

@AkamaiInternal
@Keep
public class AnaContentProvider
extends ContentProvider {
    private AnaDatabaseAccess mDao;
    static final int FEED_ITEMS = 10;
    static final int FEED_ITEM_ID = 20;
    private static final int FEED_ITEMS_FILTER = 30;
    static final int CONTENT_SOURCES = 40;
    private static final int CONTENT_SOURCE_ID = 50;
    private static final int CONTENT_SOURCE_FILTER = 60;
    private static final int FEED_ITEMS_COUNT = 130;
    static final int HTTP_STATS = 200;
    static final int SESSION_STATS = 210;
    static final int USER_EVENTS = 220;
    static final int LOG_EVENT = 230;
    static final int FEED_POLICY = 240;
    static final int SEGMENT_SUBSCRIPTION = 250;
    private static final int DELETED_FEEDS = 260;
    private static final int FEED_STATS = 290;
    static final int MESSAGE_LIST = 300;
    private static final UriMatcher sURIMatcher = new UriMatcher(-1);

    private static void initialize() {
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feeditems", 10);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feeditems/filter", 30);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feeditems/filter/*", 30);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feeditems/*", 20);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feeditemcount", 130);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "contentsources", 40);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "contentsources/filter/*", 60);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "contentsources/*", 50);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "httpstats", 200);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "sessionstats", 210);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "userevents", 220);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "eventlogs", 230);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feedpolicy", 240);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "segments", 250);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "deletedfeeds", 260);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "feedstats", 290);
        sURIMatcher.addURI(AnaProviderContract.AUTHORITY, "messagelist", 300);
    }

    @AkamaiInternal
    @Keep
    public boolean onCreate() {
        AnaProviderContract.initialize(this.getContext());
        AnaContentProvider.initialize();
        this.mDao = new AnaDatabaseAccess(this.getContext());
        this.mDao.open();
        return false;
    }

    private boolean setupDbAccessIfNeeded() {
        if (!this.mDao.isDatabaseAccessible()) {
            this.mDao.open();
            return this.mDao.isDatabaseAccessible();
        }
        return true;
    }

    @AkamaiInternal
    @Keep
    public Cursor query(@NonNull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (!this.setupDbAccessIfNeeded()) {
            return null;
        }
        int n2 = sURIMatcher.match(uri);
        Cursor cursor = null;
        switch (n2) {
            case 10: {
                cursor = this.mDao.getFeedItems(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 30: {
                cursor = this.mDao.getFilteredFeedItems(uri, string);
                break;
            }
            case 20: {
                if (!TextUtils.isEmpty((CharSequence)string)) break;
                cursor = this.mDao.getFeedItem(uri.getLastPathSegment());
                break;
            }
            case 40: 
            case 60: {
                cursor = this.mDao.getContentSources(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 50: {
                cursor = this.mDao.getContentSource(uri.getLastPathSegment());
                break;
            }
            case 130: {
                cursor = this.mDao.getFilteredCount(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 200: {
                cursor = this.mDao.getHttpConsumptionStats(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 210: {
                cursor = this.mDao.getSessionStats(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 220: {
                cursor = this.mDao.getUserEvents(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 230: {
                cursor = this.mDao.getEventLogs(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 240: {
                cursor = this.mDao.getFeedPolicy(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 250: {
                cursor = this.mDao.getSegment(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 260: {
                cursor = this.mDao.getDeletedFeeds(uri, stringArray, string, stringArray2, string2);
                break;
            }
            case 300: {
                cursor = this.mDao.getMessageList(stringArray, string, stringArray2, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        if (cursor != null && this.getContext() != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    @AkamaiInternal
    @Keep
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @AkamaiInternal
    @Keep
    public Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        if (!this.setupDbAccessIfNeeded()) {
            return null;
        }
        int n2 = sURIMatcher.match(uri);
        Uri uri2 = null;
        switch (n2) {
            case 10: 
            case 20: {
                uri2 = this.mDao.addFeedItem(contentValues);
                break;
            }
            case 40: {
                if (!this.mDao.addContentSource(contentValues)) break;
                if (this.getContext() != null) {
                    this.getContext().getContentResolver().notifyChange(uri, null);
                }
                uri2 = uri;
                break;
            }
            case 200: {
                this.mDao.addHttpConsumptionStats(contentValues);
                break;
            }
            case 210: {
                this.mDao.addSessionStats(contentValues);
                break;
            }
            case 220: {
                this.mDao.addUserEvent(contentValues);
                break;
            }
            case 230: {
                this.mDao.addEventLog(contentValues);
                break;
            }
            case 240: {
                this.mDao.addOrUpdateFeedPolicy(contentValues);
                break;
            }
            case 250: {
                this.mDao.addOrUpdateSegment(contentValues);
                break;
            }
            case 260: {
                this.mDao.addDeletedFeeds(contentValues);
                break;
            }
            case 300: {
                this.mDao.addOrUpdateMessageList(contentValues);
                break;
            }
        }
        return uri2;
    }

    @AkamaiInternal
    @Keep
    public int delete(@NonNull Uri uri, String string, String[] stringArray) {
        if (!this.setupDbAccessIfNeeded()) {
            return 0;
        }
        int n2 = sURIMatcher.match(uri);
        int n3 = 1;
        switch (n2) {
            case 10: {
                this.mDao.deleteFeeds(string, stringArray);
                break;
            }
            case 20: {
                if (!TextUtils.isEmpty((CharSequence)string)) break;
                this.mDao.deleteFeedItem(uri.getLastPathSegment());
                if (this.getContext() == null) break;
                this.getContext().getContentResolver().notifyChange(AnaProviderContract.CONTENT_URI_FEEDS, null);
                this.getContext().getContentResolver().notifyChange(AnaProviderContract.CONTENT_URI_FEED_DELETED, null);
                break;
            }
            case 200: {
                this.mDao.deleteHttpConsumptionStats(string, stringArray);
                break;
            }
            case 210: {
                this.mDao.deleteSessionStats(string, stringArray);
                break;
            }
            case 220: {
                this.mDao.deleteUserEvents(string, stringArray);
                break;
            }
            case 230: {
                this.mDao.deleteEventLogs(string, stringArray);
                break;
            }
            case 240: {
                this.mDao.deleteFeedPolicy();
                break;
            }
            case 250: {
                this.mDao.deleteSegment(string, stringArray);
                break;
            }
            case 260: {
                this.mDao.deleteDeletedFeeds(string, stringArray);
                break;
            }
            case 300: {
                this.mDao.deleteMessageList(string, stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        return n3;
    }

    @AkamaiInternal
    @Keep
    public int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        if (!this.setupDbAccessIfNeeded()) {
            return 0;
        }
        int n2 = sURIMatcher.match(uri);
        String string2 = null;
        int n3 = 0;
        switch (n2) {
            case 20: {
                string2 = uri.getLastPathSegment();
                n3 = this.mDao.updateFeed(string2, contentValues, string, stringArray);
                break;
            }
            case 50: {
                string2 = uri.getLastPathSegment();
                n3 = this.mDao.updateContentSource(string2, contentValues, string, stringArray);
                break;
            }
            case 10: {
                n3 = this.mDao.updateFeeds(contentValues, string, stringArray);
                break;
            }
            case 250: {
                n3 = this.mDao.updateSegment(contentValues, string, stringArray);
                break;
            }
            case 290: {
                n3 = this.mDao.updateFeedStats(contentValues, string, stringArray);
                break;
            }
            case 300: {
                n3 = this.mDao.updateMessageList(contentValues, string, stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        if (contentValues != null && contentValues.getAsInteger("status") != null && contentValues.getAsInteger("status") == 2 && this.getContext() != null) {
            this.getContext().getContentResolver().notifyChange(AnaProviderContract.CONTENT_URI_FEED_DELETED, null);
        }
        if (this.getContext() != null) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        if (n2 != 290) {
            Uri.Builder builder = AnaProviderContract.CONTENT_URI_FEEDS_FILTER.buildUpon();
            builder.appendQueryParameter("resourceready", Boolean.toString(true));
            uri = builder.build();
            if (this.getContext() != null) {
                this.getContext().getContentResolver().notifyChange(uri, null);
            }
        }
        return n3;
    }

    @AkamaiInternal
    @Keep
    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] contentValuesArray) {
        if (!this.setupDbAccessIfNeeded()) {
            return 0;
        }
        if (uri == null || contentValuesArray == null) {
            throw new IllegalArgumentException("Method arguments cannot be null");
        }
        int n2 = sURIMatcher.match(uri);
        return this.mDao.bulkInsert(n2, contentValuesArray);
    }
}

