/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.SharedPreferences;
import androidx.annotation.Keep;
import com.akamai.android.annotations.AkamaiInternal;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.net.AkaDefHttpURLConn;
import com.akamai.android.sdk.net.AkaDefHttpsURLConn;
import com.akamai.android.sdk.net.AkaSURLConnection;
import com.akamai.android.sdk.net.AkaURLConnection;
import com.akamai.android.sdk.net.AkaURLDefStreamHandler;
import com.akamai.android.sdk.net.VocAccelerator;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

@AkamaiInternal
@Keep
public class AkaURLStreamHandler
extends AkaURLDefStreamHandler {
    public AkaURLStreamHandler() {
        super(Boolean.valueOf(false));
    }

    public AkaURLStreamHandler(Boolean bl2) {
        super(bl2);
    }

    @AkamaiInternal
    @Keep
    protected URLConnection openConnection(URL uRL) throws IOException {
        SharedPreferences sharedPreferences = VocAccelerator.getInstance().getSharedPreferences();
        int n2 = sharedPreferences.getInt("hostname_filter_mode", 0);
        if (!AkaSessionHandler.isEnabled()) {
            return this.getDefaultUrlConnection(uRL);
        }
        switch (n2) {
            case 0: {
                return this.getSdkUrlConnection(uRL);
            }
            case 2: {
                Set set = sharedPreferences.getStringSet("hostname_filter_list", null);
                if (set != null && set.contains(uRL.getHost())) {
                    return this.getDefaultUrlConnection(uRL);
                }
                return this.getSdkUrlConnection(uRL);
            }
            case 1: {
                Set set = sharedPreferences.getStringSet("hostname_filter_list", null);
                if (set != null && set.contains(uRL.getHost())) {
                    return this.getSdkUrlConnection(uRL);
                }
                return this.getDefaultUrlConnection(uRL);
            }
        }
        return this.getSdkUrlConnection(uRL);
    }

    private URLConnection getSdkUrlConnection(URL uRL) {
        if (super.getIsSecure() == null || !super.getIsSecure().booleanValue()) {
            return new AkaURLConnection(uRL);
        }
        return new AkaSURLConnection(uRL);
    }

    private URLConnection getDefaultUrlConnection(URL uRL) throws IOException {
        if (super.getIsSecure() == null || !super.getIsSecure().booleanValue()) {
            AkaDefHttpURLConn akaDefHttpURLConn = new AkaDefHttpURLConn(uRL);
            return akaDefHttpURLConn;
        }
        AkaDefHttpsURLConn akaDefHttpsURLConn = new AkaDefHttpsURLConn(uRL);
        return akaDefHttpsURLConn;
    }

    private URLConnection getDefaultUrlConnection(URL uRL, Proxy proxy) throws IOException {
        if (super.getIsSecure() == null || !super.getIsSecure().booleanValue()) {
            AkaDefHttpURLConn akaDefHttpURLConn = new AkaDefHttpURLConn(uRL);
            akaDefHttpURLConn.setProxy(proxy);
            return akaDefHttpURLConn;
        }
        AkaDefHttpsURLConn akaDefHttpsURLConn = new AkaDefHttpsURLConn(uRL);
        akaDefHttpsURLConn.setProxy(proxy);
        return akaDefHttpsURLConn;
    }

    @AkamaiInternal
    @Keep
    protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        if (!AkaSessionHandler.isEnabled()) {
            return this.getDefaultUrlConnection(uRL, proxy);
        }
        URLConnection uRLConnection = this.openConnection(uRL);
        if (uRLConnection instanceof AkaURLConnection) {
            ((AkaURLConnection)((Object)uRLConnection)).setProxy(proxy);
        } else if (uRLConnection instanceof AkaSURLConnection) {
            ((AkaSURLConnection)((Object)uRLConnection)).setProxy(proxy);
        }
        return uRLConnection;
    }
}

