/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.text.TextUtils;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.model.VocFeedPolicy;
import com.akamai.android.sdk.util.AnaUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class VocPolicyController {
    private static final String LOG_TAG = "VocPolicyController";
    private static final String POLICY_NAME = "name";
    private static final String POLICIES = "policies";

    public void storePolicy(Context context, JSONArray jSONArray) {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                String string = jSONObject.getString(POLICY_NAME);
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                JSONArray jSONArray2 = jSONObject.getJSONArray(POLICIES);
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    JSONObject jSONObject2 = jSONArray2.getJSONObject(i3);
                    VocFeedPolicy vocFeedPolicy = new VocFeedPolicy(string, jSONObject2);
                    if (TextUtils.isEmpty((CharSequence)vocFeedPolicy.getPolicyType())) continue;
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("policyid", vocFeedPolicy.getPolicyId());
                    contentValues.put("policytype", vocFeedPolicy.getPolicyType());
                    contentValues.put("displaywhenoffline", Integer.valueOf(vocFeedPolicy.isDisplayWhenOffline() ? 1 : 0));
                    contentValues.put("mincontentexpiry", Integer.valueOf(0));
                    context.getContentResolver().insert(AnaProviderContract.CONTENT_URI_FEED_POLICY, contentValues);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public VocFeedPolicy getPolicy(Context context, AnaFeedItem anaFeedItem) {
        VocFeedPolicy vocFeedPolicy = null;
        if (anaFeedItem != null) {
            String string;
            String string2 = anaFeedItem.getPolicyId();
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = this.getDefaultContentPolicyName(context);
            }
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string = anaFeedItem.getType())) && (vocFeedPolicy = this.getPolicy(context, string2, string = string.replaceAll("\\s+", "").toLowerCase())) == null) {
                if (string.contains("/") && (vocFeedPolicy = this.getPolicy(context, string2, string = string.split("/")[0])) != null) {
                    return vocFeedPolicy;
                }
                string = "default";
                vocFeedPolicy = this.getPolicy(context, string2, string);
            }
        }
        return vocFeedPolicy;
    }

    private VocFeedPolicy getPolicy(Context context, String string, String string2) {
        String string3 = "policyid=" + this.getQuotedString(string) + " AND " + "policytype" + "=" + this.getQuotedString(string2);
        VocFeedPolicy vocFeedPolicy = null;
        try {
            Cursor cursor = context.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEED_POLICY, null, string3, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    vocFeedPolicy = new VocFeedPolicy(cursor);
                }
                cursor.close();
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("VocPolicyController: getPolicy: " + exception));
            exception.printStackTrace();
        }
        return vocFeedPolicy;
    }

    private String getQuotedString(String string) {
        return "'" + string + "'";
    }

    private String getDefaultContentPolicyName(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        return sharedPreferences.getString("defaultContentPolicy", "");
    }
}

