/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.akamai.android.sdk.AkaMap;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaCookieManager;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaWebContentDownloader;
import com.akamai.android.sdk.internal.AnaDownloadManager;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.MapScope;
import com.akamai.android.sdk.internal.SecureWriter;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.model.MapConnectionParameters;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.AkaResponseHeaderParser;
import com.akamai.android.sdk.net.AkaSURLConnection;
import com.akamai.android.sdk.net.AkaURLConnection;
import com.akamai.android.sdk.net.AkaURLStreamHandler;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class AnaResourceDownloadRunnable
implements Runnable {
    private final AnaFeedItem mFeedItem;
    private final AnaDownloadPolicyManager mDownloadPolicyManager;
    private final Context mContext;
    private long mDuration;
    private static final int CONNECTION_RETRY_INTERVAL = 2000;
    private static final int CONNECTION_READ_TIMEOUT = 10000;
    private static final int MAX_RETRY_COUNT = 3;
    private static final String LOG_TAG = "AnaResourceDndRunnable";
    private static final int AUTH_WINDOW_IN_SECONDS = 3000;
    private static final String TEMP_GHOST_AUTH_SALT = "akamai123";
    private static final String GHOST_AUTH_SALT = "miKAZuKi2sEcREtEri@t";
    private long mFeedSize = 0L;
    private Map<String, String> mResponseHeaders;
    private long mMaxAgeInSeconds = 0L;
    private static final String MOBILE_USER_AGENT_STRING = "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58K; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/46.0.2490.76 Mobile Safari/537.36";
    private String mFeedType = "";
    private final boolean mRunning = true;
    private static final long sExpirationBuffer = TimeUnit.MINUTES.toMillis(15L);
    private boolean mForegroundDownload = false;
    private long mTTFB;
    private boolean mMustRevalidate;

    AnaResourceDownloadRunnable(AnaFeedItem anaFeedItem, AnaDownloadPolicyManager anaDownloadPolicyManager, Context context, Boolean bl2, boolean bl3) {
        this.mDownloadPolicyManager = anaDownloadPolicyManager;
        this.mContext = context;
        this.mFeedItem = anaFeedItem;
        boolean bl4 = bl2;
        this.mForegroundDownload = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AnaDownloadManager anaDownloadManager = AnaDownloadManager.getInstance(this.mContext);
        int n2 = 0;
        DownloadResult downloadResult = new DownloadResult();
        if (anaDownloadManager.addFeed(this.mFeedItem.getId())) {
            boolean bl2 = false;
            try {
                long l2;
                this.mFeedSize = l2 = this.mFeedItem.getSize();
                if (this.mFeedSize <= 0L) {
                    this.mFeedSize = Long.MIN_VALUE;
                }
                if ((n2 = this.mDownloadPolicyManager.isDownloadPermitted()) == 0) {
                    this.mFeedItem.setSize(this.mFeedSize);
                    if (AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, this.mFeedSize, this.mFeedItem) != 0) {
                        return;
                    }
                }
                ContentValues contentValues = new ContentValues();
                if (n2 == 0) {
                    if (this.mFeedItem.getScope() == MapScope.WEBCONTENT) {
                        boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", true);
                        boolean bl4 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
                        boolean bl5 = AkaSessionHandler.isFgSegment(this.mFeedItem.getSegment());
                        if (!bl3 && !bl5 || !bl4 && bl5) {
                            return;
                        }
                        boolean bl6 = true;
                        if (this.mFeedItem.getRefreshTimeStamp() > 0L && this.mFeedItem.isResourceReady()) {
                            long l3 = this.mFeedItem.getRefreshTimeStamp() + TimeUnit.SECONDS.toMillis(AkaHttpUtils.getMaxAge(this.mFeedItem, AnaUtils.getSDKSharedPreferences(this.mContext)));
                            long l4 = l3 - System.currentTimeMillis();
                            boolean bl7 = bl6 = l4 < sExpirationBuffer;
                        }
                        if (!bl6) {
                            Logger.dd((String)("AnaResourceDndRunnable: Web Content not expired, url: " + this.mFeedItem.getUrl()), (Object[])new Object[0]);
                            contentValues.clear();
                            contentValues.put("resourceready", Boolean.valueOf(true));
                            this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + this.mFeedItem.getId())), contentValues, null, null);
                            bl2 = true;
                            return;
                        }
                        contentValues.clear();
                        contentValues.put("resourceready", Boolean.valueOf(false));
                        this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + this.mFeedItem.getId())), contentValues, null, null);
                    }
                    if (this.downloadUrl()) {
                        contentValues.clear();
                        contentValues.put("resourceready", Boolean.valueOf(true));
                        contentValues.put("status", Integer.valueOf(0));
                        contentValues.put("preferredstream", Integer.valueOf(this.mFeedItem.getPreferredBitrate()));
                        if (this.mFeedSize > 0L && this.mFeedSize != l2) {
                            contentValues.put("size", Long.valueOf(this.mFeedSize));
                        }
                        if (this.mFeedItem.getScope() == MapScope.WEBCONTENT) {
                            contentValues.put("responseheaders", AkaHttpUtils.convertToStringHeaders(this.mResponseHeaders));
                            contentValues.put("maxage", Long.valueOf(this.mMaxAgeInSeconds));
                            contentValues.put("refreshtimestamp", Long.valueOf(System.currentTimeMillis()));
                            if (!TextUtils.isEmpty((CharSequence)this.mFeedType) && !this.mFeedType.equals(this.mFeedItem.getType())) {
                                contentValues.put("feedtype", this.mFeedType);
                            }
                            contentValues.put("mustRevalidate", Integer.valueOf(this.mMustRevalidate ? 1 : 0));
                        }
                        this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + this.mFeedItem.getId())), contentValues, null, null);
                        bl2 = true;
                    } else {
                        contentValues.put("hidden", Integer.valueOf(1));
                        if (this.mFeedSize > 0L && this.mFeedSize != l2) {
                            contentValues.put("size", Long.valueOf(this.mFeedSize));
                        }
                        if (this.mFeedItem.getScope() == MapScope.WEBCONTENT && !TextUtils.isEmpty((CharSequence)this.mFeedType) && !this.mFeedType.equals(this.mFeedItem.getType())) {
                            contentValues.put("feedtype", this.mFeedType);
                        }
                        this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + this.mFeedItem.getId())), contentValues, null, null);
                    }
                } else {
                    Logger.d((String)("AnaResourceDndRunnable:  Out of policy window, break " + this.mFeedItem.getVideoFileName()), (Object[])new Object[0]);
                    contentValues.put("hidden", Integer.valueOf(1));
                    this.mContext.getContentResolver().update(Uri.parse((String)(AnaProviderContract.CONTENT_URI_FEEDS.toString() + "/" + this.mFeedItem.getId())), contentValues, null, null);
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)LOG_TAG, (Throwable)exception);
                if (AnaDiskUtils.freeMemory(this.mFeedItem.getSourcePath()) * 1048576.0f < 1048576.0f) {
                    downloadResult.isDiskSpaceNotEnough = true;
                }
            }
            finally {
                anaDownloadManager.removeFeed(this.mFeedItem.getId(), this.mForegroundDownload);
            }
        }
    }

    private boolean downloadUrl() {
        DownloadResult downloadResult = new DownloadResult();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AnaResourceDownloadRunnable.addCookiesToRequestHeadersFor(this.mFeedItem.getUrl(), null, hashMap);
        return this.downloadMAPUrl(this.mFeedItem.getUrl(), null, hashMap, downloadResult);
    }

    private static void addCookiesToRequestHeadersFor(String string, String string2, Map<String, String> map) {
        try {
            AkaCookieManager akaCookieManager = AkaCookieManager.getInstance();
            Map<String, List<String>> map2 = akaCookieManager.get(new URI(AnaResourceDownloadRunnable.getUrl(string, string2)), AnaResourceDownloadRunnable.convertToUrlConnectionHeaders(map));
            if (map2 != null && !map2.isEmpty()) {
                List<String> list = map2.get("Cookie");
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(string3);
                }
                map.put("Cookie", stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getUrl(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                URL uRL = new URL(string);
                String string3 = string.replaceFirst(uRL.getHost(), string2);
                return string3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static Map<String, List<String>> convertToUrlConnectionHeaders(Map<String, String> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadMAPUrl(String string, String string2, HashMap<String, String> hashMap, DownloadResult downloadResult) {
        boolean bl2 = false;
        long l2 = this.mFeedSize;
        String string3 = VocUtils.getMediaPath(this.mContext, this.mFeedItem);
        File file = new File(string3 + this.mFeedItem.getVideoFileName());
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        boolean bl6 = this.mFeedItem.getScope() == MapScope.WEBCONTENT;
        try {
            long l3 = System.currentTimeMillis();
            Thread.currentThread().setPriority(1);
            BufferedOutputStream bufferedOutputStream = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                HttpURLConnection httpURLConnection = null;
                byte[] byArray = new byte[4096];
                try {
                    int n3;
                    long l4;
                    int n4;
                    InputStream inputStream;
                    Object object;
                    long l5;
                    long l6;
                    block98: {
                        block97: {
                            Iterator<Map.Entry<String, String>> iterator;
                            Object object2;
                            n2 = this.mDownloadPolicyManager.isDownloadPermitted();
                            if (n2 == 0) {
                                this.mFeedItem.setSize(this.mFeedSize);
                                n2 = AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, this.mFeedSize, this.mFeedItem);
                            }
                            if (n2 != 0) break block97;
                            bl5 = false;
                            Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: downloading url = " + string + " to path " + this.mFeedItem.getSourcePath()), (Object[])new Object[0]);
                            l6 = 0L;
                            l5 = 0L;
                            boolean bl7 = new URL(string).getProtocol().equalsIgnoreCase("https");
                            URL uRL = new URL(null, string, (URLStreamHandler)((Object)new AkaURLStreamHandler(bl7)));
                            httpURLConnection = (HttpURLConnection)uRL.openConnection();
                            String string4 = bl6 ? (Build.VERSION.SDK_INT >= 17 ? WebSettings.getDefaultUserAgent((Context)this.mContext) : MOBILE_USER_AGENT_STRING) : AnaUtils.getUserAgentString(this.mContext);
                            if (!bl6) {
                                bl3 = this.isRangeSupported(string, string2, hashMap);
                            }
                            if (!file.exists()) {
                                file.createNewFile();
                            } else if (!bl6) {
                                l5 = file.length();
                            } else {
                                this.mResponseHeaders = AkaHttpUtils.parseHeadersFromString(this.mFeedItem.getRespHeaders());
                                object2 = this.mResponseHeaders.get("etag");
                                if (!TextUtils.isEmpty((CharSequence)object2)) {
                                    httpURLConnection.setRequestProperty("If-None-Match", AkaHttpUtils.getQuotedString((String)object2));
                                }
                                if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = this.mResponseHeaders.get("last-modified"))))) {
                                    httpURLConnection.setRequestProperty("If-Modified-Since", (String)((Object)iterator));
                                }
                            }
                            httpURLConnection.setRequestProperty("x-user-type", "sdk");
                            httpURLConnection.setRequestProperty("User-Agent", string4);
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                httpURLConnection.setRequestProperty("Host", string2);
                            }
                            if (httpURLConnection instanceof AkaSURLConnection && bl6 && !TextUtils.isEmpty((CharSequence)((Object)(iterator = ((URI)(object2 = new URI(string))).getHost()))) && (object = AkaMap.getInstance().getConnectionParameters((String)((Object)iterator))) != null) {
                                if (((MapConnectionParameters)object).getSSLSocketFactory() != null) {
                                    ((AkaSURLConnection)((Object)httpURLConnection)).setSSLSocketFactory(((MapConnectionParameters)object).getSSLSocketFactory());
                                }
                                if (((MapConnectionParameters)object).getHostnameVerifier() != null) {
                                    ((AkaSURLConnection)((Object)httpURLConnection)).setHostnameVerifier(((MapConnectionParameters)object).getHostnameVerifier());
                                }
                            }
                            httpURLConnection.setRequestMethod("GET");
                            httpURLConnection.setReadTimeout(10000);
                            object2 = AnaUtils.getBillingHeaders(this.mContext, this.mFeedItem.getId());
                            if (object2 != null && !((HashMap)object2).isEmpty()) {
                                iterator = ((HashMap)object2).entrySet().iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    httpURLConnection.setRequestProperty(object.getKey(), object.getValue());
                                }
                            }
                            if (!hashMap.isEmpty()) {
                                iterator = hashMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    httpURLConnection.setRequestProperty(object.getKey(), object.getValue());
                                }
                            }
                            if (l5 > 0L && bl3 && !bl6) {
                                Logger.d((String)("AnaResourceDndRunnable: Resume download " + file.getName() + " feed " + this.mFeedItem.getTitle() + " from " + l5), (Object[])new Object[0]);
                                httpURLConnection.setRequestProperty("Range", "bytes=" + l5 + "-");
                                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
                            }
                            httpURLConnection.connect();
                            int n5 = httpURLConnection.getResponseCode();
                            this.mFeedType = httpURLConnection.getContentType();
                            object = null;
                            if (httpURLConnection instanceof AkaSURLConnection) {
                                object = new AkaResponseHeaderParser(((AkaSURLConnection)((Object)httpURLConnection)).getResponseHeaders(true));
                            } else if (httpURLConnection instanceof AkaURLConnection) {
                                object = new AkaResponseHeaderParser(((AkaURLConnection)((Object)httpURLConnection)).getResponseHeaders(true));
                            }
                            AkaCookieManager akaCookieManager = AkaCookieManager.getInstance();
                            if (n5 == 200 || n5 == 206) {
                                akaCookieManager.put(new URI(AnaResourceDownloadRunnable.getUrl(string, string2)), httpURLConnection.getHeaderFields());
                                if (bl6 && object != null && !((AkaResponseHeaderParser)object).canDownload()) {
                                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaResourceDndRunnable: Content not downloadable: " + string));
                                    boolean bl8 = false;
                                    return bl8;
                                }
                                if (bufferedOutputStream == null) {
                                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                                }
                                inputStream = httpURLConnection.getInputStream();
                                if (bl6 && uRL.getProtocol().equals("https")) {
                                    SecureWriter secureWriter = new SecureWriter(this.mContext);
                                    inputStream = secureWriter.getEncryptedInputStream(inputStream);
                                }
                                if ((n4 = httpURLConnection.getContentLength()) > 0 && bl6) {
                                    this.mFeedSize = n4;
                                    this.mFeedItem.setSize(this.mFeedSize);
                                    if (AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, this.mFeedSize, this.mFeedItem) != 0) {
                                        if (file != null && file.exists()) {
                                            try {
                                                file.delete();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        boolean bl9 = false;
                                        return bl9;
                                    }
                                }
                                l4 = 0x200000L;
                                break block98;
                            } else {
                                if (n5 != 304) continue;
                                akaCookieManager.put(new URI(AnaResourceDownloadRunnable.getUrl(string, string2)), httpURLConnection.getHeaderFields());
                                this.mDuration = System.currentTimeMillis() - l3;
                                Logger.d((String)"AkaSdkLogger-map", (String)("AnaResourceDndRunnable: 304 not modified: " + string));
                                this.updateResponseHeaders((AkaResponseHeaderParser)object);
                                boolean bl10 = true;
                                return bl10;
                            }
                        }
                        Logger.e((String)"AkaSdkLogger-map", (String)("AnaResourceDndRunnable downloadMAPUrl: Out of policy window, break " + file.getName() + " " + file.length()));
                        bl5 = true;
                        break;
                    }
                    while ((n3 = inputStream.read(byArray)) > 0) {
                        if (this.mTTFB <= 0L) {
                            this.mTTFB = System.currentTimeMillis() - l3;
                        }
                        if (l6 >= l4) {
                            int n6 = this.mDownloadPolicyManager.isDownloadPermitted();
                            if (n6 != 0) {
                                bl5 = true;
                                if (file == null) throw new Exception("Out of Policy break, result: " + AnaDownloadPolicyManager.valueOf(n6));
                                if (!file.exists()) throw new Exception("Out of Policy break, result: " + AnaDownloadPolicyManager.valueOf(n6));
                                try {
                                    file.delete();
                                    throw new Exception("Out of Policy break, result: " + AnaDownloadPolicyManager.valueOf(n6));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw new Exception("Out of Policy break, result: " + AnaDownloadPolicyManager.valueOf(n6));
                            }
                            l4 += 0x200000L;
                        }
                        bufferedOutputStream.write(byArray, 0, n3);
                        bufferedOutputStream.flush();
                        l6 += (long)n3;
                    }
                    inputStream.close();
                    if (this.mFeedSize != (long)n4) {
                        this.mFeedSize = file.length();
                        this.mFeedItem.setSize(this.mFeedSize);
                        if (AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, this.mFeedSize, this.mFeedItem) != 0) {
                            if (file != null && file.exists()) {
                                try {
                                    file.delete();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            boolean bl11 = false;
                            return bl11;
                        }
                    }
                    AnaDiskUtils.addToUsedMemory(file.length());
                    if (file.length() < l2 && l6 < (long)n4) continue;
                    long l7 = System.currentTimeMillis();
                    this.mDuration = l7 - l3;
                    if (bl3 && l5 > 0L && !bl6) {
                        Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: Range Downloaded  file with size " + file.getName() + " " + file.length() + " took " + this.mDuration + " " + l6), (Object[])new Object[0]);
                    } else {
                        Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: Downloaded  file with size " + file.getName() + " " + file.length() + " took " + this.mDuration + " " + l6), (Object[])new Object[0]);
                    }
                    if (file.length() != l2) {
                        l2 = file.length();
                    }
                    bl2 = true;
                    this.mDownloadPolicyManager.updateDayUsage(l6);
                    this.updateResponseHeaders((AkaResponseHeaderParser)object);
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AnaResourceDndRunnable: " + exception.getMessage()));
                    if (AnaDiskUtils.freeMemory(this.mFeedItem.getSourcePath()) * 1048576.0f < (float)byArray.length) {
                        downloadResult.isDiskSpaceNotEnough = true;
                        break;
                    }
                    AnaResourceDownloadRunnable anaResourceDownloadRunnable = this;
                    synchronized (anaResourceDownloadRunnable) {
                        try {
                            Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: Cannot get connection, wait and attempt " + i2), (Object[])new Object[0]);
                            this.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                finally {
                    try {
                        if (bufferedOutputStream != null) {
                            bufferedOutputStream.flush();
                            bufferedOutputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    bufferedOutputStream = null;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: Cannot download file " + file.getName()), (Object[])new Object[0]);
        }
        finally {
            if (downloadResult != null) {
                downloadResult.resultCongestion = bl4;
                downloadResult.resultPolicy = n2;
            }
        }
        if (file.length() == l2) {
            return true;
        }
        if (file.length() > 0L) {
            Logger.d((String)("AnaResourceDndRunnable: downloadMAPUrl: Partial download " + file.getName() + " " + file.length() + " took " + this.mDuration), (Object[])new Object[0]);
            this.mDownloadPolicyManager.updateDayUsage(file.length());
        }
        if (bl3) {
            if (file.length() != 0L) return bl2;
        }
        Logger.e((String)"AkaSdkLogger-map", (String)("AnaResourceDndRunnable: deleting file: " + file.getName() + ", rangeSupported: " + bl3 + ", file len: " + file.length()));
        File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
        file.renameTo(file2);
        file2.delete();
        return false;
    }

    private void updateResponseHeaders(AkaResponseHeaderParser akaResponseHeaderParser) {
        if (this.mFeedItem.getScope() == MapScope.WEBCONTENT && akaResponseHeaderParser != null) {
            Map<String, String> map = akaResponseHeaderParser.getBareHeaders();
            if (this.mResponseHeaders == null) {
                this.mResponseHeaders = map;
            } else {
                for (String string : map.keySet()) {
                    this.mResponseHeaders.put(string, map.get(string));
                }
            }
            this.mMaxAgeInSeconds = akaResponseHeaderParser.getExpiry() / 1000L;
            this.mMustRevalidate = akaResponseHeaderParser.mustRevalidate();
        }
    }

    public static int isDownloadPolicyAllowed(Context context, AnaDownloadPolicyManager anaDownloadPolicyManager, long l2, AnaFeedItem anaFeedItem) {
        String string = AnaDiskUtils.getInternalStoragePath(context);
        int n2 = string == null ? 4 : 0;
        String string2 = VocUtils.getMediaPath(context, null);
        n2 = anaDownloadPolicyManager.isDownloadPermittedForSize(l2, anaFeedItem, string2);
        if (n2 != 0) {
            Logger.d((String)("AnaResourceDndRunnable: WebContent: Download failed for url " + anaFeedItem.getUrl() + ",  policy  " + n2), (Object[])new Object[0]);
            if (n2 == 4) {
                AkaWebContentDownloader.pruneCacheIfNeeded(context, anaDownloadPolicyManager);
            }
            return n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRangeSupported(String string, String string2, HashMap<String, String> hashMap) {
        HttpURLConnection httpURLConnection = null;
        boolean bl2 = false;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                httpURLConnection.setRequestProperty("Host", string2);
            }
            if (!hashMap.isEmpty()) {
                for (Map.Entry<String, String> object2 : hashMap.entrySet()) {
                    httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
                }
            }
            int n2 = httpURLConnection.getResponseCode();
            String string3 = httpURLConnection.getHeaderField("Accept-Ranges");
            bl2 = string3 != null && string3.equals("bytes");
        }
        catch (IOException iOException) {
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return bl2;
    }

    private class DownloadResult {
        boolean resultCongestion;
        int resultPolicy;
        int resultHttpResponseCode = -1;
        boolean isDiskSpaceNotEnough;

        private DownloadResult() {
        }
    }
}

