/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.text.TextUtils;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaJsonObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AkaManifestData {
    private static final String SEGMENT_ID = "segment_id";
    private static final String LICENSE_KEY = "license_key";
    private static final String SEGMENT_HASH = "segment_hash";
    private static final String SEGMENT_TYPE = "segment_type";
    private static final String URLS = "urls";
    private static final String URL = "url";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPS = "timestamps";
    private static final String MODIFIED = "modified";
    private static final String CREATED = "created";
    private String mSegmentId = null;
    private String mLicenseKey = null;
    private String mSegmentHash = null;
    private String mSegmentType = null;
    private final Map<String, String> mUrls = new HashMap<String, String>();
    private String mModified;
    private String mCreated;

    AkaManifestData(String string) {
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                AkaJsonObject akaJsonObject = new AkaJsonObject(new JSONObject(string));
                this.mSegmentId = akaJsonObject.getString(SEGMENT_ID, "");
                this.mLicenseKey = akaJsonObject.getString(LICENSE_KEY, "");
                this.mSegmentHash = akaJsonObject.getString(SEGMENT_HASH, "");
                this.mSegmentType = akaJsonObject.getString(SEGMENT_TYPE, "");
                JSONArray jSONArray = akaJsonObject.getJsonArray(URLS, null);
                this.addUrls(jSONArray);
                JSONObject jSONObject = akaJsonObject.getJsonObject(TIMESTAMPS, null);
                this.addTimestamp(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Logger.d((String)"AnaNotificationData: exception ", (Object[])new Object[]{jSONException});
        }
    }

    private void addUrls(JSONArray jSONArray) {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                AkaJsonObject akaJsonObject = new AkaJsonObject(jSONArray.getJSONObject(i2));
                String string = akaJsonObject.getString(URL, "");
                String string2 = akaJsonObject.getString(TIMESTAMP, "");
                if (string == null || string.isEmpty() || string2 == null) continue;
                this.mUrls.put(string, string2);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void addTimestamp(JSONObject jSONObject) {
        AkaJsonObject akaJsonObject = new AkaJsonObject(jSONObject);
        try {
            this.mModified = akaJsonObject.getString(MODIFIED, "");
            this.mCreated = akaJsonObject.getString(CREATED, "");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public String getSegmentId() {
        return this.mSegmentId;
    }

    public String getLicenseKey() {
        return this.mLicenseKey;
    }

    public String getSegmentHash() {
        return this.mSegmentHash;
    }

    public String getSegmentType() {
        return this.mSegmentType;
    }

    public Map<String, String> getUrls() {
        return this.mUrls;
    }

    public String getModified() {
        return this.mModified;
    }

    public String getCreated() {
        return this.mCreated;
    }
}

