/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.os.Build;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.net.AkaHttpUtils;
import java.lang.reflect.Field;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

class AkaInterceptorHandler {
    AkaInterceptorHandler() {
    }

    public static void removeData(Context context) {
        AkaInterceptorHandler.removeCookies();
        AkaInterceptorHandler.resetURLStreamHandlerToDefault();
    }

    public static void removeCookies() {
        try {
            CookieManager cookieManager = (CookieManager)CookieManager.getDefault();
            CookieStore cookieStore = cookieManager.getCookieStore();
            cookieStore.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void resetURLStreamHandlerToDefault() {
        try {
            String string = "streamHandlerFactory";
            if (Build.VERSION.CODENAME.equalsIgnoreCase("N") || Build.VERSION.SDK_INT > 23) {
                string = "factory";
            }
            Field field = URL.class.getDeclaredField(string);
            field.setAccessible(true);
            field.set(null, null);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String string) {
                    try {
                        if (string.equals("http")) {
                            return AkaHttpUtils.getDefaultHandler((boolean)false);
                        }
                        if (string.equals("https")) {
                            return AkaHttpUtils.getDefaultHandler((boolean)true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Logger.dd((String)"Exception in resetURLStreamHandlerToDefault : ", (Object[])new Object[]{exception});
        }
    }
}

