/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.lifecycle.LiveData;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.Operation;
import androidx.work.WorkContinuation;
import androidx.work.WorkManager;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaClearCacheController;
import com.akamai.android.sdk.internal.AkaResetSdkController;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaSyncController;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.concurrent.TimeUnit;

public class AkaBackgroundService {
    private static final String LOG_TAG = "AkaBackgroundService";
    public static final long NOTIFICATION_INTENT_INTERVAL_MS = "production".equals("mock") ? 2000L : TimeUnit.MINUTES.toMillis(1L);
    public static final long FOREGROUND_SYNC_INTERVAL_MS = "production".equals("mock") ? 0L : TimeUnit.MINUTES.toMillis(5L);
    private static final String SYNC_TAG = "sync_in_progress";
    private final WorkManager mWorkManager;
    private static AkaBackgroundService sInstance;
    private final Context mContext;

    private AkaBackgroundService(Context context) {
        this.mContext = context;
        this.mWorkManager = WorkManager.getInstance((Context)context.getApplicationContext());
    }

    public static synchronized AkaBackgroundService getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new AkaBackgroundService(context);
        }
        return sInstance;
    }

    public synchronized boolean performFullSync(Context context, String string) {
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Perform Full Sync");
        return this.performSync(context, string, true, false);
    }

    public synchronized boolean performFullSync(Context context, String string, boolean bl2) {
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Perform Full Sync");
        return this.performSync(context, string, true, bl2);
    }

    public synchronized boolean performCacheSync(Context context) {
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Perform Cache Sync");
        return this.performSync(context, null, false, false);
    }

    private synchronized boolean performSync(Context context, String string, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        if (AkaSessionHandler.isKilled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: createSyncWork: SDK is not active");
            return false;
        }
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        long l2 = sharedPreferences.getLong("com.akamai.anaina.FULL_SYNC", 0L);
        boolean bl6 = bl5 = !TextUtils.isEmpty((CharSequence)string);
        if (bl3) {
            bl4 = true;
        } else if (bl5) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)"Sync attempted by Notification");
            bl4 = AnaUtils.getCurrentUTCTimeInMillis() - l2 > NOTIFICATION_INTENT_INTERVAL_MS;
        } else {
            boolean bl7 = bl4 = AnaUtils.getCurrentUTCTimeInMillis() - l2 > FOREGROUND_SYNC_INTERVAL_MS;
        }
        if (bl4) {
            if (bl5) {
                SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(context).edit();
                editor.putLong("fcm_recv_ts", AnaUtils.getCurrentUTCTimeInMillis());
                editor.apply();
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaBackgroundService: Notification data: " + string));
            } else {
                Logger.dd((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Foreground createSyncWork");
            }
            AkaBackgroundService.updateIntentQueueTs(context);
            this.createSyncWork(string, bl2);
            return true;
        }
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Sync called within interval");
        return false;
    }

    public synchronized boolean resetSdkForNewApiKey() {
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Reset SDK to handle new API key");
        this.createResetSdkWork();
        return true;
    }

    public synchronized boolean clearCache() {
        Logger.d((String)"AkaSdkLogger-map", (String)"AkaBackgroundService: Clear cache request");
        this.createClearCacheWork();
        return true;
    }

    private static void updateIntentQueueTs(Context context) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("com.akamai.anaina.FULL_SYNC", System.currentTimeMillis());
        editor.apply();
    }

    public LiveData<Operation.State> createSyncWork(String string, boolean bl2) {
        OneTimeWorkRequest oneTimeWorkRequest = this.getSyncWorkRequest(string, bl2);
        Operation operation = this.mWorkManager.enqueueUniqueWork(SYNC_TAG, ExistingWorkPolicy.KEEP, oneTimeWorkRequest);
        return operation.getState();
    }

    private OneTimeWorkRequest getSyncWorkRequest(String string, boolean bl2) {
        Data.Builder builder = new Data.Builder();
        if (string != null) {
            builder.putString("Notification", string);
        }
        builder.putBoolean("allowConfigSync", bl2);
        Data data = builder.build();
        return (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AkaSyncController.class).setInputData(data)).build();
    }

    public LiveData<Operation.State> createClearCacheWork() {
        OneTimeWorkRequest oneTimeWorkRequest = this.getClearCacheRequest();
        Operation operation = this.mWorkManager.enqueueUniqueWork(SYNC_TAG, ExistingWorkPolicy.APPEND, oneTimeWorkRequest);
        return operation.getState();
    }

    private OneTimeWorkRequest getClearCacheRequest() {
        return (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(AkaClearCacheController.class).build();
    }

    public LiveData<Operation.State> createResetSdkWork() {
        Operation operation;
        OneTimeWorkRequest oneTimeWorkRequest = this.getResetSdkRequest();
        WorkContinuation workContinuation = this.mWorkManager.beginUniqueWork(SYNC_TAG, ExistingWorkPolicy.REPLACE, oneTimeWorkRequest);
        workContinuation = workContinuation.then(this.getClearCacheRequest());
        if (!TextUtils.isEmpty((CharSequence)AkaSessionHandler.getLicense(this.mContext))) {
            operation = this.getSyncWorkRequest(null, true);
            workContinuation = workContinuation.then((OneTimeWorkRequest)operation);
        }
        operation = workContinuation.enqueue();
        return operation.getState();
    }

    private OneTimeWorkRequest getResetSdkRequest() {
        return (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(AkaResetSdkController.class).build();
    }
}

