/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.akamai.android.AkaLogger;
import com.akamai.android.AkaOptions;
import com.akamai.android.AkaPushNotificationHandler;
import com.akamai.android.AkaStreamHandler;
import com.akamai.android.annotations.AkamaiInternal;
import com.akamai.android.annotations.PublicApi;
import com.akamai.android.sdk.AkaCommon;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.MapProperties;
import com.akamai.android.sdk.MapSdkInfo;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.internal.AkaNetworkQualityHandler;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AnaNetworkQualityStatus;
import com.akamai.android.sdk.internal.PushMessagingService;
import com.akamai.android.sdk.model.MapConnectionParameters;
import com.akamai.android.sdk.net.AkaURLStreamHandler;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.File;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@PublicApi
@Keep
public class AkaMap
implements AkaPushNotificationHandler,
AkaStreamHandler {
    private final Context mContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static AkaMap sInstance;
    private static final String LOG_TAG = "AkaMap";
    private static final Map<String, MapConnectionParameters> mConnectionParametersMap;

    @PublicApi
    @Keep
    public static AkaMap getInstance() {
        return (AkaMap)AkaCommon.getInstance().get(AkaMap.class);
    }

    @PublicApi
    @Keep
    public void startEvent(String string) {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            VocAccelerator.getInstance().startEvent(string, AnaUtils.getCurrentUTCTimeInMillis());
        }
    }

    @PublicApi
    @Keep
    public void stopEvent(String string) {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            VocAccelerator.getInstance().stopEvent(string, AnaUtils.getCurrentUTCTimeInMillis());
        }
    }

    @PublicApi
    @Keep
    public void logEvent(String string) {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            VocAccelerator.getInstance().logEvent(string, AnaUtils.getCurrentUTCTimeInMillis());
        }
    }

    @PublicApi
    @Keep
    public int getNetworkQuality() {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return 0;
        }
        int n2 = -1;
        try {
            if (!AnaUtils.isCongestionControlEnabled()) {
                return n2;
            }
            AnaNetworkQualityStatus anaNetworkQualityStatus = AkaNetworkQualityHandler.getNetworkQuality(this.mContext);
            n2 = anaNetworkQualityStatus.networkQuality;
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)LOG_TAG, (Throwable)exception);
        }
        return n2;
    }

    @PublicApi
    @Keep
    public void initialize(@NonNull String string, @NonNull Set<String> set) {
        boolean bl2;
        if (AkaSessionHandler.isKilled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMapSDK is killed ");
            return;
        }
        boolean bl3 = bl2 = !AkaSessionHandler.getLicense(this.mContext).equals(string);
        if (bl2 && string != null) {
            AkaSessionHandler.setLicense(this.mContext, string);
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaMap MAP instance created with api Key:" + string));
            if (set != null) {
                AkaSessionHandler.setUserSegments(this.mContext, set);
                AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaMap MAP segments are:" + set));
            }
            if (AkaSessionHandler.isEnabled()) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap Resetting the SDK for the given API and segments");
                AkaBackgroundService.getInstance(this.mContext).resetSdkForNewApiKey();
                return;
            }
            AkaBackgroundService.getInstance(this.mContext).performFullSync(this.mContext, null);
        }
        AkaLogger.in((String)"AkaSdkLogger-map", (String)"AkaMap Same API key. Ignoring the call");
    }

    @PublicApi
    @Keep
    public boolean subscribeSegments(final @NonNull Set<String> set) {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return false;
        }
        if (set == null) {
            throw new IllegalArgumentException("segments == null");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AkaSessionHandler.setUserSegments(AkaMap.this.mContext, set);
            }
        });
        thread.start();
        return true;
    }

    @PublicApi
    @Keep
    public MapSdkInfo getSdkStatus() {
        return new MapSdkInfo();
    }

    @PublicApi
    @Keep
    public void setCustomConnectionParameters(String string, MapConnectionParameters mapConnectionParameters) {
        MapConnectionParameters mapConnectionParameters2 = mConnectionParametersMap.get(string);
        if (mapConnectionParameters2 != null && mapConnectionParameters == null) {
            mConnectionParametersMap.remove(string);
            return;
        }
        if (mapConnectionParameters != null) {
            mConnectionParametersMap.put(string, mapConnectionParameters);
        }
    }

    @PublicApi
    @Keep
    public MapConnectionParameters getConnectionParameters(String string) {
        return mConnectionParametersMap.get(string);
    }

    @Deprecated
    @PublicApi
    @Keep
    public boolean clearMapCache() {
        return AkaBackgroundService.getInstance(this.mContext).clearCache();
    }

    @PublicApi
    @Keep
    public boolean handlePushNotification(@NonNull Map<String, String> map) {
        Logger.dd((String)"AkaSdkLogger-map", (String)"AkaMap Push Notification received");
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaMap: sync: SDK is not active");
            return false;
        }
        if (map != null && !map.isEmpty() && map.containsKey("mapsdk")) {
            PushMessagingService.onPushMessageReceived(this.mContext, map);
            return true;
        }
        return false;
    }

    @AkamaiInternal
    @Keep
    public URLStreamHandler getUrlStreamHandler(String string) {
        return new AkaURLStreamHandler(string.equals("https"));
    }

    @AkamaiInternal
    @Keep
    public int getStreamHandlerPriority() {
        return 100;
    }

    @AkamaiInternal
    @Keep
    static synchronized AkaMap createMapInstance(final Context context, AkaOptions akaOptions) {
        if (sInstance == null) {
            if ("production".equals("dev")) {
                AkaLogger.enableInternalLogging = true;
            }
            String string = "";
            String string2 = "";
            if (akaOptions != null) {
                string = akaOptions.getValue("com_akamai_map_license_key");
                if (string == null) {
                    string = akaOptions.getValue("com_akamai_sdk_license_key");
                }
                if ((string2 = akaOptions.getValue("com_akamai_map_segments")) == null) {
                    string2 = akaOptions.getValue("com_akamai_sdk_segments");
                }
            }
            sInstance = new AkaMap(context);
            if (string == null) {
                string = "";
            }
            String string3 = AkaSessionHandler.getLicense(context);
            boolean bl2 = false;
            if (string != null) {
                boolean bl3 = bl2 = !string3.equals(string = string.trim());
                if (bl2) {
                    AkaSessionHandler.setLicense(context, string);
                    if (Looper.myLooper() == null) {
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                AnaUtils.loadDefaultPrefs(context);
                            }
                        });
                    } else {
                        AnaUtils.loadDefaultPrefs(context);
                    }
                }
            }
            if (AkaSessionHandler.isUpgradeFromNonUnifiedSdk(context)) {
                AkaSessionHandler.upgradeToUnifiedSdk(context);
            }
            AnaProviderContract.initialize(context);
            VocAccelerator.getInstance().init(context.getApplicationContext(), sInstance);
            boolean bl4 = false;
            if (!bl4 && !AnaUtils.isEmulator() && AkaMap.isRooted()) {
                AkaSessionHandler.signOut(context, null);
            }
            AkaMap.handlePropValues(context.getApplicationContext());
            if (bl2) {
                AkaSessionHandler.setUserSegments(context, string2, false);
                if (string3.isEmpty()) {
                    AkaBackgroundService.getInstance(context).performFullSync(context, null);
                } else {
                    AkaBackgroundService.getInstance(context).resetSdkForNewApiKey();
                }
            }
        }
        return sInstance;
    }

    protected static boolean isRooted() {
        String[] stringArray;
        String string = "su";
        for (String string2 : stringArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            if (!new File(string2 + string).exists()) continue;
            return true;
        }
        return false;
    }

    protected AkaMap(Context context) {
        this.mContext = context.getApplicationContext();
    }

    private static void handlePropValues(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MapProperties mapProperties = MapProperties.getInstance();
                if (mapProperties.loadProperties(context)) {
                    this.logConfig(mapProperties);
                    this.logContent(mapProperties);
                    this.setLogLevelDebug(mapProperties);
                    this.clearCache(mapProperties);
                    this.fillCache(mapProperties);
                    this.signOut(mapProperties);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void logConfig(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("logConfig", false);
                if (bl2) {
                    Logger.LEVEL lEVEL = Logger.getCurrentLogLevel();
                    Logger.setLevel((Logger.LEVEL)Logger.LEVEL.DEBUG);
                    try {
                        MapSdkInfo.logCurrentConfiguration(context);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        Logger.setLevel((Logger.LEVEL)lEVEL);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void logContent(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("logContent", false);
                if (bl2) {
                    Logger.LEVEL lEVEL = Logger.getCurrentLogLevel();
                    Logger.setLevel((Logger.LEVEL)Logger.LEVEL.DEBUG);
                    try {
                        MapSdkInfo.logExistingContent(context);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        Logger.setLevel((Logger.LEVEL)lEVEL);
                    }
                }
            }

            private void setLogLevelDebug(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("setLogLevelDebug", false);
                if (bl2) {
                    Logger.setLevel((Logger.LEVEL)Logger.LEVEL.DEBUG);
                }
            }

            private void clearCache(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("clearCache", false);
                if (bl2) {
                    AkaMap.getInstance().clearMapCache();
                }
            }

            private void fillCache(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("performCacheFill", false);
                if (bl2) {
                    AkaBackgroundService.getInstance(context).performCacheSync(context);
                }
            }

            private void signOut(MapProperties mapProperties) {
                boolean bl2 = mapProperties.getProperty("signOut", false);
                if (bl2) {
                    AkaSessionHandler.signOut(context, null);
                }
            }
        }).start();
    }

    static {
        mConnectionParametersMap = new ConcurrentHashMap<String, MapConnectionParameters>();
    }
}

