/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.util;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class ErrorUtils {
    private static final String DNS_ERRORS = "DNS";
    private static final String CONNECT_ERRORS = "CT";
    private static final String CONNECTTIMEOUT_ERRORS = "CTTO";
    private static final String HANDSHAKE_ERRORS = "SSL";
    private static final String STREAM_ERRORS = "IO";
    private static final String UNMAPPED_ERRORS = "UNK";
    private static final int MAXCHARS_MESSAGE = 50;
    private static final Map<String, String> errorMap = new HashMap<String, String>();

    public static String getError(Exception exception) {
        try {
            if (errorMap != null && errorMap.containsKey(exception.getClass().getSimpleName())) {
                return errorMap.get(exception.getClass().getSimpleName());
            }
            String string = exception.getMessage();
            if (!TextUtils.isEmpty((CharSequence)string) && string.length() > 50) {
                return "UNK-" + string.substring(0, 50);
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return "UNK-" + string;
            }
            return UNMAPPED_ERRORS;
        }
        catch (Exception exception2) {
            return "";
        }
    }

    static {
        errorMap.put("UnknownHostException", "DNS-UnkHst");
        errorMap.put("BindException", "CT-Bind");
        errorMap.put("ConnectException", "CT-Ct");
        errorMap.put("HttpRetryException", "CT-HttpRetry");
        errorMap.put("MalformedURLException", "CT-MalURL");
        errorMap.put("NoRouteToHostException", "CT-NoRtToHost");
        errorMap.put("PortUnreachableException", "CT-PortUnr");
        errorMap.put("ProtocolException", "CT-Prtcl");
        errorMap.put("SocketException", "CT-St");
        errorMap.put("UnknownServiceException", "CT-UnkSrvc");
        errorMap.put("URISyntaxException", "CT-URISyntx");
        errorMap.put("SocketTimeoutException", "CTTO-StTO");
        errorMap.put("ConnectTimeoutException", "CTTO-CtTO");
        errorMap.put("SSLException", "SSL-SSL");
        errorMap.put("SSLHandshakeException", "SSL-HShake");
        errorMap.put("SSLKeyException", "SSL-Key");
        errorMap.put("SSLPeerUnverifiedException", "SSL-Peer");
        errorMap.put("SSLProtocolException", "SSL-Prtcl");
        errorMap.put("CharConversionException", "IO-Char");
        errorMap.put("EOFException", "IO-EOF");
        errorMap.put("FileNotFoundException", "IO-FileNF");
        errorMap.put("InterruptedIOException", "IO-IntIO");
        errorMap.put("InvalidClassException", "IO-InvClass");
        errorMap.put("InvalidObjectException", "IO-InvObj");
        errorMap.put("IOException", "IO-IO");
        errorMap.put("NotActiveException", "IO-NotAct");
        errorMap.put("NotSerializableException", "IO-NotSrlb");
        errorMap.put("ObjectStreamException", "IO-ObjStr");
        errorMap.put("OptionalDataException", "IO-OptData");
        errorMap.put("StreamCorruptedException", "IO-StrCrpted");
        errorMap.put("SyncFailedException", "IO-SyncFail");
        errorMap.put("UncheckedIOException", "IO-UncIO");
        errorMap.put("UnsupportedEncodingException", "IO-UnsupEnc");
        errorMap.put("UTFDataFormatException", "IO-UTFDataFrmt");
        errorMap.put("WriteAbortedException", "IO-WrtAbrt");
    }
}

