/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net.webkit;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@TargetApi(value=21)
public class AkaWebViewL21Client
extends WebViewClient {
    private static final String TAG = "AkaWebViewL21Client";
    private static HashSet<String> sMimeTypeSet = new HashSet();
    private static HashMap<Integer, String> sResponseMessageMap = new HashMap();
    CookieManager mCookieManager;

    public AkaWebViewL21Client() {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler instanceof CookieManager) {
            this.mCookieManager = (CookieManager)cookieHandler;
        } else {
            this.mCookieManager = new CookieManager();
            this.mCookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(this.mCookieManager);
        }
    }

    public final WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
        String string = webResourceRequest.getMethod();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equalsIgnoreCase("GET")) {
            return null;
        }
        String string2 = "";
        String string3 = webResourceRequest.getUrl().toString();
        String string4 = AkaHttpUtils.getFileExtensionFromUrl(string3);
        if (string4 != null) {
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string4);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (string4 != null && string4.equals("js")) {
                string2 = "application/x-javascript";
            }
            if (string4 != null && string4.equals("json")) {
                string2 = "application/json";
            }
        }
        if (TextUtils.isEmpty((CharSequence)string2) || webResourceRequest.getRequestHeaders() != null && webResourceRequest.getRequestHeaders().containsKey("Range")) {
            return null;
        }
        if (this.shouldLazyLoadRequest(webResourceRequest.getRequestHeaders(), string2)) {
            return new AkaWebResourceResponse(webResourceRequest, string2);
        }
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            URL uRL = new URL(string3);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            for (Map.Entry entry : webResourceRequest.getRequestHeaders().entrySet()) {
                httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Context context = VocAccelerator.getInstance().getAppContext();
            if (context != null) {
                httpURLConnection.setRequestProperty("X-Requested-With", context.getPackageName());
            }
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            string2 = httpURLConnection.getContentType();
            String string5 = httpURLConnection.getContentEncoding();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                object = string2.split(";");
                string2 = object[0];
                if (TextUtils.isEmpty((CharSequence)string5)) {
                    for (String string6 : object) {
                        if (!(string6 = string6.trim()).toLowerCase(Locale.ENGLISH).startsWith("charset=")) continue;
                        string5 = string6.substring("charset=".length());
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)string5)) {
                string5 = "UTF-8";
            }
            if (n2 >= 200 && n2 < 300) {
                Object object2 = object = !TextUtils.isEmpty((CharSequence)httpURLConnection.getResponseMessage()) ? httpURLConnection.getResponseMessage() : sResponseMessageMap.get(n2);
                if (TextUtils.isEmpty((CharSequence)object)) {
                    return null;
                }
                Map<String, String> map = AkaHttpUtils.convertToWebViewHeaders(httpURLConnection.getHeaderFields(), false);
                this.addCookiesIfNeeded(map, string3);
                return new WebResourceResponse(string2, string5, httpURLConnection.getResponseCode(), (String)object, map, httpURLConnection.getInputStream());
            }
            return null;
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            Logger.e((String)("AkaWebViewL21Client: Unable to process request: " + webResourceRequest.getUrl()), (Throwable)exception);
            return null;
        }
    }

    private boolean shouldLazyLoadRequest(Map<String, String> map, String string) {
        if (map == null || map.containsKey("Origin") || map.containsKey("Access-Control-Request-Headers") || map.containsKey("Access-Control-Request-Method")) {
            return false;
        }
        return string.startsWith("image/") || sMimeTypeSet.contains(string);
    }

    private void addCookiesIfNeeded(Map<String, String> map, String string) {
        try {
            URI uRI = new URI(string);
            List<HttpCookie> list = this.mCookieManager.getCookieStore().get(uRI);
            for (HttpCookie httpCookie : list) {
                if (httpCookie.hasExpired()) continue;
                map.put("Cookie", String.format("%s=%s; ", httpCookie.getName(), httpCookie.getValue()));
            }
        }
        catch (Exception exception) {
            Logger.d((String)"AkaWebViewL21Client Failed to construct URI ", (Throwable)exception);
        }
    }

    static {
        sMimeTypeSet.add("text/plain");
        sMimeTypeSet.add("text/xml");
        sMimeTypeSet.add("text/css");
        sMimeTypeSet.add("application/pdf");
        sMimeTypeSet.add("application/zip");
        sMimeTypeSet.add("application/json");
        sMimeTypeSet.add("application/x-font");
        sResponseMessageMap.put(200, "OK");
        sResponseMessageMap.put(201, "Created");
        sResponseMessageMap.put(202, "Accepted");
        sResponseMessageMap.put(203, "Non-Authoritative Information");
        sResponseMessageMap.put(204, "No Content");
        sResponseMessageMap.put(205, "Reset Content");
        sResponseMessageMap.put(206, "Partial Content");
        sResponseMessageMap.put(207, "Multi-Status");
        sResponseMessageMap.put(208, "Multi-Status");
        sResponseMessageMap.put(226, "IM Used");
    }

    private class AkaWebInputStream
    extends InputStream {
        private WebResourceRequest mResourceRequest;
        private WebResourceResponse mWebResourceResponse;
        private boolean mInitialized;
        private InputStream mInputStream;

        public AkaWebInputStream(WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
            this.mResourceRequest = webResourceRequest;
            this.mInitialized = false;
            this.mWebResourceResponse = webResourceResponse;
        }

        private void createUrlConnection() throws IOException {
            block5: {
                try {
                    if (!this.mInitialized) {
                        URL uRL = new URL(this.mResourceRequest.getUrl().toString());
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        for (Map.Entry entry : this.mResourceRequest.getRequestHeaders().entrySet()) {
                            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        Context context = VocAccelerator.getInstance().getAppContext();
                        if (context != null) {
                            httpURLConnection.setRequestProperty("X-Requested-With", context.getPackageName());
                        }
                        this.mWebResourceResponse.setMimeType(httpURLConnection.getContentType());
                        this.mWebResourceResponse.setEncoding(httpURLConnection.getContentEncoding());
                        this.mWebResourceResponse.setResponseHeaders(AkaHttpUtils.convertToWebViewHeaders(httpURLConnection.getHeaderFields(), false));
                        this.mInputStream = httpURLConnection.getInputStream();
                        this.mInitialized = true;
                    }
                }
                catch (Exception exception) {
                    if (!(exception instanceof IOException)) break block5;
                    throw exception;
                }
            }
        }

        @Override
        public void mark(int n2) {
            if (this.mInitialized && this.mInputStream != null) {
                this.mInputStream.mark(n2);
            }
        }

        @Override
        public boolean markSupported() {
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.markSupported();
            }
            return super.markSupported();
        }

        @Override
        public int available() throws IOException {
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.available();
            }
            return super.available();
        }

        @Override
        public long skip(long l2) throws IOException {
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.skip(l2);
            }
            return super.skip(l2);
        }

        @Override
        public void close() throws IOException {
            if (this.mInitialized && this.mInputStream != null) {
                this.mInputStream.close();
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.mInitialized && this.mInputStream != null) {
                this.mInputStream.reset();
            }
        }

        @Override
        public int read(@NonNull byte[] byArray) throws IOException {
            this.createUrlConnection();
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.read(byArray);
            }
            return -1;
        }

        @Override
        public int read(@NonNull byte[] byArray, int n2, int n3) throws IOException {
            this.createUrlConnection();
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.read(byArray, n2, n3);
            }
            return -1;
        }

        @Override
        public int read() throws IOException {
            this.createUrlConnection();
            if (this.mInitialized && this.mInputStream != null) {
                return this.mInputStream.read();
            }
            return -1;
        }
    }

    private class AkaWebResourceResponse
    extends WebResourceResponse {
        private WebResourceRequest mWebRequest;

        public AkaWebResourceResponse(WebResourceRequest webResourceRequest, String string) {
            super(string, "UTF-8", null);
            this.mWebRequest = webResourceRequest;
        }

        public InputStream getData() {
            return new AkaWebInputStream(this.mWebRequest, this);
        }

        public String getEncoding() {
            String string = super.getEncoding();
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "UTF-8";
            }
            return string;
        }

        public Map<String, String> getResponseHeaders() {
            HashMap<String, String> hashMap = super.getResponseHeaders();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            AkaWebViewL21Client.this.addCookiesIfNeeded(hashMap, this.mWebRequest.getUrl().toString());
            return hashMap;
        }
    }
}

