/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AnaFeedController;
import com.akamai.android.sdk.util.AnaUtils;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class AkaCryptoHandler {
    private final Context mContext;
    private final int SHARED_KEY_SZ_BYTES = 16;
    private static final Object sLock = new Object();
    private static final String LOG_TAG = "AKC";

    AkaCryptoHandler(Context context) {
        this.mContext = context;
    }

    protected Cipher getCipher(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new UnsupportedOperationException("Only mode ENCRYPT and DECRYPT supported");
        }
        Cipher cipher = null;
        byte[] byArray = this.getKey();
        if (byArray == null && n2 == 1) {
            this.storeKey();
            byArray = this.getKey();
        }
        if (byArray != null) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            try {
                cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
                byte[] byArray2 = this.generateSalt();
                cipher.init(n2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeKey() {
        Object object = sLock;
        synchronized (object) {
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
            String string = sharedPreferences.getString("skey", null);
            if (TextUtils.isEmpty((CharSequence)string)) {
                byte[] byArray = this.saltedKey(this.generateKey(), this.generateSalt());
                if (byArray != null) {
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString("skey", Base64.encodeToString((byte[])byArray, (int)2));
                    editor.apply();
                }
            } else if (this.isUsingRSAKeys()) {
                byte[] byArray = Base64.decode((byte[])string.getBytes(), (int)2);
                PrivateKey privateKey = this.getRSAPrivateKey();
                try {
                    Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(2, privateKey);
                    byte[] byArray2 = cipher.doFinal(byArray);
                    this.deleteRSAKeyAndStoreSaltedKey(byArray2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.e((String)"AKC: Clear existing keys");
                    this.removeRSAKeys(true);
                }
            }
        }
    }

    private void removeRSAKeys(boolean bl2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean("ks_in_use", false);
        if (bl2) {
            editor.remove("skey");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AnaFeedController.clearHttpsWebContent(AkaCryptoHandler.this.mContext);
                }
            }).start();
        }
        editor.apply();
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.deleteEntry("aK@mA!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deleteRSAKeyAndStoreSaltedKey(byte[] byArray) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("skey", Base64.encodeToString((byte[])byArray, (int)2));
        editor.putBoolean("ks_in_use", false);
        editor.apply();
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.deleteEntry("aK@mA!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private PrivateKey getRSAPrivateKey() {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            if (keyStore.containsAlias("aK@mA!")) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("aK@mA!", null);
                return privateKeyEntry.getPrivateKey();
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AKC: Unable to get private key.");
            exception.printStackTrace();
        }
        return null;
    }

    private boolean isUsingRSAKeys() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        boolean bl2 = sharedPreferences.getBoolean("ks_in_use", false);
        if (bl2) {
            try {
                KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
                boolean bl3 = keyStore.containsAlias("aK@mA!");
                if (!bl3) {
                    Logger.e((String)"AKC: KS purged...clear existing keys");
                    this.removeRSAKeys(true);
                }
                return bl3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getKey() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        String string = sharedPreferences.getString("skey", null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Object object = sLock;
            synchronized (object) {
                if (this.isUsingRSAKeys()) {
                    byte[] byArray = Base64.decode((byte[])string.getBytes(), (int)2);
                    PrivateKey privateKey = this.getRSAPrivateKey();
                    try {
                        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                        cipher.init(2, privateKey);
                        byte[] byArray2 = cipher.doFinal(byArray);
                        this.deleteRSAKeyAndStoreSaltedKey(byArray2);
                        return this.saltedKey(byArray2, this.generateSalt());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Logger.e((String)"AKC: Clear existing keys");
                        this.removeRSAKeys(true);
                        return null;
                    }
                }
            }
            string = sharedPreferences.getString("skey", null);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return this.saltedKey(Base64.decode((byte[])string.getBytes(), (int)2), this.generateSalt());
            }
        }
        return null;
    }

    private byte[] saltedKey(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return null;
        }
        byte[] byArray3 = new byte[16];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        return byArray3;
    }

    private byte[] generateKey() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128, secureRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private byte[] generateSalt() {
        String string = this.generateUniqueString();
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[16];
        int n2 = 16;
        if (byArray.length < 16) {
            n2 = byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @SuppressLint(value={"HardwareIds"})
    private String generateUniqueString() {
        String string = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id") + this.mContext.getPackageName() + "1@2#3$4%s@t3lL1T";
        char[] cArray = new char[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            cArray[i2] = (i2 & 1) == 0 ? string.charAt(i2) : Character.reverseBytes(string.charAt(i2));
        }
        return new String(cArray);
    }
}

