/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.model;

import android.database.Cursor;
import android.text.TextUtils;
import com.akamai.android.sdk.Logger;
import org.json.JSONObject;

public class VocFeedPolicy {
    private static final String TAG = "FeedPolicy";
    private static final String DISPLAYWHENOFFLINE = "displayWhenOffline";
    private static final String MINCONTENTEXPIRY = "minContentExpiry";
    private static final String TYPE = "type";
    private String policyId;
    private String policyType;
    private boolean displayWhenOffline = true;
    private int minContentExpiryInSec = 0;

    public VocFeedPolicy(String string, JSONObject jSONObject) {
        this.policyId = string;
        if (jSONObject != null) {
            this.policyType = this.getPolicyType(jSONObject);
            this.displayWhenOffline = this.getDisplayWhenOffline(jSONObject);
        }
    }

    private boolean getDisplayWhenOffline(JSONObject jSONObject) {
        boolean bl2 = true;
        try {
            bl2 = Boolean.parseBoolean(jSONObject.getString(DISPLAYWHENOFFLINE));
        }
        catch (Exception exception) {
            Logger.e((String)"FeedPolicy: Invalid display when offline", (Throwable)exception);
        }
        return bl2;
    }

    private String getPolicyType(JSONObject jSONObject) {
        String string = null;
        try {
            string = jSONObject.getString(TYPE);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            string = string.replaceAll("\\s+", "").toLowerCase();
        }
        catch (Exception exception) {
            Logger.e((String)"FeedPolicy: Invalid policy type", (Throwable)exception);
        }
        return string;
    }

    public VocFeedPolicy(Cursor cursor) {
        if (cursor != null) {
            this.policyId = cursor.getString(cursor.getColumnIndex("policyid"));
            this.policyType = cursor.getString(cursor.getColumnIndex("policytype"));
            int n2 = cursor.getInt(cursor.getColumnIndex("displaywhenoffline"));
            this.displayWhenOffline = n2 == 1;
            this.minContentExpiryInSec = cursor.getInt(cursor.getColumnIndex("mincontentexpiry"));
        }
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public boolean isDisplayWhenOffline() {
        return this.displayWhenOffline;
    }

    public int getMinContentExpiryInSec() {
        return this.minContentExpiryInSec;
    }

    public void setMinContentExpiryInSec(int n2) {
        this.minContentExpiryInSec = n2;
    }

    public String toString() {
        return "FeedPolicy = policyId: " + this.policyId + ", policyType: " + this.policyType + ", displayWhenOffline: " + this.displayWhenOffline;
    }
}

