/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AbstractContentDownloader;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AnaDownloadManager;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.AnaResourceDownloadRunnable;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class AkaWebContentDownloader
extends AbstractContentDownloader {
    private static final String LOG_TAG = "AkaWebContentDownloader";

    AkaWebContentDownloader(Context context) {
        super(context);
    }

    @Override
    protected void downloadWebContent() {
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("preposition", true);
        boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false);
        if (AnaUtils.isPrefetchAllowed(this.mContext) && (bl2 || bl3)) {
            Object object;
            Object object2;
            this.mDownloadPolicyManager.verifyDayUsageTimestamp();
            this.mDownloadPolicyManager.dailyUsagePrefs();
            String string = null;
            Cursor cursor = this.mContext.getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_FEEDS.toString()), null, "syncPending=?", new String[]{String.valueOf(0)}, string);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        object2 = new AnaFeedItem(cursor);
                        boolean bl4 = AkaSessionHandler.isFgSegment(((AnaFeedItem)object2).getSegment());
                        if (!bl3 && bl4 || !bl2 && !bl4) continue;
                        linkedList.add(object2);
                        cursor.moveToNext();
                    }
                }
                cursor.close();
            }
            object2 = new ArrayList();
            LinkedHashMap<String, AnaFeedItem> linkedHashMap = new LinkedHashMap<String, AnaFeedItem>();
            long l2 = 0L;
            int n2 = this.mDownloadPolicyManager.isDownloadPermitted();
            if (n2 == 0) {
                boolean bl5 = VocAccelerator.getInstance().isAppInForeground();
                boolean bl6 = false;
                object = new ArrayList();
                while (!linkedList.isEmpty()) {
                    AnaFeedItem anaFeedItem = (AnaFeedItem)linkedList.remove();
                    if (linkedHashMap.containsKey(anaFeedItem.getId()) || !bl5 && !TextUtils.isEmpty((CharSequence)anaFeedItem.getSegment()) && AkaSessionHandler.isFgSegment(anaFeedItem.getSegment())) continue;
                    long l3 = anaFeedItem.getSize();
                    n2 = AnaResourceDownloadRunnable.isDownloadPolicyAllowed(this.mContext, this.mDownloadPolicyManager, l2 + l3, anaFeedItem);
                    if (n2 == 0) {
                        l2 += l3;
                        linkedHashMap.put(anaFeedItem.getId(), anaFeedItem);
                        continue;
                    }
                    if (n2 == 9) continue;
                    break;
                }
            }
            Logger.d((String)("AkaWebContentDownloader: WebContent: Queued for download, no of items" + linkedHashMap.size() + ", policy  " + n2));
            object2.addAll(linkedHashMap.keySet());
            ContentValues contentValues = new ContentValues();
            contentValues.put("hidden", Integer.valueOf(0));
            this.mContext.getContentResolver().update(AnaProviderContract.CONTENT_URI_FEEDS, contentValues, AnaProviderContract.getIdSelectionClause((List<String>)object2), null);
            AnaDownloadManager anaDownloadManager = AnaDownloadManager.getInstance(this.mContext);
            object = anaDownloadManager.downloadGenericFeeds(linkedHashMap);
            try {
                object.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            anaDownloadManager.clearFeeds();
            Logger.d((String)"AkaWebContentDownloader: WebContent: Done");
        } else {
            Logger.d((String)"AkaWebContentDownloader: WebContent: prefetch not allowed");
        }
    }

    public static Set<String> pruneCacheIfNeeded(Context context, AnaDownloadPolicyManager anaDownloadPolicyManager) {
        return AkaWebContentDownloader.pruneFeedIds(context, new HashSet<String>(), anaDownloadPolicyManager);
    }
}

