/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.internal.AkaCacheHandler;
import com.akamai.android.sdk.internal.AkaConfigHandler;
import com.akamai.android.sdk.internal.AkaInterceptorHandler;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSegmentManifestParser;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaStatusHelper;
import com.akamai.android.sdk.internal.AkaWebAnalyticsHandler;
import com.akamai.android.sdk.internal.AkaWebContentDownloader;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.ICacheSyncController;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class AkaSyncController
implements ICacheSyncController {
    private static final String LOG_TAG = "AkaSyncController";
    private static AkaSyncController sInstance;
    private static volatile boolean sSyncInProgress;
    private final Context mAppContext;
    private final AkaWebContentDownloader mWebContentDownloader;
    private final AkaSegmentManifestDownloader mSegmentManifestDownloader;
    private final AkaBackgroundService mService;
    private final AnaDownloadPolicyManager mDownloadPolicyManager;

    public static synchronized AkaSyncController getInstance(Context context, AkaBackgroundService akaBackgroundService) {
        if (sInstance == null) {
            sInstance = new AkaSyncController(context, akaBackgroundService);
        }
        return sInstance;
    }

    private AkaSyncController(Context context, AkaBackgroundService akaBackgroundService) {
        this.mAppContext = context;
        this.mWebContentDownloader = new AkaWebContentDownloader(context);
        this.mSegmentManifestDownloader = AkaSegmentManifestDownloader.getInstance(context);
        this.mService = akaBackgroundService;
        this.mDownloadPolicyManager = new AnaDownloadPolicyManager((Context)this.mService);
    }

    @Override
    public boolean downloadMetadata() {
        return this.mSegmentManifestDownloader.downloadMetaData();
    }

    @Override
    public void downloadWebContent() {
        this.mWebContentDownloader.downloadWebContent();
    }

    @Override
    public void parseManifestAndInsertToDb() {
        AkaSegmentManifestParser akaSegmentManifestParser = new AkaSegmentManifestParser(this.mAppContext);
        akaSegmentManifestParser.parseManifestAndInsertToDb();
    }

    @Override
    public void getConfig() {
        try {
            AkaConfigHandler akaConfigHandler = new AkaConfigHandler(this.mAppContext);
            JSONObject jSONObject = akaConfigHandler.getConfig();
            if (jSONObject != null) {
                akaConfigHandler.updateConfig(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sync(String string, boolean bl2) {
        try {
            if (AkaSyncController.isSyncInProgress()) {
                Logger.e((String)"AkaSyncController: Sync already in progress");
                return;
            }
            if (!this.mDownloadPolicyManager.isNetworkAvailable()) {
                Logger.e((String)"AkaSyncController: No network available");
                return;
            }
            AkaSyncController.setSyncInProgress(true);
            if (AkaConfigHandler.isConfigSyncAllowed(this.mAppContext, string) || bl2) {
                Logger.d((String)"AkaSyncController: Performing Full sync");
                this.fullSync();
            } else {
                Logger.d((String)"AkaSyncController: Performing Cache sync");
                this.cacheSync();
            }
        }
        finally {
            AkaSyncController.setSyncInProgress(false);
        }
    }

    private void cacheSync() {
        if (!AkaSessionHandler.isEnabled()) {
            Logger.e((String)"AkaSyncController: sync: SDK is not active");
            return;
        }
        int n2 = this.mDownloadPolicyManager.isDownloadPermitted();
        if (n2 == 0) {
            this.mService.sendBroadcast(AkaStatusHelper.createCacheSyncStartIntent(this.mAppContext));
            this.updateCacheTime(System.currentTimeMillis());
            boolean bl2 = this.downloadMetadata();
            if (bl2) {
                this.parseManifestAndInsertToDb();
            }
            this.downloadWebContent();
            this.mService.sendBroadcast(AkaStatusHelper.createCacheSyncDoneIntent(this.mAppContext));
        } else {
            Logger.dd((String)("AkaSyncController: fullSync, policy failure: " + AnaDownloadPolicyManager.valueOf(n2)));
        }
    }

    private void fullSync() {
        AkaWebAnalyticsHandler.sendWebAnalytics(this.mAppContext);
        this.getConfig();
        this.cacheSync();
    }

    public static synchronized boolean isSyncInProgress() {
        return sSyncInProgress;
    }

    public static synchronized void setSyncInProgress(boolean bl2) {
        sSyncInProgress = bl2;
    }

    private void updateCacheTime(long l2) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mAppContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_cache_fill", l2);
        editor.apply();
    }

    public void clearCache(Context context) {
        AkaCacheHandler.clearCache(context, false);
    }

    public void resetSdkForNewApiKey(Context context) {
        AkaInterceptorHandler.removeCookies();
        AkaSegmentManifestDownloader.removeData(context);
        this.clearCache(context);
        this.fullSync();
    }

    static {
        sSyncInProgress = false;
    }
}

