/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.app.JobIntentService;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaSyncController;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.concurrent.TimeUnit;

public class AkaBackgroundService
extends JobIntentService {
    private static final String LOG_TAG = "AkaBackgroundService";
    public static final long NOTIFICATION_INTENT_INTERVAL_MS = "production".equals("mock") ? 2000L : TimeUnit.MINUTES.toMillis(1L);
    public static final long FOREGROUND_SYNC_INTERVAL_SEC = "production".equals("mock") ? 0L : TimeUnit.MINUTES.toMillis(5L);
    private static final int JOB_ID = 7853;

    public static synchronized void enqueueWork(Context context, Intent intent) {
        try {
            if (!AkaBackgroundService.shouldEnqueueIntent(context, intent)) {
                Logger.d((String)("AkaBackgroundService: " + intent.getAction() + " called within interval"));
                return;
            }
            AkaBackgroundService.updateIntentQueueTs(context, intent.getAction());
            AkaBackgroundService.enqueueWork((Context)context, AkaBackgroundService.class, (int)7853, (Intent)intent);
        }
        catch (Exception exception) {
            Logger.e((String)("Enqueue work exception " + exception));
        }
    }

    protected void onHandleWork(@NonNull Intent intent) {
        if (intent == null || intent.getAction() == null) {
            return;
        }
        Context context = this.getApplicationContext();
        AkaSyncController akaSyncController = AkaSyncController.getInstance(context, this);
        AnaProviderContract.initialize(context);
        String string = intent.getAction();
        Logger.d((String)("AkaBackgroundService: " + string));
        boolean bl2 = true;
        switch (string) {
            case "com.akamai.anaina.INIT_CACHE": {
                bl2 = false;
            }
            case "com.akamai.anaina.FULL_SYNC": {
                String string2 = AkaBackgroundService.getNotificationData(intent, context);
                if (!string2.isEmpty()) {
                    SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(context).edit();
                    editor.putLong("fcm_recv_ts", AnaUtils.getCurrentUTCTimeInMillis());
                    editor.apply();
                    Logger.dd((String)("AkaBackgroundService: Notification data: " + string2));
                } else {
                    Logger.dd((String)"AkaBackgroundService: Foreground sync");
                }
                akaSyncController.sync(string2, bl2);
                break;
            }
            case "com.akamai.anaina.CLEAR_CACHE": {
                Logger.d((String)"AkaBackgroundService: Clear cache request");
                akaSyncController.clearCache((Context)this);
                break;
            }
            case "com.akamai.anaina.RESET_SDK": {
                Logger.d((String)"AkaBackgroundService: Reset SDK to handle new API key");
                akaSyncController.resetSdkForNewApiKey((Context)this);
                break;
            }
            default: {
                Logger.e((String)("AkaBackgroundService: Incorrect Action " + string));
            }
        }
    }

    private static String getNotificationData(@NonNull Intent intent, Context context) {
        String string = "";
        if (intent.hasExtra("mapsdk")) {
            string = intent.getStringExtra("mapsdk");
        }
        return string;
    }

    private static boolean shouldEnqueueIntent(Context context, Intent intent) {
        if (AkaSessionHandler.isKilled() && !intent.getAction().equals("com.akamai.anaina.CLEAR_CACHE")) {
            Logger.e((String)"AkaBackgroundService: sync: SDK is not active");
            return false;
        }
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        long l2 = 0L;
        if (intent != null && intent.getAction() != null) {
            if ("com.akamai.anaina.FULL_SYNC".equals(intent.getAction())) {
                l2 = sharedPreferences.getLong("com.akamai.anaina.FULL_SYNC", 0L);
                String string = AkaBackgroundService.getNotificationData(intent, context);
                if (!string.isEmpty()) {
                    AkaLogger.in((String)"Sync attempted by Notification");
                    return AnaUtils.getCurrentUTCTimeInMillis() - l2 > NOTIFICATION_INTENT_INTERVAL_MS;
                }
                return AnaUtils.getCurrentUTCTimeInMillis() - l2 > FOREGROUND_SYNC_INTERVAL_SEC;
            }
            return true;
        }
        return true;
    }

    private static void updateIntentQueueTs(Context context, String string) {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(string, System.currentTimeMillis());
        editor.apply();
    }

    public static synchronized boolean performCacheFill(Context context) {
        boolean bl2 = AkaSyncController.isSyncInProgress();
        if (!bl2) {
            Intent intent = new Intent(context, AkaBackgroundService.class);
            intent.setAction("com.akamai.anaina.INIT_CACHE");
            AkaBackgroundService.enqueueWork(context, intent);
        } else {
            Logger.d((String)"AkaBackgroundService Sync in progress");
        }
        return !bl2;
    }

    public static synchronized boolean performFullSync(Context context, String string) {
        boolean bl2 = AkaSyncController.isSyncInProgress();
        if (!bl2) {
            Intent intent = new Intent(context, AkaBackgroundService.class);
            intent.setAction("com.akamai.anaina.FULL_SYNC");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                intent.putExtra("mapsdk", string);
            }
            AkaBackgroundService.enqueueWork(context, intent);
        } else {
            Logger.d((String)"AkaBackgroundService Sync in progress");
        }
        return !bl2;
    }

    public static synchronized boolean resetSdkForNewApiKey(Context context) {
        boolean bl2 = AkaSyncController.isSyncInProgress();
        if (!bl2) {
            Intent intent = new Intent(context, AkaBackgroundService.class);
            intent.setAction("com.akamai.anaina.RESET_SDK");
            AkaBackgroundService.enqueueWork(context, intent);
        } else {
            Logger.d((String)"AkaBackgroundService Sync in progress");
        }
        return !bl2;
    }
}

