/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.net.Uri;
import android.text.TextUtils;
import com.akamai.android.sdk.AkaMap;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaDatabaseSchema;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.model.AnaContentSource;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

class AnaDatabaseAccess {
    private SQLiteDatabase database;
    private final AnaDatabaseSchema databaseHelper;
    private static final int SQLITE_ERROR = -1;
    private static final String LOG_TAG = "AnaDatabaseAccess";
    private final Context mContext;
    private final String[] feedItemColumns = new String[]{"_id", "provider", "title", "summary", "thumbfile", "url", "videofile", "feedtype", "size", "timestamp", "resourceready", "duration", "preference", "viewbookmark", "viewcount", "expirydate", "saved", "priority", "hidden", "shareurl", "creationtimestamp", "categories", "adserver", "tags", "preferredstream", "source", "metadata", "status", "keyserver", "drmstatus", "parentid", "scope", "childid", "responseheaders", "policyid", "refreshtimestamp", "maxage", "persisttoexpiration", "paused", "contentId", "lowcost_map_use", "lowcost_map_url", "lowcost_map_host", "sourcePath", "syncPending", "downloadState", "bytesDownloaded", "downloadFailureErrorCode", "markForDownloadTimestamp", "downloadCompletionTimestamp", "accessts", "drmfile", "maxdurationtocache", "storagePreference", "downloadInitiatedTimestamp", "preferredquality", "availability_ts", "segment"};
    private final String[] contentSourceColumns = new String[]{"_id", "name", "url", "subscribed", "thumbfile", "signinrequired", "urlAuthRequired", "description", "language"};
    private final String[] httpStatsColumns = new String[]{"_id", "feedid", "url", "downloadtype", "timestamp", "duration", "ttfb", "batterylevel", "ischarging", "connectiontype", "location", "signalstrength", "respcode", "requestheadersize", "responseheadersize", "contentlength", "mimetype", "mptype", "mpmethod", "mpwinner", "serverprofile", "amcid", "quicEnabled", "requestType", "v4Tries", "v6Tries", "contentLengthHeader", "maxRwnd", "brotliEnabled", "brotliUsed", "cacheable", "tpResult", "sessionId", "exceptionMessage", "precached", "redirected"};
    private final String[] sessionStatsColumns = new String[]{"_id", "timestamp", "duration", "name"};
    private final String[] userEventColumns = new String[]{"_id", "name", "starttime", "stoptime", "connectiontype", "sessionId"};
    private final String[] eventLogColumns = new String[]{"_id", "name", "timestamp", "sessionId"};
    private final String[] feedPolicyColumns = new String[]{"policyid", "policytype", "displaywhenoffline", "mincontentexpiry"};
    private final String[] segmentSubscriptionColumns = new String[]{"sgmntlname", "sgmntsname", "httpts", "timestamp", "subscribed", "downloadManifestTS", "fgSegment"};
    private final String[] deletedFeedsColumns = new String[]{"_id", "timestamp"};
    private final String[] messageListColumns = new String[]{"endpoint", "frequency", "timestamp"};

    AnaDatabaseAccess(Context context) {
        this.mContext = context;
        this.databaseHelper = new AnaDatabaseSchema(context, (DatabaseErrorHandler)new DefaultDatabaseErrorHandler());
    }

    public synchronized void open() throws SQLException {
        try {
            this.database = this.databaseHelper.getWritableDatabase();
            this.database.execSQL("PRAGMA foreign_keys=ON");
            this.database.execSQL("VACUUM");
        }
        catch (SQLException sQLException) {
            Logger.e((String)"AnaDatabaseAccess: open: ", (Throwable)sQLException);
            AnaUtils.getSDKSharedPreferences(this.mContext).edit().putLong("last_db_corruption_ts", Calendar.getInstance(TimeZone.getTimeZone("utc")).getTimeInMillis()).apply();
            if (this.database == null) {
                String string = this.mContext.getDatabasePath("feed.db").getPath();
                this.deleteFile(string);
                this.deleteFile(string + "-journal");
                this.deleteFile(string + "-shm");
                this.deleteFile(string + "-wal");
                try {
                    this.database = this.databaseHelper.getWritableDatabase();
                    this.database.execSQL("PRAGMA foreign_keys=ON");
                    this.database.execSQL("VACUUM");
                }
                catch (Exception exception) {
                    Logger.e((String)"AnaDatabaseAccess: open: exception within exception handling: ", (Throwable)exception);
                }
                AkaMap.getInstance().clearMapCache();
            }
            this.database.close();
            this.database = null;
        }
        catch (Exception exception) {
            Logger.e((String)"AnaDatabaseAccess: open: Non SQL exception: ", (Throwable)exception);
        }
    }

    private void deleteFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        file.delete();
    }

    private void close() {
        this.databaseHelper.close();
    }

    public Uri addFeedItem(ContentValues contentValues) {
        Uri uri = null;
        try {
            this.database.insertOrThrow("feeditem", null, contentValues);
            uri = Uri.parse((String)("feeditems/" + contentValues.getAsString("_id")));
            VocAccelerator.getInstance().onInsert(contentValues.getAsString("_id"), contentValues.getAsString("url"));
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return uri;
    }

    public boolean addContentSource(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            this.database.insertOrThrow("contentsource", null, contentValues);
            bl2 = true;
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public int updateFeed(String string, ContentValues contentValues, String string2, String[] stringArray) {
        int n2 = 0;
        try {
            n2 = string2 != null && !string2.isEmpty() ? this.database.update("feeditem", contentValues, "_id='" + string + "'" + " and " + string2, stringArray) : this.database.update("feeditem", contentValues, "_id='" + string + "'", null);
            if (n2 == 1 && contentValues.containsKey("resourceready")) {
                VocAccelerator.getInstance().onUpdate(string, contentValues.getAsBoolean("resourceready"));
            }
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return n2;
    }

    public int updateFeeds(ContentValues contentValues, String string, String[] stringArray) {
        int n2 = 0;
        try {
            n2 = this.database.update("feeditem", contentValues, string, stringArray);
        }
        catch (SQLiteFullException sQLiteFullException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLiteFullException.toString()));
            this.handleDiskIOError();
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return n2;
    }

    public int updateContentSource(String string, ContentValues contentValues, String string2, String[] stringArray) {
        if (string2 != null && !string2.isEmpty()) {
            return this.database.update("contentsource", contentValues, "_id='" + string + "'" + " and " + string2, stringArray);
        }
        return this.database.update("contentsource", contentValues, "_id='" + string + "'", null);
    }

    public int updateFeedStats(ContentValues contentValues, String string, String[] stringArray) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.database.update("feeditem", contentValues, string, stringArray);
        }
        return this.database.update("feeditem", contentValues, null, null);
    }

    public int updateMessageList(ContentValues contentValues, String string, String[] stringArray) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.database.update("messagelist", contentValues, string, stringArray);
        }
        return this.database.update("messagelist", contentValues, null, null);
    }

    public void delete(AnaFeedItem anaFeedItem) {
        String string = anaFeedItem.getId();
        this.database.delete("feeditem", "_id = " + string, null);
    }

    public void delete(AnaContentSource anaContentSource) {
        String string = anaContentSource.getId();
        this.database.delete("contentsource", "_id = " + this.quotifyString(string), null);
    }

    public void deleteFeedItem(String string) {
        this.database.delete("feeditem", "_id = " + this.quotifyString(string), null);
    }

    public int deleteFeeds(String string, String[] stringArray) {
        int n2;
        if (string == null || string.isEmpty()) {
            n2 = this.database.delete("feeditem", null, null);
            VocAccelerator.getInstance().onClearCache();
        } else {
            n2 = this.database.delete("feeditem", string, stringArray);
        }
        return n2;
    }

    public int deleteFeedPolicy() {
        int n2 = this.database.delete("feedpolicy", null, null);
        return n2;
    }

    public int deleteSegment(String string, String[] stringArray) {
        int n2 = string == null || string.isEmpty() ? this.database.delete("segment", null, null) : this.database.delete("segment", string, stringArray);
        return n2;
    }

    public int deleteDeletedFeeds(String string, String[] stringArray) {
        if (string == null || string.isEmpty()) {
            return this.database.delete("deletedfeeds", null, null);
        }
        return this.database.delete("deletedfeeds", string, stringArray);
    }

    public int deleteMessageList(String string, String[] stringArray) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.database.delete("messagelist", string, stringArray);
        }
        return this.database.delete("messagelist", null, null);
    }

    public Cursor getFeedItems(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = this.feedItemColumns;
        }
        Cursor cursor = string2 != null && !string2.isEmpty() ? this.database.query("feeditem", stringArray, string, stringArray2, null, null, string2, null) : this.database.query("feeditem", stringArray, string, stringArray2, null, null, "timestamp DESC", null);
        return cursor;
    }

    public Cursor getFilteredCount(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count (*) from ");
        stringBuffer.append("feeditem");
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string);
        Cursor cursor = this.database.rawQuery(stringBuffer.toString(), stringArray2);
        return cursor;
    }

    public Cursor getFilteredFeedItems(Uri uri, String string) {
        Iterator iterator;
        Cursor cursor = null;
        Set set = uri.getQueryParameterNames();
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = " AND ";
        String[] stringArray = null;
        String string3 = null;
        String string4 = null;
        boolean bl2 = false;
        stringBuffer.append("hidden");
        stringBuffer.append("=");
        stringBuffer.append(0);
        if (string != null && !string.isEmpty()) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((iterator = set.iterator()).hasNext()) {
            stringBuffer.append(string2);
        }
        while (iterator.hasNext()) {
            String string5;
            String string6 = (String)iterator.next();
            if (string6.equals("provider") && (string5 = uri.getQueryParameter(string6)) != null && !string5.isEmpty()) {
                stringBuffer.append("provider");
                stringBuffer.append(" = ");
                stringBuffer.append(this.quotifyString(string5));
            }
            if (string6.equals("resourceready") && (string5 = uri.getQueryParameter(string6)) != null && !string5.isEmpty()) {
                stringBuffer.append("resourceready");
                if (string5.equals("true")) {
                    stringBuffer.append(" !='0' ");
                } else {
                    stringBuffer.append(" ='0' ");
                }
            }
            if (string6.equals("categories") && (string5 = uri.getQueryParameter(string6)) != null && !string5.isEmpty()) {
                if (string5.endsWith("Saved")) {
                    stringBuffer.append("saved");
                    stringBuffer.append(" = ");
                    stringBuffer.append(1);
                } else {
                    stringBuffer.append("categories");
                    stringBuffer.append(" LIKE  '%");
                    stringBuffer.append(string5);
                    stringBuffer.append("%'");
                }
            }
            if (string6.equals("scope") && !TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter(string6)))) {
                stringBuffer.append("scope");
                stringBuffer.append(" = ");
                stringBuffer.append(this.quotifyString(string5));
            }
            if (string6.equals("title") && (string3 = uri.getQueryParameter(string6)) != null && !string3.isEmpty()) {
                stringBuffer.append("(");
                stringBuffer.append("title");
                stringBuffer.append(" LIKE  ?");
                string2 = " OR ";
                bl2 = true;
            }
            if (string6.equals("summary") && (string4 = uri.getQueryParameter(string6)) != null && !string4.isEmpty()) {
                stringBuffer.append("summary");
                stringBuffer.append(" LIKE  ?");
                stringBuffer.append(")");
                string2 = " OR ";
                bl2 = true;
            }
            if (string6.equals("tags") && (string5 = uri.getQueryParameter(string6)) != null && !string5.isEmpty()) {
                stringBuffer.append("tags");
                stringBuffer.append(" LIKE  '%");
                stringBuffer.append(string5);
                stringBuffer.append("%'");
                string2 = " OR ";
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string2);
        }
        if (bl2) {
            stringArray = new String[]{"%" + string3 + "%", "%" + string4 + "%"};
        }
        cursor = this.database.query("feeditem", this.feedItemColumns, stringBuffer.toString(), stringArray, null, null, "timestamp DESC", null);
        return cursor;
    }

    public Cursor getContentSources(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("contentsource", this.contentSourceColumns, string, stringArray2, null, null, "_id ASC", null);
        return cursor;
    }

    public Cursor getFeedItem(String string) {
        Cursor cursor = this.database.query("feeditem", this.feedItemColumns, "_id = '" + string + "'", null, null, null, "_id DESC", null);
        return cursor;
    }

    public Cursor getContentSource(String string) {
        Cursor cursor = this.database.query("contentsource", this.contentSourceColumns, "_id = '" + string + "'", null, null, null, "_id DESC", null);
        return cursor;
    }

    public Cursor getHttpConsumptionStats(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals("count (*)")) {
            return this.getCountOfHttpConsumptionStats(string, stringArray2);
        }
        Cursor cursor = this.database.query("httpstats", this.httpStatsColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    private Cursor getCountOfHttpConsumptionStats(String string, String[] stringArray) {
        String string2 = "SELECT count (*) from httpstats WHERE " + string;
        return this.database.rawQuery(string2, stringArray);
    }

    public Cursor getSessionStats(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("sessionstats", this.sessionStatsColumns, string, stringArray2, null, null, "timestamp ASC", null);
        return cursor;
    }

    public Cursor getUserEvents(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("userevents", this.userEventColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public Cursor getEventLogs(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("eventlog", this.eventLogColumns, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public Cursor getFeedPolicy(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = this.database.query("feedpolicy", this.feedPolicyColumns, string, stringArray2, null, null, null, null);
        return cursor;
    }

    public Cursor getSegment(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return this.database.query("segment", this.segmentSubscriptionColumns, string, stringArray2, null, null, null, null);
    }

    public Cursor getDeletedFeeds(Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        if (stringArray == null) {
            stringArray = this.deletedFeedsColumns;
        }
        if (string2 == null) {
            string2 = "timestamp ASC";
        }
        Cursor cursor = this.database.query("deletedfeeds", stringArray, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public Cursor getMessageList(String[] stringArray, String string, String[] stringArray2, String string2) {
        Cursor cursor = stringArray == null ? this.database.query("messagelist", this.messageListColumns, string, stringArray2, null, null, string2, null) : this.database.query("messagelist", stringArray, string, stringArray2, null, null, string2, null);
        return cursor;
    }

    public boolean addHttpConsumptionStats(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            if (this.database.insertOrThrow("httpstats", null, contentValues) != -1L) {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public boolean addSessionStats(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            if (this.database.insertOrThrow("sessionstats", null, contentValues) != -1L) {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public boolean addUserEvent(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            if (this.database.insertOrThrow("userevents", null, contentValues) != -1L) {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public boolean addEventLog(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            if (this.database.insertOrThrow("eventlog", null, contentValues) != -1L) {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public boolean addOrUpdateFeedPolicy(ContentValues contentValues) {
        boolean bl2 = false;
        try {
            String string = "INSERT OR REPLACE INTO feedpolicy VALUES ( " + this.quotifyString(contentValues.getAsString("policyid")) + "," + this.quotifyString(contentValues.getAsString("policytype")) + "," + contentValues.get("displaywhenoffline") + "," + contentValues.get("mincontentexpiry") + ")";
            this.database.execSQL(string);
            bl2 = true;
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: " + sQLException.toString()));
        }
        return bl2;
    }

    public void addOrUpdateSegment(ContentValues contentValues) {
        try {
            String string = "INSERT OR REPLACE INTO segment VALUES ( " + this.quotifyString(contentValues.getAsString("sgmntlname")) + "," + this.quotifyString(contentValues.getAsString("sgmntsname")) + "," + contentValues.get("timestamp") + "," + this.quotifyString(contentValues.getAsString("httpts")) + "," + contentValues.get("subscribed") + "," + contentValues.get("downloadManifestTS") + "," + contentValues.get("fgSegment") + ")";
            this.database.execSQL(string);
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: addOrUpdateSegment: " + (Object)((Object)sQLException)));
        }
    }

    public boolean addDeletedFeeds(ContentValues contentValues) {
        try {
            if (this.database.insertOrThrow("deletedfeeds", null, contentValues) != -1L) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.e((String)("AnaDatabaseAccess: addDeletedFeeds" + (Object)((Object)sQLException)));
        }
        return false;
    }

    public void addOrUpdateMessageList(ContentValues contentValues) {
        String string = contentValues.getAsString("endpoint");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                String string2 = "INSERT OR REPLACE INTO messagelist VALUES ( " + this.quotifyString(string) + "," + contentValues.get("frequency") + "," + "(" + "SELECT " + "timestamp" + " FROM " + "messagelist" + " WHERE " + "endpoint" + " = " + this.quotifyString(string) + ")" + ")";
                this.database.execSQL(string2);
            }
            catch (SQLException sQLException) {
                Logger.e((String)("AnaDatabaseAccess: addOrUpdateMessageList: " + (Object)((Object)sQLException)));
            }
        }
    }

    public void deleteHttpConsumptionStats(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("httpstats", string, stringArray);
    }

    public void deleteSessionStats(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("sessionstats", string, stringArray);
    }

    public void deleteUserEvents(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("userevents", string, stringArray);
    }

    public void deleteEventLogs(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
            stringArray = null;
        }
        this.database.delete("eventlog", string, stringArray);
    }

    public int updateSegment(ContentValues contentValues, String string, String[] stringArray) {
        return this.database.update("segment", contentValues, string, stringArray);
    }

    private String quotifyString(String string) {
        return string != null ? "'" + string + "'" : "''";
    }

    private void handleDiskIOError() {
        Logger.e((String)"AnaDatabaseAccess: handleDiskIOError closing db");
        try {
            this.close();
            this.open();
        }
        catch (Exception exception) {
            Logger.e((String)"AnaDatabaseAccess: handleDiskIOError ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(int n2, ContentValues[] contentValuesArray) {
        int n3 = 0;
        switch (n2) {
            case 10: 
            case 20: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addFeedItem(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 40: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        if (!this.addContentSource(contentValues)) continue;
                        ++n3;
                    }
                    this.mContext.getContentResolver().notifyChange(AnaProviderContract.CONTENT_URI_SOURCES, null);
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 200: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addHttpConsumptionStats(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 210: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addSessionStats(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 220: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addUserEvent(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 230: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addEventLog(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 240: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addOrUpdateFeedPolicy(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 250: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addOrUpdateSegment(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
            case 300: {
                try {
                    this.database.beginTransaction();
                    for (ContentValues contentValues : contentValuesArray) {
                        this.addOrUpdateMessageList(contentValues);
                        ++n3;
                    }
                    this.database.setTransactionSuccessful();
                    break;
                }
                catch (Exception exception) {
                    Logger.e((String)("AnaDatabaseAccess: Database Transaction failed " + exception));
                    break;
                }
                finally {
                    this.database.endTransaction();
                }
            }
        }
        return n3;
    }

    boolean isDatabaseAccessible() {
        return this.database != null && this.database.isOpen();
    }
}

